###
### Maple program
### accompanying the paper "How to integrate a polynomial over a simplex"
### by V. Baldoni, N. Berline, J. A. De Loera, M. Koeppe, and M. Vergne
###
### $Header: /home/mkoeppe/cvsroot/mkoeppe/w/papers/rat/pisa/programs/velleda-experiments-2008-05-18/table-comparison-integration.mpl,v 1.2 2008/09/24 22:15:38 mkoeppe Exp $
###
### This creates the tables for the section "comparison of integration methods"

with(combinat):

#read("integration.mpl");
read("latex-table.mpl");
read("examples.mpl");
read("duality.mpl");
read("waring.mpl");
read("iterated_laurent.mpl");

## generator is called with arguments DIMENSION, DEGREE to return a sparse POLYNOMIAL.
## integrator is called with arguments SIMPLEX, DIMENSION, POLYNOMIAL.
table_integration_of_random_polynomial := proc(dimensions, degrees, num_samples, time_limit, generator, integrator)
  printf("%%%%integration of random monomial by %s:\n", procedure);
  dimension_degree_avg_runtime_table(dimensions, degrees, 
    proc(n, M)
      local S, poly;
      S := lattice_random_simplex(n, 100);
      poly := generator(n, M);
      integrator(S, n, poly);
    end,
    num_samples, time_limit);
end:

