# Integral via CUBPACK interface
# The  integer d is the dimension;
# A vector in Q^d is a list of d rational numbers.
# A vertex is a vector in Q^d;
# The simplex  S is the convex hull of its vertices s_i.
# Thus S is encoded as a list of vectors
# in Q^d.
# If the simplex is of full dimension, we have (d+1) vertices.

read("best.mpl");

write_cubpack_file := proc(S, d, m, filename)
    local i, j, filedes, answer, Sij;
    filedes := fopen(filename, WRITE);
    fprintf(filedes, "%d\n", d);
    fprintf(filedes, "%g\n", 1.0);
    for i from 1 to nops(m) do
        fprintf(filedes, "%g ", m[i]);
    od;
    fprintf(filedes, "\n");
    for i from 1 to nops(S) do
        for j from 1 to nops(S[i]) do
            Sij := S[i][j];
            fprintf(filedes, "%30.20g ", evalhf(Sij));
        od;
        fprintf(filedes, "\n");
    od;

    answer := integral_via_best_method(S, d, [[1, m]]);

    Digits := 30;
    fprintf(filedes, "%30.20g\n", evalf(answer));
    Digits := 10;

    fclose(filedes);
end:

read_cubpack_result_file := proc(filename)
    local filedes, result;
    filedes := fopen(filename, READ);
    Digits := 30;
    result := fscanf(filedes, "%g")[1];
    Digits := 10;
    fclose(filedes);
    result;
end:

cubpack_test_program := "cubpack/pisa-test":

run_cubpack := proc(S, d, m)
  local error_code, result;
  write_cubpack_file(S, d, m, "testdata");
  
  error_code := system(cubpack_test_program);
  if error_code != 0 then
     error "CUBPACK failed";
  end if;
  
  result := read_cubpack_result_file("testresult");
  result;
end:


serial := 1:


integral_monome_via_cubpack := proc(S,d,m)
  run_cubpack(S,d,m);
end:

## No longer used:
generate_testdata_for_cubpack:=proc(S,d,m)
    local deg;
    global serial;
##     print (m);
    deg := add(m[i], i=1..nops(m));
##     print (deg, d, serial);
    write_cubpack_file(S, d, m, sprintf("testdata-dim%d-deg%d-%d", d, deg, serial));
    serial := serial + 1;
    42;
end:

integral_via_cubpack:=proc(S,d,sparse_poly)

local n,iii,output;


output:=0;
n:=nops(sparse_poly);

for iii from 1 to n do
output:=output+integral_monome_via_cubpack(S,d,sparse_poly[iii][2])*sparse_poly[iii][1];
   od;
end:

