!
! Adapted from simplexpapertest.f90
! for experiments for the Pisa integration paper.
!

! This file contains the full example of the paper
! A. Genz & R. Cools
! An adaptive numerical cubature algorithm for simplices
!

MODULE global
  USE PRECISION_MODEL

  INTEGER :: dim
  INTEGER, PARAMETER :: maxdim = 100
  REAL(kind=stnd) :: coeff
  INTEGER, DIMENSION(1:maxdim) :: exponent

END MODULE global


MODULE INTEGRAND
  USE PRECISION_MODEL
  USE global
  IMPLICIT NONE
  PRIVATE
  PUBLIC :: F
CONTAINS

  FUNCTION F( L, X ) RESULT(FUN)
    INTEGER,                       INTENT(IN) :: L
    REAL(kind=stnd), DIMENSION(:), INTENT(IN) :: X
    REAL(kind=stnd), DIMENSION(0:L-1)         :: FUN
    !
    REAL(kind=stnd)    :: S
    INTEGER            :: I
    S = coeff
    DO I = 1, dim
       S = S * X(I) ** exponent(I)
    END DO
    FUN(0) = S
!!     print *, "Eval: ", X      !, "exponent: ", exponent(1:dim) 
!!     print *, "Result: ", FUN(0)
  END FUNCTION F
!
END MODULE INTEGRAND
!

PROGRAM Simplex_Example

USE Precision_Model
USE CUI                                 ! Cubpack User Interface
USE INTEGRAND
USE global

open (7, file = "testdata")
read(7, *) dim
print *, "Dimension: ", dim
CALL Read_and_Compute

STOP

CONTAINS

  SUBROUTINE Read_and_Compute
    INTEGER                             :: NEval, i, j, Inform
    REAL(kind=stnd), DIMENSION(dim, 0:dim, 1) :: Simplex
    REAL(kind=stnd), DIMENSION(0:0)     :: Value, AbsErr, ExactValue
    
    read(7, *) coeff
!!     DO i = 1,dim
!!        read(7,*) exponent(i)
!!     END DO
    read(7,*) exponent(1:dim)
    DO i = 0,dim
!        DO j=1,dim
!!           read(7,*) Simplex(j, i, 1)
!!           print *, "Data: ", Simplex(j, i, 1)
          read(7,*) Simplex(:, i, 1)
!        end do
    end do
    read (7,*) ExactValue
    
    Inform = -1                      ! Soft noisy errors            
    !    The single region | is a simplex    |
    !                      v                 v
    CALL CUBATR( dim, 1, F, 1, Simplex,     (/1/), Value, AbsErr,      &
         Inform, NEval, EpsRel=5.0e-4_stnd, MaxPts=200000000 )
    
    Print *, "Expected values are ",  Value(0) 
    Print *, "with estimated errors ", AbsErr(0) 

    Print *, "Exact value was ", ExactValue
    Print *, "Actual error is ", abs(ExactValue - Value(0))


    Print *,"The number of integrand evaluations used was ", NEval 

    open (8, file="testresult")
    write (8,*) Value(0)
    
  END SUBROUTINE Read_and_Compute

END PROGRAM Simplex_Example
