###
### Maple program
### accompanying the paper "How to integrate a polynomial over a simplex"
### by V. Baldoni, N. Berline, J. A. De Loera, M. Koeppe, and M. Vergne
###
### $Header: /home/mkoeppe/cvsroot/mkoeppe/w/papers/rat/pisa/programs/integration-experiments-float/tables.mpl,v 1.1 2009/07/16 23:38:38 mkoeppe Exp $
###
### This creates the tables for the section "comparison of integration methods"

with(combinat):

#read("integration.mpl");
read("latex-table.mpl");
read("examples.mpl");
read("duality.mpl");
read("waring.mpl");
read("iterated_laurent.mpl");

## generator is called with arguments DIMENSION, DEGREE to return a sparse POLYNOMIAL.
## integrator is called with arguments SIMPLEX, DIMENSION, POLYNOMIAL.
table_integration_of_random_polynomial := proc(dimensions, degrees, num_samples, time_limit, generator, integrator)
  printf("%%%%integration of random monomial by %s:\n", procedure);
  dimension_degree_avg_runtime_table(dimensions, degrees,
    proc(n, M)
      local S, poly;
      S := around_one_simplex(n);
      poly := generator(n, M);
      integrator(S, n, poly);
    end,
    num_samples, time_limit);
end:

error_table_integration_of_random_polynomial := proc(dimensions, degrees, num_samples, time_limit,
                                                     generator, exact_integrator, inexact_integrator)
  dimension_degree_avg_table_floatformat(dimensions, degrees,
    proc(n, M)
    local S, poly, exact_result, inexact_result, relative_error;
        S := around_one_simplex(n);
        #print(S);
        poly := generator(n, M);
        exact_result := exact_integrator(S, n, poly);
        inexact_result := inexact_integrator(S, n, poly);
        relative_error := abs(exact_result - inexact_result) / abs(exact_result);
##          print ("Simplex:", S, "Poly:", poly, "Exact: ", evalhf(exact_result), "Inexact: ",
##                 inexact_result, "Relative error: ", relative_error);
        relative_error;
    end,
    num_samples, time_limit);
end:

