If there is a transition from 0 to 1,
// send the "diag mode off" command to the istec.

void IstecRingOn (unsigned char Device);
// Ring a phone. Device is 0..n

void IstecRingOff (unsigned char Device);
// Bell off. Device is 0..n



// End of ICCOM.H

#endif



                                                                                                                                                                                                                                                       /*****************************************************************************/
/*                                                                           */
/*                                ICCONFIG.CC                                */
/*                                                                           */
/* (C) 1995-97  Ullrich von Bassewitz                                        */
/*              Wacholderweg 14                                              */
/*              D-70597 Stuttgart                                            */
/* EMail:       uz@ibb.schwaben.com                                          */
/*                                                                           */
/*****************************************************************************/



// $Id$
//
// $Log$
//
//



#include <string.h>

#include "check.h"
#include "chartype.h"
#include "str.h"
#include "strcvt.h"

#include "icobjid.h"
#include "iccti.h"
#include "icac.h"
#include "icerror.h"
#include "icdlog.h"
#include "icconfig.h"



// Register the classes
LINK (IstecBaseConfig, ID_IstecBaseConfig);
LINK (IstecDevConfig, ID_IstecDevConfig);
LINK (IstecDevColl, ID_IstecDevColl);
LINK (IstecConfig, ID_IstecConfig);



/*****************************************************************************/
/*                      Explicit template instantiation                      */
/*****************************************************************************/



#ifdef EXPLICIT_TEMPLATES
template class SortedCollection<IstecDevConfig, unsigned char>;
template class Collection<IstecDevConfig>;
#endif



/*****************************************************************************/
/*                           class IstecBaseConfig                           */
/*****************************************************************************/



IstecBaseConfig::IstecBaseConfig ():
    Connection (coPointToMulti),
    DevCount (8),
    Protocol (prDSS1),
    VersionHigh (1),
    VersionLow (70),
    TFEAssignment (FirstDev),
    Music (0),
    IntS0 (0),
    ExtS0 (1),
    QueryLoc1 (0),
    QueryLoc2 (0),
    MusicPort (0),
    CountryCode (49),
    AlarmTone (0)
// Constructor
{
    memset (MSN, 0, sizeof (MSN));
    memset (Number1, 0, sizeof (Number1));
    memset (Number2, 0, sizeof (Number2));
    memset (MSNGroups, 0xFF, sizeof (MSNGroups));
    memset (TFELoc, 0, sizeof (TFELoc));
    memset (Signaling, 0, sizeof (Signaling));
    memset (Reserved, 0, sizeof (Reserved));
}



void IstecBaseConfig::Load (Stream& S)
// Load the object from a stream
{
    if (S.GetStatus () != stOk) {
        // Stream has an error
        return;
    }

    S >> Connection >> DevCount >> Protocol >> VersionHigh >> VersionLow;
    S >> TFEAssignment;
    S.Read (MSN, sizeof (MSN));
    S >> Music >> IntS0 >> ExtS0 >> QueryLoc1 >> QueryLoc2;
    S.Read (Number1, sizeof (Number1));
    S.Read (Number2, sizeof (Number2));
    S.Read (MSNGroups, sizeof (MSNGroups));
    S >> MusicPort >> CountryCode;
    S.Read (TFELoc, sizeof (TFELoc));
    S >> AlarmTone;
    S.Read (Signaling, sizeof (Signaling));
    S.Read (Reserved, sizeof (Reserved));
}



void IstecBaseConfig::Store (Stream& S) const
// Store the object into a stream
{
    if (S.GetStatus () != stOk) {
        // Stream has an error
        return;
    }

    S << Connection << DevCount << Protocol << VersionHigh << VersionLow;
    S << TFEAssignment;
    S.Write (MSN, sizeof (MSN));
    S << Music << IntS0 << ExtS0 << QueryLoc1 << QueryLoc2;
    S.Write (Number1, sizeof (Number1));
    S.Write (Number2, sizeof (Number2));
    S.Write (MSNGroups, sizeof (MSNGroups));
    S << MusicPort << CountryCode;
    S.Write (TFELoc, sizeof (TFELoc));
    S << AlarmTone;
    S.Write (Signaling, sizeof (Signaling));
    S.Write (Reserved, sizeof (Reserved));
}



u16 IstecBaseConfig::StreamableID () const
// Return the stream ID
{
    return ID_IstecBaseConfig;
}



Streamable* IstecBaseConfig::Build ()
// Return a new instance
{
    return new IstecBaseConfig (Empty);
}



unsigned char* IstecBaseConfig::Pack (unsigned char* Buf) const
// Pack the data of struct IstecBaseConfig into an array ready for
// transmission. The function returns Buf.
{
    unsigned I;
    unsigned char* B = Buf;

    // Clear the complete buffer
    memset (B, 0, BaseConfigSize);

    // Copy the values
    *B++ = Connection;
    *B++ = DevCount;
    *B++ = Protocol;
    *B++ = VersionHigh;
    *B++ = VersionLow;
    *B++ = TFEAssignment;
    for (I = 0; I < bcMSNCount; I++) {
        memcpy (B, MSN [I], sizeof (MSN [I]));
        B += sizeof (MSN [I]);
    }
    *B++ = Music;
    *B++ = IntS0;
    *B++ = ExtS0;
    *B++ = QueryLoc1;
    *B++ = QueryLoc2;
    memcpy (B, Number1, sizeof (Number1));
    B += sizeof (Number1);
    memcpy (B, Number2, sizeof (Number2));
    B += sizeof (Number2);
    memcpy (B, MSNGroups, sizeof (MSNGroups));
    B += sizeof (MSNGroups);

    // Version 1.93 extensions follow.
    unsigned Version = unsigned (VersionHigh) * 100 + unsigned (VersionLow);
    if (Version >= 193) {

        *B++            = MusicPort;
        *B++            = (unsigned char) (CountryCode & 0x00FF);
        *B++            = (unsigned char) ((CountryCode >> 8) & 0x00FF);
        memcpy (B, TFELoc, sizeof (TFELoc));
        B += sizeof (TFELoc);

        if (Version >= 200) {
            *B++        = AlarmTone;
            for (I = 0; I < bcMSNCount; I++) {
                *B++ = OutSignal (Signaling [I]);
            }
        }

    }

    // Return the prepared buffer
    return Buf;
}



IstecBaseConfig& IstecBaseConfig::Unpack (const unsigned char* Buf)
// Unpack an array of char that contains data for an IstecBaseConfig struct.
// The function returns this.
{
    unsigned I;

    if ((Connection = *Buf++) > coMax) {
        WriteDebugLog (FormatStr ("IstecBaseConfig::Unpack: Got invalid value for connection: %02X",
                                  Connection));
        Connection = coPointToMulti;
    }
    DevCount = *Buf++;
    if ((Protocol = *Buf++) > prMax) {
        WriteDebugLog (FormatStr ("IstecBaseConfig::Unpack: Got invalid value for protocol: %02X",
                                  Protocol));
        Protocol = prDSS1;
    }
    VersionHigh   = *Buf++;
    VersionLow    = *Buf++;
    TFEAssignment = *Buf++;
    if ((TFEAssignment != 0) &&
        (TFEAssignment < 21 || TFEAssignment > LastDev)) {
        WriteDebugLog (FormatStr ("IstecBaseConfig::Unpack: Got invalid value for TFE assignment: %02X",
                                  TFEAssignment));
        TFEAssignment = FirstDev;
    }
    for (I = 0; I < bcMSNCount; I++) {
        memcpy (MSN [I], Buf, sizeof (MSN [I]));
        Buf += sizeof (MSN [I]);
    }
    Music             = (*Buf++ != 0);
    IntS0             = *Buf++;
    ExtS0             = *Buf++;
    QueryLoc1         = *Buf++;
    QueryLoc2         = *Buf++;
    memcpy (Number1, Buf, sizeof (Number1));
    Buf += sizeof (Number1);
    memcpy (Number2, Buf, sizeof (Number2));
    Buf += sizeof (Number2);
    memcpy (MSNGroups, Buf, sizeof (MSNGroups));
    Buf += sizeof (MSNGroups);

    // Version 1.93 extensions follow
    unsigned Version = unsigned (VersionHigh) * 100 + unsigned (VersionLow);
    if (Version >= 193) {

        MusicPort   = *Buf++;
        CountryCode = unsigned (Buf [1]) * 0x100 + unsigned (Buf [0]);
        Buf += 2;
        memcpy (TFELoc, Buf, sizeof (TFELoc));
        Buf += sizeof (TFELoc);

        if (Version >= 200) {
            AlarmTone = *Buf++;
            for (I = 0; I < bcMSNCount; I++) {
                Signaling [I] = InSignal (*Buf++);
            }
            memcpy (Reserved, Buf, sizeof (Reserved));
        } else {
            // Use defaults for the additional fields
            AlarmTone = 0;
            for (I = 0; I < bcMSNCount; I++) {
                Signaling [I] = siStandard;
            }
            memset (Reserved, 0, sizeof (Reserved));
        }

    } else {

        // This is an old version, clear out the additional fields
        MusicPort   = 0;            // None
        CountryCode = 49;           // Germany
        memset (TFELoc, 0, sizeof (TFELoc));
        AlarmTone   = 0;            // Off
        for (I = 0; I < bcMSNCount; I++) {
            Signaling [I] = siStandard;
        }
        memset (Reserved, 0, sizeof (Reserved));
    }

    // Return the prepared struct
    return *this;
}



IstecBaseConfig& IstecBaseConfig::Unpack (const IstecMsg& Msg)
// Unpack an array of char that contains data for an IstecBaseConfig struct.
// The function returns this.
{
    PRECONDITION (Msg.Size >= 94 && Msg.At (0) == 0x17);
    return Unpack (&Msg.Data [1]);
}



int operator == (const IstecBaseConfig& lhs, const IstecBaseConfig& rhs)
{
    // For simplicity, convert to an array, then do a memcmp
    unsigned char Left [BaseConfigSize], Right [BaseConfigSize];
    return memcmp (lhs.Pack (Left), rhs.Pack (Right), BaseConfigSize) == 0;
}



int operator != (const IstecBaseConfig& lhs, const IstecBaseConfig& rhs)
{
    // For simplicity, convert to an array, then do a memcmp
    unsigned char Left [BaseConfigSize], Right [BaseConfigSize];
    return memcmp (lhs.Pack (Left), rhs.Pack (Right), BaseConfigSize) != 0;
}



unsigned IstecBaseConfig::IstecID () const
// Return the type of the istec, determined by the parameters of the base
// configuration. The return value is 0 if the istec type could not be
// identified, 1008 for an istec 1008 etc.
{
    if (ExtS0 == 1) {
        // It is a 10XX type
        switch (DevCount) {
            case 3:     return 1003;
            case 8:     return 1008;
            case 16:    return 1016;
            case 24:    return 1024;
        }
    } else if (ExtS0 == 2) {
        // Type 20XX or 24XX
        if (IntS0 == 0) {
            // It is a 20XX type
            switch (DevCount) {
                case 16:    return 2016;
                case 24:    return 2024;
            }
        } else if (IntS0 == 4) {
            // It is a 24XX type
            switch (DevCount) {
                case 0:     return 2400;
                case 16:    return 2416;
                case 24:    return 2424;
            }
        }
    }

    // Unknown type if it comes here...
    return 0;
}



/*****************************************************************************/
/*                           class IstecDevConfig                            */
/*****************************************************************************/



IstecDevConfig::IstecDevConfig (unsigned char aDevNum):
    DevNum (aDevNum),
    DialCaps (dcKeine),
    Service (svFernsprechen),
    Reroute (0),
    ChargePulse (0),
    TerminalMode (0),
    InternalKnock (0),
    ExternalKnock (0),
    ExtNumLen (0),
    RerouteIfBusy (0),
    RerouteDelayed (0),
    RingsUntilReroute (0)
// Create an IstecDevConfig
{
    memset (PIN, 0xFF, sizeof (PIN));
}



void IstecDevConfig::Load (Stream& S)
// Load the object from a stream
{
    if (S.GetStatus () != stOk) {
        // Stream error
        return;
    }

    S >> DevNum >> DialCaps >> Service >> Reroute >> ChargePulse;
    S.Read (PIN, sizeof (PIN));
    S >> ExtNum >> TerminalMode >> InternalKnock >> ExternalKnock;
    S >> ExtNumLen;
    S >> RerouteIfBusy >> RerouteDelayed >> RingsUntilReroute;
}



void IstecDevConfig::Store (Stream& S) const
// Store the object into a stream
{
    if (S.GetStatus () != stOk) {
        // Stream error
        return;
    }

    S << DevNum << DialCaps << Service << Reroute << ChargePulse;
    S.Write (PIN, sizeof (PIN));
    S << ExtNum << TerminalMode << InternalKnock << ExternalKnock;
    S << ExtNumLen;
    S << RerouteIfBusy << RerouteDelayed << 