/*****************************************************************************/
/*                                                                           */
/*                                  CONT.CC                                  */
/*                                                                           */
/* (C) 1993-95  Ullrich von Bassewitz                                        */
/*              Zwehrenbuehlstrasse 33                                       */
/*              D-72070 Tuebingen                                            */
/* EMail:       uz@ibb.schwaben.com                                          */
/*                                                                           */
/*****************************************************************************/



// $Id$
//
// $Log$
//
//



#include <stdio.h>
#include <sys/stat.h>

#include "streamid.h"
#include "cont.h"



// Register class Container
LINK(Container, ID_Container);



/*****************************************************************************/
/*                              class Container                              */
/*****************************************************************************/



Container::Container (const Container& C)
{
    if (C.Data == NULL) {
        // Other container is empty
        Data = NULL;
        Size = 0;
    } else {
        // Second container is not empty
        Size = C.Size;
        Data = new char [Size];
        memcpy (Data, C.Data, Size);
    }
}



Container::~Container ()
{
    FreeData ();
}



void Container::Load (Stream& S)
{
    // Get Size of Data
    S >> Size;

    // Maybe, size is 0
    if (Size == 0) {
        Data = NULL;
    } else {
        Data = new char [Size];
        S.Read (Data, Size);
    }
}



void Container::Store (Stream& S) const
{
    S << Size;
    S.Write (Data, Size);
}



u16 Container::StreamableID () const
{
    return ID_Container;
}



Streamable* Container::Build ()
{
    return new Container (Empty);
}



void Container::Fre to sort out the needed ones.



#ifndef _CRC_H
#define _CRC_H



#include <stdlib.h>

#include "machine.h"



/*****************************************************************************/
/*                                   Code                                    */
/*****************************************************************************/



u16 CRC_CCITT (u16 StartCRC