 '|' !
{
    // Get the environment value
    String Val = GetEnvVar (Var);

    // Match the keyword ignoring case
    return MatchKeyword (Val.ToUpper (), ToUpper (ValStr));
}



i32 GetEnvVal (const String& Var, const String& ValStr)
// Read the environment variable Var and compare the value with values stored
// in ValStr. ValStr looks like this: "1^ON|0^OFF|1^YES|0^NO|", meaning:
// Return 1 if the value is "ON", return 0 if the value is "OFF" etc.
// Case is ignored when comparing the value. The first value stored in ValStr
// is the default, it is returned if Var does not exist or is invalid.
// The function calls FAIL if the given ValStr is invalid. Don't forget the
// trailing '|' !
{
    // BC complains over a (nonexistant) ambiguity here, so do explicit
    // casting here...
    return GetEnvVal (Var.GetStr (), String (ValStr));
}



i32 GetEnvNum (const char* Var, i32 Default)
// Read the environment variable Var and treat the value as a number string.
// Return the converted number or Default if the variable does not exist or
// contains an invalid value.
{
    // Get the value
    String Val = GetEnvVar (Var);

    // Try to convert it to a number
    StringParser SP (Val);
    i32 Value;
    if (SP.GetI32 (Value) == 0) {
	// Done
	return Value;
    } else {
	// Error
	return Default;
    }
}



i32 GetEnvNum (const String& Var, i32 Default)
// Read the environment variable Var and treat the value as a number string.
// Return the converted number or Default if the variable does not exist or
// contains an invalid value.
{
    return GetEnvNum (Var.GetStr (), Default);
}



int GetEnvBool (const char* Var, int Default)