   },
    {   '9',    kbMeta9         },
    {   'A',    kbMetaA         },
    {   'B',    kbMetaB         },
    {   'C',    kbMetaC         },
    {   'D',    kbMetaD         },
    {   'E',    kbMetaE         },
    {   'F',    kbMetaF         },
    {   'G',    kbMetaG         },
    {   'H',    kbMetaH         },
    {   'I',    kbMetaI         },
    {   'J',    kbMetaJ         },
    {   'K',    kbMetaK         },
    {   'L',    kbMetaL         },
    {   'M',    kbMetaM         },
    {   'N',    kbMetaN         },
    {   'O',    kbMetaO         },
    {   'P',    kbMetaP         },
    {   'Q',    kbMetaQ         },
    {   'R',    kbMetaR         },
    {   'S',    kbMetaS         },
    {   'T',    kbMetaT         },
    {   'U',    kbMetaU         },
    {   'V',    kbMetaV         },
    {   'W',    kbMetaW         },
    {   'X',    kbMetaX         },
    {   'Y',    kbMetaY         },
    {   'Z',    kbMetaZ         }
};



/*****************************************************************************/
/*                                   Code                                    */
/*****************************************************************************/



Key GetMetaCode (Key K)
// Return the "meta version" of the given key K or kbNoKey if none exists
{
    // Do a linear search (hmm..., is it worth a binary search?)
    for (size_t I = 0; I < sizeof (MetaTable) / sizeof (MetaTable [0]); I++) {
        if (MetaTable [I].Orig == K) {
            return MetaTable [I].Meta;
        }
    }

    // Not found
    return kbNoKey;
}



Key GetMetaKey (Key K)
// Return the "normal key" of the meta key given key K or kbNoKey if none
// exists
{
    // Do a linear search (hmm..., is it worth a binary search?)
    for (size_t I = 0; I < sizeof (MetaTable) / sizeof (MetaTable [0]); I++) {
        if (MetaTable [I].Meta == K) {
            return MetaTable [I].Orig;
        }
    }

    // Not found
    return kbNoKey;
}



                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              /*****************************************************************************/
/*                                                                           */
/*                                 KEYDEF.H                                  */
/*                                                                           */
/* (C) 1993-95  Ullrich von Bassewitz                                        */
/*              Zwehrenbuehlstrasse 33                                       */
/*              D-72070 Tuebingen                                            */
/* EMail:       uz@ibb.schwaben.com                                          */
/*                                                                           */
/*****************************************************************************/



// $Id$
//
// $Log$
//
//



#ifndef __KEYDEF_H
#define __KEYDEF_H



#include "machine.h"



/*****************************************************************************/
/*                                 Keycodes                                  */
/*****************************************************************************/



// Type of a key
typedef u16     Key;



// "Special" key
static const Key        kbNoKey         = 0x0000;



/*****************************************************************************/
/*                             "Plain" Keycodes                              */
/*****************************************************************************/



// Keys without any modifiers
static const Key        kbEnter         = 0x000D;
static const Key        kbEsc           = 0x001B;
static const Key        kbBack          = 0x0008;

static const Key        kbTab           = 0x0009;



// Keys with ctrl modifier
static const Key        kbCtrlA         = 0x0001;
static const Key        kbCtrlB         = 0x0002;
static const Key        kbCtrlC         = 0x0003;
static const Key        kbCtrlD         = 0x0004;
static const Key        kbCtrlE         = 0x0005;
static const Key        kbCtrlF         = 0x0006;
static const Key        kbCtrlG         = 0x0007;
static const Key        kbCtrlH         = 0x0008;
static const Key        kbCtrlI         = 0x0009;
static const Key        kbCtrlJ         = 0x000A;
static const Key        kbCtrlK         = 0x000B;
static const Key        kbCtrlL         = 0x000C;
static const Key        kbCtrlM         = 0x000D;
static const Key        kbCtrlN         = 0x000E;
static const Key        kbCtrlO         = 0x000F;
static const Key        kbCtrlP         = 0x0010;
static const Key        kbCtrlQ         = 0x0011;
static const Key        kbCtrlR         = 0x0012;
static const Key        kbCtrlS         = 0x0013;
static const Key        kbCtrlT         = 0x0014;
static const Key        kbCtrlU         = 0x0015;
static const Key        kbCtrlV         = 0x0016;
static const Key        kbCtrlW         = 0x0017;
static const Key        kbCtrlX         = 0x0018;
static const Key        kbCtrlY         = 0x0019;
static const Key        kbCtrlZ         = 0x001A;



inline int IsPlainKey (Key K)
// Determine if K is a normal keycode
{
    return ((K & 0xFF00) == 0x0000);
}



/*****************************************************************************/
/*                             Extended Keycodes                             */
/*****************************************************************************/



static const Key        kbF1            = 0x013B;
static const Key        kbF2            = 0x013C;
static const Key        kbF3            = 0x013D;
static const Key     /*****************************************************************************/
/*                                                                           */
/*                                   KBD.H                                   */
/*                                                                           */
/* (C) 1993-96  Ullrich von Bassewitz                                        */
/*              Wacholderweg 14                                              */
/*              D-70597 Stuttgart                                            */
/* EMail:       uz@ibb.schwaben.com                                          */
/*                                                                           */
/*****************************************************************************/



// $Id$
//
// $Log$
//
//



// Class Keyboard has some inline functions that don't need to be inline
// (because they are rather big and there is no need for speed), but they
// are declared this way, because they are only used in a few places (so
// no code size penalty) and this way they are out of the target specific
// .cc files.



#ifndef _KBD_H
#define _KBD_H


#include "machine.h"
#include "object.h"
#include "circbuf.h"
#include "keydef.h"
#include "str.h"



/*****************************************************************************/
/*                                   Data                                    */
/*****************************************************************************/



// Instance to handle keyboard input
extern class Keyboard* Kbd;



/*****************************************************************************/
/*                              Class Keyboard                               */
/*****************************************************************************/



class Keyboard : public Object {

private:
    CircularBuffer<Key, 16>     KeyBuf;
    int                         Console;
    unsigned char*              TransTable;


    Key RawKey ();
    // Get a raw (unmapped) key from the os

    void GetMappedKey (int Wait = 1);
    // Read keys until the needed key is not found in the mapper or until
    // a valid sequence is found. If Wait is zero, return immediately if
    // no match is found and no more keys are available.

    Key Translate (Key K);
    // Translate plain keys via the translation table (if valid)

public:
    Keyboard ();
    // Construct a keyboard object

    ~Keyboard ();
    // Destruct a keyboard object

    Key Get ();
    // Return a key from the keyboard

    Key Peek ();
    // Return the next key but don't remove it from the queue. This function
    // returns kbNoKey if no key is currently available.

    void Put (Key);
    // Put back a key into the queue

    int KeyAvail ();
    // Return true if a key is available

    int IsConsole ();
    // Return true if the keyboard is the console keyboard

    String GetKeyName (Key K);
    // Return a string describing the give key
};



inline Key Keyboard::Translate (Key K)
// Translate plain keys via the translation table (if valid)
{
    return IsPlainKey (K) && TransTable != NULL ? TransTable [K] : K;
}



inline Key Keyboard::Get ()
{
    if (KeyBuf.IsEmpty ()) {
        // Get a key from the os
        GetMappedKey ();
    }

    // In any case a key is now available
    return KeyBuf.Get ();
}



inline Key Keyboard::Peek ()
// Return the next key but don't remove it from the queue. This function
// returns kbNoKey if no key is currently available.
{
    if (KeyBuf.IsEmpty ()) {
        // Get new key but don't wait
        GetMappedKey (0);
    }

    // Return kbNoKey if no key is available, otherwise return the first
    // key in the buffer
    if (KeyBuf.IsEmpty ()) {
        return kbNoKey;
    } else {
        // Return top of stack
        return KeyBuf.Peek ();
    }
}



inline void Keyboard::Put (Key K)
{
    KeyBuf.PutInFront (K);
}



inline int Keyboard::KeyAvail ()
{
    if (!KeyBuf.IsEmpty ()) {
        // Buffer contains characters
        return 1;
    }

    // Buffer is emtpy, read new keys if there are any
    GetMappedKey (0);

    // Now return the buffer status
    return KeyBuf.IsEmpty () == 0;
}



inline int Keyboard::IsConsole ()
// Return true if the keyboard is the console keyboard
{
    return Console;
}



// End of KBD.H

#endif
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /*****************************************************************************/
/*                                                                           */
/*                                 KEYDEF.CC                                 */
/*                                                                           */
/* (C) 1993-95  Ullrich von Bassewitz                                        */
/*              Zwehrenbuehlstrasse 33                                       */
/*              D-72070 Tuebingen                                            */
/* EMail:       uz@ibb.schwaben.com                                          */
/*                                                                           */
/*****************************************************************************/



// $Id$
//
// $Log$
//
//



#include <stddef.h>

#include "keydef.h"



/*****************************************************************************/
/*                                   Data                           