;
                } else if (ID == ID_TextEdit) {
                    ((TextEdit*) Item)->AllowEmptyInput ();
                }
                break;

        }
    }

    // Pop the status line, delete the menue
    PopStatusLine ();
    delete M;
}



void ResEditApp::ChangeSubMenue (WindowItem* Item)
{
    // Try to load the submenue for the item
    String MenueName = ChooseRes ();
    if (MenueName.IsEmpty ()) {
        return;
    }
    Streamable* M = LoadRes (MenueName);
    if (M == 0) {
        return;
    }

    // Check if we really have a menue
    if (M->StreamableID () != ID_Menue) {
        ErrorMsg ("Must have a menue object for assignment");
        delete M;
        return;
    }

    // Change the submenue
    ((SubMenueItem*) Item)->SetSubMenue ((Menue*) M);

    // Resource has changed
    ResChanged = 1;
}



void ResEditApp::Order ()
{
    // Cast the resource pointer
    ItemWindow * Win = (ItemWindow *) Res;

    // Check if the window has items
    if (Win->ItemCount == 0) {
        ErrorMsg ("No items - sorry");
        return;
    }

    PushStatusLine (" Choose the first item");

    // Choose the first item
    WindowItem *Item = ChooseItem ();
    if (Item == NULL) {
        // Abort
        return;
    }

    // Unlink this item and place it in front of all other items
    Win->FirstItem = Item;

    StatusLine->Replace (" Choose next item");

    // Now get one item after the other and place it in a row
    WindowItem *NextItem;
    while ((NextItem = ChooseItem ()) != NULL && NextItem != Win->FirstItem) {

        // If the same item is selected twice, this would result in an error.
        // Since this happens usually as a result of pressing the wrong key,
        // print an error message  and ignore it.
        if (NextItem == Item) {
            ErrorMsg ("Cannot select the same item twice");
        } else {
            NextItem->INode.Unlink ();
            NextItem->INode.InsertAfter (&Item->INode);
            Item = NextItem;
        }
    }

    PopStatusLine ();

    ResChanged = 1;

}



                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        P$Sǆ`        &    C`]Ch]؍MU؍EPPP  $PP  $RQV } ukEPP$EPP$Sǆ`     FPPh   ]SS PPjSPPjEPe[^]U\WVS}UR@1fU}t=   t5PPh  ]SS PPjEP  PPh  ]SUjSWE     PPjURh   UR@tЍ]Ѓ E    Uj j EPPPj St& E    PPj EPUR  $  E     Uj j EP   &    PPPPEPW|PV Uj9j0VUVURW\  PPPPEPWHPV Uj9j0VUjFjAV UjfjaVUVURW~  PPPPEPWPV UjzjaVUjZjAV UVURW<Ǉ`       PPPPEPWPV Ujj VUVURW   EUURWPPPSEP
t& PPjSPPh  SEPURSW PPjS} u]PPEPSUSURWǇ`      6}}uEP}   uUJh&    PPjEP} } tPPUjR@ЃPPjV   PPjEP&    PPjEPPPjEP    PPjEPPPjEP6    EPPjP[    e[^_]U,WVSu]PPVSf} uPPjW   v PPWVÃuPPjW   S@Ѓf6t[PPh@  EPV     