
:Begin:
:Function: allvertices
:Pattern: AllVertices[m_Integer, d_Integer, a_String]
:Arguments: {m, d, a}
:ArgumentTypes: {Integer, Integer, String}
:ReturnType: Manual
:End:

:Evaluate: AllVertices::usage = "AllVertices[m,d+1,A] generates all extreme points (vertices) and extreme rays of the convex polyhedron in R^(d+1) given as the solution set to an inequality system  A x >= 0 where  A is an m*(d+1) matrix  and  x=(1,x1,...,xd).  The output is {{extlist, linearity}, ecdlist} where extlist is  the extreme point list and ecdlist is the incidence list.  Each vertex (ray) has the first component 1 (0).  If the convex polyhedron is nonempty and has no vertices, extlist is a (nonunique) set of generators of the polyhedron where those generators in the linearity list are considered as linearity space (of points satisfying A (0, x1, x2, ...., xd) = 0)  generators."


:Begin:
:Function: allvertices2
:Pattern: AllVerticesWithAdjacency[m_Integer, d_Integer, a_String]
:Arguments: {m, d, a}
:ArgumentTypes: {Integer, Integer, String}
:ReturnType: Manual
:End:

:Evaluate: AllVerticesWithAdjacency::usage = "AllVerticesWithAdjacency[m,d+1,A] generates all extreme points (vertices) and extreme rays of the convex polyhedron in R^(d+1) given as the solution set to an inequality system  A x >= 0 where   A is an m*(d+1) matrix  and x=(1,x1,...,xd). The output is {{extlist, linearity}, ecdlist, eadlist, icdlist, iadlist} where extlist, ecdlist, eadlist are the extreme point list, the incidence list, the adjacency list (of extreme points and rays), and icdlist, iadlist are the incidence list, the adjacency list (of inequalities).  Each vertex (ray) has the first component 1 (0). If the convex polyhedron is nonempty and has no vertices, extlist is a (nonunique) set of generators of the polyhedron where those generators in the linearity list are considered as linearity space (of points satisfying A (0, x1, x2, ...., xd) = 0) generators."

:Begin:
:Function: allfacets
:Pattern: AllFacets[n_Integer, d_Integer, g_String]
:Arguments: {n, d, g}
:ArgumentTypes: {Integer, Integer, String}
:ReturnType: Manual
:End:

:Evaluate: AllFacets::usage = "AllFacets[n,d+1,G] generates all facet inequalities of the convex polyhedron in R^(d+1) generated by points and rays given in the rows of an n*(d+1) matrix G.  Each point (ray) must have 1 (0) in the first coordinate.  The output is {{faclist, equalities}, icdlist} where faclist is  the facet  list and icdlist is the incidence list.  If the convex polyhedron is not full-dimensional, extlist is a (nonunique) set of inequalities of the polyhedron where those inequalities in the equalities list are considered as equalities."

:Begin:
:Function: allfacets2
:Pattern: AllFacetsWithAdjacency[n_Integer, d_Integer, g_String]
:Arguments: {n, d, g}
:ArgumentTypes: {Integer, Integer, String}
:ReturnType: Manual
:End:

:Evaluate: AllFacetsWithAdjacency::usage = "AllFacetsWithAdjacency[n,d+1,G] generates all facet inequalities of the convex polyhedron in R^(d+1) generated by points and rays given in the rows of an n*(d+1) matrix G.  Each point (ray) must have 1 (0) in the first coordinate.  The output is {{faclist, equalities}, icdlist, iadlist, ecdlist, eadlist} where faclist, icdlist, iadlist are the facet list, the incidence list, the adjacency list (of facets), and ecdlist, eadlist are the incidence list, the adjacency list (of points and rays).  If the convex polyhedron is not full-dimensional, extlist is a (nonunique) set of inequalities of the polyhedron where those inequalities in the equalities list are considered as equalities."

