(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     19132,        550]*)
(*NotebookOutlinePosition[     20178,        586]*)
(*  CellTagsIndexPosition[     20090,        580]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  StyleBox["Diet Problem",
    FontColor->RGBColor[0.0557107, 0.137819, 0.517113]],
  "\nAn Application of Vertex Enumeration\nwith ",
  StyleBox["cddmathlink2",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0, 1]],
  " (",
  StyleBox["MathLink",
    FontSize->24,
    FontSlant->"Italic",
    FontColor->RGBColor[0.0146487, 0.461387, 0.0967727]],
  " to ",
  StyleBox["cddlib)",
    FontColor->RGBColor[0.517113, 0.0273594, 0.0273594]]
}], "Title",
  ImageRegion->{{0, 1}, {0, 1}},
  FontSize->27],

Cell[TextData[StyleBox["Komei Fukuda, fukuda@ifor.math.ethz.ch\nSwiss Federal \
Institute of Technology, Lausanne and Zurich\nDecember 14, 2002",
  FontSize->17,
  FontSlant->"Italic"]], "Subtitle",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["What's New?", "Section",
  ImageRegion->{{0, 1}, {0, 1}},
  FontSize->20],

Cell[TextData[{
  StyleBox["cddmathlink2",
    FontColor->RGBColor[0, 0, 1]],
  " is a new version of cddmathlink.  It comes in two flavors. ",
  StyleBox["cddmathlink2",
    FontColor->RGBColor[0, 0, 1]],
  " is essentially the same as the old cddmathlink which uses floating-point \
arithmetic, while ",
  StyleBox["cddmathlink2gmp",
    FontColor->RGBColor[1, 0, 0]],
  " uses GMP rational exact arithmetic.  Thus one can ",
  StyleBox["compute exactly",
    FontColor->RGBColor[1, 0, 0]],
  " with ",
  StyleBox["cddmathlink2gmp",
    FontColor->RGBColor[1, 0, 0]],
  ".  I have tested this only with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 4.1 on MacOS X. "
}], "Text"],

Cell[CellGroupData[{

Cell["Connecting  cddmathlink2", "Section",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell[TextData[{
  "You just put the compiled cddmathlink2 and cddmathlink2gmp on your \
computer in some directory.  In this example, the name of the directory is ",
  StyleBox["\"~/Math\".",
    FontFamily->"Courier",
    FontWeight->"Bold"]
}], "Text",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["Off[General::spell1]; Off[General::spell];", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["cddml=Install[\"~/Math/cddmathlink2gmp\"]", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(LinkObject["/Users/fukuda/Math/cddmathlink2gmp", 3, 3]\)], "Output"],

Cell[BoxData[
    \( (*If\ you\ prefer\ to\ use\ floating - 
        point\ arithmetic, \(use\ \(cddmathlink2 : cddml\) = 
          Install["\<~/Math/cddmathlink2\>"];\)*) \)], "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["What is Diet Problem?", "Section",
  ImageRegion->{{0, 1}, {0, 1}},
  FontSize->20],

Cell["\<\
The following diet problem is taken from V. Chvatal's  great book \
on Linear Programming (\"Linear Programming\", W.H.Freeman and Company,1983). \
  It is to design a cheapest meal with six possible items below to satisfy \
prescribed nutritional needs.  Please see Page 3 of the book.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["\<\
var={\"\",\"Oatmeal\",\"Chicken\",\"Eggs\",\"Milk\",\"Cherry Pie\", \

\t\"Pork Beans\"};

price={\"Price/Ser\", \"3c\", \"24c\", \"13c\", \"9c\", \"20c\", \
\"19c\"}\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  FontSize->14],

Cell[BoxData[
    \({"Price/Ser", "3c", "24c", "13c", "9c", "20c", "19c"}\)], "Output"]
}, Open  ]],

Cell["\<\
MatrixForm[dietproblem1=
{{0, 1, 0, 0, 0, 0, 0}, {0, 0, 1, 0, 0, 0, 0},
 {0, 0, 0, 1, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 0}, 
 {0, 0, 0, 0, 0, 1, 0}, {0, 0, 0, 0, 0, 0, 1}, 
 {4, -1, 0, 0, 0, 0, 0}, {3, 0, -1, 0, 0, 0, 0},
 {2, 0, 0, -1, 0, 0, 0}, {8, 0, 0, 0, -1, 0, 0}, 
 {2, 0, 0, 0, 0, -1, 0}, {2, 0, 0, 0, 0, 0, -1},
 {-2000, 110, 205, 160, 160, 420, 260}, 
 {-55, 4, 32, 13, 8, 4, 14}, 
 {-800, 2, 12, 54, 285, 22, 80}}];\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  FontSize->14],

Cell[CellGroupData[{

Cell["\<\
TableForm[table1=Prepend[Prepend[dietproblem1,var],price]]
\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"Price/Ser\"\>", "\<\"3c\"\>", "\<\"24c\"\>", "\<\"13c\"\>", "\
\<\"9c\"\>", "\<\"20c\"\>", "\<\"19c\"\>"},
          {"\<\"\"\>", "\<\"Oatmeal\"\>", "\<\"Chicken\"\>", "\<\"Eggs\"\>", \
"\<\"Milk\"\>", "\<\"Cherry Pie\"\>", "\<\"Pork Beans\"\>"},
          {"0", "1", "0", "0", "0", "0", "0"},
          {"0", "0", "1", "0", "0", "0", "0"},
          {"0", "0", "0", "1", "0", "0", "0"},
          {"0", "0", "0", "0", "1", "0", "0"},
          {"0", "0", "0", "0", "0", "1", "0"},
          {"0", "0", "0", "0", "0", "0", "1"},
          {"4", \(-1\), "0", "0", "0", "0", "0"},
          {"3", "0", \(-1\), "0", "0", "0", "0"},
          {"2", "0", "0", \(-1\), "0", "0", "0"},
          {"8", "0", "0", "0", \(-1\), "0", "0"},
          {"2", "0", "0", "0", "0", \(-1\), "0"},
          {"2", "0", "0", "0", "0", "0", \(-1\)},
          {\(-2000\), "110", "205", "160", "160", "420", "260"},
          {\(-55\), "4", "32", "13", "8", "4", "14"},
          {\(-800\), "2", "12", "54", "285", "22", "80"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell["\<\
m=Transpose[Drop[Transpose[dietproblem1],1]];
b=-First[Transpose[dietproblem1]];
c={3, 24, 13, 9, 20, 19};\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  FontSize->14],

Cell[TextData[{
  "By using the build-in LP optimizer of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", one can easily compute the optimal solution."
}], "Text",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["lps=LinearProgramming[c, m,b]", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  FontSize->14],

Cell[BoxData[
    \({4, 0, 0, 9\/2, 2, 0}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["optvalue= N[c.lps]", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  FontSize->14],

Cell[BoxData[
    \(92.5`\)], "Output"]
}, Open  ]],

Cell["\<\
We can see the optimal solution better in the following table.   It \
is certainly not an exciting menu.   In fact, an optimal solution to any \
optimization problem tends to be extreme, and thus it must be modified for \
practical purposes.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["\<\
TableForm[Join[{var},{Prepend[N[lps],optvalue]}]]
\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  FontSize->14],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"\"\>", "\<\"Oatmeal\"\>", "\<\"Chicken\"\>", "\<\"Eggs\"\>", \
"\<\"Milk\"\>", "\<\"Cherry Pie\"\>", "\<\"Pork Beans\"\>"},
          {"92.5`", "4.`", "0.`", "0.`", "4.5`", "2.`", "0.`"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Why is the Vertex Enumeration Useful?", "Section",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
Now we try to do something more reasonable.  We use cddmathlink \
fuction AllVertices:\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["?AllVertices", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \("AllVertices[m,d+1,A] generates all extreme points (vertices) and \
extreme rays of the convex polyhedron in R^(d+1) given as the solution set to \
an inequality system  A x >= 0 where  A is an m*(d+1) matrix  and  \
x=(1,x1,...,xd).  The output is {{extlist, linearity}, ecdlist} where extlist \
is  the extreme point list and ecdlist is the incidence list.  Each vertex \
(ray) has the first component 1 (0).  If the convex polyhedron is nonempty \
and has no vertices, extlist is a (nonunique) set of generators of the \
polyhedron where those generators in the linearity list are considered as \
linearity space (of points satisfying A (0, x1, x2, ...., xd) = 0)  \
generators."\)], "Print",
  CellTags->"Info3248898481-6231000"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
We can then compute ALL possibilities for cost at most, say One \
Dollar.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["BudgetLimit=10111/100;", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[BudgetLimit]\)], "Input"],

Cell[BoxData[
    \(101.11`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
MatrixForm[dietproblem2=Append[dietproblem1, 
  {BudgetLimit, -3, -24, -13, -9, -20, -19}]]\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"0", "1", "0", "0", "0", "0", "0"},
            {"0", "0", "1", "0", "0", "0", "0"},
            {"0", "0", "0", "1", "0", "0", "0"},
            {"0", "0", "0", "0", "1", "0", "0"},
            {"0", "0", "0", "0", "0", "1", "0"},
            {"0", "0", "0", "0", "0", "0", "1"},
            {"4", \(-1\), "0", "0", "0", "0", "0"},
            {"3", "0", \(-1\), "0", "0", "0", "0"},
            {"2", "0", "0", \(-1\), "0", "0", "0"},
            {"8", "0", "0", "0", \(-1\), "0", "0"},
            {"2", "0", "0", "0", "0", \(-1\), "0"},
            {"2", "0", "0", "0", "0", "0", \(-1\)},
            {\(-2000\), "110", "205", "160", "160", "420", "260"},
            {\(-55\), "4", "32", "13", "8", "4", "14"},
            {\(-800\), "2", "12", "54", "285", "22", "80"},
            {\(10111\/100\), \(-3\), \(-24\), \(-13\), \(-9\), \(-20\), \(-19\
\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"],

Cell[CellGroupData[{

Cell["{m2,d2}=Dimensions[dietproblem2]", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({16, 7}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["s1=ToString[dietproblem2,InputForm]", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \("{{0, 1, 0, 0, 0, 0, 0}, {0, 0, 1, 0, 0, 0, 0}, {0, 0, 0, 1, 0, 0, 0}, \
{0, 0, 0, 0, 1, 0, 0}, {0, 0, 0, 0, 0, 1, 0}, {0, 0, 0, 0, 0, 0, 1}, {4, -1, \
0, 0, 0, 0, 0}, {3, 0, -1, 0, 0, 0, 0}, {2, 0, 0, -1, 0, 0, 0}, {8, 0, 0, 0, \
-1, 0, 0}, {2, 0, 0, 0, 0, -1, 0}, {2, 0, 0, 0, 0, 0, -1}, {-2000, 110, 205, \
160, 160, 420, 260}, {-55, 4, 32, 13, 8, 4, 14}, {-800, 2, 12, 54, 285, 22, \
80}, {10111/100, -3, -24, -13, -9, -20, -19}}"\)], "Output"]
}, Open  ]],

Cell["{{extlist,linearity},inclist}=AllVertices[m2,d2,s1];", "Input",
  ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Length[extlist]", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(22\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["vlist=Map[Drop[#,1]&, ToExpression[extlist]]", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({{4, 0, 0, 8, 2\/3, 0}, {4, 0, 0, 9\/2, 2, 0}, {4, 0, 2, 5\/2, 2, 
        0}, {4, 0, 0, 6844\/3065, 2, 4276\/3065}, {1170957\/331150, 0, 0, 
        1796723\/827875, 2, 5397633\/3311500}, {4856\/1275, 0, 2, 
        13421\/5100, 2, 0}, {552\/425, 0, 0, 10807\/1700, 2, 0}, {4, 0, 2, 
        8531\/2900, 1328\/725, 0}, {4, 488\/9975, 2, 97249\/39900, 2, 0}, {4, 
        0, 2, 7957\/3500, 2, 122\/875}, {4, 0, 153643\/83500, 458359\/208750, 
        2, 29818\/104375}, {4, 0, 0, 3903233\/1826250, 1307357\/730500, 
        6551599\/3652500}, {4, 0, 0, 51416\/23475, 2, 48429\/31300}, {4, 
        328\/475, 0, 6869\/1900, 2, 0}, {4, 21949\/73875, 0, 848572\/369375, 
        2, 552209\/492500}, {4, 0, 2, 2311\/900, 2, 0}, {4, 0, 0, 1637\/300, 
        2, 0}, {10869\/4700, 0, 0, 8, 10421\/9400, 0}, {4, 0, 7931\/11300, 8, 
        1128\/2825, 0}, {4, 0, 0, 8, 4357\/13900, 7931\/13900}, {4, 
        7931\/29900, 0, 8, 64249\/119600, 0}, {4, 0, 0, 8, 1711\/2000, 
        0}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["allsolutions=Union[Map[Prepend[#, N[c.#,3]]&, N[vlist,5]]]", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({{92.5`, 4.`, 0.`, 0.`, 4.5`, 2.`, 0.`}, {97.33333333333333`, 4.`, 0.`, 
        0.`, 8.`, 0.6666666666666666`, 0.`}, {98.60358890701468`, 4.`, 0.`, 
        0.`, 2.232952691680261`, 2.`, 1.3951060358890701`}, {100.5`, 4.`, 
        0.`, 2.`, 2.5`, 2.`, 0.`}, {101.10999999999999`, 3.808627450980392`, 
        0.`, 2.`, 2.63156862745098`, 2.`, 0.`}, {101.11`, 
        1.2988235294117647`, 0.`, 0.`, 6.357058823529412`, 2.`, 
        0.`}, {101.11`, 2.3125531914893616`, 0.`, 0.`, 8.`, 
        1.1086170212765958`, 0.`}, {101.11`, 3.5360320096632947`, 0.`, 0.`, 
        2.170282953344406`, 2.`, 1.6299661784689718`}, {101.11`, 4.`, 0.`, 
        0.`, 2.1372939082819986`, 1.7896741957563314`, 
        1.7937300479123888`}, {101.11`, 4.`, 0.`, 0.`, 2.19024494142705`, 
        2.`, 1.5472523961661342`}, {101.11`, 4.`, 0.`, 0.`, 
        5.456666666666667`, 2.`, 0.`}, {101.11`, 4.`, 0.`, 0.`, 8.`, 
        0.3134532374100719`, 0.5705755395683453`}, {101.11`, 4.`, 0.`, 0.`, 
        8.`, 0.8555`, 0.`}, {101.11`, 4.`, 0.`, 0.701858407079646`, 8.`, 
        0.3992920353982301`, 0.`}, {101.11`, 4.`, 0.`, 1.8400359281437126`, 
        2.195731736526946`, 2.`, 0.2856814371257485`}, {101.11`, 4.`, 0.`, 
        2.`, 2.5677777777777777`, 2.`, 0.`}, {101.11`, 4.`, 0.`, 2.`, 
        2.9417241379310344`, 1.8317241379310345`, 0.`}, {101.11`, 4.`, 
        0.04892230576441103`, 2.`, 2.4373182957393484`, 2.`, 0.`}, {101.11`, 
        4.`, 0.26525083612040135`, 0.`, 8.`, 0.5371989966555184`, 
        0.`}, {101.11`, 4.`, 0.29710998307952624`, 0.`, 2.2973184433164127`, 
        2.`, 1.1212365482233502`}, {101.11`, 4.`, 0.6905263157894737`, 0.`, 
        3.615263157894737`, 2.`, 0.`}, {101.11000000000001`, 4.`, 0.`, 2.`, 
        2.2734285714285716`, 2.`, 0.13942857142857143`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["TableForm[table2=Prepend[allsolutions,var]]", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"\"\>", "\<\"Oatmeal\"\>", "\<\"Chicken\"\>", "\<\"Eggs\"\>", \
"\<\"Milk\"\>", "\<\"Cherry Pie\"\>", "\<\"Pork Beans\"\>"},
          {"92.5`", "4.`", "0.`", "0.`", "4.5`", "2.`", "0.`"},
          {"97.33333333333333`", "4.`", "0.`", "0.`", "8.`", 
            "0.6666666666666666`", "0.`"},
          {"98.60358890701468`", "4.`", "0.`", "0.`", "2.232952691680261`", 
            "2.`", "1.3951060358890701`"},
          {"100.5`", "4.`", "0.`", "2.`", "2.5`", "2.`", "0.`"},
          {"101.10999999999999`", "3.808627450980392`", "0.`", "2.`", 
            "2.63156862745098`", "2.`", "0.`"},
          {"101.11`", "1.2988235294117647`", "0.`", "0.`", 
            "6.357058823529412`", "2.`", "0.`"},
          {"101.11`", "2.3125531914893616`", "0.`", "0.`", "8.`", 
            "1.1086170212765958`", "0.`"},
          {"101.11`", "3.5360320096632947`", "0.`", "0.`", 
            "2.170282953344406`", "2.`", "1.6299661784689718`"},
          {"101.11`", "4.`", "0.`", "0.`", "2.1372939082819986`", 
            "1.7896741957563314`", "1.7937300479123888`"},
          {"101.11`", "4.`", "0.`", "0.`", "2.19024494142705`", "2.`", 
            "1.5472523961661342`"},
          {"101.11`", "4.`", "0.`", "0.`", "5.456666666666667`", "2.`", 
            "0.`"},
          {"101.11`", "4.`", "0.`", "0.`", "8.`", "0.3134532374100719`", 
            "0.5705755395683453`"},
          {"101.11`", "4.`", "0.`", "0.`", "8.`", "0.8555`", "0.`"},
          {"101.11`", "4.`", "0.`", "0.701858407079646`", "8.`", 
            "0.3992920353982301`", "0.`"},
          {"101.11`", "4.`", "0.`", "1.8400359281437126`", 
            "2.195731736526946`", "2.`", "0.2856814371257485`"},
          {"101.11`", "4.`", "0.`", "2.`", "2.5677777777777777`", "2.`", 
            "0.`"},
          {"101.11`", "4.`", "0.`", "2.`", "2.9417241379310344`", 
            "1.8317241379310345`", "0.`"},
          {"101.11`", "4.`", "0.04892230576441103`", "2.`", 
            "2.4373182957393484`", "2.`", "0.`"},
          {"101.11`", "4.`", "0.26525083612040135`", "0.`", "8.`", 
            "0.5371989966555184`", "0.`"},
          {"101.11`", "4.`", "0.29710998307952624`", "0.`", 
            "2.2973184433164127`", "2.`", "1.1212365482233502`"},
          {"101.11`", "4.`", "0.6905263157894737`", "0.`", 
            "3.615263157894737`", "2.`", "0.`"},
          {"101.11000000000001`", "4.`", "0.`", "2.`", "2.2734285714285716`", 
            "2.`", "0.13942857142857143`"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output"]
}, Open  ]]
}, Open  ]],

Cell["\<\
The list is complete in the sense that any feasible menu of cost at \
most BudgetLimit is a combination of these seventeen (extreme) solutions.  \
One can find menus with Chicken, Eggs or Pork that might be much more \
desireble than the optimal menu.   Also it shows you cannot avoid Oatmeal nor \
Cherry pie within this budget to satisfy the nutritional needs.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Disconnecting  cddmathlink2", "Section",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["Uninstall[cddml]", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \("/Users/fukuda/Math/cddmathlink2gmp"\)], "Output"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.1 for Macintosh",
ScreenRectangle->{{0, 1152}, {0, 746}},
AutoGeneratedPackage->Automatic,
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{704, 616},
WindowMargins->{{Automatic, 51}, {Automatic, 27}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Info3248898481-6231000"->{
    Cell[9054, 308, 753, 11, 151, "Print",
      CellTags->"Info3248898481-6231000"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Info3248898481-6231000", 19978, 573}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 520, 17, 179, "Title"],
Cell[2228, 69, 231, 4, 92, "Subtitle"],
Cell[2462, 75, 79, 2, 60, "Section"],
Cell[2544, 79, 693, 20, 68, "Text"],

Cell[CellGroupData[{
Cell[3262, 103, 104, 2, 56, "Section",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[3391, 109, 315, 8, 50, "Text",
  InitializationCell->True],
Cell[3709, 119, 120, 2, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[3854, 125, 119, 2, 27, "Input",
  InitializationCell->True],
Cell[3976, 129, 88, 1, 27, "Output"],
Cell[4067, 132, 186, 3, 43, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[4314, 142, 89, 2, 60, "Section"],
Cell[4406, 146, 343, 6, 68, "Text"],

Cell[CellGroupData[{
Cell[4774, 156, 240, 9, 76, "Input"],
Cell[5017, 167, 87, 1, 27, "Output"]
}, Open  ]],
Cell[5119, 171, 495, 13, 172, "Input"],

Cell[CellGroupData[{
Cell[5639, 188, 117, 4, 42, "Input"],
Cell[5759, 194, 1261, 27, 293, "Output"]
}, Open  ]],
Cell[7035, 224, 180, 6, 60, "Input"],
Cell[7218, 232, 207, 6, 32, "Text"],

Cell[CellGroupData[{
Cell[7450, 242, 95, 2, 28, "Input"],
Cell[7548, 246, 55, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7640, 252, 84, 2, 28, "Input"],
Cell[7727, 256, 39, 1, 27, "Output"]
}, Open  ]],
Cell[7781, 260, 298, 6, 50, "Text"],

Cell[CellGroupData[{
Cell[8104, 270, 124, 5, 44, "Input"],
Cell[8231, 277, 443, 11, 53, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8723, 294, 89, 1, 56, "Section"],
Cell[8815, 297, 149, 4, 46, "Subsection"],

Cell[CellGroupData[{
Cell[8989, 305, 62, 1, 27, "Input"],
Cell[9054, 308, 753, 11, 151, "Print",
  CellTags->"Info3248898481-6231000"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9844, 324, 136, 4, 46, "Subsection"],
Cell[9983, 330, 72, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[10080, 335, 47, 1, 27, "Input"],
Cell[10130, 338, 41, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10208, 344, 149, 4, 42, "Input"],
Cell[10360, 350, 1052, 22, 285, "Output"],

Cell[CellGroupData[{
Cell[11437, 376, 82, 1, 27, "Input"],
Cell[11522, 379, 41, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11600, 385, 85, 1, 27, "Input"],
Cell[11688, 388, 468, 6, 107, "Output"]
}, Open  ]],
Cell[12171, 397, 102, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12310, 403, 65, 1, 27, "Input"],
Cell[12378, 406, 36, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12451, 412, 94, 1, 27, "Input"],
Cell[12548, 415, 1011, 14, 280, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13596, 434, 108, 1, 27, "Input"],
Cell[13707, 437, 1817, 25, 235, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15561, 467, 93, 1, 27, "Input"],
Cell[15657, 470, 2721, 51, 389, "Output"]
}, Open  ]]
}, Open  ]],
Cell[18405, 525, 419, 7, 68, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18861, 537, 79, 1, 56, "Section"],

Cell[CellGroupData[{
Cell[18965, 542, 66, 1, 27, "Input"],
Cell[19034, 545, 70, 1, 27, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

