program BMPviewer;

{ GR / VgaMem version, supporting > 64K bitmaps
}

uses Crt, Gr, VgaMem, Bitmap, Dos, WinRes, Objects;

var
  index, count: integer;
  d, m: integer;
  Image: pointer;
  s: PStream;
  bmpfilename: string;
  Dir: DirStr;
  Name: NameStr;
  Ext: ExtStr;

begin
  DirectVideo := false;
  WriteLn('Bitmap Viewer, Copr. 1995 Matthias Kppe');
  WriteLn;
  WriteLn('This is a demonstration program for handling Windows BMP files');
  WriteLn('in DOS by our <Windows Bitmaps for DOS> tool. This version');
  WriteLn('uses VgaMem, so it supports > 64K images.');
  WriteLn;
  If ParamCount = 0
  then count := MaxInt
  else count := ParamCount;
  Index := 1;

  SetGrMode(gr640x480x16);
  InitVgaMem;

  Repeat

    If Count = MaxInt
    then Begin
      Write('Bitmap file to be shown: ');
      Readln(bmpfilename);
      if bmpfilename = '' then break
    End
    else Begin
      bmpFileName := ParamStr(index);
      Inc(index)
    End;

    FSplit(bmpFileName, Dir, Name, Ext);
    If Ext = '' then Ext := '.BMP';
    bmpFileName := Dir + Name + Ext;
    bmpFileName := FSearch(bmpFileName, GetEnv('PATH'));
    If bmpfilename = ''
    then WriteLn('File not found...')
    else begin

      InitGraphics;

      s := new(pdosstream, Init(bmpfilename, stOpenRead));
      Image := Loadbitmapfileimg(s^);
      Dispose(s, done);

      If Image <> nil then
      PasteImage(0, 0, Image, normalput);
      FreeImage(Image);

      Readkey;
      CloseGraphics;

    end;
  Until Index > Count;

  DoneVgaMem;
end.
