; Coloumn Cache Definitions, Copr. 1994 Matthias Kppe

		INCLUDE	grdef.asm

	; TCacheHeader struc definition

TCacheHeader	STRUC
  chReserved	DW	?	; reserviert fr Offset
  chColHeight	DW	?	; Hhe einer Spalte = Byteabstand der Spalten
  chStartOfs	DW	?	; Offset der ersten Bytespalte im Ringpuffer
  chStartCol	DW	?	; Nummer der ersten Bytespalte
  chWrapOfs	DW	?	; Umbruch-Offset
  chDest	DD	?	; Bildadresse
  chLeftCol	DW	?	; Nummer der linken Bytespalte
  chRightCol	DW	?	; Nummer der rechten Bytespalte
  chLeftMask	DB	?	; Linke Randmaske
  chRightMask	DB	?	; Rechte Randmaske
  chMask	DB	?	; Zusatz-Maske
  chFlushProc	DW	?	; Flush proc
  chColor	DW	?	; Color
  chBkColor	DW	?	; Background color
  chBPL		DW	?	; bytes per line
  chWindowSize	DW	?	; VESA Window Size
  chTemp1	DW	?	; ccach256 will store DSeg here
  chTemp2	DW	?	; ccach256 will store DS here
TCacheHeader	ENDS

DATA		SEGMENT WORD PUBLIC

	; Setup proc prototype
	;
	; In:	es:bx	TCacheHeader struc
	;	ax	start x
	;	dx	start y
	;
	; Out:	ax, cx, dx, di destroyed

		EXTRN	SetupProc: WORD

	; Flush proc prototype
	;
	; In:	es:bx	TCacheHeader struc
	;	es:di	coloumn to be flushed
	;	ds:si	the address
	;	ax	the number of the coloumn
	;
	; Out:	ds:si	address of the next coloumn
	;	ax,bx,di saved

		EXTRN	FlushProc: WORD
		EXTRN	FlushTrans: WORD

DATA		ENDS

CODE		SEGMENT BYTE PUBLIC

	; SetupCache procedure
	;
	; In:	es:bx	TCacheHeader struc
	;	ax	start x
	;	dx	start y
	;	cx	height
	;	si	coloumn count

		GLOBAL	SetupCache: NEAR

	; GotoPos procedure
	;
	; In:	es:bx	TCacheHeader struc
	;	ax	horiz pixel position
	;
	; Out:	di	offset of the coloumn to write in
	;	cl	shift value

		GLOBAL	GotoPos: NEAR

	; SetRightPos procedure
	;
	; In:	es:bx   TCachHeader struc
	;	ax	end pos

		GLOBAL	SetRightPos: NEAR

CODE		ENDS

	; Wrap macro
	;
	; In:	Reg	an offset of a coloumn
	;	es:bx	TCacheHeader struc
	; Out:	Reg	the wrapped offset of the coloumn

Wrap		MACRO	Reg
		LOCAL	@@1
Cache		EQU	es:[bx].TCacheHeader
		mov	ax, Reg
		sub	ax, Cache.chWrapOfs
		jb	SHORT @@1
		add	ax, TYPE TCacheHeader
		add	ax, bx
		mov	Reg, ax
@@1:
		ENDM

	; NextCol macro
	;
	; In:	Reg	an offset of a coloumn
	;	es:bx   TCacheHeader struc
	; Out:	Reg	the offset of the next coloumn

NextCol		MACRO	Reg
Cache		EQU	es:[bx].TCacheHeader
		add	Reg, Cache.chColHeight
		Wrap	Reg
		ENDM
