unit MAnimate;

{ Mouse cursor animations, MyMouse sample unit, Copr. 1994 Matthias K"oppe

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}

interface

uses Objects;

{ Animation management object
}
type
  PAnimation = ^TAnimation;
  TAnimation = object(TCollection)
    Num, Step, Cur: Integer;
    LastTicks: Word;
    constructor Init(ANum, AStep: Integer);
    constructor Load(var S: TStream);
    procedure ChangeCursor;
    procedure FreeItem(Item: Pointer); virtual;
    function GetCursor(n: Integer): Boolean;
    function GetItem(var S: TStream): Pointer; virtual;
    procedure PutItem(var S: TStream; Item: Pointer); virtual;
    procedure Store(var S: TStream);
  end;

{ Call AnimTimer when a timer click has occured.
}
procedure AnimTimer;

implementation

uses WinRes, MyMouse;

var
  Ticks: Word				absolute $40:$6C;

constructor TAnimation.Init;
Begin
  TCollection.Init(10, 10);
  Num := ANum;
  Step := AStep;
End;

constructor TAnimation.Load;
Begin
  TCollection.Load(S);
  S.Read(Num, 4)
End;

procedure TAnimation.ChangeCursor; assembler;
asm
	mov	es, Seg0040
	mov	ax, es:Ticks
	les	di, Self
	mov	cx, es:[di].TAnimation.LastTicks
	add	cx, es:[di].TAnimation.Step
	cmp	ax, cx
	mov	bx, es:[di].TAnimation.Cur
	jb	@@2
	mov	es:[di].TAnimation.LastTicks, ax
	inc	bx
	cmp	bx, es:[di].TCollection.Count
	jb	@@1
	mov	bx, 0
@@1:	mov	es:[di].TAnimation.Cur, bx
@@2:    add	bx, es:[di].TAnimation.Num
	mov	MyMouse.NewNum, bx
end;

procedure TAnimation.FreeItem;
Begin
  Dispose(PMyCursor(Item))
End;

function TAnimation.GetCursor;
Begin
  GetCursor := false;
  If (n >= Num) and (n < Num + Count)
  then Begin
    MyMouse.CursorPtr := At(n - Num);
    GetCursor := true
  End
End;

function TAnimation.GetItem;
var
  Item: PMyCursor;
Begin
  New(Item);
  S.Read(Item, SizeOf(Item));
  GetItem := Item
End;

procedure TAnimation.PutItem;
Begin
  S.Write(Item^, SizeOf(TMyCursor))
End;

procedure TAnimation.Store;
Begin
  TCollection.Store(S);
  S.Write(Num, 4)
End;

procedure AnimTimer;
Begin
  { initiate a ChangeCursor call }
  with CriticalArea do SetCriticalArea(A.x, A.y, B.x, B.y)
End;

End.
