; MyMouse, Real mode support assembler source, Copr. 1994 Matthias Kppe

		INCLUDE	mymodef.asm

		PUBLIC	HandleDrvReqDummy, HandleDrvReq, HandleDrvReq386, \
			InitDrvReq, DoneDrvReq, CallSavedDrvReq

CODE		SEGMENT BYTE PUBLIC

HandleDrvReqDummy	PROC FAR
			retf
HandleDrvReqDummy	ENDP

DoHandleDrvReq	PROC FAR
		test	MouseMode, mmAltMul
		jnz	@@2
		SHL	CX, 3
		SHL	DX, 3
@@2:
		CMP	InMouse, 0
		JNZ	@@1
		CALL	MouseInt
		CALL	UpdateMouse
		ret
@@1:		CALL	StoreEvent
		ret
DoHandleDrvReq	ENDP

HandleDrvReq	PROC FAR
		push	ds
		mov	si, SEG DATA
		mov	ds, si
		mov     WORD PTR CallStack[0], sp
		mov	WORD PTR CallStack[2], ss
		mov	ss, WORD PTR MouseStackPointer[2]
		mov	sp, WORD PTR MouseStackPointer[0]
		push	es
		call	DoHandleDrvReq
		pop	es
		mov	ss, WORD PTR CallStack[2]
		mov	sp, WORD PTR CallStack[0]
		pop	ds
		retf
HandleDrvReq	ENDP

.386

HandleDrvReq386	PROC FAR
		push	ds
		mov	si, SEG DATA
		mov	ds, si
		mov     WORD PTR CallStack[0], sp
		mov	WORD PTR CallStack[2], ss
		lss	sp, MouseStackPointer
		pushad
		push	es fs gs
		call	DoHandleDrvReq
		pop	gs fs es
		popad
		lss	sp, CallStack
		pop	ds
		retf
HandleDrvReq386	ENDP

.286

InitDrvReq	PROC NEAR
		ARG	Service: DWORD = ArgSize
		push	bp
		mov	bp, sp
		MOV	AX, 0Ch
			; 14h is not commonly supported by DOS extenders
		MOV	CX, 0FFFFh
		LES	DX, Service
		INT	33h
		;MOV	WORD PTR SavedDrvReq, DX
		;MOV	WORD PTR SavedDrvReq + 2, ES
		;mov	WORD PTR MouseInt[0], dx
		;mov	WORD PTR MouseInt[2], es
		CALL	DrvMouseArea
		pop	bp
		retn	ArgSize
InitDrvReq	ENDP

DoneDrvReq	PROC NEAR
		MOV	AX, 0Ch
		xor	cx, cx
		xor	dx, dx
		mov	es, dx
		;MOV	CX, 0FFFFh
		;LES	DX, SavedDrvReq
		INT	33H
		retn
DoneDrvReq	ENDP

CallSavedDrvReq	PROC FAR
		jmp	SavedDrvReq
CallSavedDrvReq	ENDP

CODE		ENDS

		END
