program TrueTypeDemo;

uses
  Dos, Objects, Strings, Drivers, Views, HistList,
  Gr, WinRes, MetaGr, Bitmap, ExtGraph, GvDriver, MyMouse, MyFonts,
  vesa, mymofast,
  GvViews, GvDialog, GvMenus, GvApp, GvMsgBox, GvStdDlg, GVTexts,
  GvBitmap, GvWinDlg, GvGadget, GvClock, GvEyes, GvFonts, GvFiler;

var
  Res: PStream;

const
  CTextInterior = #20#19;

type
{ TTextInterior object
}
  PTextInterior = ^TTextInterior;
  TTextInterior = object (TScroller)
    Strings: TStringCollection;
    constructor Init(var Bounds: TRect; AHScrollBar,
	AVScrollBar: PScrollBar; FileName: PathStr);
    destructor Done; virtual;
    procedure Draw; virtual;
    function GetPalette: PPalette; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure ReadFile(FileName: PathStr); virtual;
  end;

{ TTextWindow object
}
  PTextWindow = ^TTextWindow;
  TTextWindow = object (TWindow)
    constructor Init (var Bounds: TRect; WinTitle: String;
      ANumber: Integer);
  end;

{ TBitmapWindow object
}
  PBitmapWindow = ^TBitmapWindow;
  TBitmapWindow = object(TWindow)
    constructor Init(Bounds: TRect; WinTitle: String;
      WindowNo: Word);
  end;

{ TMorphWindow object
}
  PMorphWindow = ^TMorphWindow;
  TMorphWindow = object(TWindow)
    constructor Init(var Bounds: TRect);
    procedure Locate(var R: TRect); virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure Zoom; virtual;
  end;

{ Application
}
  TFormApp = object(TApplication)
    Heap: PHeapView;
    constructor Init;
    destructor Done; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure Idle; virtual;
    procedure InitDesktop; virtual;
    procedure InitMenuBar; virtual;
    procedure InitStatusLine; virtual;
  end;

(*************************** TTextInterior object ***************************)

constructor TTextInterior.Init;
Begin
  TScroller.Init (Bounds, AHScrollBar, AVScrollBar);
  GrowMode:=gfGrowHiX + gfGrowHiY;
  ReadFile (FileName);
End;

destructor TTextInterior.Done;
Begin
  Strings.Done;
  TGView.Done;
End;

procedure TTextInterior.Draw;
var
  I, j: Integer;
  S, Ins: String;
Begin
  { Background
  }
  SetFillStyle(SolidFill, GetColor(1));
  Bar(0, 0, Size.X-1, Size.Y-1);
  { Text
  }
  SetTextParams(ftMonoSpace, 0, GetColor(2), false);
  SetTextJustify(LeftText, CenterText);
  Ins := '        ';
  For I := Delta.Y to Delta.Y + Size.Y div TextSize.Y do
    If I < Strings.Count
    then Begin
      S := PString(Strings.At(I))^;
      { Tab conversion
      }
      j := 1;
      while j <= Length(S) do
	if S[j] = #9
	then begin
	  Ins[0] := Chr(7 - (j - 1) mod 8);
	  Insert(Ins, S, j + 1);
	  S[j] := ' ';
	  Inc(j, Length(Ins) + 1)
	end
	else Inc(j);
      { Output the text line
      }
      OutTextXY(- Delta.X * TextSize.X,
	(I - Delta.Y) * TextSize.Y + TextSize.Y div 2, S)
    End;
End;

procedure TTextInterior.ReadFile;
var F: Text;
    S: String;
    I: Integer;
Begin
  Strings.Init (30,10);
  Strings.Duplicates:=true;
  Assign (F, FileName);
  {$I-}
  Reset (F);
  While not EOF (F) and (IOResult = 0) do Begin
    ReadLn (F, S);
    If S='' then S:=' ';
    Strings.AtInsert (Strings.Count, NewStr (S));
  End;
  Close (F);
  {$I+}
  SetLimit (100, Strings.Count);
End;

function TTextInterior.GetPalette;
const
  P: String [Length (CTextInterior)] = CTextInterior;
Begin
  GetPalette:=@P;
End;

procedure TTextInterior.HandleEvent;
Begin
  TScroller.HandleEvent(Event);
End;

(**************************** TTextWindow object ****************************)

constructor TTextWindow.Init;
var R: TRect;
Begin
  TWindow.Init (Bounds, WinTitle, ANumber);
  GetExtent (R);
  R.Grow (-4,-4);
  R.A.Y:=23;
  Dec (R.B.X, 17); Dec (R.B.Y, 17);
  Insert (New (PTextInterior, Init (R,
    StandardScrollBar (sbHorizontal+sbHandleKeyboard),
    StandardScrollBar (sbVertical+sbHandleKeyboard),
    WinTitle)));
End;

(**************************** TBitmapWindow object **************************)

constructor TBitmapWindow.Init(Bounds: TRect; WinTitle: String;
  WindowNo: Word);
var
  HScrollBar, VScrollBar: PScrollBar;
  Interior: PGView;
begin
  TWindow.Init(Bounds, WinTitle, WindowNo);

  VScrollBar := StandardScrollBar(sbVertical + sbHandleKeyboard);
  HScrollBar := StandardScrollBar(sbHorizontal + sbHandleKeyboard);

  GetExtent(Bounds);
  Bounds.Grow(-4,-4);
  Bounds.A.Y := 23; Dec(Bounds.B.X, 17); Dec(Bounds.B.Y, 17);

  Interior := New(PBmpScroller, Init(Bounds, HScrollBar, VScrollBar, WinTitle));
  Insert(Interior);
end;

{ TMorphWindow object 
}

constructor TMorphWindow.Init(var Bounds: TRect);
var
  R: TRect;
  BmpView: PGView;
  IL: PInputLine;
  sb: PScrollBar;
  cl: PCluster;
  w: Word;
  s: string;
  left: Integer;
  Dir: DirStr;
  Name: NameStr;
  Ext: ExtStr;
begin
  MessageBox(
    'The window appearing soon is a, say, funny one. ' +
    'Please don''t take it too seriously.'^m^m +
    'However, it shows the wonderful move from text mode to Graphics Vision.',
    nil, mfOKButton + mfWarning);
  R.Assign(0, 0, 0, 0);
  FSplit(ParamStr(0), Dir, Name, Ext);
  BmpView := New(PBmpView, InitByFile(R, Dir + 'tvmorph.bmp', bmfAdjustSize));
  BmpView^.GetExtent(R);
  R.Move(Bounds.A.x, Bounds.A.y);
  If R.Empty
  then begin
    left := 100;
    MessageBox('Funny bitmap is not available. Check the path.',
      nil, mfOKButton + mfError);
    R.B.y := Bounds.B.y;
  end
  else
    left := BmpView^.Size.x;
  R.B.x := Bounds.B.x;
  TWindow.Init(R, 'Window Window', 0);
  Palette := wpGrayWindow;
  sb := StandardScrollBar(sbHorizontal);
  with sb^ do
  begin
    GetBounds(R);
    Dec(R.B.x, 2);
    Dec(R.A.y, 2); Dec(R.B.y);
    ChangeBounds(R);
    SetState(sfDisabled, true);
  end;
  sb := StandardScrollBar(sbVertical);
  with sb^ do
  begin
    GetBounds(R);
    Dec(R.B.y, 2);
    Dec(R.A.x, 2); Dec(R.B.x);
    ChangeBounds(R);
    SetParams(20, 0, 100, 10, 1);
  end;

  R.Assign(left - 1, 66, 355, 89);
  IL := New(PInputLine, Init(R, 80));
  s := 'efficiency'; IL^.SetData(s);
  Insert(IL);

  R.Assign(355, 66, 372, 89);
  Insert(New(PHistory, Init(R, IL, 77)));
  s := 'design'; HistoryAdd(77, s);
  s := 'technology'; HistoryAdd(77, s);
  s := 'evolution'; HistoryAdd(77, s);

  R.Assign(left + 10, 110, Size.x - 30, 176);
  cl := New(PCheckBoxes, Init(R,
    NewSItem('~C~omfort in usage',
    NewSItem('~G~reater performance',
    NewSItem('~I~ntelligence enabled',
    NewSItem('~A~lways Graphics Vision',
    nil))))));
  w := 15; cl^.SetData(w);
  Insert(cl);

  Insert(BmpView);

  R.Assign(left + 20, 198, left + 131, 221);
  Insert(New(PButton, Init(R, 'That''s it', cmClose, bfDefault)));

  SelectNext(false)
end;

procedure TMorphWindow.Zoom;
begin
  MessageBoxTitle(
    'No, I don''t want to...',
    'Zooming is boring. You can do it with other windows but me.',
    nil, mfError + mfCancelButton)
end;

procedure TMorphWindow.Locate;
var
  NewSize: TPoint;
begin
  NewSize.x := R.B.x - R.A.x;
  NewSize.y := R.B.y - R.A.y;
  SetCurrentCursor(mcNoCursor);
  if LongInt(NewSize) <> LongInt(Size)
  then MessageBoxTitle(
    'No, I don''t want to...',
    'Listen, would you like to be stretched, shrunk, or distorted? ' +
    'I think you wouldn''t like to. Either do I.',
    nil, mfError + mfCancelButton)
  else begin
    TWindow.Locate(R);
    MessageBoxTitle(
      'Thank you',
      'Moving is great. I''ve always been quite mobile...',
      nil, mfInformation + mfOKButton)
  end
end;

procedure TMorphWindow.HandleEvent(var Event: TEvent);
var
  R: TRect;
begin
  TWindow.HandleEvent(Event);
  If Event.What = evCommand then
    case Event.Command of
      cmClose: Close;
    end
  else
  if (Event.What = evBroadcast) and (Event.Command = cmScrollbarChanged)
  then MessageBoxTitle(
    'Hey',
    'Speaking between you and me, what did ya expect this scrollbar to scroll? ' +
    'Well, it scrolls itself. That''s enough, ain''t it.',
    nil, mfInformation + mfOKButton)
  else
  if not GetState(sfDragging) then
  if Event.What = evTimer
  then begin
    if Random(800) = 0
    then begin
      if MessageBoxTitle(
	'Excuse me',
	'I''d like to move a bit. May I?',
	nil, mfConfirmation + mfYesButton + mfNoButton) = cmYes
      then begin
	GOwner^.GetExtent(R);
	MoveTo(Random(R.B.x - Size.x), Random(R.B.y - Size.y))
      end
    end;
  end
end;

{ 
}

constructor TFormApp.Init;
var
  Dir: DirStr;
  Name: NameStr;
  Ext: ExtStr;
  R: TRect;
Begin
  Randomize;
  Res := OpenResource('ttdemo.dll');
  If Res^.Status <> 0
  then begin
    WriteLn('Resource ttdemo.dll not found.');
    Halt(1)
  end;
  InitClasses;
  RegisterGvWinDlg;
  inherited Init;
  R.Assign (Size.X-71, Size.Y-21, Size.X+1, Size.Y+1);
  Heap:=New (PHeapView, Init (R));
  If Heap<>nil then Insert (Heap);
End;

procedure TFormApp.HandleEvent;
var
  l: LongInt;

  procedure FileOpen(FileName: PathStr);
  var
    R: TRect;
  Begin
    R.Assign(0, 0, 400, 300);
    R.Move(Random(240), Random(140));
    Desktop^.Insert(New(PTextWindow, Init(R, Filename, wnJustANumber)));
  End;

  procedure OpenFileDlg;
  var
    D: PFileDialog;
    S: PathStr;
  begin
    D := New(PFileDialog, Init('*.txt', 'Open a text file', 'Name',
      fdOpenButton, 0));
    if Desktop^.ExecView(D) <> cmCancel
    then begin
      D^.GetFileName(S);
      FileOpen(S)
    end;
    Dispose(D, Done)
  end;

  procedure BitmapOpen(FileName: PathStr);
  var
    R: TRect;
  Begin
    R.Assign(0, 0, 300, 200);
    R.Move(Random(340), Random(240));
    Desktop^.Insert(New(PBitmapWindow, Init(R, Filename, wnJustANumber)));
  End;

  procedure OpenBitmapDlg;
  var
    D: PFileDialog;
    S: PathStr;
  begin
    D := New(PFileDialog, Init('*.bmp', 'Open a bitmap file', 'Name',
      fdOpenButton, 0));
    if Desktop^.ExecView(D) <> cmCancel
    then begin
      D^.GetFileName(S);
      BitmapOpen(S)
    end;
    Dispose(D, Done)
  end;

  procedure ShowMorph;
  var
    R: TRect;
    Window: PWindow;
  begin
    R.Assign(0, 0, 421, 260);
    R.Move(Random(220), Random(200));
    Window := New(PMorphWindow, Init(R));
    Desktop^.Insert(Window)
  end;

  procedure ShowClock;
  var
    R: TRect;
    Window: PWindow;
    i: Integer;
  begin
    i := Random(150) + 80;
    R.Assign(0, 0, i, i);
    R.Move(Random(Desktop^.Size.X-i), Random(Desktop^.Size.Y-i));
    Window := New(PStandardClockWindow, Init(R, clmAnalog, nil));
    Desktop^.Insert(Window)
  end;

  procedure ShowEyes;
  var
    R: TRect;
    Window: PWindow;
    i: Integer;
  begin
    i := Random(150) + 80;
    R.Assign(0, 0, i, i);
    R.Move(Random(Desktop^.Size.X-i), Random(Desktop^.Size.Y-i));
    Window := New(PEyeWindow, Init(R));
    Desktop^.Insert(Window)
  end;

  procedure ShowCharMap;
  var
    W: PCharMapWindow;
    R: TRect;
  begin
    R.Assign(0, 0, 400, 250);
    W := New(PCharMapWindow, Init(R));
    W^.Options := W^.Options or ofCentered;
    Desktop^.Insert(W)
  end;

  procedure ShowFiler;
  var
    W: PWindow;
    R, Client, Sheet: TRect;
  begin
    R.Assign(0, 0, 300, 300);
    R.Move(Random(340), Random(140));
    W := New(PWindow, Init(R, 'Filer Window', wnJustANumber));
    with W^ do
    begin
      Palette := wpGrayWindow;
      GetClientRect(Client);
      R.Assign(Client.A.X, Client.A.Y, Client.B.X, Client.A.Y + 20);
      with PFilerBar(Insert(New(PFilerBar, Init(R, fbProportionalWidth))))^ do
      begin
	Sheet.Assign(Client.A.X, Client.A.Y + 20, Client.B.X, Client.B.Y);
	with InsertSheet(New(PFilerSheet, Init(Sheet, 'Eyes')))^ do
	begin
	  R.Assign(10, 10, Size.X - 10, Size.Y - 10);
	  Insert(New(PEyes, Init(R)))
	end;
	with InsertSheet(New(PFilerSheet, Init(Sheet, 'Clock')))^ do
	begin
          R.Assign(9, 9, Size.X - 9, Size.Y - 9);
	  PGView(Insert(New(PLevel, Init(R, -1))))^.GrowMode := gfGrowHiX + gfGrowHiY;
	  R.Assign(10, 10, Size.X - 10, Size.Y - 10);
	  Insert(New(PClock, Init(R)))
	end;
	with InsertSheet(New(PFilerSheet, Init(Sheet, 'Several Clocks')))^ do
	begin
	  R.Assign(10, 10, Size.X div 2 - 10, Size.Y div 2 - 10);
	  { Oh what nicely complicated expressions are possible with
	    a functional TGGroup.Insert...
	  }
	  PGView(Insert(New(PClock, Init(R))))^.GrowMode :=
	    gfGrowHiX + gfGrowHiY;
	  R.Move(Size.X div 2, 0);
	  PGView(Insert(New(PClock, Init(R))))^.GrowMode :=
	    gfGrowLoX + gfGrowHiX + gfGrowHiY;
	  R.Move(0, Size.Y div 2);
	  PGView(Insert(New(PClock, Init(R))))^.GrowMode :=
	    gfGrowLoX + gfGrowHiX + gfGrowLoY + gfGrowHiY;
	  R.Move(-Size.X div 2, 0);
	  PGView(Insert(New(PClock, Init(R))))^.GrowMode :=
	    gfGrowHiX + gfGrowLoY + gfGrowHiY
	end;
      end
    end;
    Desktop^.Insert(W)
  end;

Begin
  inherited HandleEvent(Event);
  If Event.What = evCommand then
  case Event.Command of
    101: ShowEyes;
    102: ShowMorph;
    103: ShowClock;
    104: OpenFileDlg;
    105: OpenBitmapDlg;
    106: ShowFiler;
    201: FileOpen('truetype.doc');
    202: FileOpen('gvision.doc');
    203: FileOpen('sharware.doc');
    204: FileOpen('cis.doc');
    205: FileOpen('pslorder.doc');
    206: FileOpen('mkmorder.doc');
    207: FileOpen('dist.doc');
    208: FileOpen('register.doc');
    209: FileOpen('license.doc');
    301: ShowCharMap;
    302: EndModal(cmQuit);
  end
End;

procedure TFormApp.Idle;
begin
  inherited Idle;
  Heap^.Update;
end;

procedure TFormApp.InitDesktop;
var
  R: TRect;
begin
  GetExtent(R);
  R.Grow (0,-21);
  Desktop := New(PNewDesktop, Init(R, 'c:\windows\blaetter.bmp'))
end;

procedure TFormApp.InitMenuBar;
var
  R: TRect;
Begin
  GetExtent(R);
  R.B.Y := 21;
  MenuBar := New(PMenuBar, Init(R,
    LoadMenu(Res^, nil, mo_GraphicsVision)));
End;

procedure TFormApp.InitStatusLine;
var
  R: TRect;
Begin
  GetExtent(R);
  R.A.Y := R.B.Y - 21;
  StatusLine := New(PStatusLine, Init(R,
    NewStatusDef(0, $FFFF,
      NewStatusKey('~Alt+X~ Exit Demo', kbAltX, cmQuit,
      StdStatusKeys(
      nil)),
    nil)))
End;

destructor TFormApp.Done;
Begin
  inherited Done;
  DoneClasses;
  Dispose(Res, Done);
End;

var
  FormApp: TFormApp;

Begin
  Language := lfEnglish;
  FormApp.Init;
  FormApp.Run;
  FormApp.Done
End.

