uses Gr, Objects, Crt, Graph, Bgi, ttColor;

{ 
}
procedure Cross(X, Y: Integer);
begin
  Line(X - 10, Y, X + 10, Y);
  Line(X, Y - 10, X, Y + 10)
end;

var
  Back, Fore: TColor;
  {Coll: PColorCollection;}

{procedure Out(A: TColor; Col: Word; DrawCross: Boolean);
var
  X, Y: Integer;
begin
  X := Round(Parameter(Back, A, Fore) * 256 + 30);
  Y := Round(Epsilon(Back, A, Fore) + 10);
  If DrawCross
  then begin
    SetColor(Col);
    Cross(X, Y)
  end;
  PutPixel(X, Y, Col)
end;}

var
  P: TColor;
  i: Integer;
  {E: PColorEntry;}
  x: Real;
  Dist: PChar;

begin
  SetGrMode(gr320x200x256);
  Randomize;
  Repeat
    CloseGraphics;
    InitGraphics;
    For i := 1 to 254 do
      SetRGBPalette(i, Random(64) shl 2, Random(64) shl 2, Random(64) shl 2);
    SetRGBPalette(255, $FC, $FC, $FC);
    UserParams(3); GrNotifyProc(gnpPalette, 0);
    {MakeColor(0, 0, 0, Back);}
    MakeColor(Random(256), Random(256), Random(256), Back);
    {with DevicePalette[Random(256)] do
      MakeColor(rgbtBlue, rgbtGreen, rgbtRed, Back);}
    {MakeColor(255, 255, 255, Fore);}
    MakeColor(Random(256), Random(256), Random(256), Fore);
    {Out(Back, 255, true);
    Out(Fore, 255, true);}

    {Coll := New(PColorCollection, Init(32, 32));
    For i := 0 to 255 do
    begin
      with DevicePalette[i] do
	MakeColor(rgbtBlue, rgbtGreen, rgbtRed, P);
      Out(P, i, false);
      If Epsilon(Back, P, Fore) < MaxEpsilon
      then begin
	x := Parameter(Back, P, Fore);
	If (x >= 0) and (x <= 1)
	then begin
	  New(E);
	  E^.Index := i;
	  E^.Parameter := x;
	  Coll^.Insert(E)
	end
      end;
    end;

    Dist := Coll^.GetDistribution;
    Dispose(Coll, Done);}
    Dist := Interpolation(Back, Fore);
    For i := 0 to 255 do
    begin
      SetColor(Byte(Dist[i]));
      Line(i + 30, 0, i + 30, 10)
    end;
    FreeMem(Dist, 256);

  until readkey = #27;
  CloseGraphics
end.
