; VgaMem, 16 colors assembler source, Copr. 1994 Matthias Kppe

	;;  $Id: vmem16.asm 1.3 1999/02/09 16:36:15 mkoeppe Exp $
	
; Major Change: PutImage_ is now FAR
; 		Capabilities

		INCLUDE	vmemdef.asm
		INCLUDE grserv.asm

		EXTRN	SelOfs: FAR, PageAddr: FAR, SaveRegs: FAR, \
			RestoreRegs: FAR, SetActiveWindow: FAR

		EXTRN	CopyScreen: FAR, GetSize: FAR

CODE		SEGMENT BYTE PUBLIC

		PUBLIC	Table_16, GetSize16, GetBPL16, \
			SaveScreen16, RestoreScreen16, CopyMem16, CopyScreen16

GetBPL_16	PROC NEAR
		ARG	x2, x1: WORD = ArgSize
		push	bp
		mov	bp, sp
		MOV	SI, x1
		SAR	SI, 3
		MOV	AX, x2
		DEC	AX
		SAR	AX, 3
		SUB	AX, SI
		INC	AX
		pop	bp
		retn	ArgSize
GetBPL_16	ENDP

	; This returns the required memory in bytes.

GetSize_16	PROC NEAR
		ARG 	y2: WORD, x2: WORD, y1: WORD, x1: WORD = ArgSize
		push	bp
		mov	bp, sp
		MOV	SI, x1
		SAR	SI, 3
		MOV	DI, x2
		DEC	DI
		SAR	DI, 3
		SUB	DI, SI
		INC	DI
		MOV	AX, y2
		SUB	AX, y1
		MUL	DI
		pop	bp
		retn	ArgSize
GetSize_16	ENDP

SaveScreen_16	PROC NEAR
		ARG	Addr: WORD, y2: WORD, x2: WORD, \
			y1: WORD, x1: WORD = ArgSize
		push	bp
		mov	bp, sp
		MOV     DX, 03CEH		; GC
		MOV	AX, 0105H		; Write Mode 1
		OUT	DX, AX
		MOV	BX, BytesPerLine
		MOV	AX, Page0Seg
		ADD	AX, Addr
		PUSH	AX
		PUSH	0
		CALL	SelOfs
		MOV	ES, DX
		MOV	DI, AX
		PUSH	SourcePage
		CALL	PageAddr
		PUSH	DS
		MOV	DS, DX
		MOV	CX, AX
		MOV	AX, y1
		MUL	BX
		MOV	SI, x1
		SAR     SI, 3
		MOV	DX, x2
		DEC	DX
		SAR	DX, 3
		SUB	DX, SI
		INC	DX			; Anzahl Bytes horizontal
		ADD	SI, AX
		ADD	SI, CX
		CLD
		MOV	CX, y2
		SUB	CX, y1
		SUB	BX, DX
@@1:    	PUSH	CX
		MOV	CX, DX
		REP	MOVSB			; nur zur Erzeugung der R/W-Zyklen
		ADD     SI, BX
		POP	CX
		LOOP    @@1
		POP	DS
		MOV	DX, 03CEH
		MOV	AX, 0005H		; Write Mode 0
		OUT	DX, AX
		pop	bp
		retn	ArgSize
SaveScreen_16	ENDP

SetVgaReg	MACRO Read, Write
		MOV	DX, 03CEH
		MOV	AX, Read * 100H + 04H
		OUT	DX, AX
		MOV	DX, 03C4H
		MOV	AX, Write * 100H + 02H
		OUT	DX, AX
		ENDM

CopyByteRest	PROC NEAR
		SetVgaReg 0, 1
		MOV	AL, [SI]
		XCHG	es:[DI], AL
		SetVgaReg 1, 2
		MOV	AL, [SI]
		XCHG	es:[DI], AL
		SetVgaReg 2, 4
		MOV	AL, [SI]
		XCHG	es:[DI], AL
		SetVgaReg 3, 8
		LODSB				; inc/dec
		MOV	AH, es:[DI]
		STOSB
		retn
CopyByteRest	ENDP

RestoreScreen_16	PROC NEAR
		ARG	Addr: WORD, y3: WORD, x3: WORD, y2: WORD, \
			x2: WORD, y1: WORD, x1: WORD = ArgSize
		LOCAL	Method: BYTE, Mask1: BYTE, Mask2: BYTE, \
			Shift: BYTE, WriteMap: BYTE, ReadMap: BYTE, \
			SourceDelta: WORD = LocalSize
		enter	LocalSize, 0
		CALL	SaveRegs
		MOV	AX, ClipRect.A.x
		MOV	CX, AX
		MOV	BX, x3
		SUB	AX, BX
		JAE	@@30
		XOR	AX, AX			; echte Differenz ClipRect.A.x - x3
		MOV	CX, BX
@@30:		MOV	DI, CX
		SAR	DI, 3			; Adresse des linken Randes
		AND	CL, 7
		MOV	SI, x1
		AND	SI, 7
		ADD	SI, AX
		SAR	SI, 3			; Offset zur Quelle
		ADD	AX, x1
		AND	AX, 7
		MOV	DX, x1
		SUB	DX, x3
		AND	DX, 7
		CMP	AX, DX
		MOV	AL, "A"
		JL	@@32
		MOV	AL, "B"
@@32:		MOV	Method, AL
		MOV	AL, 0FFH
		SHR	AL, CL
		MOV	Mask1, AL		; linke Randmaske

		MOV	AX, ClipRect.B.x
		MOV	CX, AX
		SUB	AX, x3
		ADD	AX, x1
		MOV	DX, x2
		CMP	AX, DX
		JL	@@31
		MOV	CX, x3
		ADD	CX, x2
		SUB	CX, x1			; "x4"
		MOV	AX, DX
@@31:
		MOV	BX, AX			; in AX: min(Clip.B.x', x2)
		SAR	AX, 3
		MOV	DX, x1
		SAR	DX, 3
		SUB	AX, DX
		SUB	AX, SI			; Anzahl der Quellbytes - 1
		JL 	@@55
		mov	dx, bx
		AND	DX, 7
		MOV	BX, x1
		SUB	BX, x3
		AND	BX, 7
		CMP	DX, BX
		Jb	@@36
		INC	AX
@@36:
		MOV	DX, 0FF00H
		AND	CL, 7
		SHR	DX, CL
		MOV	Mask2, DL		; rechte Randmaske

		MOV     DX, x1
		SAR     DX, 3
		MOV	CX, x2
		DEC	CX			; TV-Notation
		SAR	CX, 3
		SUB	CX, DX
		INC	CX
		MOV	SourceDelta, CX		; Anzahl Bytes horizontal in Quelle
		MOV	DX, AX			; Anzahl der Quellbytes - 1

		MOV	BX, BytesPerLine	; Anzahl der Bytes pro Bildzeile

		PUSH	DX
		MOV	CX, y2
		SUB	CX, y1			; Vertikale Anzahl
		MOV     AX, y3
		MOV	DX, ClipRect.A.y
		CMP	AX, DX
		JGE	@@53
		SUB	AX, DX
		ADD	CX, AX			; Vertikale Anzahl reduzieren
		IMUL	SourceDelta
		SUB	SI, AX
		MOV	AX, ClipRect.A.y
@@53:   	MUL     BX
		POP	DX
		ADD     DI, AX			; Zieloffset in DI
		MOV	AX, y2
		SUB	AX, y1
		ADD	AX, y3
		SUB	AX, ClipRect.B.y
		JG	@@54
		XOR	AX, AX			; Subtraktion wird bentigt
@@54:		SUB	CX, AX			; Vertikale Anzahl reduzieren
		JLE	@@55			; nicht sichtbar
		CLD				; vorwrts zhlen
		PUSH	DX
		PUSH	DestPage
		CALL	PageAddr
		MOV	ES, DX
		ADD	DI, AX
		MOV	AX, Page0Seg
		ADD	AX, Addr
		PUSH	AX
		PUSH    SI
		MOV	SI, DS
		CALL	SelOfs
		MOV	DS, DX
		POP	DX
		PUSH	SI
		MOV	SI, AX

		MOV	AL, BYTE PTR x3
		MOV	AH, BYTE PTR x1
		AND	AX, 0707H
		SUB	AH, AL
		JNZ	@@12

		OR	DX, DX
		JZ	@@9

		PUSH	DX			; ** Ohne Rotieren **
		MOV     DX, 03CEH		; GC
		MOV	AX, 0003H		; Data Rotate
		OUT	DX, AX
		MOV	AX, 0005H		; Write Mode 0
		OUT	DX, AX
		MOV	AX, 0001H		; Disable Set/Reset
		OUT	DX, AX
		POP	DX
@@1:		PUSH	CX
		MOV	CX, DX
		PUSH	DX
		PUSH	SI
		PUSH	DI
		MOV	AH, Mask1
		CMP	CX, 1
		JNZ	@@73
		CMP	Mask2, 0
		JZ	@@73
		AND	AH, Mask2
@@73:		CMP	AH, 0FFH
		JZ	@@4
		MOV	DX, 03CEH		; GC
		MOV	AL, 8			; Bit Mask Reg
		OUT	DX, AX
		CALL	CopyByteRest
		DEC	CX
@@4:    	DEC	CX
		OR	CX, CX
		JZ	@@7
		JS	@@6
		MOV	DX, 03CEH		; GC
		MOV	AX, 0105H		; Write Mode 1
		OUT	DX, AX
		MOV	DX, 03C4H		; SC
		MOV	AX, 0F02H		; Map Mask
		OUT	DX, AX
		REP MOVSB			; nur zur Erzeugung der R/W-Zyklen
		MOV	DX, 03CEH		; GC
		MOV	AX, 0005H		; Write Mode 0
		OUT	DX, AX
@@7:		MOV	AH, Mask2
		OR	AH, AH
		JZ	@@6
		MOV	DX, 03CEH		; GC
		MOV	AL, 8			; Bit Mask Reg
		OUT	DX, AX
		CALL	CopyByteRest
@@6:		POP	DI
		POP	SI
		POP	DX
		ADD     SI, SourceDelta
		ADD	DI, BX
		POP	CX
		LOOP    @@1
		JMP	@@9

@@12:   	OR	DX, DX			; ** Mit Rotieren **
		JNZ	@@35
		MOV     AL, Mask2
		AND	Mask1, AL
@@35:		AND	AH, 07H
		MOV	Shift, AH
		PUSH	DX
		MOV	DX, 03CEH
		MOV	AX, 0003H		; Data Rotate
		OUT	DX, AX
		MOV	AX, 0005H		; Write Mode 0
		OUT	DX, AX
		MOV	AX, 0001H		; Disable Set/Reset
		OUT	DX, AX
		POP	DX

@@13:		PUSH	CX			; vert. Schleife
		MOV	WriteMap, 1
		MOV	ReadMap, 0
		MOV	CL, Shift

@@11:   	PUSH	DX			; Farbebenenschleife
		PUSH	SI
		PUSH	DI

		PUSH	DX
		MOV	DX, 03C4H		; SC
		MOV	AL, 02H			; Map Mask
		MOV	AH, WriteMap
		OUT	DX, AX
		MOV	DX, 03CEH		; GC
		MOV	AL, 04H			; Read Map
		MOV	AH, ReadMap
		OUT	DX, AX
		MOV	AL, 08H			; Bit Mask
		MOV	AH, Mask1
		OUT	DX, AX
		POP	DX

		CMP	Method, "A"
		JZ	@@33
		LODSB
		DEC	DX
		MOV	AH, AL
		JMP	@@34

@@33:		XOR	AH, AH
@@34:		LODSB
		MOV	CH, AL
		SHL	AX, CL
		XCHG	es:[DI], AH
		INC	DI
		MOV	AH, CH
		DEC     DX
		JZ	@@22
		JS	@@21

		PUSH	DX
		MOV	DX, 03CFH
		MOV	AL, 0FFH
		OUT	DX, AL
		POP	DX

@@20:		LODSB
		MOV	CH, AL
		SHL	AX, CL
		MOV	es:[DI], AH
		INC	DI
		MOV	AH, CH
		DEC     DX
		JNZ	@@20

@@22:		PUSH	DX
		MOV	DX, 03CFH
		MOV	AL, Mask2
		OUT	DX, AL
		POP	DX

		LODSB
		MOV	CH, AL
		SHL	AX, CL
		XCHG	es:[DI], AH

@@21:
@@72:		POP	DI
		POP	SI
		POP	DX
		CMP	ReadMap, 3
		JZ	@@18
		INC	ReadMap
		SHL	WriteMap, 1
		JMP	@@11

@@18:		ADD     SI, SourceDelta
		ADD	DI, BX
		POP	CX
		DEC	CX
		JNZ	@@13

@@9:		POP	DS
		MOV	DX, 03CEH		; ** Allgemein **
		MOV	AX, 0FF08H
		OUT	DX, AX
		MOV	DX, 03C4H
		MOV	AX, 0F02H
		OUT	DX, AX
@@55:		CLD
		CALL	RestoreRegs
		leave
		retn	ArgSize
RestoreScreen_16	ENDP

CopyMem16	PROC FAR
		ARG	Count: WORD, Dest: WORD, Source: WORD = ArgSize
		push	bp
		mov	bp, sp
		MOV	ES, Page0Seg
		MOV	SI, Source
		MOV	DI, Dest
		MOV	CX, Count
		MOV     DX, 03CEH		; GC
		MOV	AX, 0105H		; Write Mode 1
		CLD
		OUT	DX, AX
		REP SEGES MOVSB
		MOV	AX, 0005H		; Write Mode 0
		OUT	DX, AX
		pop	bp
		retf
CopyMem16	ENDP

	;
	; CopyScreen service proc: _CS_Addr
	;
	; Out:  BX:SI	Linear source address
	;	DX:DI	Linear dest address
	;	CX	Horiz source byte count
	; Sets:	Mask1, Mask2, Method
	;

CS_Addr_16	PROC NEAR
		MOV     SI, _x1
		SAR     SI, 3

		MOV	CL, BYTE PTR _x3
		AND	CL, 7
		MOV	AX, 0FF00H
		SHR	AX, CL
		MOV	_Mask1, AH		; Linke Randmaske

		MOV	CL, BYTE PTR _x2
		SUB	CL, BYTE PTR _x1
		ADD	CL, BYTE PTR _x3
		AND	CL, 7
		MOV	AX, 0FF00H
		SHR	AX, CL
		MOV	_Mask2, AL		; Rechte Randmaske

		MOV	CX, _x2
		SAR	CX, 3
		SUB	CX, SI
		INC	CX			; Anzahl Quell-Bytes horizontal

		MOV	AX, _x2			; Bits x2 / x4
		MOV	DX, _x3
		SUB	DX, _x1
		ADD	DX, AX
		AND	AX, 7
		AND	DX, 7
		CMP	AX, DX
		MOV	AL, 0
		JB	@@81
		MOV	AL, 2			; x2' > x4'
@@81:		MOV	_Method, AL

		MOV	AX, _x1			; Bits x1 / x3
		AND	AX, 7
		MOV     DX, _x3
		AND	DX, 7
		CMP	AX, DX
		MOV	AL, 0
		JB	@@80
		MOV	AL, 4			; x1' > x3'
@@80:		OR	_Method, AL

		MOV     AX, _y1
		MUL     BX
		ADD     SI, AX
		adc	dx, 0
		xchg	bx, dx			; BX:SI Linear source addr

		MOV     DI, _x3
		SAR     DI, 3
		MOV     AX, _y3
		MUL     dx
		ADD     DI, AX
		adc	dx, 0			; DX:DI Linear dest addr
		retn
CS_Addr_16	ENDP

	; copy byte latches es:[si] -> es:[di]

CopyByte	PROC NEAR
		SetVgaReg 0, 1
		MOV	AL, es:[SI]
		XCHG	es:[DI], AL
		SetVgaReg 1, 2
		MOV	AL, es:[SI]
		XCHG	es:[DI], AL
		SetVgaReg 2, 4
		MOV	AL, es:[SI]
		XCHG	es:[DI], AL
		SetVgaReg 3, 8
		SEGES LODSB			; inc/dec
		MOV	AH, es:[DI]
		STOSB				; inc/dec
		retn
CopyByte	ENDP

CS_Copy_16	PROC NEAR
		MOV	AL, BYTE PTR _x3
		MOV	AH, BYTE PTR _x1
		AND	AX, 0707H
		SUB	AH, AL
		JNZ	@@12
						; ** Ohne Rotieren **
		MOV	BX, _BPL
		PUSH	DX
		MOV     DX, 03CEH		; GC
		MOV	AX, 0003H		; Data Rotate
		OUT	DX, AX
		MOV	AX, 0005H		; Write Mode 0
		OUT	DX, AX
		MOV	AX, 0001H		; Disable Set/Reset
		OUT	DX, AX
		POP	DX

		CMP	DX, 1
		JA	@@1
		MOV	AL, _Mask2
		AND	_Mask1, AL

@@1:		PUSH	CX
		MOV	CX, DX
		PUSH	DX
		PUSH	SI
		PUSH	DI
		MOV	AH, _Mask1
		CMP	_Mask1, 0FFH
		JZ	@@4
		MOV	DX, 03CEH		; GC
		MOV	AL, 8			; Bit Mask Reg
		OUT	DX, AX
		CALL	CopyByte
		DEC	CX
@@4:    	DEC	CX
		JZ	@@7
		JS	@@6
		MOV	DX, 03CEH		; GC
		MOV	AX, 0105H		; Write Mode 1
		OUT	DX, AX
		MOV	DX, 03C4H		; SC
		MOV	AX, 0F02H		; Map Mask
		OUT	DX, AX
		REP SEGES MOVSB			; nur zur Erzeugung der R/W-Zyklen
		MOV	DX, 03CEH		; GC
		MOV	AX, 0005H		; Write Mode 0
		OUT	DX, AX
@@7:		MOV	AH, _Mask2
		OR	AH, AH
		JZ	@@6
		MOV	DX, 03CEH		; GC
		MOV	AL, 8			; Bit Mask Reg
		OUT	DX, AX
		CALL	CopyByte
@@6:		POP	DI
		POP	SI
		POP	DX
		ADD     SI, BX
		ADD	DI, BX
		add	di, CopyDeltaHack
		POP	CX
		LOOP    @@1
		JMP	@@9

@@12:		PUSH	CX			; ** Mit Rotieren **
		MOV	CL, AH
		AND	CL, 7
		MOV	_Shift, CL
		PUSH	DX
		MOV	DX, 03CEH
		MOV	AX, 0003H		; Data Rotate
		OUT	DX, AX
		MOV	AX, 0005H		; Write Mode 0
		OUT	DX, AX
		MOV	AX, 0001H		; Disable Set/Reset
		OUT	DX, AX

		TEST	_Method, 1
		JNZ	@@14
						; ** von links nach rechts **
		POP	DX
		POP	CX

		TEST	_Method, 2
		JZ	@@89
		INC	DX
@@89:		TEST	_Method, 4
		JZ	@@88
		DEC	DX
@@88:
		CMP	DX, 1
		JNZ	@@47
		MOV	AL, _Mask2
		AND	_Mask1, AL		; in 1 Byte
		MOV	_Mask2, 0
@@47:

@@13:		PUSH	CX			; vert. Schleife
		MOV	_WriteMap, 1
		MOV	_ReadMap, 0
		MOV	CL, _Shift

@@11:		MOV	BX, DX			; Farbebenenschleife
		PUSH	DX
		PUSH	SI
		PUSH	DI
		MOV	DX, 03C4H		; SC
		MOV	AL, 02H			; Map Mask
		MOV	AH, _WriteMap
		OUT	DX, AX
		MOV	DX, 03CEH		; GC
		MOV	AL, 04H			; Read Map
		MOV	AH, _ReadMap
		OUT	DX, AX

		MOV	AH, _Mask1		; linke Randmaske
		MOV	AL, 08H
		OUT	DX, AX

		TEST	BYTE PTR _Method, 4
		JZ	@@60
		SEGES LODSB
		MOV	AH, AL
		JMP	@@61
@@60:		MOV	AH, 00
@@61:		SEGES LODSB			; Quellbyte lesen
		DEC	BX
		MOV	CH, AL
		SHL	AX, CL
		XCHG	es:[DI], AH
		INC	DI

		MOV	AX, 0FF08H
		OUT	DX, AX

		MOV	AH, CH

		DEC	BX
		JL	@@63
		JE	@@17

@@62:		SEGES LODSB
		MOV	CH, AL
		SHL	AX, CL
		MOV	es:[DI], AH
		MOV	AH, CH
		INC	DI
		DEC	BX
		JNZ	@@62

@@17:   	MOV	AH, _Mask2		; rechte Randmaske
		MOV	AL, 08H
		OUT	DX, AX
		MOV	AH, CH

		SEGES LODSB			; Quellbyte lesen
		SHL	AX, CL
		XCHG	es:[DI], AH
		INC	DI

@@63:		POP	DI
		POP	SI
		POP	DX

		CMP	_ReadMap, 3
		JZ	@@18
		INC	_ReadMap
		SHL	_WriteMap, 1
		JMP	@@11

@@18:   	MOV	AX, _BPL
		ADD     SI, AX
		add	di, CopyDeltaHack
		ADD	DI, AX
		POP	CX
		DEC	CX
		JNZ	@@13
		JMP	@@9

@@14:   				; ** von rechts nach links **
		POP	DX
		POP	CX

		MOV	AL, _Method
		SHR	AL, 1
		JZ	@@90			; 00x
		DEC	AL
		JNZ	@@91
		INC	SI			; 01x
		INC	DI
		INC	DX
		JMP	@@90
@@91:		DEC	AL
		JNZ	@@92
		DEC	DI			; 10x
		DEC	DX
@@92:		DEC	AL
		JNZ	@@90
		INC	SI
@@90:
		CMP	DX, 1
		JNZ	@@94
		MOV	AL, _Mask2
		AND	_Mask1, AL		; in 1 Byte
		MOV	_Mask2, 0
@@94:

@@27:		PUSH	CX			; vert. Schleife
		MOV	_WriteMap, 1
		MOV	_ReadMap, 0
		MOV	CL, _Shift

@@26:		MOV	BX, DX			; Farbebenenschleife
		PUSH	DX
		PUSH	SI
		PUSH	DI
		MOV	DX, 03C4H		; SC
		MOV	AL, 02H			; Map Mask
		MOV	AH, _WriteMap
		OUT	DX, AX
		MOV	DX, 03CEH		; GC
		MOV	AL, 04H			; Read Map
		MOV	AH, _ReadMap
		OUT	DX, AX
		MOV	AH, _Mask1		; rechte Randmaske
		MOV	AL, 08H
		OUT	DX, AX

		MOV	AL, es:[SI]		; Quellbyte lesen
		DEC	SI
		MOV	AH, es:[SI]		; Quellbyte lesen
		DEC	SI
		MOV	CH, AH
		SHL	AX, CL
		XCHG	AH, es:[DI]
		DEC	DI
		dec	bx
		DEC	BX
		je	@@24
		JL	@@23

		MOV	AX, 0FF08H
		OUT	DX, AX
		MOV	AL, CH
@@22:		MOV	AH, es:[SI]
		DEC	SI
		MOV	CH, AH
		SHL	AX, CL
		MOV	es:[DI], AH
		DEC	DI
		MOV	AL, CH
		DEC	BX
		JNZ	@@22

@@24:   	MOV	AH, _Mask2		; linke Randmaske
		MOV	AL, 08H
		OUT	DX, AX
		MOV	AL, CH
		MOV	AH, es:[SI]
		SHL	AX, CL
		XCHG	AH, es:[DI]

@@23:		POP	DI
		POP	SI
		POP	DX
		CMP	_ReadMap, 3
		JZ	@@25
		INC	_ReadMap
		SHL	_WriteMap, 1
		JMP	@@26

@@25:   	MOV	AX, _BPL
		ADD     SI, AX
		add	di, CopyDeltaHack
		ADD	DI, AX
		POP	CX
		DEC	CX
		JNZ	@@27
		JMP	@@9

@@9:    	MOV	DX, 03CEH		; ** Allgemein **
		MOV	AX, 0FF08H
		OUT	DX, AX
		MOV	DX, 03C4H
		MOV	AX, 0F02H
		OUT	DX, AX
		retn
CS_Copy_16	ENDP

;
; Image support
;

ImageLong_16	PROC NEAR
		ARG	y2: WORD, x2: WORD, y1: WORD, x1: WORD = ArgSize
		push	bp
		mov	bp, sp
		MOV	AX, x2
		SUB	AX, x1
		SAR	AX, 3
		INC	AX
		SHL	AX, 2
		MOV	CX, y2
		SUB	CX, y1
		INC	CX
		MUL	CX
		add	ax, 6			; extra memory for BGI comp
		adc	dx, 0
		pop	bp
		retn	ArgSize
ImageLong_16	ENDP

GetImage_16	PROC NEAR
		ARG	Bitmap: DWORD, y2: WORD, x2: WORD, \
			y1: WORD, x1: WORD = ArgSize
		LOCAL	HorizCount: WORD, VertCount: WORD, BPL: WORD, \
			ReadMap: BYTE = LocalSize
		enter	LocalSize, 0
		CALL	SaveRegs
		LES	DI, Bitmap
		MOV	AX, x2
		SUB	AX, x1
		CLD
		STOSW
		SAR	AX, 3
		INC	AX
		MOV	HorizCount, AX
		MOV	AX, y2
		SUB	AX, y1
		STOSW
		INC	AX
		MOV	VertCount, AX
		MOV	AX, y1
		ADD	AX, DrawOrigin.y
		MOV	BX, BytesPerLine
		MOV	BPL, BX
		IMUL	BX
		MOV	SI, x1
		ADD	SI, DrawOrigin.x
		MOV	CX, SI
		AND	CL, 7
		SAR	SI, 3
		ADD	SI, AX

		ADD	SI, ActivePOfs
		PUSH	DS
		MOV	DS, ActivePSeg
		MOV	DX, 03CEH
		MOV	AX, 0005H		; Lesemodus 0
		OUT	DX, AX

@@3:		MOV	ReadMap, 3

@@2:		MOV	DX, 03CEH
		MOV	AL, 04H
		MOV	AH, ReadMap
		OUT	DX, AX

		MOV	DL, BYTE PTR HorizCount
		PUSH	SI
		LODSB
		MOV	AH, AL
@@1:		LODSB
		MOV	CH, AL
		SHL	AX, CL
		MOV	AL, AH
		STOSB
		MOV	AH, CH
		DEC	DL
		JNZ	@@1
		POP	SI
		DEC	ReadMap
		JNS	@@2
		ADD	SI, BPL
		DEC	VertCount
		JNZ	@@3
		POP	DS
		CALL	RestoreRegs
		leave
		retn	ArgSize
GetImage_16	ENDP

PutImage_16	PROC FAR
		ARG	BitBlt: WORD, Bitmap: DWORD, \
			aty: WORD, atx: WORD = ArgSize
		LOCAL	Shift: BYTE: 1, Mask1: BYTE: 1, Mask2: BYTE: 1, \
			ReadMap: BYTE: 1, WriteMap: BYTE: 1, \
			HorizCount: BYTE: 1, BmDelta: WORD, LnDelta: WORD, \
			VertCount: WORD, TempW: WORD, \
			Buffer: DWORD, Back: WORD = LocalSize
_PutImage_16:
		enter	LocalSize, 0
		MOV	AX, DrawOrigin.x
		ADD	atx, AX
		MOV	AX, DrawOrigin.y
		ADD	aty, AX
		TEST	MetaState, ms_Record
		JZ	@@NR
		PUSH	LocalSize		; Locals
		PUSH	ArgSize			; Params
		PUSH	0
		MOV	AX, 3			; pushed
		CALL	[ExtSave]
		TEST	MetaState, ms_Record
		JNZ	@@NR
		MOV	AX, MetaOrigin.x
		ADD	atx, AX
		MOV	AX, MetaOrigin.y
		ADD	aty, AX
@@NR:		TEST	MetaState, ms_Draw
		JZ	@@ND
		CALL	SaveRegs
		mov	ax, BkColor
		mov	Back, ax
		MOV	AX, atx
		MOV	CL, AL
		AND	CL, 7
		MOV	Shift, CL
		MOV	BX, BytesPerLine
		MOV	LnDelta, BX
		MOV	CX, ClipRect.A.x
		SUB	CX, AX
		MOV	BX, 0
		JLE	SHORT @@1
		MOV	AX, ClipRect.A.x	; AX wahrer Rand
		MOV	BX, CX			; BX Offset in Bits
@@1:		MOV	CX, AX
		AND	CL, 7
		MOV	CH, 0FFH
		SHR	CH, CL			; linke Randmaske
		MOV	Mask1, CH
		MOV	DI, AX
		SHR	DI, 3			; Bildschirmoffset
		AND	AX, 7
		SUB	BX, AX			; Quellenkorrektur (Abrundung)
		CMP	Shift, 0
		JNZ	SHORT @@10
		DEC	BX
@@10:		MOV	AX, aty
		MOV	CX, ClipRect.A.y
		SUB	CX, AX
		MOV	SI, 0
		JLE	SHORT @@2
		MOV	AX, ClipRect.A.y
		MOV	SI, CX			; SI vert. Offset in Bits
@@2:    	MOV	tempw, AX
		IMUL	BytesPerLine
		ADD	DI, AX			; vollstndiges Bildschirmoffset
		MOV	DX, SI
		LES	SI, BitMap
		MOV	AX, es:[SI]		; horiz. Ausdehnung - 1
		SAR	AX, 3
		INC	AX
		MOV	BmDelta, AX		; Abstand der Bitmap-Zeilen
		SHL	DX, 2
		IMUL	DX
		SAR	BX, 3
		MOV	DX, BX
		ADD	BX, AX			; vollstndiges Bitmap-Offset

		MOV	AX, atx
		ADD	AX, es:[SI]
		INC	AX
		CMP	AX, ClipRect.B.x
		JLE	SHORT @@3
		MOV	AX, ClipRect.B.x
@@3:    	MOV	CX, AX
		AND	CL, 7
		SUB	AX, atx
		SAR	AX, 3
		SUB	AX, DX                  ; Byte-Offset linker-rechter Rand
		JL	@@0
		CMP	CL, Shift
		JB	SHORT @@11
		DEC	AX
@@11:		DEC	AX
		MOV	HorizCount, AL
		CMP	AL, 0FEH
		JZ	@@0

		MOV	DX, 0FF00H
		SHR	DX, CL
		INC	AL
		JNZ	SHORT @@13
		AND	Mask1, DL
@@13:		MOV	Mask2, DL		; rechte Randmaske

		MOV	DX, aty
		ADD	DX, es:[SI+2]
		INC	DX
		CMP	DX, ClipRect.B.y
		JLE	SHORT @@4
		MOV	DX, ClipRect.B.y
@@4:		SUB	DX, tempw
		JLE	@@0
		MOV	VertCount, DX		; vertikale Anzahl

		ADD	SI, BX
		ADD	SI, 4			; Bitmap-Offset korrigieren
		ADD	DI, ActivePOfs
		MOV	BX, ActivePSeg

		call	SetActiveWindow

		mov	ax, WORD PTR TempMem[0]
		mov	dx, WORD PTR TempMem[2]
		mov	WORD PTR Buffer[0], ax
		mov	WORD PTR Buffer[2], dx

		PUSH	DS
		PUSH	ES
		POP	DS
		MOV	ES, BX

		MOV	CL, Shift
		CLD

		MOV	AL, BYTE PTR BitBlt
		MOV	BL, 0			; XOR-Maske fr CPU-Bits
		MOV	AH, AL
		and	al, 11b
		CMP	AL, 00B			; MOV
		JZ	SHORT @@5
		CMP	AL, 10B			; OR
		JZ	SHORT @@5
		XOR	AH, 10B			; XOR, AND umcodieren
@@5:		TEST	AH, 100B		; NOT
		JZ	SHORT @@6
		MOV	BL, 0FFH
@@6:
		and	ah, 11b
		MOV	DX, 03CEH		; GC
		MOV     AL, 03H			; Data Rotate Reg
		SHL	AH, 3
		OUT     DX, AX
		MOV     AX, 0001H		; Enable Set/Reset: All from CPU
		OUT     DX, AX
		MOV	AX, 0005H		; Write Mode 0
		OUT	DX, AX

	;
	; Vertical loop
	;

@@9:		MOV	ReadMap, 03H
		MOV	WriteMap, 08H

	;
	; Simple plane loop
	;

@@8:		PUSH	SI
		PUSH	DI
		MOV	BH, HorizCount

		MOV	AH, ReadMap
		MOV	AL, 04H
		OUT	DX, AX
		MOV	DX, 03C4H
		MOV	AH, WriteMap
		MOV	AL, 02H
		OUT	DX, AX

		MOV	DX, 03CEH
		MOV	AL, 08H
		MOV	AH, Mask1
		OUT	DX, AX

		MOV	AH, [SI]
		INC	SI
		LODSB
		MOV	CH, AL
		SHR	AX, CL
		XOR	AL, BL
		XCHG	es:[DI], AL
		INC	DI
		OR	BH, BH
		JZ	@@12
		CMP	BH, 0FFH
		JZ	@@14

		MOV	AX, 0FF08H
		OUT	DX, AX

@@7:		MOV	AH, CH
		LODSB
		MOV	CH, AL
		SHR	AX, CL
		XOR	AL, BL
		XCHG	es:[DI], AL
		INC	DI
		DEC	BH
		JNZ	@@7

@@12:		MOV	AL, 08H
		MOV	AH, Mask2
		OUT	DX, AX

		MOV	AH, CH
		LODSB
		SHR	AX, CL
		XOR	AL, BL
		XCHG	es:[DI], AL

@@14:		POP	DI
		POP	SI
		ADD	SI, BmDelta
		SHR	WriteMap, 1
		DEC	ReadMap
		JNS	@@8
		ADD	DI, LnDelta
		DEC	VertCount
		JNZ	@@9
		POP	DS
@@0:    	CALL	RestoreRegs
@@ND:		leave
		retf	ArgSize
PutImage_16	ENDP

ANDSB	MACRO
	lodsb
	AND	es:[di], al
	inc	di
ENDM

ANDSW	MACRO
	lodsw
	AND	es:[di], ax
	add	di, 2
ENDM

ANDNSB	MACRO
	lodsb
	not	al
	AND	es:[di], al
	inc	di
ENDM

ANDNSW	MACRO
	lodsw
	not	ax
	AND	es:[di], ax
	add	di, 2
ENDM

CLEARSB	MACRO
	mov	al, es:[di]
	not	al
	and	[si], al
	inc	di
	inc	si
ENDM

CLEARSW	MACRO
	mov	ax, es:[di]
	not	ax
	and	[si], ax
	add	di, 2
	add	si, 2
ENDM

MaskImage_16	PROC	NEAR
		ARG	DstImg: DWORD, SrcImg: DWORD = ArgSize
		LOCAL	BackColor: BYTE, \
			VertCount: WORD = LocalSize
		enter	LocalSize, 0
		mov	al, BYTE PTR BkColor
		shl	al, 4
		mov	BackColor, al
		push	ds
		lds	si, SrcImg
		les	di, DstImg
		mov	ax, WORD PTR [si+2]
		inc	ax
		mov	VertCount, ax
		mov	bx, WORD PTR [si]
		add	bx, 7
		shr	bx, 3			; bx Line Delta
		cld

	; Create image header

		movsw
		movsw

@@VertLoop:

	; Clear dest line, 1st plane

		push	di
		mov	cx, bx
		mov	ax, -1
		DoRepNoMap ,WORD,STOS
		pop	di

	; init plane loop

		mov	dh, 4
		mov	dl, BackColor
		push    si

	; plane loop

@@PlaneLoop:
		push	di
		mov	cx, bx
		shl	dl, 1
		jc	SHORT @@Invert
@@Copy:
		DoRepNoMap ,WORD,ANDNS
		jmp	SHORT @@1
@@Invert:
		DoRepNoMap ,WORD,ANDS
@@1:
		pop	di
		dec	dh
		jnz	@@PlaneLoop

	; init clearing plane loop

		pop	si
		mov	dh, 4

	; clearing plane loop

@@ClearLoop:
		mov	cx, bx
		push	di
		DoRepNoMap ,WORD,CLEARS
		pop	di
		dec	dh
		jnz	@@ClearLoop

	; Multiply the created plane

		mov	cx, bx
		push	si
		mov	si, di
		add	di, bx
		imul	cx, bx, 3		; 3 bx bytes
		shr	cx, 1
		rep seges movsw
		jnc	SHORT @@2
		seges	movsb
@@2:
		pop	si
		dec	VertCount
		jnz	@@VertLoop

		pop	ds
		leave
		ret	ArgSize
MaskImage_16	ENDP

; Service routine table

Table_16	PROC NEAR
		DW	vmcImage + vmcCopy + vmcSaveRestore + vmcBuffer
		DW	0		; mapping is not supported
		DW	GetBPL_16
		DW	GetSize_16
		DW	CS_Addr_16
		DW	CS_Copy_16
		DW	SaveScreen_16
		DW	RestoreScreen_16
		DW	ImageLong_16
		DW	GetImage_16
		DW	_PutImage_16
		DW	MaskImage_16
Table_16	ENDP

	;
	; Compatibility aliases
	;

MakeXXXX16	MACRO	XXXX
  &XXXX&16	PROC FAR
		pop	WORD PTR Temp[0]
		pop	WORD PTR Temp[2]
		call	&XXXX&_16
		jmp	Temp
  &XXXX&16	ENDP
		ENDM

		MakeXXXX16 GetBPL
		MakeXXXX16 SaveScreen
		MakeXXXX16 RestoreScreen

GetSize16	PROC FAR
		jmp	GetSize
GetSize16	ENDP

CopyScreen16	PROC FAR
		jmp	CopyScreen
CopyScreen16	ENDP

CODE		ENDS

		END
