
{*******************************************************}
{                                                       }
{       Graphics Vision Example program                 }
{                                                       }
{       Copyright (c) 1996 Matthias Kppe               }
{                                                       }
{*******************************************************}

(* This example shows:
   - how to access single controls of a dialog loaded from a Windows resource
   - how to add validators to loaded input lines

   We get our Windows resource from the GVSH.EXE program.
   This executable includes a resource which has been built from
   the GVSH.RC script.
*)

uses
  { Turbo Vision units }
  Objects, Drivers,
  { Graphics Vision units }
  GVViews, GVMenus, GVApp, GvMsgBox, WinRes, KeyNames, GvWinDlg, GvBWCC,
  { GV Dialogs
  }
  GvDialog,
  { GV Validators
  }
  GvValid,
  { Following is the symbol unit, which has been created with
    Resource Workshop. It includes identifiers for commands,
    help contexts and strings. }
  GvShCmd;

{ The resource we access
}
const
  ResourcePath = 'exam.dll';
var
  Res: PStream;

function LoadWinDialog(Name: PChar): PWinDialog;
var
  Dlg: PWinDialog;
begin
  Dlg := PWinDialog(Application^.ValidView(LoadDialog(Res^, Name)));
  If Dlg <> nil
  then Dlg^.Options := Dlg^.Options or ofCentered;
  LoadWinDialog := Dlg
end;

type
{ The application
}
  TDemoApp = object(TApplication)
    constructor Init;
    destructor Done; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure InitMenuBar; virtual;
  end;

(***************************** TDemoApp object ******************************)

constructor TDemoApp.Init;
begin
  Res := OpenResource(ResourcePath);
  If Res^.Status <> 0
  then begin
    PrintStr('Resource error.'^M^J);
    Halt(1)
  end;
  InitClasses;
  RegisterGvWinDlg;
  InitBWCC;
  inherited Init;
end;

destructor TDemoApp.Done;
begin
  inherited Done;
  DoneClasses;
  DoneBWCC;
  Dispose(Res, Done);
end;

procedure TDemoApp.HandleEvent(var Event: TEvent);

	procedure BPMemory;
	var
	  D: PWinDialog;
	  Data: record
	    RealStack: LongInt;
	    RealMinHeap: LongInt;
	    RealMaxHeap: LongInt;
	    ProtStack: LongInt;
	    WinStack: LongInt;
	    WinHeap: LongInt
	  end;

		procedure Rangify(ID: Integer; Min, Max: LongInt);
		{ This shorthand procedure accesses the control
		  view with the given ID, assumes it's an input line
		  and adds a range validator to it.
		}
		var
		  Val: PValidator;
                  IL: PInputLine;
		begin
		  Val := New(PRangeValidator, Init(Min, Max));
		  Val^.Options := Val^.Options or voTransfer;
		  { TWinDialog.GetControl parses the dialog for
		    control views whose HelpCtx matches the ID.
		  }
                  IL := PInputLine(D^.GetControl(ID));
		  if IL <> nil then IL^.SetValidator(Val)
		end;

	begin
	  { Init our data
	  }
	  with Data do
	  begin
	    RealStack := 16384;
	    RealMinHeap := 0;
	    RealMaxHeap := 655360;
	    ProtStack := 16384;
	    WinStack := 8192;
	    WinHeap := 8192
	  end;
	  { Load the dialog
	  }
	  D := LoadWinDialog('bpc_memory');
	  { 'Rangify' the input lines.

	    The hiXXXXXXX identifiers had been assigned to the
	    respective input lines in the Resource Workshop.
	    Actually, we put 'combo boxes' in the dialog, not
	    input lines. GvWinDlg loads combo boxes as TInputline
	    objects with a THistory object associated.
	  }
	  Rangify(hiBPCRealStack, 1024, 65520);
	  Rangify(hiBPCRealMinHeap, 0, 655360);
	  Rangify(hiBPCRealMaxHeap, 0, 655360);
	  Rangify(hiBPCProtStack, 1024, 65520);
	  Rangify(hiBPCWinStack, 1024, 65536);
	  Rangify(hiBPCWinHeap, 1024, 65536);
	  ExecuteDialog(D, @Data);
	end;

begin
  inherited HandleEvent(Event);
  If Event.What = evCommand
  then begin
    case Event.Command of
      cmGREP:
	ExecuteDialog(LoadWinDialog('grep'), nil);
      cmDirs:
	ExecuteDialog(LoadWinDialog('dirs'), nil);
      cmBPOptions:
	ExecuteDialog(LoadWinDialog('bpc_compiler'), nil);
      cmBPLinker:
	ExecuteDialog(LoadWinDialog('bpc_linker'), nil);
      cmBPTarget:
	ExecuteDialog(LoadWinDialog('bpc_target'), nil);
      cmTASMWarnings:
	ExecuteDialog(LoadWinDialog('tasm_warn'), nil);
      cmBPMemory:
	BPMemory;
      else Exit;
    end;
    ClearEvent(Event)
  end
end;

procedure TDemoApp.InitMenubar;
var
  R: TRect;
  Menu: PMenu;
  Acc: PAccelerators;
Begin
  Menu := LoadMenu(Res^, 'Menu', mo_GraphicsVision);
  Acc := LoadAccelerators(Res^, 'GV');
  AddAccelerators(Menu, Acc);
  FreeAccelerators(Acc);
  Main^.GetExtent(R);
  R.B.Y := 21;
  MenuBar := New(PMenuBar, Init(R, Menu));
End;

var
  App: TDemoApp;

Begin
  App.Init;
  MessageBox('Try Compiler|BP|Memory for a dialog with validated input lines.',
    nil, mfInformation + mfOKButton);
  App.Run;
  App.Done
End.
