
{*******************************************************}
{                                                       }
{       Graphics Vision Example program                 }
{                                                       }
{       Copyright (c) 1996 Matthias Kppe               }
{                                                       }
{*******************************************************}

(* This example shows:
   - how to load a Windows dialog with non-standard behavior

   We get our Windows resource from the GVSH.EXE program.
   This executable includes a resource which has been built from
   the GVSH.RC script.
*)

uses
  { Turbo Vision units }
  Objects, Drivers, Memory,
  { Graphics Vision units }
  GVViews, GVMenus, GVApp, GvMsgBox, WinRes, KeyNames, GvWinDlg, GvBWCC,
  GvDialog, GvValid, GvTexts, GvBitmap,
  { Following is the symbol unit, which has been created with
    Resource Workshop. It includes identifiers for commands,
    help contexts and strings. }
  GvShCmd;

{ The resource we access
}
const
  ResourcePath = 'exam.dll';
var
  Res: PStream;

function LoadWinDialog(Name: PChar): PWinDialog;
var
  Dlg: PWinDialog;
begin
  Dlg := PWinDialog(Application^.ValidView(LoadDialog(Res^, Name)));
  If Dlg <> nil
  then Dlg^.Options := Dlg^.Options or ofCentered;
  LoadWinDialog := Dlg
end;

type
  { This dialog type re-defines HandleEvent, such that it
    will behave differently on 'OK'.
    Well, you'll have better reasons to define a new dialog type
    than we had in this case...
  }
  PVerySpecialDialog = ^TVerySpecialDialog;
  TVerySpecialDialog = object(TWinDialog)
    procedure HandleEvent(var Event: TEvent); virtual;
  end;

procedure TVerySpecialDialog.HandleEvent(var Event: TEvent);
begin
  If (Event.What = evCommand) and (Event.Command = cmOK)
  then begin
    MessageBoxTitle('Yeah yeah yeah', 'I feel okay, too...', nil,
      mfInformation + mfOKButton);
    ClearEvent(Event)
  end;
  inherited HandleEvent(Event)
end;

type
{ The application
}
  TDemoApp = object(TApplication)
    constructor Init;
    destructor Done; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure InitMenuBar; virtual;
    procedure InitTexts; virtual;
  end;

(***************************** TDemoApp object ******************************)

constructor TDemoApp.Init;
begin
  Res := OpenResource(ResourcePath);
  If Res^.Status <> 0
  then begin
    PrintStr('Resource error.'^M^J);
    Halt(1)
  end;
  InitClasses;
  RegisterGvWinDlg;
  BWCC := Res;
  inherited Init;
end;

destructor TDemoApp.Done;
begin
  inherited Done;
  DoneClasses;
  Dispose(Res, Done);
end;

procedure TDemoApp.HandleEvent(var Event: TEvent);

	procedure VerySpecialDialog;
	begin
	  { Create a dialog of type TVerySpecialDialog and store it
	    in the global GvWinDlg.DialogTemplate variable. The RawInit
	    constructor needs no params since both title and metrics
	    will come from the Windows resource.
	  }
	  DialogTemplate := New(PVerySpecialDialog, RawInit);
	  { Load a dialog template. Instead of instantiating a new
	    dialog of type TWinDialog, the template created above
	    will be used and filled with controls.
	  }
	  ExecuteDialog(LoadWinDialog('GREP'), nil);
	end;

begin
  inherited HandleEvent(Event);
  If Event.What = evCommand
  then begin
    case Event.Command of
      cmAbout:
	VerySpecialDialog;
      else Exit;
    end;
    ClearEvent(Event)
  end
end;

procedure TDemoApp.InitMenubar;
var
  R: TRect;
  Menu: PMenu;
  Acc: PAccelerators;
Begin
  Menu := LoadMenu(Res^, 'Menu', mo_GraphicsVision);
  Acc := LoadAccelerators(Res^, 'GV');
  AddAccelerators(Menu, Acc);
  FreeAccelerators(Acc);
  GetExtent(R);
  R.B.Y := 21;
  MenuBar := New(PMenuBar, Init(R, Menu));
End;

procedure TDemoApp.InitTexts;
begin
  SetTextResource(Res)
end;

var
  App: TDemoApp;

Begin
  App.Init;
  MessageBox('Try Help|About for a non-standard dialog.',
    nil, mfInformation + mfOKButton);
  App.Run;
  App.Done
End.
