
{*******************************************************}
{                                                       }
{       Graphics Vision Example program                 }
{                                                       }
{       Copyright (c) 1996 Matthias Kppe               }
{                                                       }
{*******************************************************}

(* This example shows:
   - how to install additional system fonts through GvFonts
   - how to add user-defined behavior to existing dialog-control classes
     (see GvForm unit)

   This time, we get our Windows resource from the EXAM.DLL file.
*)

uses
  { Turbo Vision units }
  Objects, Drivers, Memory,
  { Graphics Vision units }
  GVViews, GVMenus, GVApp, GvMsgBox, WinRes, KeyNames, GvWinDlg, GvBWCC,
  GvDialog, GvValid, GvTexts, GvBitmap,
  { Graphics Vision font unit
  }
  GvFonts,
  { Graphics Vision formula display unit
  }
  GvForm,
  { Following is the symbol unit, which has been created with
    Resource Workshop. It includes identifiers for commands,
    help contexts and strings. }
  GvShCmd;

{ The resource we access
}
const
  ResourcePath = 'exam.dll';
var
  Res: PStream;

function LoadWinDialog(Name: PChar): PWinDialog;
var
  Dlg: PWinDialog;
begin
  Dlg := PWinDialog(Application^.ValidView(LoadDialog(Res^, Name)));
  If Dlg <> nil
  then Dlg^.Options := Dlg^.Options or ofCentered;
  LoadWinDialog := Dlg
end;

type
{ The application
}
  TDemoApp = object(TApplication)
    SymbolFont: PFont;
    RomanFont: PFont;
    constructor Init;
    destructor Done; virtual;
    procedure DoneFonts; virtual;
    procedure InitFonts; virtual;
  end;

(***************************** TDemoApp object ******************************)

constructor TDemoApp.Init;
begin
  Res := OpenResource(ResourcePath);
  If Res^.Status <> 0
  then begin
    PrintStr('Resource error.'^M^J);
    Halt(1)
  end;
  InitClasses;
  RegisterGvWinDlg;
  { Hook the 'STATIC' control class such that LeftNoWordWrap-style statics
    will create TFormLabel views.
  }
  RegisterGvForm;
  InitBWCC;
  inherited Init;
end;

destructor TDemoApp.Done;
begin
  inherited Done;
  DoneClasses;
  DoneBWCC;
  Dispose(Res, Done);
end;

procedure TDemoApp.InitFonts;
begin
  inherited InitFonts;
  SymbolFont := New(PFont, Init('Symbol' {(Windows)'}, 18, 0, nil));
  SymbolFont^.GetFontHandle; { result is 3 }
  RomanFont := New(PFont, Init('Times New Roman'{'MS Serif'}, 18, 0, nil));
  RomanFont^.GetFontHandle; { result is 4 }
end;

procedure TDemoApp.DoneFonts;
begin
  Dispose(SymbolFont, Done);
  Dispose(RomanFont, Done);
  inherited DoneFonts
end;

var
  App: TDemoApp;

Begin
  App.Init;
  App.ExecuteDialog(LoadWinDialog('formula'), nil);
  App.Done
End.
