
{*******************************************************}
{                                                       }
{       Graphics Vision Unit                            }
{                                                       }
{	Portions copyright (c) 1992 Borland Intl.       }
{       Copyright (c) 1994 Stefan Milius                }
{	Copyright (c) 1997,1999 Matthias K"oppe         }
{                                                       }
{*******************************************************}

{ $Id$ }

Unit GVDialog;

{$ifndef FPK}
{$A+,B-,D+,F+,G+,O+,R-,S-,X+,I-}
{$endif}

interface

{$ifdef FPK}
uses Objects, Drivers, Views, GvViews,
  Memory, ExtGraph, BGI, {VGAMem,} Validate, GvFPK;
{$i fpkdef.pp}
{$else}
{$ifdef Windows}
uses {$ifdef VER80} Messages, {$endif}
  WinTypes, Objects, Drivers, Views, GvViews, Validate;
{$else}
uses Objects, Drivers, Views, GvViews, Validate;
{$ifdef VER60}
{$define NOVALIDATE}
{$endif}
{$endif Windows}
{$endif FPK}

Const

{ Color Palettes }

  CDialog = #76#77#78#79#80#81#82#83#84#85#86#87#88#89#90#91#92#93;

  CInputLine  = #125#126#127#128#129#130#131;
  CArrowField = #132#133;
  CButton     = #103#104#105#106#107#108#109#110#111#112;
  CRegler     = #113#114#115#116;
  CCluster    = #117#118#119#120#121#122#123#124;
  CStaticText = #1#94;
  CStaticSign = #1#94;
  CLabel      = #95#96#97#98#99#100;
  CIcon       = #1#101#102;
  CHistory    = #103#111#112;

{ TArrowField commands }

  cmArrowUp = 60;
  cmArrowDn = 61;

{ TButton flags }

  bfNormal    = $00;
  bfDefault   = $01;
  bfLeftJust  = $02;
  bfBroadcast = $04;
  bfGrabFocus = $08;

{ TMultiCheckboxes flags }
{ hibyte = number of bits }
{ lobyte = bit mask }

  cfOneBit       = $0101;
  cfTwoBits      = $0203;
  cfFourBits     = $040F;
  cfEightBits    = $08FF;

{ Dialog broadcast commands }

  cmRecordHistory = 60;

Type

{ TDialog object }

  { Palette layout }
  { 1  = Background }
  { 2  = Frame active }
  { 3  = Frame not active }
  { 4  = Frame modal }
  { 5  = Zoomfield }
  { 6  = Title background normal}
  { 7  = Title background selected }
  { 8  = Title normal}
  { 9  = Title selected }
  { 10 = Close- and Zoomfield outside }
  { 11 = Closefield frame }
  { 12 = Closefield inside }
  { 13 = Closefield shadow }
  { 14 = Scrollbar background }
  { 15 = Scrollbar frame }
  { 16 = Scrollbar buttons }
  { 17 = Scrollbar button shadows }
  { 18 = Scrollbar page area }

  TDialog = object(TWindow)
    constructor Init(var Bounds: TRect; ATitle: String);
    {$ifdef Windows}
    function CreateRootWindow: Integer; virtual;
    {$endif Windows}
    function GetPalette: PPalette; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    function Valid(Command: Word): Boolean; virtual;
  end;
  PDialog = ^TDialog;

{ TInputLine SetCurPos selection type }

  TSelection = (none, left, right);

{ TInputLine object }

  { Palette layout }
  { 1 = Passive }
  { 2 = Active }
  { 3 = Selected }
  { 4 = Arrows }
  { 5 = Frame }
  { 6 = Text }
  { 7 = Cursor }

  {$IFDEF NOVALIDATE}
  PValidator = Pointer;
  {$ENDIF}

  PInputLine = ^TInputLine;
  TInputLine = object(TGView)
    Data: PString;
    MaxLen: Integer;
    CurPos: Integer;
    FirstPos: Integer;
    SelStart: Integer;
    SelEnd: Integer;
    {EndPos: Integer;}
    Validator: PValidator;
    constructor Init(var Bounds: TRect; AMaxLen: Integer);
    constructor Load(var S: TStream);
    destructor Done; virtual;
    procedure ChMCursor; virtual;
    function DataSize: Sw_Word; virtual;
    procedure Draw; virtual;
    procedure DrawText (APos, EPos: Integer); virtual;
    procedure GetData(var Rec); virtual;
    function GetPalette: PPalette; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure SelectAll(Enable: Boolean);
    {procedure SetCurPos (ACurPos: Integer; DoSelect: Boolean);}
    procedure SetCurPos(ACurPos: Integer; DoSelect: TSelection);
    procedure SetData(var Rec); virtual;
    procedure SetSelect(NewStart, NewEnd: Integer);
    procedure SetState(AState: Word; Enable: Boolean); virtual;
    procedure SetValidator(AValid: PValidator);
    procedure Store(var S: TStream);
    function Valid(Command: Word): Boolean; virtual;
  private
    procedure DoDrawText(s, e: Integer; Sel: Boolean);
    procedure GetPosition(apos, epos: Integer; var R: TRect);
    function GetIndex(P: TPoint): Integer;
    function IsSelection: Boolean;
    procedure Restore;
  end;

{ TArrowField object }

  { Palette layout }
  { 1 = Background }
  { 2 = Icon }

  PArrowField = ^TArrowField;
  TArrowField = object (TGView)
		  constructor Init(var Bounds: TRect);
		  procedure Draw; virtual;
		  function GetPalette: PPalette; virtual;
		  procedure HandleEvent(var Event: TEvent); virtual;
		end;

{ TNumInput object }

  { Palette layout = TInputLine }

  PNumInput = ^TNumInput;
  TNumInput = object (TInputLine)
		Arrows: PArrowField;
		constructor Init(var Bounds: TRect; ALimitLo, ALimitHi: Integer;
		   AArrows: PArrowField);
		constructor Load(var S: TStream);
		procedure HandleEvent(var Event: TEvent); virtual;
		procedure SetData(var Rec); virtual;
		procedure SetLimit(ALimitLo, ALimitHi: Integer);
		procedure Store(var S: TStream);
	      end;

{ TButton object }

  { Palette layout }
  { 1 = Background }
  { 2 = Normal text }
  { 3 = Default text }
  { 4 = Selected text }
  { 5 = Disabled text }
  { 6 = Normal shortcut }
  { 7 = Default shortcut }
  { 8 = Selected shortcut }
  { 9 = Borders }
  {10 = Lines }

  PButton = ^TButton;
  TButton = Object(TGView)
    Title: PString;
    Command: Word;
    Flags: Byte;
    AmDefault: Boolean;
    constructor Init(var Bounds: TRect; ATitle: TTitleStr; ACommand: Word;
      AFlags: Word);
    constructor Load(var S: TStream);
    destructor Done; virtual;
    procedure CondDrawState(Down: Boolean);
    procedure Draw; virtual;
    procedure DrawState(Down: Boolean); virtual;
    procedure DrawText(Down: Boolean); virtual;
    function GetPalette: PPalette; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure MakeDefault(Enable: Boolean);
    procedure Press; virtual;
    procedure SetState(AState: Word; Enable: Boolean); virtual;
    procedure Store(var S: TStream);
  private
    Pressed: Boolean;
  end;

{ TGButton object }

  { Palette layout }
  { 1 = Background }
  { 2 = Normal sign }
  { 3 = Default sign }
  { 4 = Selected sign }
  { 5 = Disabled sign }
  { 6 = nicht benutzt }
  { 7 = nicht benutzt }
  { 8 = nicht benutzt }
  { 9 = Borders }
  {10 = Lines }

  PGButton = ^TGButton;
  TGButton = Object (TButton)
    Sign : Pointer;
    constructor Init(var Bounds: TRect; ASign: Pointer; ACommand: Word;
      AFlags: Word);
    constructor Load(var S: TStream);
    destructor Done; virtual;
    procedure DrawText(Down: Boolean); virtual;
    procedure Store(var S: TStream);
  end;

{ TRegler object }

  { Palette layout }
  { 1 = selected frame }
  { 2 = normal frame }
  { 3 = disabled frame }
  { 4 = background }

{$ifndef FPK}
  PRegler = ^TRegler;
  TRegler = Object (TGView)
    Value:Real;
    Constructor Init (var Bounds:TRect; AMinValue, AMaxValue:Real;
      ABezeichnung, AMinBez, AMidBez, AMaxBez:String);
    destructor Done; virtual;
    constructor Load (var S: TStream);
    Function GetPalette:PPalette; virtual;
    Procedure HandleEvent (Var Event:TEvent); virtual;
    Procedure Draw; virtual;
    Procedure SetState(AState: Word; Enable: Boolean); virtual;
    Procedure SetData (var Rec); virtual;
    Procedure GetData (var Rec); virtual;
    Function DataSize: Sw_Word; virtual;
    procedure Store (var S: TStream);
  private
    MinValue, MaxValue, OldValue:Real;
    Bezeichnung, MinBez, MidBez, MaxBez:PString;
    OldY:Word;
{    Selected:Boolean;}
    Procedure UpDate;
    Function Position (XValue:Real): Integer;
    Function ToValue (XPosition:Integer): Real;
  End;
{$endif}

{ TSItem record }

  PSItem = ^TSItem;
  TSItem = record
    Value: PString;
    Next: PSItem;
  end;

{ TCluster object }

  { Palette layout }
  { 1 = Normal text }
  { 2 = Selected text }
  { 3 = Normal shortcut }
  { 4 = Selected shortcut }
  { 5 = Normal background }
  { 6 = Selected background }
  { 7 = Disabled background }
  { 8 = Disabled text }

  PCluster = ^TCluster;
  TCluster = object(TGView)
    Value: LongInt;
    Sel: Integer;
    EnableMask: LongInt;
    Strings: TStringCollection;
    constructor Init(var Bounds: TRect; AStrings: PSItem);
    constructor Load(var S: TStream);
    destructor Done; virtual;
    function ButtonState(Item: Integer): Boolean;
    function DataSize: Sw_Word; virtual;
    procedure Draw; virtual;
    procedure DrawItem(Item: Integer; Down: Boolean); virtual;
    procedure GetData(var Rec); virtual;
    function GetHelpCtx: Word; virtual;
    function GetIconNum(Id: Byte): Integer; virtual;
    procedure GetItemRect(Item: Integer; var Extent: TRect); virtual;
    function GetPalette: PPalette; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    function Mark(Item: Integer): Boolean; virtual;
    function MultiMark(Item: Integer): Byte; virtual;
    procedure Press(Item: Integer); virtual;
    procedure MovedTo(Item: Integer); virtual;
    procedure SetButtonState(AMask: Longint; Enable: Boolean);
    procedure SetData(var Rec); virtual;
    procedure SetState(AState: Word; Enable: Boolean); virtual;
    procedure Store(var S: TStream);
  end;

{ TRadioButtons object }

  { Palette layout }
  { 1 = Normal text }
  { 2 = Selected text }
  { 3 = Normal shortcut }
  { 4 = Selected shortcut }
  { 5 = Normal background }
  { 6 = Selected background }
  { 7 = Disabled background }
  { 8 = Disabled text }

  PRadioButtons = ^TRadioButtons;
  TRadioButtons = object(TCluster)
    function GetIconNum(Id: Byte): Integer; virtual;
    function Mark(Item: Integer): Boolean; virtual;
    procedure MovedTo(Item: Integer); virtual;
    procedure Press(Item: Integer); virtual;
    procedure SetData (var Rec); virtual;
  end;

{ TCheckBoxes object }

  { Palette layout }
  { 1 = Normal text }
  { 2 = Selected text }
  { 3 = Normal shortcut }
  { 4 = Selected shortcut }
  { 5 = Normal background }
  { 6 = Selected background }
  { 7 = Disabled background }
  { 8 = Disabled text }

  PCheckBoxes = ^TCheckBoxes;
  TCheckBoxes = object(TCluster)
    function GetIconNum(Id: Byte): Integer; virtual;
    function Mark(Item: Integer): Boolean; virtual;
    procedure Press(Item: Integer); virtual;
  end;

{ TMultiCheckBoxes object }

  { Palette layout }
  { 1 = Normal text }
  { 2 = Selected text }
  { 3 = Normal shortcut }
  { 4 = Selected shortcut }
  { 5 = Normal background }
  { 6 = Selected background }
  { 7 = Disabled background }
  { 8 = Disabled text }

  PMultiCheckBoxes = ^TMultiCheckBoxes;
  TMultiCheckBoxes = object(TCluster)
    SelRange: Byte;
    Flags: Word;
    States: Pointer;
    MyData: Boolean;
    constructor Init(var Bounds: TRect; AStrings: PSItem;
      ASelRange: Byte; AFlags: Word; AStates: Pointer);
    constructor Load(var S: TStream);
    destructor Done; virtual;
    function DataSize: Sw_Word; virtual;
    procedure DrawItem(Item: Integer; Down: Boolean); virtual;
    procedure GetData(var Rec); virtual;
    function GetIconNum(Id: Byte): Integer; virtual;
    function MultiMark(Item: Integer): Byte; virtual;
    procedure Press(Item: Integer); virtual;
    procedure SetData(var Rec); virtual;
    procedure Store(var S: TStream);
  private
    function GetIcon(Index: Integer): Pointer;
  end;

{ TListBoxRec Record }

  PListBoxRec = ^TListBoxRec;
  TListBoxRec = Record
                  List: PCollection;
                  Index: Integer;
		End;

{ TListBox object }

  { Palette layout }
  { 1 = Background }
  { 2 = Frame }
  { 3 = Normal Text }
  { 4 = Selected Text }
  { 5 = Normal Background }
  { 6 = Selected Background }

  PListBox = ^TListBox;
  TListBox = object(TListViewer)
    List: PCollection;
    NewFocus: Integer;
    constructor Init(var Bounds: TRect; AScrollBar: PScrollBar);
    constructor Load(var S: TStream);
    function DataSize: Sw_Word; virtual;
    procedure GetData(var Rec); virtual;
    function GetText(Item: Integer; MaxLen: Integer): String; virtual;
    procedure NewList(AList: PCollection); virtual;
    procedure SetData(var Rec); virtual;
    procedure Store(var S: TStream);
  end;

{ TStaticText object }

  { Palette layout }
  { 1 = Background }
  { 2 = Text }

  PStaticText = ^TStaticText;
  TStaticText = Object (TGView)
    Text: PString;
    Constructor Init(var Bounds:TRect; AText:String);
    constructor Load(var S: TStream);
    Destructor Done; virtual;
    Procedure Draw; virtual;
    function GetPalette: PPalette; virtual;
    procedure GetText(var S: String); virtual;
    procedure Store(var S: TStream);
  End;

{ TParamText object }

  { Palette layout }
  { 1 = Background }
  { 2 = Text }

  PParamText = ^TParamText;
  TParamText = object(TStaticText)
    ParamCount: Integer;
    ParamList: Pointer;
    constructor Init(var Bounds: TRect; AText: String; AParamCount: Integer);
    constructor Load(var S: TStream);
    function DataSize: Sw_Word; virtual;
    procedure GetText(var S: String); virtual;
    procedure SetData(var Rec); virtual;
    procedure Store(var S: TStream);
  end;

{ TStaticSign object }

  { Palette layout }
  { 1 = View background }
  { 2 = Image background }

  PStaticSign = ^TStaticSign;
  TStaticSign = object (TGView)
    Sign:Pointer;
    Constructor Init(var Bounds:TRect; ASign:Pointer);
    constructor Load(var S: TStream);
    Destructor Done; virtual;
    Procedure Draw; virtual;
    function GetPalette: PPalette; virtual;
    procedure Store(var S: TStream);
  End;

{ TLabel object }

  { Palette layout }
  { 1 = Normal text }
  { 2 = Selected text }
  { 3 = Normal shortcut }
  { 4 = Selected shortcut }
  { 5 = Normal Background }
  { 6 = Selected Background }

  PLabel = ^TLabel;
  TLabel = object(TStaticText)
    Link: PGView;
    Light: Boolean;
    constructor Init(var Bounds: TRect; AText: String; ALink: PGView);
    constructor Load(var S: TStream);
    procedure Draw; virtual;
    function GetPalette: PPalette; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure Store(var S: TStream);
  end;

{ TIcon object }

  { Palette layout }
  { 1 = View background }
  { 2 = Normal Background }
  { 3 = Selected Background }

  PIcon = ^TIcon;
  TIcon = object(TStaticSign)
    Link: PGView;
    Light: Boolean;
    constructor Init(var Bounds: TRect; ASign: Pointer; ALink: PGView);
    constructor Load(var S: TStream);
    procedure Draw; virtual;
    function GetPalette: PPalette; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure Store(var S: TStream);
  end;

{ THistoryViewer object }

  { Palette layout = TListBox }

  PHistoryViewer = ^THistoryViewer;
  THistoryViewer = object(TListViewer)
    HistoryId: Word;
    constructor Init(var Bounds: TRect; AScrollBar: PScrollBar;
       AHistoryId: Word);
    function GetText(Item: Integer; MaxLen: Integer): String; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    function HistoryWidth: Integer;
  end;

{ THistoryWindow object }

  { Palette layout = TWindow }

  PHistoryWindow = ^THistoryWindow;
  THistoryWindow = object(TWindow)
    Viewer: PListViewer;
    constructor Init(var Bounds: TRect; HistoryId: Word);
    function GetSelection: String; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure InitViewer(HistoryId: Word); virtual;
  end;

{ THistory object }

  { Palette layout }
  { 1 = Button }
  { 2 = Button shadow }
  { 3 = Button frame }

  PHistory = ^THistory;
  THistory = object(TGView)
    Link: PInputLine;
    HistoryId: Word;
    constructor Init(var Bounds: TRect; ALink: PInputLine; AHistoryId: Word);
    constructor Load(var S: TStream);
    procedure Draw; virtual;
    function GetPalette: PPalette; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    function InitHistoryWindow(var Bounds: TRect): PHistoryWindow; virtual;
    procedure RecordHistory(S: String); virtual;
    procedure Store(var S: TStream);
  private
    Down: Boolean;
  end;

{ SItem routines }

function NewSItem(Str: String; ANext: PSItem): PSItem;

procedure FreeSItem(ASItem: PSItem);

{ Support routines }

function StaticTextHeight(S: string; Width: Integer): Integer;

{ GVDialog registration procedure }

procedure RegisterGVDialog;

{ Stream registration records }

const

  RDialog: TStreamRec = (
    ObjType: 116;
    VmtLink: Ofs(TypeOf(TDialog)^);
    Load: @TDialog.Load;
    Store: @TDialog.Store);

  RInputLine: TStreamRec = (
    ObjType: 117;
    VmtLink: Ofs(TypeOf(TInputLine)^);
    Load: @TInputLine.Load;
    Store: @TInputLine.Store);

  RArrowField: TStreamRec = (
    ObjType: 118;
    VmtLink: Ofs(TypeOf(TArrowField)^);
    Load: @TArrowField.Load;
    Store: @TArrowField.Store);

  RNumInput: TStreamRec = (
    ObjType: 119;
    VmtLink: Ofs(TypeOf(TNumInput)^);
    Load: @TNumInput.Load;
    Store: @TNumInput.Store);

  RButton: TStreamRec = (
    ObjType: 120;
    VmtLink: Ofs(TypeOf(TButton)^);
    Load: @TButton.Load;
    Store: @TButton.Store);

  RGButton: TStreamRec = (
    ObjType: 121;
    VmtLink: Ofs(TypeOf(TGButton)^);
    Load: @TGButton.Load;
    Store: @TGButton.Store);

{$ifndef FPK}
  RRegler: TStreamRec = (
    ObjType: 122;
    VmtLink: Ofs(TypeOf(TRegler)^);
    Load: @TRegler.Load;
    Store: @TRegler.Store);
{$endif}

  RCluster: TStreamRec = (
    ObjType: 123;
    VmtLink: Ofs(TypeOf(TCluster)^);
    Load: @TCluster.Load;
    Store: @TCluster.Store);

  RRadioButtons: TStreamRec = (
     ObjType: 124;
     VmtLink: Ofs(TypeOf(TRadioButtons)^);
     Load:    @TRadioButtons.Load;
     Store:   @TRadioButtons.Store);

  RCheckBoxes: TStreamRec = (
     ObjType: 125;
     VmtLink: Ofs(TypeOf(TCheckBoxes)^);
     Load:    @TCheckBoxes.Load;
     Store:   @TCheckBoxes.Store);

  RMultiCheckBoxes: TStreamRec = (
     ObjType: 126;
     VmtLink: Ofs(TypeOf(TMultiCheckBoxes)^);
     Load:    @TMultiCheckBoxes.Load;
     Store:   @TMultiCheckBoxes.Store);

  RListBox: TStreamRec = (
    ObjType: 127;
    VmtLink: Ofs(TypeOf(TListBox)^);
    Load: @TListBox.Load;
    Store: @TListBox.Store);

  RStaticText: TStreamRec = (
    ObjType: 128;
    VmtLink: Ofs(TypeOf(TStaticText)^);
    Load: @TStaticText.Load;
    Store: @TStaticText.Store);

  RParamText: TStreamRec = (
    ObjType: 129;
    VmtLink: Ofs(TypeOf(TParamText)^);
    Load: @TParamText.Load;
    Store: @TParamText.Store);

  RStaticSign: TStreamRec = (
    ObjType: 130;
    VmtLink: Ofs(TypeOf(TStaticSign)^);
    Load: @TStaticSign.Load;
    Store: @TStaticSign.Store);

  RLabel: TStreamRec = (
    ObjType: 131;
    VmtLink: Ofs(TypeOf(TLabel)^);
    Load: @TLabel.Load;
    Store: @TLabel.Store);

  RIcon: TStreamRec = (
    ObjType: 132;
    VmtLink: Ofs(TypeOf(TIcon)^);
    Load: @TIcon.Load;
    Store: @TIcon.Store);

  RHistory: TStreamRec = (
    ObjType: 133;
    VmtLink: Ofs(TypeOf(THistory)^);
    Load: @THistory.Load;
    Store: @THistory.Store);

{ Assign true if you want to have the wf3DFrame Window Flag
  set by default in TDialog.Init.
}
const
  Use3DFrame: Boolean = false;

implementation

{$ifdef FPK}
uses GvValid, HistList;
{$else}
{$ifdef Windows}
uses WinProcs, WinGr, OMemory, ExtGraph, VgaMem, HistList, GVisible,
     GvValid, GvApp;
{$else}
uses CRT, Memory, Gr, MetaGr, ExtGraph, GVDriver, MyMouse, MyFonts,
     VGAMem, HistList, GVisible, GvValid;
{$endif}
{$endif}

const

{ TInputLine Getindex constants }

  leftover  = -1;
  rightover = -2;

{ Help functions }

{$ifndef NOIASM}
function Min (x, y: Integer): Integer; Assembler;
Asm
	MOV	AX, X
	CMP	AX, Y
	JLE	@@1
	MOV	AX, Y
@@1:
End;

function Max (x, y: Integer): Integer; Assembler;
Asm
	MOV	AX, X
	CMP 	AX, Y
        JGE	@@1
        MOV	AX, Y
@@1:
End;
{$endif}

{***************************** TDialog object *****************************}

constructor TDialog.Init(var Bounds: TRect; ATitle: String);
Begin
  TWindow.Init(Bounds, ATitle, wnNoNumber);
  Options:=Options and not ofTileable;
  Flags:=wfMove+wfClose+wfBackground+wfShowTitle+wfModal;
  if Use3DFrame then Flags := Flags or wf3DFrame;
  DragMode:=DragMode and not dmDragGrow;
  GrowMode:=gfAlign;
End;

{$ifdef Windows}
function TDialog.CreateRootWindow: Integer;
var
  st: LongInt;
  ctl3dSubclassDlgEx: function(w: HWND; grbit: LongInt): Bool;
begin
  st := ws_PopupWindow or ws_Caption or ws_ClipSiblings or ws_ClipChildren;
  Wnd := CreateWindowEx(ws_ex_DlgModalFrame, WindowClass, nil, st,
    0, 0, 100, 100, Main^.Wnd, 0, hInstance, @Self);
  {Flags := Flags or wfRootFrame;}
  SetFlags(Flags or wfRootFrame);
  {if Application^.Ctl3DModule <> 0
  then begin
    @ctl3dSubclassDlgEx := GetProcAddress(Application^.Ctl3DModule,
      'Ctl3dSubclassDlgEx');
    ctl3dSubclassDlgEx(Wnd, $ffff)
  end;}
  CreateRootWindow := sw_Show
end;
{$endif Windows}

function TDialog.GetPalette: PPalette;
const P: String [Length (CDialog)] = CDialog;
Begin
  GetPalette:=@P;
End;

procedure TDialog.HandleEvent(var Event: TEvent);
{$ifdef Windows}
const
  Ctl3DDlgFramePaint: function(W: HWND; m: Word; wparam: Word; lparam: LongInt): Bool = nil;
{$endif Windows}
Begin
  TWindow.HandleEvent (Event);
  {$ifdef Windows}
  If Event.What=evSystem
  then with PMSG(Event.InfoPtr)^ do begin
    case message of
      WM_SETTEXT,
      WM_NCPAINT,
      WM_NCACTIVATE:
        if Application^.Ctl3DModule <> 0
        then begin
          if @Ctl3DDlgFramePaint = nil
          then @Ctl3DDlgFramePaint := GetProcAddress(Application^.Ctl3DModule,
            'Ctl3dDlgFramePaint');
          if @Ctl3DDlgFramePaint <> nil
          then begin
            Ctl3DDlgFramePaint(hwnd, message, wparam, lparam);
            ClearEvent(Event);
          end
        end;
    end
  end else
  {$endif Windows}
  If Event.What=evCommand then
    Case Event.Command Of
      cmYes,cmNo,cmOK,cmCancel :
        If State and sfModal <> 0 then Begin
          {  Event.InfoPtr:=@Self; }
          EndModal (Event.Command);
          ClearEvent (Event)
        End;
    End else
  If Event.What=evKeyBoard then Begin
    Case Event.KeyCode Of
      kbEsc   : Begin
                  Event.What := evCommand;
                  Event.Command := cmCancel;
                  Event.InfoPtr := nil;
                  PutEvent(Event)
                End;
      kbEnter : Begin
                  Event.What:=evCommand; Event.Command:=cmDefault;
                  Event.InfoPtr:=@Self;
                  PutEvent (Event)
                End;
     else Exit;
    End;
    ClearEvent (Event);
  End;
End;

function TDialog.Valid(Command: Word): Boolean;
Begin
  Valid:=TWindow.Valid (Command) or (Command=cmCancel);
End;

{**************************** TInputLine object ***************************}

constructor TInputLine.Init(var Bounds: TRect; AMaxLen: Integer);
Begin
  TGView.Init (Bounds);
  {SetState (sfCursorVis,True);}
  Options:=Options or (ofSelectable+ofFirstClick);
  EventMask := EventMask or evBroadcast;
  MaxLen:=AMaxLen;
  FirstPos:=1;
  {SetTextParams (ftMonoSpace, 0,0,true);
  EndPos:=(Size.X-4) div 8;}
  CurPos := 1;
  SetState (sfCursorIns,True);
  GetMem (Data,MaxLen+1);
  Data^:='';
  CursorSize.X:=2;
  CursorSize.Y:=Size.Y-4;
  ShowCursor;
End;

constructor TInputLine.Load(var S: TStream);
Begin
  TGView.Load (S);
  {S.Read (MaxLen, SizeOf (Integer) * 6);}
  S.Read (MaxLen, SizeOf (Integer) * 5);
  GetMem(Data, MaxLen + 1);
  S.Read(Data^[0], 1);
  S.Read(Data^[1], Length(Data^));
  Validator := PValidator(S.Get);
End;

destructor TInputLine.Done;
Begin
  FreeMem (Data,MaxLen+1);
  SetValidator(nil);
  TGView.Done;
End;

procedure TInputLine.ChMCursor;
Var R: TRect;
Begin
  GetExtent (R);
  MakeGlobal (R.A,R.A);
  MakeGlobal (R.B,R.B);
  If R.Contains (MouseWhere) and GetState (sfActive) then NewNum:=mcInput;
End;

function TInputLine.DataSize: Sw_Word;
var
  DSize: Word;
Begin
  DSize := 0;

  {$IFNDEF NOVALIDATE}
  If Validator <> nil then
    DSize := Validator^.Transfer(Data^, nil, vtDataSize);
  {$ENDIF}

  If DSize <> 0 then DataSize := DSize
                else DataSize := MaxLen + 1;
End;

procedure TInputLine.DoDrawText(s, e: Integer; Sel: Boolean);
var
  R: TRect;
  Str: String;
Begin
  if Sel then SetFillStyle(SolidFill, GetColor(3))
  else SetFillStyle(SolidFill, GetColor(2));
  SetTextParams(GetStandardFont, 0, GetColor(6), false);
  SetKern(false);
  GetPosition(s, e, R);
  if R.B.x - R.A.x <> 0 then begin
    Bar(R.A.x, R.A.y, R.B.x - 1, R.B.y - 1);
    Str := Copy(Data^, s, e - s + 1);
    OutTextXY(R.A.x, (R.B.y - R.A.y) div 2 + 1, Str);
  end
End;

procedure TInputLine.Draw;
Begin
  HideCursor;
  If GetState (sfSelected) then SetFillStyle (SolidFill, GetColor (2))
			   else SetFillStyle (SolidFill, GetColor (1));
  Bar (0, 0, Size.X-1, Size.Y-1);
  SetColor (GetColor (5));
  RectAngle (0, 0, Size.X-1, Size.Y-1);
  ShowCursor;
  {DrawText (FirstPos, FirstPos+EndPos);}
  DrawText (FirstPos, Length(Data^) + 1);
End;

{procedure TInputLine.DrawText;
var R: TRect;
    H: Word;
    S: String;
    I: Integer;
Begin
  If APos>EPos then Exit;
  SetViewPort;
  HideCursor;

  GetExtent(R);
  R.Grow(-2, -2);
  SetSubRect(R);
  SetTextParams (ftMonoSpace, 0,0,true);
  H:=8;
  For I:=APos to EPos do Begin
    If (I>=FirstPos) and (I<=FirstPos+EndPos) then Begin
      If (I>=SelStart) and (I<SelEnd) and GetState (sfSelected) then
	SetFillStyle (SolidFill,GetColor (3))
      Else If GetState (sfSelected) then
	     SetFillStyle (SolidFill, GetColor (2))
	   Else SetFillStyle (SolidFill, GetColor (1));
      Bar (2+(I-FirstPos)*H, 2, 9+(I-FirstPos)*H, Size.Y-3);
    End;
  End;

  If EPos>Length (Data^) then EPos:=Length (Data^);
  If EPos>FirstPos+EndPos then EPos:=FirstPos+EndPos;
  If APos<FirstPos then APos:=FirstPos;
  S:=Copy (Data^,APos, EPos-APos+1);
  R.Assign (2+(APos-FirstPos)*H,2,Size.X-3,Size.Y-5);

  SetTextJustify(LeftText, CenterText);
  SetTextParams(ftMonoSpace, 0, GetColor(6), false);
  OutTextXY(R.A.X, R.A.Y + R.B.Y div 2 + 1, S);

  ShowCursor;
  RestoreViewPort;
End;
}

procedure TInputLine.DrawText(apos, epos: Integer);
var R: TRect;
Begin
  If APos>EPos then Exit;
  SetViewPort;
  HideCursor;

  GetExtent(R);
  R.Grow(-2, -2);
  SetSubRect(R);
  SetTextParams (GetStandardFont, 0,0,true);
  SetKern(false);
  SetTextJustify(LeftText, CenterText);

  if IsSelection then begin
    { Draw before selection }
    if apos < SelStart then DoDrawText(apos, Min(SelStart - 1, epos), false);

    { Draw selection }
    if epos > SelStart then DoDrawText(SelStart, Min(epos, SelEnd - 1), true);

    { Draw after selection }
    if SelEnd < epos then DoDrawText(SelEnd, epos, false);
  end
  else DoDrawText(apos, epos, false);

  ShowCursor;
  RestoreViewPort;
End;

procedure TInputLine.GetData(var Rec);
Begin
  {$IFNDEF NOVALIDATE}
  If (Validator = nil) or
     (Validator^.Transfer(Data^, @Rec, vtGetData) = 0) then Begin
  {$ELSE}
  If true then Begin
  {$ENDIF}
    FillChar(Rec, DataSize, #0);
    Move(Data^, Rec, Length(Data^) + 1);
  End;
End;

function TInputLine.GetIndex(P: TPoint): Integer;
var
  i: Integer;
  R: TRect;
Begin
  if P.x < 2 then GetIndex := leftover
  else if P.x > Size.x - 2 then  GetIndex := rightover
  else begin
    i := FirstPos;
    P.y := Size.y div 2;
    repeat
      GetPosition(FirstPos, i, R);
      inc(i);
    until R.Contains(P) or (i > Length(Data^) + 1);
    if i > Length(Data^) + 1 then GetIndex := Length(Data^) + 1
    else GetIndex := i - 1;
  end;
End;

procedure TInputLine.GetPosition(apos, epos: Integer; var R: TRect);
var
  l, start, len: Integer;
  negativ, s, c: String;
Begin
  l := Length(Data^) + 1;
  apos := Max(Min(l, apos), 1);
  epos := Max(Min(l, epos), apos);
  negativ := Copy(Data^, 1, FirstPos - 1);
  s := Copy(Data^, 1, apos - 1);
  c := Copy(Data^, apos, epos - apos + 1);
  SetTextParams(GetStandardFont, 0, 0, false);
  SetKern(false);
  start := TextWidth(s) - TextWidth(negativ);
  len := TextWidth(c) {+ 1};
{  if (apos <> 1) then inc(start); }
  R.Assign(2 + start, 2, 2 + start + len, Size.y - 2);
End;

Function TInputLine.GetPalette: PPalette;
Const
  P:String [Length (CInputLine)]=CInputLine;
Begin
  GetPalette:=@P
End;

{procedure TInputLine.HandleEvent;
var MIV: Boolean;
    I: Integer;
    R: TRect;
    EvWhere: TPoint;

    OldData: String;
    OldCurPos, OldFirstPos, OldSelStart, OldSelEnd: Integer;
    WasAppending: Boolean;

 procedure SaveState;
 Begin
   OldCurPos := CurPos;
   If Validator <> nil then Begin
     OldData := Data^;
     OldFirstPos := FirstPos;
     OldSelStart := SelStart;
     OldSelEnd := SelEnd;
     WasAppending := Length(Data^)+1 = CurPos;
   End;
 End;

 procedure RestoreState;
 Begin
   If Validator <> nil then Begin
     Data^ := OldData;
     SetCurPos(OldCurPos, false);
     FirstPos := OldFirstPos;
     SetSelect(OldSelStart, OldSelEnd);
   End;
 End;

 function CheckValid(NoAutoFill: Boolean): Boolean;
 var
   OldLen: Integer;
   NewData: String;
 Begin
   $IFNDEF NOVALIDATE
   If Validator <> nil then Begin
     CheckValid := False;
     OldLen := Length(Data^);
     If (Validator^.Options and voOnAppend = 0) or
	(WasAppending and (CurPos = OldLen+1)) then Begin
       NewData := Data^;
       If not Validator^.IsValidInput(NewData, NoAutoFill) then
	 RestoreState
       Else Begin
	 If Length(NewData) > MaxLen then NewData[0] := Char(MaxLen);
	 Data^ := NewData;
	 If (CurPos >= OldLen) and (Length(Data^) > OldLen) then
	   SetCurPos(Length(Data^) + 1, false);
	 CheckValid := True;
       End;
     End
     Else Begin
       CheckValid := True;
       If CurPos = OldLen+1 then
	 If not Validator^.IsValidInput(Data^, False) then Begin
	   Validator^.Error;
	   CheckValid := False;
	 End;
     End;
   End
   Else CheckValid := True;
   $ELSE
   CheckValid := true;
   $ENDIF
 End;

Begin
  TGView.HandleEvent (Event);
  MIV:=MouseInView (Event.Where);
  If Event.What=evMouseDown then Begin
    If SelEnd <> SelStart then SetSelect(CurPos, CurPos);
    Repeat
      GetExtent (R);
      MakeLocal (Event.Where, EvWhere);
      If R.Contains(EvWhere) and (Event.What = evMouseDown) then
        SetCurPos(FirstPos + Evwhere.X div 8, false);
      If Event.What = evMouseAuto then Begin
        If (R.A.X < EvWhere.X) and (R.B.X > EvWhere.X) then Begin
	  I := FirstPos + EvWhere.X div 8;
          If SelEnd = SelStart then Begin
	    If I < CurPos then SetSelect(I, SelEnd);
            If I > CurPos then SetSelect(SelStart, I);
	  End
          Else Begin
	    If CurPos = SelStart then SetSelect(Min(I, SelEnd), Max(I, SelEnd));
            If CurPos = SelEnd then SetSelect(Min(SelStart, I), Max(SelStart, I));
          End;
	  SetCurPos(FirstPos + EvWhere.X div 8, true);
        End
	Else If (R.A.X >= EvWhere.X) and (CurPos > 1) then Begin
          If (CurPos = SelEnd) and (SelEnd <> SelStart) then
	    SetSelect(SelStart, CurPos - 1)
	  Else SetSelect(CurPos-1, SelEnd);
          SetCurPos(CurPos-1, true);
        End
        Else If (R.B.X <= EvWhere.X) and (CurPos <= Length(Data^)) then Begin
          If (CurPos = SelStart) and (SelEnd <> SelStart) then
            SetSelect(CurPos+1, SelEnd)
	  Else SetSelect(SelStart, CurPos+1);
	  SetCurPos(CurPos+1, true);
        End;
      End;
    Until not MouseEvent (Event, evMouseAuto);
  End;
  If (Event.What=evKeyBoard) and GetState (sfSelected) then Begin
    Event.KeyCode := CtrlToArrow(Event.KeyCode);
    SaveState;
    Case Event.KeyCode Of
      kbRight: If CurPos<=Length (Data^) then Begin
		 If GetShiftState and (kbLeftShift+kbRightShift) <>0 then Begin
		   If SelEnd=SelStart then SetSelect(CurPos, CurPos + 1)
		   Else If (SelStart=CurPos) and (SelEnd>=SelStart) then
			  SetSelect(CurPos + 1, SelEnd)
			Else SetSelect(SelStart, Curpos + 1);
		   SetCurPos(CurPos+1, true);
		 End
		 Else SetCurPos (CurPos+1, false);
		 CheckValid(true)
	       End;
      kbLeft : If CurPos>1 then Begin
		 If (GetShiftState and (kbLeftShift+kbRightShift) <>0) then Begin
		   If SelEnd=SelStart then SetSelect (CurPos-1, CurPos)
		   Else If CurPos-1<SelStart then SetSelect(CurPos-1, SelEnd)
					     else SetSelect(SelStart, CurPos -1);
		   SetCurPos (CurPos-1, true);
		 End
		 Else SetCurPos (CurPos-1, false);
	       End;
      kbDel  : Begin
		 Delete (Data^,SelStart, Max(SelEnd-SelStart,1));
		 SetCurPos(SelStart, false);
		 CheckValid(true);
		 DrawText(SelEnd, FirstPos+EndPos);
	       End;
      kbBack : If (CurPos<=MaxLen+1) and (CurPos>1) then Begin
		 If SelStart <> SelEnd then Begin
		   Delete(Data^, SelStart, SelEnd - SelStart);
		   SetCurPos(SelStart, false);
		   CheckValid(true);
		   DrawText(SelEnd, FirstPos + EndPos);
		 End
		 Else Begin
		   Delete (Data^,CurPos-1,1);
		   SetCurPos (CurPos-1, false);
		   CheckValid(true);
		   DrawText(CurPos, FirstPos + EndPos);
		 End;
	       End;
      kbIns  : SetState (sfCursorIns, not GetState (sfCursorIns));
      kbEnd  : Begin
		 If GetShiftState and (kbLeftShift+kbRightShift) <>0 then Begin
		   SetSelect(CurPos, Length(Data^)+1);
		   SetCurPos(Length(Data^)+1, true);
		 End
		 Else SetCurPos (Length (Data^)+1, false);
		 CheckValid(true)
	       End;
      kbHome : Begin
		 If GetShiftState and (kbLeftShift+kbRightShift) <>0 then Begin
		   SetSelect(1, CurPos);
		   SetCurPos(1, true);
		 End
		 Else SetCurPos (1,false);
	       End;
     Else If Ord (Event.CharCode) in [32..254] then Begin
	    If State and sfCursorIns = 0 then
	      Delete(Data^, CurPos, 1)
	    Else If SelEnd > SelStart then Begin
	      Delete(Data^,SelStart,SelEnd-SelStart);
	      DrawText(SelEnd, FirstPos + EndPos-1);
	      SetCurPos(SelStart, false);
	    End;
	    If CurPos > Length(Data^)+1 then SetCurPos(Length(Data^)+1, false);
	    If CheckValid(true) then Begin
	      If Length(Data^) < MaxLen then Begin
		Insert(Event.CharCode, Data^, CurPos);
		If CurPos <= MaxLen then SetCurPos (CurPos+1, false);
		CheckValid(false);
		If Exposed then DrawText(min(CurPos - 1, OldCurPos), Length(Data^));
	      End
	    End
	    Else If State and sfCursorIns = 0 then DrawText(CurPos, FirstPos + EndPos);
     End
     Else Exit;
    End;
    ClearEvent (Event);
  End;
End; }

procedure TInputLine.HandleEvent(var Event: TEvent);
var
  OldData: String;
  OldCurPos, OldFirstPos, OldSelStart, OldSelEnd: Integer;
  WasAppending: Boolean;
  EvWhere, P: TPoint;
  index: Integer;
  shift: Boolean;
  str: String;

 procedure SaveState;
 Begin
   OldCurPos := CurPos;
   OldData := Data^;
   OldFirstPos := FirstPos;
   OldSelStart := SelStart;
   OldSelEnd := SelEnd;
   WasAppending := Length(Data^)+1 = CurPos;
 End;

 procedure RestoreState;
 Begin
   If Validator <> nil then Begin
     Data^ := OldData;
     SetCurPos(OldCurPos, none);
     FirstPos := OldFirstPos;
     SetSelect(OldSelStart, OldSelEnd);
   End;
 End;

 function CheckValid(NoAutoFill: Boolean): Boolean;
 var
   OldLen: Integer;
   NewData: String;
 Begin
   {$IFNDEF NOVALIDATE}
   If Validator <> nil then Begin
     CheckValid := False;
     OldLen := Length(Data^);
     If (Validator^.Options and voOnAppend = 0) or
	(WasAppending and (CurPos = OldLen+1)) then Begin
       NewData := Data^;
       If not Validator^.IsValidInput(NewData, NoAutoFill) then
	 RestoreState
       Else Begin
	 If Length(NewData) > MaxLen then NewData[0] := Char(MaxLen);
	 Data^ := NewData;
	 If (CurPos >= OldLen) and (Length(Data^) > OldLen) then
	   SetCurPos(Length(Data^) + 1, none);
	 CheckValid := True;
       End;
     End
     Else Begin
       CheckValid := True;
       If CurPos = OldLen+1 then
	 If not Validator^.IsValidInput(Data^, False) then Begin
	   Validator^.Error;
	   CheckValid := False;
	 End;
     End;
   End
   Else CheckValid := True;
   {$ELSE}
   CheckValid := true;
   {$ENDIF}
 End;

Begin
  TGView.HandleEvent (Event);
  If Event.What=evMouseDown then Begin
    If SelEnd <> SelStart then SetSelect(CurPos, CurPos);
    Repeat
      MakeLocal (Event.Where, EvWhere);
      index := GetIndex(EvWhere);
      Case index of
        leftover:
          SetCurPos(FirstPos - 1, left);
        rightover: Begin
          P.x := Size.x - 2; P.y := 0;
          SetCurPos(GetIndex(P) + 1, right);
	end
        else begin
          if Event.What = evMouseDown then SetCurPos(index, none)
          else if index > CurPos then SetCurPos(index, right)
	  else SetCurPos(index, left);
        end;
      end;
    Until not MouseEvent (Event, evMouseAuto);
    ClearEvent(Event);
  End;
  If (Event.What=evKeyBoard) and GetState (sfSelected) then Begin
    Event.KeyCode := CtrlToArrow(Event.KeyCode);
    SaveState;
    shift := GetShiftState and (kbLeftShift+kbRightShift) <>0;
    Case Event.KeyCode Of
      kbRight: if Shift then SetCurPos(CurPos + 1, right)
               else SetCurPos(CurPos + 1, none);
      kbLeft : if Shift then SetCurPos(CurPos - 1, left)
               else SetCurPos(CurPos - 1, none);
      kbDel  : Begin
		 Delete (Data^,SelStart, Max(SelEnd-SelStart,1));
		 SetCurPos(SelStart, none);
		 CheckValid(true);
		 DrawText(SelStart, Length(Data^) + 1);
                 Restore;
	       End;
      kbBack : If CurPos>1 then Begin
		 If IsSelection then Begin
		   Delete(Data^, SelStart, SelEnd - SelStart);
		   SetCurPos(SelStart, none);
		   CheckValid(true);
		   DrawText(SelStart, Length(Data^) + 1);
		 End
		 Else Begin
		   Delete (Data^,CurPos-1,1);
		   SetCurPos (CurPos-1, none);
		   CheckValid(true);
		   DrawText(CurPos, Length(Data^) + 1);
		 End;
                 Restore;
	       End;
      kbIns  : SetState (sfCursorIns, not GetState (sfCursorIns));
      kbEnd  : Begin
                 if Shift then SetCurPos(Length(Data^)+ 1, right)
                 else SetCurPos(Length(Data^) + 1, none);
	       End;
      kbHome : Begin
		 if Shift then SetCurPos(1, left)
                 else SetCurPos(1, none);
	       End;
     Else If Ord (Event.CharCode) in [32..254] then Begin
       if IsSelection then begin
         Delete(Data^, SelStart, SelEnd - SelStart);
         SetCurPos(SelStart, none);
         CheckValid(true);
         DrawText(SelStart, Length(Data^) + 1);
	 Restore;
       end;
       if WasAppending then begin
         if Length(Data^) < MaxLen then begin
	   inc(Byte(Data^[0])); Data^[Length(Data^)] := Event.CharCode;
         end
       end
       else begin
         str := Event.CharCode;
         if GetState(sfCursorIns) then begin
           if Length(Data^) < MaxLen then Insert(str, Data^, CurPos)
         end
	 else If (CurPos <> MaxLen + 1) then Data^[CurPos] := Event.CharCode;
       end;
       SetCurPos(CurPos + 1, none);
       CheckValid(false);
       DrawText(CurPos - 1, Length(Data^) + 1);
       if not GetState(sfCursorIns) then Restore;
     End
     Else Exit;
    End;
    ClearEvent (Event);
  End;
End;

function TInputLine.IsSelection: Boolean;
Begin
  IsSelection := GetState(sfSelected) and (SelStart < SelEnd);
end;

procedure TInputLine.Restore;
var R: TRect;
Begin
  SetViewport;
  HideCursor;
  GetPosition(1, Length(Data^) + 1, R);
  if R.B.x < Size.x then Begin
    SetFillStyle(SolidFill, GetColor(2));
    R.A.x := R.B.x; R.B.x := Size.x - 2;
    Bar(R.A.x, R.A.y, R.B.x - 1, R.B.y - 1);
  end;
  ShowCursor;
  RestoreViewport;
End;

{procedure TInputLine.SelectAll;
Var I: Integer;
Begin
  SetCurPos (1,false);
  FirstPos:=1;
  If Enable then SetSelect (1, Length (Data^)+1);
  If Exposed then DrawText (SelStart, FirstPos+EndPos-1);
End;}
procedure TInputLine.SelectAll(Enable: Boolean);
Begin
  SetCurPos (1,none);
  FirstPos:=1;
  If Enable then SetSelect (1, Length (Data^)+1);
  If Exposed then DrawText (SelStart, Length(Data^) + 1);
End;

{procedure TInputLine.SetCurPos;
var OldC: Integer;
    P: TPoint;
    R: TRect;
Begin
  OldC:=CurPos;
  CurPos:=Max(1, Min(Length(Data^)+1,ACurPos));
  If not DoSelect then SetSelect(CurPos, CurPos);
  HideCursor;

  P.Y := 0;
  R.Assign(2, 2, Size.X - 2, Size.Y - 2);
  If CurPos>FirstPos+EndPos-1 then Begin
    FirstPos:=CurPos-EndPos+1;
    If Exposed then Begin
      If OldC+1 = CurPos then Begin
        P.X := -8;
        ScrollView(@Self, P, @R);
      End
      Else DrawText (FirstPos, FirstPos+EndPos);
    End;
  End;
  If CurPos<FirstPos then Begin
    FirstPos:=CurPos;
    If Exposed then Begin
      If OldC-1 = CurPos then Begin
        P.X := 8;
        ScrollView(@Self, P, @R);
      End
      Else DrawText (FirstPos, FirstPos+EndPos);
    End;
  End;
  SetCursor (2+(CurPos-FirstPos)*8, 2);
  ShowCursor;
End; }

procedure TInputLine.SetCurPos(ACurPos: Integer; DoSelect: TSelection);
var OldC, OldFirst: Integer;
    R: TRect;
Begin
  OldC:=CurPos;
  CurPos:=Max(1, Min(Length(Data^)+1,ACurPos));
  Case DoSelect of
    none: SetSelect(CurPos, CurPos);
    left:
      if (OldC = SelEnd) then
	SetSelect(Min(SelStart, CurPos), Max(SelStart, CurPos))
      else SetSelect(CurPos, SelEnd);
    right:
      if (OldC = SelStart) then
	SetSelect(Min(CurPos, SelEnd), Max(SelEnd, CurPos))
      else SetSelect(SelStart, CurPos);
  end;
  HideCursor;
  GetPosition(CurPos, CurPos, R);
  OldFirst := FirstPos;
  if (R.B.x > Size.x - 2) then
    while (R.B.x > Size.x - 2) and (FirstPos <= Length(Data^)) do begin
      inc(FirstPos);
      GetPosition(CurPos, CurPos, R);
    end
  else
    if CurPos < FirstPos then begin
      FirstPos := Max(1, CurPos - 5);
      GetPosition(CurPos, CurPos, R);
    end;
  if (OldFirst <> FirstPos) then DrawView; { yeah scrolling }
  SetCursor (R.A.x, 2);
  ShowCursor;
End;

Procedure TInputLine.SetData(var Rec);
Begin
  {$IFNDEF NOVALIDATE}
  If (Validator = nil) or
     (Validator^.Transfer(Data^, @Rec, vtSetData) = 0) then
  {$ELSE}
  If true then
  {$ENDIF}
    Move(Rec, Data^[0], DataSize);

  {If CurPos>Length (Data^) then SetCurPos (Length (Data^), false);}
  If CurPos>Length (Data^) then SetCurPos (Length (Data^), none);
  SelectAll (True);
  DrawView;
End;

procedure TInputLine.SetSelect(NewStart, NewEnd: Integer);
var DrawStart, DrawEnd: Integer;
Begin
  If (NewStart <> SelStart) or (NewEnd <> SelEnd) then Begin
    DrawStart := 0; DrawEnd := DrawStart;
    NewStart := Max(1, NewStart); NewEnd := Min(Length(Data^)+1, NewEnd);
    If (NewStart <> NewEnd) or (SelStart <> SelEnd) then Begin
      If NewStart = NewEnd then Begin
	DrawStart := SelStart;
	DrawEnd := SelEnd;
      End
      Else Begin
	If NewStart <> SelStart then Begin
	  DrawStart := Min(NewStart, SelStart);
	  DrawEnd := Max(NewStart, SelStart);
	End;
	If NewEnd <> SelEnd then Begin
          If DrawStart = 0 then DrawStart := Min(NewEnd, SelEnd);
          DrawEnd := Max(NewEnd, SelEnd);
	End;
      End;
    End;
    SelEnd := NewEnd;
    SelStart := NewStart;
    If Exposed and (DrawStart <> DrawEnd) then DrawText (DrawStart, DrawEnd);
  End;
End;

procedure TInputLine.SetState(AState: Word; Enable: Boolean);
Begin
  TGView.SetState (AState,Enable);
  If AState and sfSelected <>0
  then begin
    If GetColor(1) <> GetColor(2) then DrawView;
    SelectAll (Enable);
  end;
  If (AState and sfCursorIns <>0) and GetState (sfCursorVis) then Begin
    If CursorFlag then DrawCursor;
    If Enable then CursorSize.X:=2
	      else CursorSize.X:=8;
    If CursorFlag then DrawCursor;
  End;
End;

procedure TInputLine.SetValidator(AValid: PValidator);
Begin
  {$ifndef NOVALIDATE}
  If Validator <> nil then Validator^.Free;
  {$endif}
  Validator := AValid;
End;

procedure TInputLine.Store(var S: TStream);
Begin
  TGView.Store (S);
  {S.Write (MaxLen, SizeOf (Integer) * 6);}
  S.Write (MaxLen, SizeOf (Integer) * 5);
  S.WriteStr(Data);
  S.Put(Validator);
End;

function TInputLine.Valid(Command: Word): Boolean;

{$ifndef NOVALIDATE}
  function AppendError(Validator: PValidator): Boolean;
  begin
    AppendError := False;
    with Validator^ do
      if (Options and voOnAppend <> 0) and (CurPos <> Length(Data^))
	  and not IsValidInput(Data^, True) then
      begin
	Error;
	AppendError := True;
      end;
  end;
{$endif}

Begin
  Valid := inherited Valid(Command);
{$ifndef NOVALIDATE}
  If (Validator <> nil) and (State and sfDisabled = 0) then
    If Command = cmValid then Valid := Validator^.Status = vsOk
    Else If Command <> cmCancel then Begin
      If AppendError(Validator) or not Validator^.Valid(Data^) then Begin
	Select;
	Valid := False;
      End;
    End;
{$endif}
End;

{**************************** TNumInput object ****************************}

constructor TNumInput.Init(var Bounds: TRect; ALimitLo, ALimitHi: Integer;
		   AArrows: PArrowField);
Begin
  TInputLine.Init (Bounds,6);
  Arrows:=AArrows;
  SetValidator(New(PIntRangeValidator, Init(ALimitLo, ALimitHi)));
  Validator^.Options := Validator^.Options or voTransfer;
  SetLimit (ALimitLo, ALimitHi);
End;

constructor TNumInput.Load(var S: TStream);
Begin
  TInputLine.Load (S);
  GetPeerViewPtr (S, Arrows);
End;

procedure TNumInput.HandleEvent(var Event: TEvent);
var
  Value: Integer;
Begin
  inherited HandleEvent (Event);
  If Event.What=evKeyDown then Begin
    GetData(Value);
    Case Event.KeyCode Of
      kbUp       : Inc(Value);
      kbDown     : Dec(Value);
      kbPgUp     : Inc(Value, 10);
      kbPgDn     : Dec(Value, 10);
      kbCtrlPgUp : Value := PIntRangeValidator(Validator)^.Max;
      kbCtrlPgDn : Value := PIntRangeValidator(Validator)^.Min;
      else Exit;
    End;
    ClearEvent (Event);
    SetData (Value);
    SetCurPos(Length(Data^)+1, none);
  End;
  If (Arrows <> nil) and (Event.What=evBroadCast) and
     (Event.InfoPtr=Arrows) then Begin
    If not GetState (sfSelected) then Select;
    GetData(Value);
    Case Event.Command Of
      cmArrowUp: Inc(Value);
      cmArrowDn: Dec(Value);
     else Exit;
    End;
    SetData (Value);
    SetCurPos(Length(Data^)+1, none);
    ClearEvent (Event);
    Delay (50);
  End;
End;

procedure TNumInput.SetData(var Rec);
var
  Value: Integer;
begin
  Value := Integer(Rec);
  if (Validator <> nil) and (TypeOf(Validator^) = TypeOf(TIntRangeValidator))
  then with PIntRangeValidator(Validator)^ do begin
    if Value < Min then Value := Min else
    if Value > Max then Value := Max
  end;
  inherited SetData(Value)
end;

procedure TNumInput.SetLimit(ALimitLo, ALimitHi: Integer);
var
  Value: Integer;
Begin
  If ALimitLo>ALimitHi then ALimitHi:=ALimitLo;
  if (Validator <> nil) and (TypeOf(Validator^) = TypeOf(TIntRangeValidator))
  then with PIntRangeValidator(Validator)^ do begin
    Min := ALimitLo;
    Max := ALimitHi
  end;
  GetData(Value);
  SetData(Value)
End;

procedure TNumInput.Store(var S: TStream);
Begin
  TInputLine.Store (S);
  PutPeerViewPtr (S, PGView (Arrows));
End;

{*************************** TArrowField object ***************************}

constructor TArrowField.Init(var Bounds: TRect);
Begin
  TGView.Init (Bounds);
  Options:=Options or ofPreProcess;
  EventMask:=EventMask or evBroadCast;
End;

procedure TArrowField.Draw;
var P: TPoint;
Begin
  SetFillStyle (SolidFill, GetColor (1));
  Bar (0, 0, Size.X-1, Size.Y-1);
  P.X:=0; P.Y:=0;
  DrawColIcon (P.X, P.Y, 23, GetColor (2));
End;

function TArrowField.GetPalette: PPalette;
const P: String [Length (CArrowField)] = CArrowField;
Begin
  GetPalette:=@P;
End;

procedure TArrowField.HandleEvent(var Event: TEvent);
var P: TPoint;
    R: TRect;
Begin
  TGView.HandleEvent (Event);
  If Event.What=evMouseDown then Begin
    Repeat
      MakeLocal (Event.Where,P);
      R.Assign (1, 0, Size.X-1, 9);
      If R.Contains (P) then Begin
	Message (GOwner, evBroadCast, cmArrowUp, @Self);
      End;
      R.Move (0, 10);
      Inc (R.B.Y);
      If R.Contains (P) then Begin
	Message (GOwner, evBroadCast, cmArrowDn, @Self);
      End;
    Until not MouseEvent (Event, evMouseAuto);
  End;
End;

{************************** TButton object ********************************}

constructor TButton.Init(var Bounds: TRect; ATitle: TTitleStr; ACommand: Word;
  AFlags: Word);
Begin
  TGView.Init (Bounds);
  Title:=NewStr (ATitle);
  Command:=ACommand;
  Flags:=AFlags;
  AmDefault:=Flags and bfDefault <> 0;
  Options:=Options or (ofSelectable + ofFirstClick + ofPreProcess + ofPostProcess);
  EventMask:=EventMask or evBroadcast;
  If not CommandEnabled(ACommand) then Begin
    State := State or sfDisabled;
    AmDefault := false;
  End;
  {Pressed:=true;}
  Pressed := false
End;

constructor TButton.Load(var S: TStream);
Begin
  TGView.Load (S);
  Title:=S.ReadStr;
  S.Read (Command, SizeOf (Command));
  S.Read (Flags, SizeOf (Flags));
  AmDefault:=(Flags and bfDefault)<>0;
  {Pressed:=true;}
  Pressed := false;
{$ifndef FPK}
  If State and sfDisabled <> 0 then DisableCommands([Command]);
{$endif FPK}
End;

Destructor TButton.Done;
Begin
  DisposeStr (Title);
  TGView.Done
End;

Procedure TButton.Draw;
Begin
  DrawState (Pressed{false});
  {Pressed:=false;}
End;

Procedure TButton.CondDrawState(Down: Boolean);
Begin
{$ifdef FPK}
  if Byte(Pressed)<>Byte(Down) then begin
{$else}
  If Pressed<>Down then Begin
{$endif}
    Pressed:=Down;
    DrawState (Down);
  End;
End;

Procedure TButton.DrawState(Down: Boolean);
Var R:TRect;
    C: Word;
Begin
  SetViewPort;
  Pressed := Down;
  { Hintergrund }
  If AmDefault then Begin
    SetColor (GetColor (10));
    RectAngle (0, 0, Size.X-1, Size.Y-1);
    R.Assign (1, 1, Size.X-1, Size.Y-1);
  End
  Else R.Assign (0, 0, Size.X, Size.Y);
  DrawButton (R, Down, False, White, GetColor (10), GetColor (1), GetColor (9));
  If GOwner <> nil then C:=GOwner^.GetColor (1)
		   else C:=White;
  PutPixel (0,0, C);
  PutPixel (0,Size.Y-1, C);
  PutPixel (Size.X-1,0, C);
  PutPixel (Size.X-1,Size.Y-1, C);
  DrawText (Down);
  RestoreViewPort;
End;

procedure TButton.DrawText(Down: Boolean);
var P: TPoint;
    Col1, Col2: Byte;
Begin
  If GetState (sfSelected) then Begin
    Col1:=4;
    If AmDefault then Col2:=7
		 else Col2:=8;
  End
  Else If GetState (sfDisabled) then Begin
	 Col1:=5;
	 Col2:=5;
       End
       Else If AmDefault then Begin
	      Col1:=3;
	      Col2:=7;
	    End
	    Else Begin
	      Col1:=2;
	      Col2:=6;
	    End;

  P.X:=0; P.Y:=0;
  If Down then Begin Inc (P.X); Inc (P.Y, 2) End;
  If Flags and bfLeftJust <>0 then Begin
    SetTextJustify(LeftText, CenterText);
    Inc(P.X, 4);
  End
  Else Begin SetTextJustify(CenterText, CenterText); P.X := P.X + Size.X div 2 End;
  SetTextParams(GetStandardFont, 0, GetColor(Col1) + GetColor(Col2) shl 8, true);
  If Title <> nil then
  OutTextXY(P.X, P.Y + Size.Y div 2, Title^);
End;

Function TButton.GetPalette: PPalette;
Const
  P:String [Length (CButton)] =CButton;
Begin
  GetPalette:=@P
End;

Procedure TButton.HandleEvent(var Event: TEvent);

 function KeyMatch: Boolean;
 Begin
   KeyMatch := false;
   If (Title = nil) or (GOwner = nil) then Exit;
   KeyMatch := (Ord(GetAltChar(Event.KeyCode)) = Ord(UpCase(GetShortcut(Title^)))) or
               ((GOwner^.Phase = phPostProcess) and
		(Ord(UpCase(Event.CharCode)) = Ord(UpCase(GetShortCut(Title^)))));
 End;

 function Test(P: PGView): Boolean; {$ifndef FPK}far;{$endif}
 Begin
   Test := P^.State and sfDefault <> 0;
 End;

Begin
  If (Event.What=evMouseDown) and MouseInView (Event.Where) then Begin
    If Flags and bfGrabFocus <> 0 then TGView.HandleEvent(Event);
    If Event.What <> evNothing then Begin
      Repeat
        CondDrawState (MouseInView (Event.Where));
      Until not MouseEvent (Event, evMouseAuto+evMouseMove);
      CondDrawState (False);
      If MouseInView (Event.Where) then Press;
      ClearEvent(Event);
    End;
  End
  Else TGView.HandleEvent(Event);
  If ((Event.What=evKeyBoard) and
       (((Event.CharCode=' ') and GetState (sfSelected)) or KeyMatch)) or
     ((Event.What=evCommand) and (Event.Command=cmDefault) and AmDefault)
      Then Begin
        If Exposed then Begin
           DrawState (True);
	   Delay(30);
           DrawState (False);
        End;
        Press;
        ClearEvent(Event);
      End;
  If (Event.What=evBroadCast) then
    Case Event.Command of
      cmGrabDefault:
        If (Flags and bfDefault <> 0) and AmDefault then Begin
	  AmDefault := false;
          DrawView;
        End;
      cmCommandSetChanged:
        If CommandEnabled(Command) and (State and sfDisabled <> 0) then
          SetState(sfDisabled, false)
        Else If not CommandEnabled(Command) and (State and sfDisabled = 0) then
          SetState(sfDisabled, true);
    End;
  If (Flags and bfDefault <> 0) and not AmDefault and (GOwner <> nil) and
     (GOwner^.Current^.State and sfSelected <> 0) and
     (GOwner^.FirstThatInMethod(@Test, @Self) = nil) then Begin
    AmDefault := true;
    DrawView;
  End;
End;

Procedure TButton.MakeDefault(Enable: Boolean);
var C: Word;
Begin
  If Flags and bfDefault = 0 then Begin
    If Enable then C := cmGrabDefault
	      else C := cmReleaseDefault;
    SetState(sfDefault, Enable);
    Message(GOwner, evBroadcast, C, @Self);
    AmDefault := Enable;
    DrawView;
  End;
End;

Procedure TButton.Press;
var E: TEvent;
    P: PGGroup;
Begin
  Message(GOwner, evBroadcast, cmRecordHistory, nil);
  If Flags and bfBroadcast <> 0 then Begin
    P := GOwner;
    While (P <> nil) and (P^.GOwner <> nil) do P := P^.GOwner;
    Message(P, evBroadcast, Command, @Self)
  End
  Else Begin
    E.What := evCommand;
    E.Command := Command;
    E.InfoPtr := @Self;
    PutEvent(E);
  End;
End;

Procedure TButton.SetState(AState: Word; Enable: Boolean);
Begin
  TGView.SetState (AState, Enable);
  If (AState and sfSelected <> 0) and (State and sfDisabled = 0) then
    MakeDefault (Enable);
  If (AState and (sfSelected) <> 0) and
     ((GOwner<>nil) {and (GOwner^.AlreadyDrawn)}) and
     not GetState (sfDisabled) and not GetState (sfDragging) Then
    Begin DrawView End;
  If AState and sfDisabled <> 0 then Begin
    AmDefault := false;
    DrawView;
  End;
End;

procedure TButton.Store(var S: TStream);
Begin
  TGView.Store (S);
  S.WriteStr (Title);
  S.Write (Command, SizeOf (Command));
  S.Write (Flags, SizeOf (Flags));
End;

{*************************** TGButton object ******************************}

Constructor TGButton.Init(var Bounds: TRect; ASign: Pointer; ACommand: Word;
  AFlags: Word);
Begin
  TButton.Init (Bounds,'',ACommand,AFlags);
  Sign := CopyImage(ASign)
End;

constructor TGButton.Load(var S: TStream);
Begin
  TButton.Load (S);
  Sign := LoadImage(S)
End;

Destructor TGButton.Done;
Begin
  FreeImage(Sign);
  TGView.Done
End;

procedure TGButton.DrawText(Down: Boolean);
var R: TRect;
    Col: Byte;
Begin
  If GetState (sfSelected)
    Then Col:=4
    Else If GetState (sfDisabled)
	   Then Col:=5
	   Else If AmDefault
                  Then Col:=3
                  Else Col:=2;

  GetExtent (R);
  If Down then R.Move (2,2);
  PutGVImage (R, Sign, GetColor (Col));
End;

procedure TGButton.Store(var S: TStream);
Begin
  TButton.Store (S);
  StoreImage(S, Sign)
End;

{****************************** TRegler object ****************************}

{$ifndef FPK}
Constructor TRegler.Init;
Begin
  TGView.Init (Bounds);
  Value:=0; MinValue:=AMinValue; MaxValue:=AMaxValue;
  Bezeichnung:=NewStr (ABezeichnung);
  MinBez:=NewStr (AMinBez);
  MidBez:=NewStr (AMidBez);
  MaxBez:=NewStr (AMaxBez);
  OldY:=Position (Value);
  Options:=Options or (ofSelectable + ofFirstClick);
  EventMask := EventMask or evBroadcast;
End;

destructor TRegler.Done;
Begin
  DisposeStr (Bezeichnung);
  DisposeStr (MinBez);
  DisposeStr (MidBez);
  DisposeStr (MaxBez);
  TGView.Done;
End;

constructor TRegler.Load;
Begin
  TGView.Load (S);
  S.Read(Value, SizeOf(Value));
  S.Read (MinValue, SizeOf (MinValue));
  S.Read (MaxValue, SizeOf (MaxValue));
  Bezeichnung:=S.ReadStr;
  MinBez:=S.ReadStr;
  MidBez:=S.ReadStr;
  MaxBez:=S.ReadStr;
  OldY:=Position (Value);
End;

procedure TRegler.Store;
Begin
  TGView.Store (S);
  S.Write(Value, SizeOf(Value));
  S.Write (MinValue, SizeOf (MinValue));
  S.Write (MaxValue, SizeOf (MaxValue));
  S.WriteStr (Bezeichnung);
  S.WriteStr (MinBez);
  S.WriteStr (MidBez);
  S.WriteStr (MaxBez);
End;

Function TRegler.GetPalette;
Const
  P:String [Length (CRegler)]=CRegler;
Begin
  GetPalette:=@P;
End;

Procedure TRegler.SetData;
Var
  NewValue:Real absolute Rec;
Begin
  Value:=NewValue
End;

Procedure TRegler.GetData;
Var
  NewValue:Real absolute Rec;
Begin
  NewValue:=Value
End;

Function TRegler.DataSize;
Begin DataSize:=SizeOf (Value) End;

Procedure TRegler.Draw;
var C: Byte;
Begin
  SetFillStyle (SolidFill, GetColor (4));
  Bar (0, 0, Size.X-1, Size.Y-1);
  If GetState (sfDisabled)
    Then C:=GetColor (3)
    Else If GetState (sfSelected)
      Then C:=GetColor (1)
      Else C:=GetColor (2);
  SetColor (C);
  RectAngle (0, 0, Size.X-1, Size.Y-1);
  SetTextParams (ftSansSerif,0, (C shl 8)+C, True);
  SetTextJustify (CenterText, TopText);
  OutTextXY (Size.X div 2, Size.Y+5, Bezeichnung^);
  SetTextJustify (RightText, CenterText);
  OutTextXY (-2, Size.Y, MinBez^);
  OutTextXY (-2, Size.Y div 2, midBez^);
  OutTextXY (-2, 0, maxBez^);
  UpDate;
End;

Procedure TRegler.UpDate;
Var
  y:Word;
  R:TRect;
Begin
  SetViewPort;
  y:=Position (Value);
  HideMouse;
  SetColor (GetColor(4)); HoriLine (1, OldY, Size.X-2);
  If GetState (sfDisabled)
    Then SetColor (GetColor (3))
    Else If GetState (sfSelected)
      Then SetColor (GetColor (1))
      Else SetColor (GetColor (2));
  HoriLine (1, Y, Size.X-2);
  ShowMouse;
  OldY:=y;
  RestoreViewPort;
End;

Function TRegler.Position;
Begin
  Position:=Round ((XValue-minValue)/(minValue-maxValue)
                  *(Size.Y-3)) + Size.Y - 2
End;

Function TRegler.ToValue;
Var V:Real;
Begin
  V:=(XPosition-Size.Y+2) / (Size.Y-3)
     *(minValue-maxValue) + minValue;
  If V>maxValue Then V:=maxValue;
  If V<minValue Then V:=minValue;
  ToValue:=V
End;

Procedure TRegler.HandleEvent;
Var
  y:Integer;
  P:TPoint;
Begin
  TGView.HandleEvent (Event);
  y:=Position (Value);
  MakeLocal (Event.Where, P);
  Case Event.What of
    evMouseDown: If MouseInView (Event.Where) then Begin
		   Repeat
                     MakeLocal (Event.Where, P);
                     If (Value<=maxValue) and (Value>=minValue) then Begin
                       OldValue:=Value;
                       Value:=ToValue (P.Y);
                       If OldValue<>Value then UpDate;
                     End;
                   Until not MouseEvent (Event, evMouseMove+evMouseAuto);
		   ClearEvent (Event);
                 End;
    evKeyDown: Begin
                 If Event.CharCode=' '
                   Then Value:=(MinValue+MaxValue)/2
                   Else
                     Case Event.KeyCode of
                       kbUp:   Value:=ToValue (Position (Value)-1);
                       kbDown: Value:=ToValue (Position (Value)+1);
                       kbPgUp: Value:=ToValue (Position (Value)-Size.Y div 8);
                       kbPgDn: Value:=ToValue (Position (Value)+Size.Y div 8);
                       kbHome: Value:=MaxValue;
                       kbEnd:  Value:=MinValue;
                       Else Exit
                     End;
                 UpDate;
               End;
  End { Case }
End;

Procedure TRegler.SetState;
Var
  S:Boolean;
Begin
  S:=GetState (sfSelected);
  TGView.SetState (AState, Enable);
  {
  If (AState and sfSelected <> 0) and (S<>Enable) and
     ((GOwner<>nil))
    Then DrawView;
   }
End;
{$endif FPK}

{**************************** TCluster object *****************************}

constructor TCluster.Init(var Bounds: TRect; AStrings: PSItem);
var SItem: PSItem;
    I: Integer;
Begin
  TGView.Init (Bounds);
  Options:=Options or (ofSelectable+ofPostProcess+ofFirstClick);
  EventMask := EventMask or evBroadcast;
  Value:=0;
  Sel:=0;
  EnableMask := $FFFFFFFF;

  I := 0;
  SItem:=AStrings;
  While SItem <> nil do Begin
    Inc(I);
    SItem := SItem^.Next;
  End;
  Strings.Init(I, 0);
  While AStrings<>nil do Begin
    SItem:=AStrings;
    Strings.AtInsert(Strings.Count, AStrings^.Value);
    AStrings := AStrings^.Next;
    Dispose(SItem);
  End;
End;

destructor TCluster.Done;
Begin
  Strings.Done;
  TGView.Done;
End;

constructor TCluster.Load(var S: TStream);
Begin
  TGView.Load (S);
  S.Read (Value, SizeOf (Value));
  S.Read (Sel, SizeOf (Sel));
  S.Read(EnableMask, SizeOf(EnableMask));
  Strings.Load (S);
End;

{$ifdef NOIASM}
function TCluster.ButtonState(Item: Integer): Boolean;
begin
  if Item > 31 then ButtonState := false
  else ButtonState := (EnableMask shr Item) and 1 <> 0
end;
{$else}
function TCluster.ButtonState(Item: Integer): Boolean; Assembler;
asm
	XOR     AL,AL
	MOV     CX,Item
	CMP     CX,31
	JA      @@3
	MOV     AX,1
	XOR     DX,DX
	JCXZ    @@2
@@1:    SHL     AX,1
	RCL     DX,1
	LOOP    @@1
@@2:    LES     DI,Self
	AND     AX,ES:[DI].TCluster.EnableMask.Word[0]
	AND     DX,ES:[DI].TCluster.EnableMask.Word[2]
	OR      AX,DX
	JZ      @@3
	MOV     AL,1
@@3:
end;
{$endif}

function TCluster.DataSize: Sw_Word;
Begin
  DataSize:=SizeOf(Word)
End;

procedure TCluster.Draw;
var Item: Integer;
Begin
  SetFillStyle (SolidFill, GetColor (5));
  Bar (0, 0, Size.X-1, Size.Y-1);
  For Item:=0 to Strings.Count-1 do DrawItem (Item, false);
End;

procedure TCluster.DrawItem(Item: Integer; Down: Boolean);
var Help, ItemRect: TRect;
    Col1, Col2: Byte;
    s: PString;
Begin
  SetViewPort;
  HideMouse;
  GetItemRect (Item, ItemRect);
  If ButtonState(Item) then Col1 := GetColor(6)
                       else Col1 := GetColor(7);
  SetFillStyle (SolidFill, Col1);
  With ItemRect do Bar (A.X, A.Y, B.X-1, B.Y-1);
  If (Item=Sel) and GetState (sfSelected) then Begin
    Col1:=GetColor (2); Col2:=GetColor (4);
  End
  Else If ButtonState(Item) then Begin
	 Col1:=GetColor (1); Col2:=GetColor (3);
       End
       Else Begin
         Col1 := GetColor(8); Col2 := Col1;
       End;
  Help:=ItemRect;
  Inc (Help.A.Y, (Help.B.Y-Help.A.Y) div 2-6);
  If Mark (Item) then
    If Down then DrawColIcon (Help.A.X, Help.A.Y, GetIconNum (4), Col1)
	    else DrawColIcon (Help.A.X, Help.A.Y, GetIconNum (2), Col1)
  Else
    If Down then DrawColIcon (Help.A.X, Help.A.Y, GetIconNum (3), Col1)
	    else DrawColIcon (Help.A.X, Help.A.Y, GetIconNum (1), Col1);
  s := Strings.At(Item);
  If s <> nil then Begin
    Inc (ItemRect.A.X, 18);
    Dec (ItemRect.B.Y, ItemRect.A.Y); Dec (ItemRect.B.X, ItemRect.A.X);
    SetTextParams(GetStandardFont, 0, Col1 + Col2 shl 8, true);
    SetTextJustify(LeftText, CenterText);
    OutTextXY(ItemRect.A.X, ItemRect.A.Y + ItemRect.B.Y div 2 + 1, s^);
  End;
  ShowMouse;
  RestoreViewPort;
End;

procedure TCluster.GetData(var Rec);
Begin
  Word(Rec) := Value;
End;

function TCluster.GetHelpCtx: Word;
Begin
  If HelpCtx<>hcNoContext then GetHelpCtx:=HelpCtx+Sel
                          else GetHelpCtx:=HelpCtx;
End;

function TCluster.GetIconNum(Id: Byte): Integer;
Begin
  Abstract
End;

procedure TCluster.GetItemRect(Item: Integer; var Extent: TRect);
var
  dy, NumCol, ColHeight, ColWidth, ItemsInCol, ColNum, NumInCol: Integer;
Begin
  SetTextParams (GetStandardFont, 0, 0, False);
  dy := TextHeight('') + 2;
  ColHeight := Size.Y - 4;
  ItemsInCol := ColHeight div dy;
  If ItemsInCol = 0 then Inc(ItemsInCol);
  NumCol := (Strings.Count + ItemsInCol - 1) div ItemsInCol;
  ColWidth := (Size.X - 4) div NumCol;
  ColNum := Item div ItemsInCol;
  NumInCol := Item mod ItemsInCol;
  Extent.Assign(2 + ColNum * ColWidth, 2 + NumInCol * dy,
    2 + (ColNum + 1) * ColWidth, 2 + (NumInCol + 1) * dy)
End;

Function TCluster.GetPalette: PPalette;
Const P:String [Length (CCluster)]=CCluster;
Begin
  GetPalette:=@P
End;

procedure TCluster.HandleEvent(var Event: TEvent);
var EvWhere: TPoint;
    ItemRect: TRect;
    Item, H: Integer;
    Down: Boolean;
    s: PString;
Begin
  TGView.HandleEvent (Event);
  If (Options and ofSelectable) = 0 then Exit;

  If (Event.What=evMouseDown) and MouseInView (Event.Where) then Begin
    Down:=False;
    Repeat
      GetItemRect(Sel, ItemRect); MakeLocal (Event.Where,EvWhere);
      If (ItemRect.Contains(EvWhere) and not Down) or
         (not ItemRect.Contains(EvWhere) and Down) then Begin
        Down:=not Down;
	DrawItem (Sel, Down);
      End;
      For Item:=0 to Strings.Count-1 do If ButtonState(Item) then Begin
        GetItemRect (Item,ItemRect);
        If ItemRect.Contains(EvWhere) then Begin
	  H:=Sel;
	  Sel:=Item;
          If H<>Sel then Begin
	    DrawItem (Sel, Down);
	    DrawItem (H, false);
	  End;
	End;
      End;
    Until not MouseEvent (Event, evMouseAuto+evMouseMove);
    GetItemRect(Sel, ItemRect);  MakeLocal(Event.Where, EvWhere);
    If ItemRect.Contains(EvWhere) then Press (Sel);
    ClearEvent (Event);
  End;
  If Event.What=evKeyBoard then Begin
    For Item:=0 to Strings.Count-1 do If ButtonState(Item) then Begin
      s := Strings.At(Item);
      If (s <> nil) and (Ord(GetAltChar(Event.Keycode)) = Ord(GetShortCut(s^)))
      then Begin
	Press (Item);
	If not GetState(sfSelected) then Begin
	  Sel := Item;
	  Select;
	End Else MovedTo(Item);
	ClearEvent (Event);
      End;
    End;
    If GetState (sfFocused+sfSelected) then
      Case Event.KeyCode of
	kbDown : Begin
		   H:=Sel;
                   If Sel+1>=Strings.Count then H:=0
                                           else Inc (H);
                   ClearEvent (Event);
		   MovedTo (H);
		 End;
        kbUp   : Begin
                   H:=Sel;
                   ClearEvent (Event);
                   Repeat
                     If H = 0 then H := Strings.Count;
		     Dec(H);
                   Until ButtonState(H);
                   MovedTo (H);
                 End;
        kbRight: Begin
                   H := Sel;
                   SetTextParams(GetStandardFont, 0, 0, false);
                   Item := (Size.Y - 4) div (TextHeight('') + 2);
                   Repeat
                     Inc(H, Item);
                     If H >= Strings.Count then Dec(H, Strings.Count);
                   Until ButtonState(H);
                   MovedTo(H);
                   ClearEvent(Event);
                 End;
        kbLeft : Begin
		   H := Sel;
		   SetTextParams(GetStandardFont, 0, 0, false);
                   Item := (Size.Y - 4) div (TextHeight('') + 2);
                   Repeat
                     Dec(H, Item);
                     If H < 0 then Inc(H, Strings.Count);
		   Until ButtonState(H);
                   MovedTo(H);
                   ClearEvent(Event);
                 End;
        Else If Event.CharCode=' ' then Begin
               Press (Sel);
	       ClearEvent (Event);
             End;
      End;
  End;
End;

function TCluster.Mark(Item: Integer): Boolean;
Begin
  Mark:=False;
End;

function TCluster.MultiMark(Item: Integer): Byte;
Begin
{$ifdef FPK}
  MultiMark := Byte(Byte(Mark(Item)) <> 0)
{$else}
  MultiMark := Byte(Mark(Item) = True);
{$endif}
End;

procedure TCluster.Press(Item: Integer);
Begin
  Abstract;
End;

procedure TCluster.MovedTo(Item: Integer);
var Old: Integer;
Begin
  If Options and ofSelectable = 0 then Exit;
  While not ButtonState(Item) do Begin
    Inc(Item);
    If Item >= Strings.Count then Item := 0;
  End;
  Old:=Sel;
  Sel:=Item;
  If (Old<>Sel) and Exposed then Begin
    DrawItem (Sel, false);
    DrawItem (Old, false);
  End;
End;

{$ifdef NOIASM}
procedure TCluster.SetButtonState(AMask: Longint; Enable: Boolean);
begin
  if Enable
  then EnableMask := EnableMask or AMask
  else EnableMask := EnableMask and not AMask;
  if Strings.Count <= 32
  then begin
    if (Strings.Count > 0)
      and (EnableMask and ((LongInt(1) shl Strings.Count) - 1) <> 0)
    then Options := Options or ofSelectable
    else Options := Options and not ofSelectable;
  end
end;
{$else}
procedure TCluster.SetButtonState(AMask: Longint; Enable: Boolean);
Begin
asm
	LES     DI,Self
	MOV     AX,AMask.Word[0]
	MOV     DX,AMask.Word[2]
	TEST    Enable,0FFH
	JNZ     @@1
	NOT     AX
	NOT     DX
	AND     ES:[DI].TCluster.EnableMask.Word[0],AX
	AND     ES:[DI].TCluster.EnableMask.Word[2],DX
	JMP     @@2
@@1:    OR      ES:[DI].TCluster.EnableMask.Word[0],AX
	OR      ES:[DI].TCluster.EnableMask.Word[2],DX
@@2:    MOV     CX,ES:[DI].Strings.TCollection.Count
	CMP     CX,32
	JA      @@6
	MOV     BX,ES:[DI].TCluster.Options
	AND     BX,not ofSelectable
	MOV     AX,ES:[DI].TCluster.EnableMask.Word[0]
	MOV     DX,ES:[DI].TCluster.EnableMask.Word[2]
@@3:    SHR     DX,1
	RCR     AX,1
	JC      @@4
	LOOP    @@3
	JMP     @@5
@@4:    OR      BX,ofSelectable
@@5:    MOV     ES:[DI].TCluster.Options,BX
@@6:
end;
{ Ergnzungen fr GV }
  MovedTo(Sel);
End;
{$endif}

procedure TCluster.SetData(var Rec);
Begin
  Value := Word(Rec);
  DrawView;
End;

procedure TCluster.SetState(AState: Word; Enable: Boolean);
Begin
  TGView.SetState (AState,Enable);
  If (AState and sfSelected<>0) and not GOwner^.GetState (sfDragging) then
    DrawView;
End;

procedure TCluster.Store(var S: TStream);
Begin
  TGView.Store (S);
  S.Write (Value, SizeOf (Value));
  S.Write (Sel, SizeOf (Sel));
  S.Write(EnableMask, SizeOf(EnableMask));
  Strings.Store (S);
End;

{*************************** TRadioButtons object *************************}

function TRadioButtons.GetIconNum(Id: Byte): Integer;
Begin
  Case Id Of
   1: GetIconNum:=2;
   2: GetIconNum:=3;
   3: GetIconNum:=19;
   4: GetIconNum:=20;
  End;
End;

function TRadioButtons.Mark(Item: Integer): Boolean;
Begin
  Mark:=Value=Item;
End;

procedure TRadioButtons.MovedTo(Item: Integer);
Begin
  Value:=Item;
  TCluster.MovedTo(Item);
End;

procedure TRadioButtons.Press(Item: Integer);
Var OldV: Word;
Begin
  OldV:=Value;
  Value:=Item;
  If OldV<>Value then DrawItem(OldV, false);
  DrawItem(Value, false);
End;

procedure TRadioButtons.SetData(var Rec);
Begin
  TCluster.SetData (Rec);
  Sel := Integer(Value)
End;

{**************************** TCheckBoxes object **************************}

function TCheckBoxes.GetIconNum(Id: Byte): Integer;
Begin
  Case Id Of
   1: GetIconNum:=0;
   2: GetIconNum:=1;
   3: GetIconNum:=17;
   4: GetIconNum:=18;
  End;
End;

function TCheckBoxes.Mark(Item: Integer): Boolean;
Begin
  Mark:=Value and (1 shl Item) <>0;
End;

procedure TCheckBoxes.Press(Item: Integer);
Begin
  Value := Value xor (1 shl Item);
  DrawItem (Item, false);
End;

{************************** TMultiCheckboxes object ***********************}

constructor TMultiCheckBoxes.Init(var Bounds: TRect; AStrings: PSItem;
  ASelRange: Byte; AFlags: Word; AStates: Pointer);
Begin
  TCluster.Init(Bounds, AStrings);
  SelRange := ASelRange;
  Flags := AFlags;
  States := AStates;
  MyData := false;
End;

constructor TMultiCheckBoxes.Load(var S: TStream);
var L: Word;
Begin
  TCluster.Load(S);
  S.Read(SelRange, SizeOf(Byte));
  S.Read(Flags, SizeOf(Word));
  S.Read(L, SizeOf(L));
  GetMem(States, L);
  S.Read(States^, L);
  MyData := true;
End;

destructor TMultiCheckBoxes.Done;
var L, I: Word;
    Icon: Pointer;
Begin
  If MyData then Begin
    L := 0;
    For I := 0 to SelRange - 1 do Begin
      Icon := GetIcon(I);
      Inc(L, Word(Icon^)+1);
      KillIcon(Icon);
    End;
    FreeMem(States, L * 2);
  End;
  TCluster.Done;
End;

function TMultiCheckBoxes.DataSize: Sw_Word;
Begin DataSize := SizeOf(Value) End;

procedure TMultiCheckBoxes.DrawItem(Item: Integer; Down: Boolean);
var Help, ItemRect: TRect;
    Col1, Col2: Byte;
    Icon: Pointer;
Begin
  SetViewPort;
  HideMouse;
  GetItemRect (Item, ItemRect);
  If ButtonState(Item) then Col1 := GetColor(6)
                       else Col1 := GetColor(7);
  SetFillStyle (SolidFill, Col1);
  With ItemRect do Bar (A.X, A.Y, B.X-1, B.Y-1);
  If (Item=Sel) and GetState (sfSelected) then Begin
    Col1:=GetColor (2); Col2:=GetColor (4);
  End
  Else If ButtonState(Item) then Begin
         Col1:=GetColor (1); Col2:=GetColor (3);
       End
       Else Begin
         Col1 := GetColor(8); Col2 := Col1;
       End;
  Help:=ItemRect;
  Inc (Help.A.Y, (Help.B.Y-Help.A.Y) div 2-6);
  If Down then DrawColIcon (Help.A.X, Help.A.Y, GetIconNum (2), Col1)
          else DrawColIcon (Help.A.X, Help.A.Y, GetIconNum (1), Col1);

  Icon := GetIcon(MultiMark(Item));
  PutIconAnd(Help.A.X + DrawOrigin.X, Help.A.Y + DrawOrigin.Y, $0F, Icon);
  If Col1 <> 0 then
  PutIconOr(Help.A.X + DrawOrigin.X, Help.A.Y + DrawOrigin.Y, Col1, Icon);
  Inc (ItemRect.A.X, 18);
  Dec (ItemRect.B.Y, ItemRect.A.Y); Dec (ItemRect.B.X, ItemRect.A.X);
  SetTextParams(GetStandardFont, 0, Col1 + Col2 shl 8, true);
  SetTextJustify(LeftText, CenterText);
  OutTextXY(ItemRect.A.X, ItemRect.A.Y + ItemRect.B.Y div 2 + 1,
            PString(Strings.At(Item))^);
  ShowMouse;
  RestoreViewPort;
End;

procedure TMultiCheckBoxes.GetData(var Rec);
Begin LongInt(Rec) := Value End;

function TMultiCheckBoxes.GetIcon(Index: Integer): pointer;
var P: Pointer;
    I: Integer;
Begin
  GetIcon := nil;
  If (Index > SelRange) or (States = nil) then Exit;
  P := States;
  For I := 1 to Index do
    P := PChar(P) + (Word(P^) + 1)*2;
  GetIcon := P;
End;

function TMultiCheckBoxes.GetIconNum(Id: Byte): Integer;
Begin
  Case Id Of
   1: GetIconNum:=0;
   2: GetIconNum:=17;
  End;
End;

function TMultiCheckBoxes.MultiMark(Item: Integer): Byte;
Begin
  MultiMark := (Value shr (Word(Item) * WordRec(Flags).Hi))
    and WordRec(Flags).Lo;
End;

procedure TMultiCheckBoxes.Press(Item: Integer);
var
  CurState: ShortInt;
Begin
  CurState := (Value shr (Word(Item) * WordRec(Flags).Hi))
    and WordRec(Flags).Lo;

  Dec(CurState);
  if (CurState >= SelRange) or (CurState < 0) then
    CurState := SelRange - 1;
  Value := (Value and not (LongInt(WordRec(Flags).Lo)
    shl (Word(Item) * WordRec(Flags).Hi))) or
    (LongInt(CurState) shl (Word(Item) * WordRec(Flags).Hi));

  DrawItem(Item, false);
End;

procedure TMultiCheckBoxes.SetData(var Rec);
Begin
  Value := LongInt(Rec);
  DrawView
End;

procedure TMultiCheckBoxes.Store(var S: TStream);
var I: Integer;
    L: Word;
Begin
  TCluster.Store(S);
  S.Write(SelRange, SizeOf(Byte));
  S.Write(Flags, SizeOf(Word));
  L := 0;
  For I := 0 to SelRange - 1 do Inc(L, (Word(GetIcon(I)^) + 1) * 2);
  S.Write(L, SizeOf(L));
  S.Write(States^, L);
End;

{**************************** TListBox object *****************************}

constructor TListBox.Init(var Bounds: TRect; AScrollBar: PScrollBar);
Begin
  TListViewer.Init (Bounds,AScrollBar);
  List:=nil;
  Range:=0;
  NewFocus := 0;
End;

constructor TListBox.Load(var S: TStream);
Begin
  TListViewer.Load (S);
  List:=PCollection (S.Get);
  S.Read(NewFocus, SizeOf(NewFocus));
End;

function TListBox.DataSize: Sw_Word;
Begin
  DataSize:=SizeOf (TListBoxRec);
End;

procedure TListBox.GetData(var Rec);
Begin
  TListBoxRec (Rec).List:=List;
  TListBoxRec (Rec).Index:=Focused;
End;

function TListBox.GetText(Item: Integer; MaxLen: Integer): string;
var S: String;
Begin
  If Item < List^.Count then Begin
    S:=PString (List^.At (Item))^;
    If Length (S)>MaxLen then S:=Copy (S,1,MaxLen);
  End
  Else S:='';
  GetText:=S;
End;

procedure TListBox.NewList(AList: PCollection);
var Top: Integer;
Begin
  If List<>nil then Dispose (List,Done);
  If AList<>nil then Begin
    List:=AList;
    Range:=List^.Count;
    Top:=TopItem;                              { ein Aufruf von SetRange ist }
    FocusItem (NewFocus);                      { hier nicht mglich - siehe NewFocus}
    If (NewFocus<>0) or (Top<2) then DrawView;
    If ScrollBar<>nil then ScrollBar^.SetRange (0,Range-1);
  End
  Else List:=nil;
End;

procedure TListBox.SetData(var Rec);
Begin
  NewList (TListBoxRec (Rec).List);
  FocusItem (TListBoxRec (Rec).Index);
End;

procedure TListBox.Store(var S: TStream);
Begin
  TListViewer.Store (S);
{$ifdef FPK}
  S.Put(PObject(List));
{$else}
  S.Put (List);
{$endif}
  S.Write(NewFocus, SizeOf(NewFocus));
End;

{*************************** TStaticText object **************************}

Constructor TStaticText.Init(var Bounds:TRect; AText:String);
Begin
  TGView.Init (Bounds);
  EventMask:=0;
  Text:=NewStr (AText);
End;

constructor TStaticText.Load(var S: TStream);
Begin
  TGView.Load (S);
  Text:=S.ReadStr;
End;

Destructor TStaticText.Done;
Begin
  DisposeStr (Text);
  TGView.Done;
End;

procedure TStaticText.Draw;
var S, H: String;
    P, L, I, J: Integer;
    R: TRect;
    Center: Boolean;

Begin
  SetFillStyle(SolidFill, GetColor(1));
  Bar(0, 0, Size.X - 1, Size.Y - 1);
  SetTextParams (GetStandardFont, 0, GetColor(2), false);
  GetText (S);
  L:=Length (S);
  R.Assign (0,0, Size.X, TextHeight (S));
  Center:=False;
  P:=1;
  While R.A.Y < Size.Y do Begin
    If P <= L then Begin
      H:='';
      If S[P] = #3 then Begin
        Center := True;
        Inc (P);
      End;
      I := P;
      Repeat
        J := P;
        While (P <= L) and (S[P] = ' ') do Inc (P);
        While (P <= L) and (S[P] <> ' ') and (S[P] <> #13) do Inc (P);
        H:=H+Copy (S, J, P-J);
      Until (P > L) or (TextWidth (H) >= Size.X) or (S[P] = #13);
      If TextWidth (H) >= Size.X then Begin
        If J > I then Begin
          Delete (H, J-I+1, Length (H)-J+I);
          P := J;
        End
        Else Begin
          Repeat Dec (H[0]) Until TextWidth (H) < Size.X;
          P := I + Length (H);
        End;
      End;

      If Center then Begin
        SetTextJustify(CenterText, CenterText);
        OutTextXY(R.A.X + R.B.X div 2, R.A.Y + R.B.Y div 2 + 1, H);
      End
      Else Begin
        SetTextJustify(LeftText, CenterText);
        OutTextXY(R.A.X, R.A.Y + R.B.Y div 2 + 1, H);
      End;

      While (P <= L) and (S[P] = ' ') do Inc (P);
      If (P <= L) and (S[P] = #13) then Begin
        Center := False;
        Inc (P);
        If (P <= L) and (S[P] = #10) then Inc (P);
      End;
    End;
    Inc (R.A.Y, TextHeight (H)+2);

  End;
End;

Function TStaticText.GetPalette: PPalette;
Const
  P:String [Length (CStaticText)]=CStaticText;
Begin
  GetPalette:=@P;
End;

procedure TStaticText.GetText(var S: String);
Begin
  If Text <> nil then S := Text^
                 else S := '';
End;

procedure TStaticText.Store(var S: TStream);
Begin
  TGView.Store (S);
  S.WriteStr (Text);
End;

function StaticTextHeight(S: string; Width: Integer): Integer;
var H: String;
    P, L, I, J: Integer;
    R: TRect;
Begin
  L := Length(S);
  R.Assign(0, 0, Width, TextHeight(S));
  P := 1;
  While P <= L do Begin
    H:='';
    If S[P] = #3 then Inc (P);
    I := P;
    Repeat
      J := P;
      While (P <= L) and (S[P] = ' ') do Inc (P);
      While (P <= L) and (S[P] <> ' ') and (S[P] <> #13) do Inc (P);
      H:=H+Copy (S, J, P-J);
    Until (P > L) or (TextWidth (H) >= Width) or (S[P] = #13);
    If TextWidth (H) >= Width then Begin
      If J > I then Begin
	Delete (H, J-I+1, Length (H)-J+I);
	P := J;
      End
      Else Begin
	Repeat Dec (H[0]) Until TextWidth (H) < Width;
	P := I + Length (H);
      End;
    End;

    While (P <= L) and (S[P] = ' ') do Inc (P);
    If (P <= L) and (S[P] = #13) then Begin
      Inc (P);
      If (P <= L) and (S[P] = #10) then Inc (P);
    End;

    Inc (R.A.Y, TextHeight (H)+2);
  End;
  StaticTextHeight := R.A.Y
End;

{*************************** TParamtext object ****************************}

constructor TParamText.Init(var Bounds: TRect; AText: String; AParamCount: Integer);
Begin
  TStaticText.Init(Bounds, AText);
  ParamCount := AParamCount;
End;

constructor TParamText.Load(var S: TStream);
Begin
  TStaticText.Load(S);
  S.Read(ParamCount, SizeOf(ParamCount));
End;

function TParamText.DataSize: Sw_Word;
Begin
  DataSize := ParamCount * SizeOf(Longint);
End;

procedure TParamText.GetText(var S: String);
Begin
  If Text <> nil then FormatStr(S, Text^, ParamList^)
                 else S := '';
End;

procedure TParamText.SetData(var Rec);
Begin
  ParamList := @Rec;
  DrawView;
End;

procedure TParamText.Store(var S: TStream);
Begin
  TStaticText.Store(S);
  S.Write(ParamCount, SizeOf(Paramcount));
End;

{*************************** TStaticSign object ***************************}

Constructor TStaticSign.Init(var Bounds:TRect; ASign:Pointer);
Begin
  TGView.Init (Bounds);
  EventMask:=0;
  Sign := CopyImage(ASign)
End;

constructor TStaticSign.Load(var S: TStream);
Begin
  TGView.Load (S);
  Sign := LoadImage(S)
End;

destructor TStaticSign.Done;
Begin
  FreeImage(Sign);
  TGView.Done
End;

Procedure TStaticSign.Draw;
Var
  R:TRect;
Begin
  GetExtent (R);
  SetFillStyle(SolidFill, GetColor(1));
  Bar(0, 0, Size.X - 1, Size.Y - 1);
  PutGVImage (R, Sign, GetColor (2));
End;

function TStaticSign.GetPalette: PPalette;
const
  P: String [Length (CStaticSign)] = CStaticSign;
Begin
  GetPalette:=@P;
End;

procedure TStaticSign.Store(var S: TStream);
Begin
  TGView.Store (S);
  StoreImage(S, Sign)
End;

{****************************** TLabel object *****************************}

constructor TLabel.Init(var Bounds: TRect; AText: String; ALink: PGView);
Begin
  TStaticText.Init (Bounds,AText);
  Link:=ALink;
  Options:=Options or (ofPreProcess+ofPostProcess);
  EventMask:=evBroadCast + evKeyDown + evMouse;
  Light:=false;
End;

constructor TLabel.Load(var S: TStream);
Begin
  TStaticText.Load (S);
  GetPeerViewPtr (S,Link);
End;

procedure TLabel.Draw;
var
  S, H: String;
  P, L, I, J: Integer;
  R: TRect;
  Center: Boolean;
  Col1, Col2: Byte;
Begin
  If Light then Begin
    SetFillStyle (SolidFill,GetColor (6));
    Col1:=GetColor (2); Col2:=GetColor (4);
  End
  Else Begin
    SetFillStyle (SolidFill,GetColor (5));
    Col1:=GetColor (1); Col2:=GetColor (3);
  End;
  Bar (0, 0, Size.X-1, Size.Y-1);
  SetTextParams(GetStandardFont,0, Col1 + Col2 shl 8, true);
  GetText (S);
  L:=Length (S); P := TextHeight(S);
  R.Assign (1,0, Size.X - 1, P);
  If R.B.Y + P > Size.Y then R.B.Y := Size.Y;
  Center:=False;
  P:=1;
  While R.A.Y < Size.Y do Begin
    If P <= L then Begin
      H:='';
      If S[P] = #3 then Begin
        Center := True;
        Inc (P);
      End;
      I := P;
      Repeat
        J := P;
        While (P <= L) and (S[P] = ' ') do Inc (P);
        While (P <= L) and (S[P] <> ' ') and (S[P] <> #13) do Inc (P);
        H:=H+Copy (S, J, P-J);
      Until (P > L) or (TextWidth (H) >= Size.X) or (S[P] = #13);
      If TextWidth (H) >= Size.X then Begin
        If J > I then Begin
          Delete (H, J-I+1, Length (H)-J+I);
          P := J;
        End
        Else Begin
          Repeat Dec (H[0]) Until TextWidth (H) < Size.X;
          P := I + Length (H);
        End;
      End;

      If Center then Begin
        SetTextJustify(CenterText, CenterText);
        OutTextXY(R.A.X + R.B.X div 2, R.A.Y + R.B.Y div 2 + 1, H);
      End
      Else Begin
        SetTextJustify(LeftText, CenterText);
        OutTextXY(R.A.X, R.A.Y + R.B.Y div 2 + 1, H);
      End;

      While (P <= L) and (S[P] = ' ') do Inc (P);
      If (P <= L) and (S[P] = #13) then Begin
        Center := False;
        Inc (P);
        If (P <= L) and (S[P] = #10) then Inc (P);
      End;
    End;
    Inc (R.A.Y, TextHeight (H)+2);

  End;
End;

Function TLabel.GetPalette: PPalette;
Const
  P:String [Length (CLabel)]=CLabel;
Begin
  GetPalette:=@P
End;

procedure TLabel.HandleEvent(var Event: TEvent);

  procedure FocusLink;
  begin
    if (Link <> nil) and (Link^.Options and ofSelectable <> 0) then
      Link^.Focus;
    ClearEvent(Event);
  end;

Begin
  inherited HandleEvent (Event);
  If Event.What = evMouseDown then FocusLink else
  if (Event.What = evKeyBoard) and (Text <> nil) then
    If (Ord(GetAltChar (Event.KeyCode)) = Ord(GetShortCut (Text^))) and not Light
    then FocusLink;
  If (Event.What=evBroadCast) and (Event.InfoPtr=Link) then
    If (Event.Command = cmReceivedFocus) and not Light then Begin
      Light:=True;
      DrawView
    End
    Else If (Event.Command = cmReleasedFocus) and Light then Begin
           Light:=False;
           DrawView
         End;
End;

procedure TLabel.Store(var S: TStream);
Begin
  TStaticText.Store (S);
  PutPeerViewPtr (S,Link);
End;

{***************************** TIcon object *******************************}

constructor TIcon.Init(var Bounds: TRect; ASign: Pointer; ALink: PGView);
Begin
  TStaticSign.Init (Bounds,ASign);
  Link:=ALink;
  Options:=Options or (ofPreProcess+ofPostProcess);
  EventMask:=evBroadCast + evMouse;
  Light:=false;
End;

constructor TIcon.Load(var S: TStream);
Begin
  TStaticSign.Load (S);
  GetPeerViewPtr (S, Link);
End;

procedure TIcon.Draw;
var R: TRect;
    Col: Byte;
Begin
  GetExtent (R);
  SetFillStyle(SolidFill, GetColor(1));
  Bar(0, 0, Size.X - 1, Size.Y - 1);
  If Light then Col:=GetColor (2)
           else Col:=GetColor (1);
  PutGVImage (R, Sign, Col);
End;

Function TIcon.GetPalette: PPalette;
Const
  P:String [Length (CIcon)]=CIcon;
Begin
  GetPalette:=@P
End;

procedure TIcon.HandleEvent(var Event: TEvent);

  procedure FocusLink;
  begin
    if (Link <> nil) and (Link^.Options and ofSelectable <> 0) then
      Link^.Focus;
    ClearEvent(Event);
  end;

Begin
  inherited HandleEvent (Event);
  If Event.What = evMouseDown then FocusLink;
  If (Event.What=evBroadCast) and (Event.InfoPtr=Link) then
    If (Event.Command = cmReceivedFocus) and not Light then Begin
      Light:=True;
      DrawView
    End
    Else If (Event.Command = cmReleasedFocus) and Light then Begin
           Light:=False;
           DrawView
         End;
End;

procedure TIcon.Store(var S: TStream);
Begin
  TStaticSign.Store (S);
  PutPeerViewPtr (S, Link);
End;

{***************************** SItem routines *****************************}

function NewSItem(Str: String; ANext: PSItem): PSItem;
var SItem: PSItem;
Begin
  New (SItem);
  SItem^.Value:=NewStr (Str);
  SItem^.Next:=ANext;
  NewSItem:=SItem;
End;

procedure FreeSItem(ASItem: PSItem);
var SItem, Help: PSItem;
Begin
  SItem:=ASItem;
  While SItem<>nil do Begin
    DisposeStr (SItem^.Value);
    Help:=SItem^.Next;
    Dispose (SItem);
    SItem:=Help;
  End;
End;

{************************** THistoryViewer object ************************}

constructor THistoryViewer.Init(var Bounds: TRect; AScrollBar: PScrollBar;
  AHistoryId: Word);
Begin
  TListViewer.Init(Bounds, AScrollBar);
  HistoryId := AHistoryId;
  SetRange(HistoryCount(AHistoryId));
  If Range > 1 then FocusItem(1);
End;

function THistoryViewer.GetText(Item: Integer; MaxLen: Integer): string;
var S: String;
Begin
  S := HistoryStr(HistoryId, Item);
  If Length (S)>MaxLen then S:=Copy (S,1,MaxLen);
  GetText := S;
End;

procedure THistoryViewer.HandleEvent(var Event: TEvent);
Begin
  If ((Event.What = evMouseDown) and (Event.Double)) or
     ((Event.What = evKeyDown) and (Event.KeyCode = kbEnter)) then
  Begin
    GOwner^.EndModal(cmOk);
    ClearEvent(Event);
  End
  Else If ((Event.What = evKeyDown) and (Event.KeyCode = kbEsc)) or
          ((Event.What = evCommand) and (Event.Command = cmCancel)) then
       Begin
         GOwner^.EndModal(cmCancel);
         ClearEvent(Event);
       End
       Else TListViewer.HandleEvent(Event);
End;

function THistoryViewer.HistoryWidth: Integer;
var
  Width, T, Count, I: Integer;
Begin
  Width := 0;
  Count := HistoryCount(HistoryId);
  SetTextParams (ftSansSerif, 0, 0, true);
  For I := 0 to Count-1 do Begin
    T := TextWidth(HistoryStr(HistoryId, I));
    if T > Width then Width := T;
  End;
  HistoryWidth := Width;
End;

{************************** THistoryWindow object ************************}

constructor THistoryWindow.Init(var Bounds: TRect; HistoryId: Word);
Begin
  TWindow.Init(Bounds, '', wnNoNumber);
  Flags := wfClose;
  InitViewer(HistoryId);
End;

function THistoryWindow.GetSelection: String;
Begin
  GetSelection := Viewer^.GetText(Viewer^.Focused,255);
End;

procedure THistoryWindow.HandleEvent(var Event: TEvent);
begin
  If (Event.What = evMouseDown) and not MouseInView(Event.Where)
  then begin
    EndModal(cmCancel);
    ClearEvent(Event)
  end
  else
    inherited HandleEvent(Event)
end;

procedure THistoryWindow.InitViewer(HistoryId: Word);
var
  R: TRect;
  S: PScrollBar;
Begin
  GetClientRect(R);
  R.Grow(0,1); Inc(R.B.X);
  R.A.X := R.B.X - 18;
  {  R.Assign(Size.X - 24, 25, Size.X - 6, Size.Y - 6); }
  S := New(PScrollBar, Init(R));
  S^.Flags := S^.Flags or sbHandleKeyBoard;
  S^.Options := S^.Options or ofPostProcess;
  Insert(S);
  GetClientRect(R);
  Dec(R.B.X, 17);
  R.Grow(1,1);
  {  R.Assign(6, 25, Size.X - 23, Size.Y - 6); }
  Viewer := New(PHistoryViewer, Init(R, S, HistoryId));
  Viewer^.GrowMode := gfGrowHiX + gfGrowHiY;
  Insert(Viewer);
End;

{***************************** THistory object ***************************}

constructor THistory.Init(var Bounds: TRect; ALink: PInputLine; AHistoryId: Word);
Begin
  TGView.Init(Bounds);
  Options := Options or ofPostProcess;
  EventMask := EventMask or (evBroadcast + evMouse + evKeyBoard);
  Link := ALink;
  HistoryId := AHistoryId;

  Down := false;
End;

constructor THistory.Load(var S: TStream);
Begin
  TGView.Load(S);
  GetPeerViewPtr(S, Link);
  S.Read(HistoryId, SizeOf(HistoryId));

  Down := false;
End;

procedure THistory.Draw;
var R: TRect;
Begin
  GetExtent(R);
  DrawButton(R, Down, true, White, GetColor (3), GetColor (1), GetColor (2));
  DrawColIcon(R.A.X, R.A.Y, 15, 0);
End;

function THistory.GetPalette: PPalette;
const P: String[Length(CHistory)] = CHistory;
Begin
  GetPalette := @P;
End;

procedure THistory.HandleEvent(var Event: TEvent);
var
  HistoryWindow: PHistoryWindow;
  R,P: TRect;
  C: Word;
  Rslt: String;
  Flag: Boolean;
  G: PGGroup;
Begin
  Flag := false;
  TGView.HandleEvent(Event);
  If (Event.What = evMouseDown) and MouseInView(Event.Where) then Begin
    Repeat
      If (not Down and MouseInView(Event.Where)) or
         (Down and not MouseInView(Event.Where)) then Begin
        Down := not Down;
        DrawView;
      End;
    Until not MouseEvent(Event, evMouseAuto);
    Down := false;
    DrawView;
    Flag := true;
  End;
  If ((Event.What = evKeyDown) and (CtrlToArrow(Event.KeyCode) = kbDown) and
     (Link^.State and sfFocused <> 0)) or Flag then Begin
    If not Flag then Begin
      Down := true;
      DrawView;
      Delay(50);
      Down := false;
      DrawView;
    End
    Else Flag := false;
    If not Link^.Focus then Begin
      ClearEvent(Event);
      Exit;
    End;
    RecordHistory(Link^.Data^);
    Link^.GetBounds(R);
    Dec(R.A.X, 3); Inc(R.B.X, 20); Inc(R.B.Y,90); Dec(R.A.Y, 3);
    GOwner^.GetExtent(P);
    R.Intersect(P);
    Dec(R.B.Y,10);
    R.B.Y := R.A.Y + (R.B.Y-R.A.Y-6) div 15 * 15 + 8;
    With GOwner^ do Begin
      MakeGlobal(R.A, R.A); MakeGlobal(R.B, R.B);
    End;
    HistoryWindow := InitHistoryWindow(R);
    If HistoryWindow <> nil then Begin
      Link^.HideCursor;
      G := GOwner;
      While G^.GOwner <> nil do G := G^.GOwner;
      C := G^.ExecView(HistoryWindow);
      If C = cmOk then Begin
        Rslt := HistoryWindow^.GetSelection;
	If Length(Rslt) > Link^.MaxLen then Rslt[0] := Chr(Link^.MaxLen);
        Link^.Data^ := Rslt;
	Link^.SelectAll(True);
	Link^.DrawView;
      End;
      Dispose(HistoryWindow, Done);
      Link^.ShowCursor;
    End;
    ClearEvent(Event);
  End
  Else If (Event.What = evBroadcast) then
         If ((Event.Command = cmReleasedFocus) and (Event.InfoPtr = Link))
            or (Event.Command = cmRecordHistory) then
           RecordHistory(Link^.Data^);
End;

function THistory.InitHistoryWindow(var Bounds: TRect): PHistoryWindow;
var
  P: PHistoryWindow;
Begin
  P := New(PHistoryWindow, Init(Bounds, HistoryId));
  P^.HelpCtx := Link^.HelpCtx;
  InitHistoryWindow := P;
End;

procedure THistory.RecordHistory(S: String);
Begin
  HistoryAdd(HistoryId, S);
End;

procedure THistory.Store(var S: TStream);
Begin
  TGView.Store(S);
  PutPeerViewPtr(S, Link);
  S.Write(HistoryId, SizeOf(HistoryId));
End;


{********************** GVDialog registration procedure *******************}

procedure RegisterGVDialog;
Begin
  RegisterType (RDialog);
  RegisterType (RInputLine);
  RegisterType (RNumInput);
  RegisterType (RArrowField);
  RegisterType (RButton);
  RegisterType (RGButton);
{$ifndef FPK}
  RegisterType (RRegler);
{$endif}
  RegisterType (RCluster);
  RegisterType (RRadioButtons);
  RegisterType (RCheckBoxes);
  RegisterType (RMultiCheckBoxes);
  RegisterType (RListBox);
  RegisterType (RStaticText);
  RegisterType (RParamText);
  RegisterType (RStaticSign);
  RegisterType (RLabel);
  RegisterType (RIcon);
  RegisterType (RHistory);
End;

End.
