
{*******************************************************}
{                                                       }
{       Graphics Vision Unit                            }
{                                                       }
{	Portions copyright (c) 1992 Borland Intl.       }
{       Copyright (c) 1994 Stefan Milius                }
{	Copyright (c) 1997 Matthias Koeppe              }
{                                                       }
{*******************************************************}

Unit GVGadget;

{$ifndef FPK}
{$A+,B-,D+,F+,G+,O+,R-,S-,X+,I-}
{$endif FPK}

{ Diese Unit bietet zwei ntzliche Hilfsmittel: Uhr und Freier-Heap-Anzeiger.
}

Interface

{$ifdef FPK}
uses Dos, Drivers, Objects, Views, BGI, ExtGraph, GvFPK, GVViews, GVApp;
{$else}
{$ifdef Windows}
uses WinDos, Dos, Drivers, Objects, Views, GVViews, GVApp;
{$else}
Uses Dos, Drivers, Objects, Views, GVViews, GVApp;
{$endif Windows}
{$endif FPK}

Type

{ THeapView object }

  { Palette layout }
  { 1 = Background }
  { 2 = Text }

  PHeapView = ^THeapView;
  THeapView = object(TGView)
    OldMem : LongInt;
    constructor Init(var Bounds: TRect);
    procedure Draw; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure Update;
  end;

{ TClockView object }

  { Palette layout }
  { 1 = Background }
  { 2 = Text }

  PClockView = ^TClockView;
  TClockView = object(TGView)
    Refresh: Byte;
    LastTime: DateTime;
    TimeStr: String[10];
    constructor Init(var Bounds: TRect);
    procedure Draw; virtual;
    function FormatTimeStr(H, M, S: Word): String; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure Update; virtual;
  end;


implementation

{$ifndef FPK}
{$ifdef Windows}
uses ExtGraph, WinGr;
{$else}
Uses MetaGr, ExtGraph, GVDriver, MyFonts;
{$endif Windows}
{$endif}

(******************************* THeapView object ***************************)

constructor THeapView.Init(var Bounds: TRect);
Begin
  TGView.Init(Bounds);
  EventMask := EventMask or evBroadcast;
  GrowMode := gfGrowLoX + gfGrowHiX;
  OldMem := 0;
End;

procedure THeapView.Draw;
var
  S: String;
Begin
  Str(OldMem, S);
  SetFillStyle (SolidFill, GetColor (8));
  Bar (0, 0, Size.X-1, Size.Y-1);
  SetTextParams(ftSystem, 0, GetColor(2), false);
  SetTextJustify(CenterText, CenterText);
  OutTextXY(Size.X div 2, Size.Y div 2, S);
  SetColor (Black);
  Rectangle (0, 0, Size.X-1, Size.Y-1);
End;

procedure THeapView.HandleEvent(var Event: TEvent);
begin
  inherited HandleEvent(Event);
  if (Event.What = evBroadcast) and (Event.Command = cmIdle)
    then Update;
end;

procedure THeapView.Update;
Begin
  If (OldMem <> MemAvail) then begin
    OldMem := MemAvail;
    DrawView
  end
End;

(******************************* TClockView object **************************)

function LeadingZero(w: Word): String;
var s: String;
begin
  {$ifdef FPK}
  Str(w, s);
  {$else}
  Str(w:0, s);
  {$endif}
  LeadingZero := Copy('00', 1, 2 - Length(s)) + s;
end;

constructor TClockView.Init(var Bounds: TRect);
Begin
  TGView.Init(Bounds);
  EventMask := EventMask or evBroadcast;
  GrowMode := gfGrowLoX + gfGrowHiX;
  FillChar(LastTime, SizeOf(LastTime), #$FF);
  TimeStr := '';
  Refresh := 1;
End;

procedure TClockView.Draw;
Begin
  SetFillStyle (SolidFill, GetColor (8));
  Bar (0, 0, Size.X-1, Size.Y-1);
  SetTextParams(ftSystem, 0, GetColor(2), false);
  SetTextJustify(CenterText, CenterText);
  OutTextXY(Size.X div 2, Size.Y div 2, TimeStr);
  SetColor (Black);
  RectAngle (0,0,Size.X-1,Size.Y-1);
End;

procedure TClockView.HandleEvent(var Event: TEvent);
begin
  inherited HandleEvent(Event);
  if (Event.What = evBroadcast) and (Event.Command = cmIdle)
    then Update;
end;

procedure TClockView.Update;
var h,m,s,hund: word;
Begin
  GetTime(h,m,s,hund);
  If Abs(s - LastTime.sec) >= Refresh then
  Begin
    With LastTime do
    Begin
      Hour := h;
      Min := m;
      Sec := s;
    End;
    TimeStr := FormatTimeStr(h, m, s);
    DrawView;
  End;
End;

function TClockView.FormatTimeStr(H, M, S: Word): String;
Begin
  FormatTimeStr := LeadingZero(h)+ ':'+ LeadingZero(m) +
    ':' + LeadingZero(s);
End;

END.
