; VgaMem, copying routines assembler source, Copr. 1994 Matthias Kppe

		INCLUDE	vmemdef.asm

		EXTRN	SelOfs: FAR, PageAddr: FAR, SaveRegs: FAR, \
			RestoreRegs: FAR

CODE		SEGMENT BYTE PUBLIC

	MakeCallProc GetBPL
	;MakeCallProc SaveScreen
	;MakeCallProc RestoreScreen

		PUBLIC	GetSize, CopyScreen

GetSize		PROC FAR
		pop	WORD PTR Temp[0]
		pop	WORD PTR Temp[2]
		call	VgaMemProcs._GetSize		; get long size

		mov	cl, Granularity			; translate into
		mov	bx, ax				; gran units
		shr	ax, cl
		sub	cl, 16
		neg	cl
		shl	dx, cl
		or	ax, dx
		shl	bx, cl
		jz	SHORT @@0
		inc	ax
@@0:		jmp	Temp
GetSize		ENDP

CopyScreen	PROC FAR
		ARG	y3: WORD, x3: WORD, \
			y2: WORD, x2: WORD, \
			y1: WORD, x1: WORD = ArgSize
		LOCAL	Mask1: BYTE: 1, Mask2: BYTE: 1, Shift: BYTE: 1, \
			Method: BYTE: 1,  WriteMap: BYTE: 1, ReadMap: BYTE: 1, \
			Off: WORD, BPL: WORD = LocalSize
		enter	LocalSize, 0

	; Metafile header

		TEST	MetaState, ms_Record
		JZ	SHORT @@NR
		PUSH	10			; Locals
		PUSH	12			; Params
		PUSH	0
		MOV	AX, 3			; pushed
		CALL	[ExtSave]
@@NR:		TEST	MetaState, ms_Draw
		JZ	@@ND

	; Clipping on stack params

		CALL	SaveRegs
		MOV	AX, x3
		MOV	BX, ClipRect.A.x
		SUB	AX, BX
		JGE	SHORT @@40
		MOV	x3, BX
		SUB	x1, AX
@@40:		MOV	AX, x2
		MOV	BX, ClipRect.B.x
		SUB	BX, x3
		ADD	BX, x1
		SUB	AX, BX
		JLE	SHORT @@41
		MOV	x2, BX

@@41:		MOV	AX, y3
		MOV	BX, ClipRect.A.y
		SUB	AX, BX
		JGE	SHORT @@42
		MOV	y3, BX
		SUB	y1, AX
@@42:		MOV	AX, y2
		MOV	BX, ClipRect.B.y
		SUB	BX, y3
		ADD	BX, y1
		SUB	AX, BX
		JLE	SHORT @@43
		MOV	y2, BX
@@43:   	MOV	AX, x1
		CMP	AX, x2
		JGE	SHORT @@44
		MOV	AX, y1
		CMP	AX, y2
		JL	SHORT @@45
@@44:		JMP	@@46

	;
	; test driver capabilities
	;

@@45:
		mov	ax, RealCaps
@@1:
		test	ax, vmcCopy
		jnz	@@2			; direct copy

		test	ax, vmcImage
		jz	@@ND			; cannot emulate

	;
	; emulate copy by imaging
	;

	; Prepare coords

		dec	x2
		dec	y2
		mov	ax, DrawOrigin.x
		mov	dx, DrawOrigin.y
		sub	x1, ax
		sub	x2, ax
		sub	x3, ax
		sub	y1, dx
		sub	y2, dx
		sub	y3, dx
		mov	ax, y1
		cmp	ax, y3
		mov	Off, +1
		jge	SHORT @@4

	; Vertically backwards

		xchg	ax, y2
		mov	y1, ax
		mov	Off, -1
		sub	ax, y2
		add	y3, ax

	; Get image
@@4:
		push	x1 y1 x2 y1 TempMem
		call	VgaMemProcs._GetImage

	; Put image

		push	x3 y3 TempMem 0 cs
		call	VgaMemProcs._PutImage

	; Forward

		mov	ax, y1
		cmp	ax, y2
		jz	SHORT @@5

		mov	ax, Off
		add	y3, ax
		add	y1, ax
		jmp	@@4
@@5:
		jmp	@@ND

	;
	; do direct copy
	;

@@2:
		MOV	BX, BytesPerLine
		MOV	BPL, BX
		PUSH	Page0Seg
		PUSH	0
		CALL	SelOfs
		MOV	ES, DX
		MOV	Off, AX

		CALL	VgaMemProcs._CS_Addr

		CLD				; vorwrts zhlen
		MOV	DX, y2
		SUB	DX, y1			; Vertikale Anzahl
		XCHG	DX, CX
		MOV	AX, y1
		CMP	AX, y3
		JAE	SHORT @@3
		MOV	AX, CX			; ** vert. rckwrts **
		PUSH	DX
		MUL	BPL
		POP	DX
		SUB	AX, BPL
		ADD	DI, AX
		ADD	SI, AX
		NEG	BPL
@@3:    	mov	ax, SourcePage		; different screen pages
		cmp	ax, DestPage
		mov	al, 0
		jnz	@@10

		MOV	AX, y1
		CMP	AX, y3
		MOV	AL, 0
		JNE	@@10
		MOV	AX, x1
		CMP	AX, x3
		MOV	AL, 0
		JG	@@10
		JE	@@46			; identische Koordinaten
		STD				; horiz. rckwrts
		ADD	SI, DX
		ADD	DI, DX
		DEC	SI
		DEC	DI
		ROR	WORD PTR Mask2, 8
		MOV	AL, 1			; horiz. rckwrts
@@10:		OR	Method, AL

		; silly but still needed for a while

		ADD	SI, Off
		ADD	DI, Off
		MOV	AX, Page1Seg
		SUB	AX, Page0Seg
		SHL	AX, 4
		CMP	SourcePage, 1
		jnz	@@50
		ADD	SI, AX
@@50:		CMP	DestPage, 1
		jnz	@@51
		ADD	DI, AX
@@51:		mov	ax, ActiveSeg
		sub	ax, Page0Seg
		shl	ax, 4
		cmp	SourcePage, 2
		jb	@@52
		add	si, ax
@@52:		cmp	DestPage, 2
		jb	@@53
		add	di, ax
@@53:		CALL	VgaMemProcs._CS_Copy
		CLD
@@46:		CALL	RestoreRegs
@@ND:		leave
		retf	ArgSize
CopyScreen	ENDP

CODE		ENDS

		END
