{*******************************************************}
{ Free Vision Runtime Library                           }
{ App Unit                                              }
{ Version: 0.1.0                                        }
{ Release Date: July 23, 1998                           }
{                                                       }
{       Copyright (c) 1992 Borland International        }
{                                                       }
{*******************************************************}
{                                                       }
{ This unit is a port of Borland International's        }
{ Dialogs.pas unit.  It is for distribution with the    }
{ Free Pascal (FPK) Compiler as part of the 32-bit      }
{ Free Vision library.  The unit is still fully         }
{ functional under BP7 by using the tp compiler         }
{ directive when rebuilding the library.                }
{                                                       }
{*******************************************************}
{ To Do List:                                           }
{   - test all FPK routines                             }
{                                                       }
{*******************************************************}

unit Dialogs;

{$i platform.inc}

{$ifdef PPC_FPC}
  {$H-}
{$else}
  {$F+,O+,E+,N+}
{$endif}
{$X+,R-,I-,Q-,V-}
{$ifndef OS_LINUX}
  {$S-}
{$endif}

interface

uses
  Objects, ObjTypes, Drivers, Views, Validate;

const

{ Color palettes }

  CGrayDialog    = #32#33#34#35#36#37#38#39#40#41#42#43#44#45#46#47 +
                   #48#49#50#51#52#53#54#55#56#57#58#59#60#61#62#63;
  CBlueDialog    = #64#65#66#67#68#69#70#71#72#73#74#75#76#77#78#79 +
                   #80#81#82#83#84#85#86#87#88#89#90#91#92#92#94#95;
  CCyanDialog    = #96#97#98#99#100#101#102#103#104#105#106#107#108 +
                   #109#110#111#112#113#114#115#116#117#118#119#120 +
                   #121#122#123#124#125#126#127;

  CDialog        = CGrayDialog;

  CStaticText    = #6;
  CLabel         = #7#8#9#9;
  CButton        = #10#11#12#13#14#14#14#15;
  CCluster       = #16#17#18#18#31;
  CInputLine     = #19#19#20#21#6;
  CHistory       = #22#23;
  CHistoryWindow = #19#19#21#24#25#19#20;
  CHistoryViewer = #6#6#7#6#6;

{ TDialog palette entires }

  dpBlueDialog = 0;
  dpCyanDialog = 1;
  dpGrayDialog = 2;

{ TButton flags }

  bfNormal    = $00;
  bfDefault   = $01;
  bfLeftJust  = $02;
  bfBroadcast = $04;
  bfGrabFocus = $08;

{ TMultiCheckboxes flags }
{ hibyte = number of bits }
{ lobyte = bit mask }

  cfOneBit       = $0101;
  cfTwoBits      = $0203;
  cfFourBits     = $040F;
  cfEightBits    = $08FF;

  ClpBrdSize: Word = 255;
    { ClpbrdSize is the maximum number of bytes which can be copied to the
      #ClpBrd#.  The default ClpBrdSize is for the maximum number of bytes
      which can be entered in an inputline.

      If the Clipboard variable in the Editors unit is used, the ClpBrd is
      changed to the buffer instantiated in the Editors unit so that one
      common clipboard exists. }

type

{ TButton object }

  { Palette layout }
  { 1 = Normal text }
  { 2 = Default text }
  { 3 = Selected text }
  { 4 = Disabled text }
  { 5 = Normal shortcut }
  { 6 = Default shortcut }
  { 7 = Selected shortcut }
  { 8 = Shadow }

  PButton = ^TButton;
  TButton = object(TView)
    Title: PString;
    Command: Word;
    Flags: Byte;
    AmDefault: Boolean;
    constructor Init(var Bounds: TRect; ATitle: TTitleStr; ACommand: Word; AFlags: Word);
    constructor Load(var S: TStream);
    destructor Done; virtual;
    procedure Draw; virtual;
    procedure DrawState(Down: Boolean);
    function GetPalette: PPalette; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure MakeDefault(Enable: Boolean);
    procedure Press; virtual;
    procedure SetState(AState: Word; Enable: Boolean); virtual;
    procedure Store(var S: TStream);
  end;

{ TStaticText }

  { Palette layout }
  { 1 = Text }

  PStaticText = ^TStaticText;
  TStaticText = object(TView)
    Text: PString;
    constructor Init(var Bounds: TRect; const AText: String);
    constructor Load(var S: TStream);
    destructor Done; virtual;
    procedure Draw; virtual;
    function GetPalette: PPalette; virtual;
    procedure GetText(var S: String); virtual;
    procedure Store(var S: TStream);
  end;

{ TLabel }

  { Palette layout }
  { 1 = Normal text }
  { 2 = Selected text }
  { 3 = Normal shortcut }
  { 4 = Selected shortcut }

  PLabel = ^TLabel;
  TLabel = object(TStaticText)
    Link: PView;
    Light: Boolean;
    constructor Init(var Bounds: TRect; const AText: String; ALink: PView);
    constructor Load(var S: TStream);
    procedure Draw; virtual;
    function GetPalette: PPalette; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure Store(var S: TStream);
  end;

{ TInputLine object }

  { Palette layout }
  { 1 = Passive }
  { 2 = Active }
  { 3 = Selected }
  { 4 = Arrows }

  PInputLine = ^TInputLine;
  TInputLine = object(TView)
    Data: PString;
    MaxLen: Sw_Integer;
    CurPos: Sw_Integer;
    FirstPos: Sw_Integer;
    SelStart: Sw_Integer;
    SelEnd: Sw_Integer;
    Validator: PValidator;
    constructor Init(var Bounds: TRect; AMaxLen: Sw_Integer);
    constructor Load(var S: TStream);
    destructor Done; virtual;
    function CanScroll(Delta: Sw_Integer): Boolean; virtual;
    function DataSize: Sw_Word; virtual;
    procedure Draw; virtual;
    procedure GetData(var Rec); virtual;
    function GetPalette: PPalette; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure SelectAll(Enable: Boolean);
    procedure SetData(var Rec); virtual;
    procedure SetState(AState: Word; Enable: Boolean); virtual;
    procedure SetValidator(AValid: PValidator);
    procedure Store(var S: TStream);
    function Valid(Command: Word): Boolean; virtual;
  end;

{ TDialog object }

  { Palette layout }
  {  1 = Frame passive }
  {  2 = Frame active }
  {  3 = Frame icon }
  {  4 = ScrollBar page area }
  {  5 = ScrollBar controls }
  {  6 = StaticText }
  {  7 = Label normal }
  {  8 = Label selected }
  {  9 = Label shortcut }
  { 10 = Button normal }
  { 11 = Button default }
  { 12 = Button selected }
  { 13 = Button disabled }
  { 14 = Button shortcut }
  { 15 = Button shadow }
  { 16 = Cluster normal }
  { 17 = Cluster selected }
  { 18 = Cluster shortcut }
  { 19 = InputLine normal text }
  { 20 = InputLine selected text }
  { 21 = InputLine arrows }
  { 22 = History arrow }
  { 23 = History sides }
  { 24 = HistoryWindow scrollbar page area }
  { 25 = HistoryWindow scrollbar controls }
  { 26 = ListViewer normal }
  { 27 = ListViewer focused }
  { 28 = ListViewer selected }
  { 29 = ListViewer divider }
  { 30 = InfoPane }
  { 31 = Cluster disabled }
  { 32 = Reserved }

  PDialog = ^TDialog;
  TDialog = object(TWindow)
    constructor Init(var Bounds: TRect; ATitle: TTitleStr);
    constructor Load(var S: TStream);
    procedure Cancel (ACommand : Word); virtual;
      { If the dialog is a modal dialog, Cancel calls EndModal(ACommand).  If
        the dialog is non-modal Cancel calls Close.

        Cancel may be overridden to provide special processing prior to
        destructing the dialog. }
    procedure ChangeTitle (ANewTitle : TTitleStr); virtual;
      { ChangeTitle disposes of the current title, assigns ANewTitle to Title,
        then redraws the dialog. }
    procedure FreeSubView (ASubView : PView); virtual;
      { FreeSubView deletes and disposes ASubView from the dialog. }
      {#X FreeAllSubViews IsSubView }
    procedure FreeAllSubViews; virtual;
      { Deletes then disposes all subviews in the dialog. }
      {#X FreeSubView IsSubView }
    function GetPalette: PPalette; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    function IsSubView (AView : PView) : Boolean; virtual;
      { IsSubView returns True if AView is non-nil and is a subview of the
        dialog. }
      {#X FreeSubView FreeAllSubViews }
    function NewButton (X, Y, W, H : Sw_Integer; ATitle : TTitleStr;
                        ACommand, AHelpCtx : Word;
                        AFlags : Byte) : PButton;
      { Creates and inserts into the dialog a new TButton with the
        help context AHelpCtx.

        A pointer to the new button is returned for checking validity of the
        initialization. }
      {#X NewInputLine NewLabel }
    function NewLabel (X, Y : Sw_Integer; AText : String;
                       ALink : PView) : PLabel;
      { NewLabel creates and inserts into the dialog a new TLabel and
        associates it with ALink. }
      {#X NewButton NewInputLine }
    function NewInputLine (X, Y, W, AMaxLen : Sw_Integer; AHelpCtx : Word
                           ; AValidator : PValidator) : PInputLine;
      { NewInputLine creates and inserts into the dialog a new TBSDInputLine
        with the help context to AHelpCtx and the validator AValidator.

        A pointer to the inputline is returned for checking validity of the
        initialization. }
      {#X NewButton NewLabel }
    function Valid(Command: Word): Boolean; virtual;
  end;

{ TSItem }

  PSItem = ^TSItem;
  TSItem = record
    Value: PString;
    Next: PSItem;
  end;

{ TCluster }

  { Palette layout }
  { 1 = Normal text }
  { 2 = Selected text }
  { 3 = Normal shortcut }
  { 4 = Selected shortcut }
  { 5 = Disabled text }

  PCluster = ^TCluster;
  TCluster = object(TView)
    Value: LongInt;
    Sel: Sw_Integer;
    EnableMask: LongInt;
    Strings: TStringCollection;
    constructor Init(var Bounds: TRect; AStrings: PSItem);
    constructor Load(var S: TStream);
    destructor Done; virtual;
    function ButtonState(Item: Sw_Integer): Boolean;
    function DataSize: Sw_Word; virtual;
    procedure DrawBox(const Icon: String; Marker: Char);
    procedure DrawMultiBox(const Icon, Marker: String);
    procedure GetData(var Rec); virtual;
    function GetHelpCtx: Word; virtual;
    function GetPalette: PPalette; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    function Mark(Item: Sw_Integer): Boolean; virtual;
    function MultiMark(Item: Sw_Integer): Byte; virtual;
    procedure Press(Item: Sw_Integer); virtual;
    procedure MovedTo(Item: Sw_Integer); virtual;
    procedure SetButtonState(AMask: Longint; Enable: Boolean);
    procedure SetData(var Rec); virtual;
    procedure SetState(AState: Word; Enable: Boolean); virtual;
    procedure Store(var S: TStream);
  private
    function Column(Item: Sw_Integer): Sw_Integer;
    function FindSel(P: TPoint): Sw_Integer;
    function Row(Item: Sw_Integer): Sw_Integer;
  end;

{ TRadioButtons }

  { Palette layout }
  { 1 = Normal text }
  { 2 = Selected text }
  { 3 = Normal shortcut }
  { 4 = Selected shortcut }

  PRadioButtons = ^TRadioButtons;
  TRadioButtons = object(TCluster)
    procedure Draw; virtual;
    function Mark(Item: Sw_Integer): Boolean; virtual;
    procedure MovedTo(Item: Sw_Integer); virtual;
    procedure Press(Item: Sw_Integer); virtual;
    procedure SetData(var Rec); virtual;
  end;

{ TCheckBoxes }

  { Palette layout }
  { 1 = Normal text }
  { 2 = Selected text }
  { 3 = Normal shortcut }
  { 4 = Selected shortcut }

  PCheckBoxes = ^TCheckBoxes;
  TCheckBoxes = object(TCluster)
    procedure Draw; virtual;
    function Mark(Item: Sw_Integer): Boolean; virtual;
    procedure Press(Item: Sw_Integer); virtual;
  end;

{ TMultiCheckBoxes }

  { Palette layout }
  { 1 = Normal text }
  { 2 = Selected text }
  { 3 = Normal shortcut }
  { 4 = Selected shortcut }

  PMultiCheckBoxes = ^TMultiCheckBoxes;
  TMultiCheckBoxes = object(TCluster)
    SelRange: Byte;
    Flags: Word;
    States: PString;
    constructor Init(var Bounds: TRect; AStrings: PSItem;
      ASelRange: Byte; AFlags: Word; const AStates: String);
    constructor Load(var S: TStream);
    destructor Done; virtual;
    function DataSize: Sw_Word; virtual;
    procedure Draw; virtual;
    procedure GetData(var Rec); virtual;
    function MultiMark(Item: Sw_Integer): Byte; virtual;
    procedure Press(Item: Sw_Integer); virtual;
    procedure SetData(var Rec); virtual;
    procedure Store(var S: TStream);
  end;

{ TListBox }

  { Palette layout }
  { 1 = Active }
  { 2 = Inactive }
  { 3 = Focused }
  { 4 = Selected }
  { 5 = Divider }

  PListBox = ^TListBox;
  TListBox = object(TListViewer)
    List: PCollection;
    constructor Init(var Bounds: TRect; ANumCols: Sw_Word;
      AScrollBar: PScrollBar);
    constructor Load(var S: TStream);
    function DataSize: Sw_Word; virtual;
    procedure DeleteFocusedItem; virtual;
      { DeleteFocusedItem deletes the focused item and redraws the view. }
      {#X FreeFocusedItem }
    procedure DeleteItem (Item : Sw_Integer); virtual;
      { DeleteItem deletes Item from the associated collection. }
      {#X FreeItem }
    procedure FreeAll; virtual;
      { FreeAll deletes and disposes of all items in the associated
        collection. }
      { FreeFocusedItem FreeItem }
    procedure FreeFocusedItem; virtual;
      { FreeFocusedItem deletes and disposes of the focused item then redraws
        the listbox. }
      {#X FreeAll FreeItem }
    procedure FreeItem (Item : Sw_Integer); virtual;
      { FreeItem deletes Item from the associated collection and disposes of
        it, then redraws the listbox. }
      {#X FreeFocusedItem FreeAll }
    function GetFocusedItem : Pointer; virtual;
      { GetFocusedItem is a more readable method of returning the focused
        item from the listbox.  It is however slightly slower than: }
{#M+}
{
Item := ListBox^.List^.At(ListBox^.Focused); }
{#M-}
    procedure GetData(var Rec); virtual;
    function GetText(Item,MaxLen: Sw_Integer): String; virtual;
    procedure Insert (Item : Pointer); virtual;
      { Insert inserts Item into the collection, adjusts the listbox's range,
        then redraws the listbox. }
      {#X FreeItem }
    procedure NewList(AList: PCollection); virtual;
    procedure SetData(var Rec); virtual;
    procedure SetFocusedItem (Item : Pointer); virtual;
      { SetFocusedItem changes the focused item to Item then redraws the
        listbox. }
      {# FocusItemNum }
    procedure Store(var S: TStream);
  end;  { of TListBox }

  TListBoxRec = record
    List : PCollection;
    Selection : Sw_Integer;
  end;  { of TListBoxRec }



{ TParamText }

  { Palette layout }
  { 1 = Text }

  PParamText = ^TParamText;
  TParamText = object(TStaticText)
    ParamCount: Sw_Integer;
    ParamList: Pointer;
    constructor Init(var Bounds: TRect; const AText: String;AParamCount: Sw_Integer);
    constructor Load(var S: TStream);
    function DataSize: Sw_Word; virtual;
    procedure GetText(var S: String); virtual;
    procedure SetData(var Rec); virtual;
    procedure Store(var S: TStream);
  end;

{ THistoryViewer }

  { Palette layout }
  { 1 = Active }
  { 2 = Inactive }
  { 3 = Focused }
  { 4 = Selected }
  { 5 = Divider }

  PHistoryViewer = ^THistoryViewer;
  THistoryViewer = object(TListViewer)
    HistoryId: Sw_Word;
    constructor Init(var Bounds: TRect; AHScrollBar, AVScrollBar: PScrollBar;
      AHistoryId: Sw_Word);
    function GetPalette: PPalette; virtual;
    function GetText(Item,MaxLen: Sw_Integer): String; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    function HistoryWidth: Sw_Integer;
  end;

{ THistoryWindow }

  { Palette layout }
  { 1 = Frame passive }
  { 2 = Frame active }
  { 3 = Frame icon }
  { 4 = ScrollBar page area }
  { 5 = ScrollBar controls }
  { 6 = HistoryViewer normal text }
  { 7 = HistoryViewer selected text }

  PHistoryWindow = ^THistoryWindow;
  THistoryWindow = object(TWindow)
    Viewer: PListViewer;
    constructor Init(var Bounds: TRect; HistoryId: Sw_Word);
    function GetPalette: PPalette; virtual;
    function GetSelection: String; virtual;
    procedure InitViewer(HistoryId: Sw_Word); virtual;
  end;

{ THistory }

  { Palette layout }
  { 1 = Arrow }
  { 2 = Sides }

  PHistory = ^THistory;
  THistory = object(TView)
    Link: PInputLine;
    HistoryId: Sw_Word;
    constructor Init(var Bounds: TRect; ALink: PInputLine; AHistoryId: Sw_Word);
    constructor Load(var S: TStream);
    procedure Draw; virtual;
    function GetPalette: PPalette; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    function InitHistoryWindow(var Bounds: TRect): PHistoryWindow; virtual;
    procedure RecordHistory(const S: String); virtual;
    procedure Store(var S: TStream);
  end;


  {#Z+}
  PBrowseInputLine = ^TBrowseInputLine;
  TBrowseInputLine = Object(TInputLine)
    History: Sw_Word;
    constructor Init(var Bounds: TRect; AMaxLen: Sw_Integer; AHistory: Sw_Word);
    constructor Load(var S: TStream);
    function DataSize: Sw_Word; virtual;
    procedure GetData(var Rec); virtual;
    procedure SetData(var Rec); virtual;
    procedure Store(var S: TStream);
  end;  { of TBrowseInputLine }

  TBrowseInputLineRec = record
    Text: string;
    History: Sw_Word;
  end;  { of TBrowseInputLineRec }
  {#Z+}
  PBrowseButton = ^TBrowseButton;
  {#Z-}
  TBrowseButton = Object(TButton)
    Link: PBrowseInputLine;
    constructor Init(var Bounds: TRect; ATitle: TTitleStr; ACommand: Word;
      AFlags: Byte; ALink: PBrowseInputLine);
    constructor Load(var S: TStream);
    procedure Press; virtual;
    procedure Store(var S: TStream);
  end;  { of TBrowseButton }


  {#Z+}
  PCommandIcon = ^TCommandIcon;
  {#Z-}
  TCommandIcon = Object(TStaticText)
    { A TCommandIcon sends an evCommand message to its owner with
      Event.Command set to #Command# when it is clicked with a mouse. }
    constructor Init (var Bounds : TRect; AText : String; ACommand : Word);
      { Creates an instance of a TCommandIcon and sets #Command# to
        ACommand.  AText is the text which is displayed as the icon.  If an
        error occurs Init fails. }
    procedure HandleEvent (var Event : TEvent); virtual;
      { Captures mouse events within its borders and sends an evCommand to
        its owner in response to the mouse event. }
      {#X Command }
      private
    Command : Word;
      { Command is the command sent to the command icon's owner when it is
        clicked. }
  end;  { of TCommandIcon }


  {#Z+}
  PCommandSItem = ^TCommandSItem;
  {#Z-}
  TCommandSItem = record
    { A TCommandSItem is the data structure used to initialize command
      clusters with #NewCommandSItem# rather than the standarad #NewSItem#.
      It is used to associate a command with an individual cluster item. }
    {#X TCommandCheckBoxes TCommandRadioButtons }
    Value : String;
      { Value is the text displayed for the cluster item. }
      {#X Command Next }
    Command : Word;
      { Command is the command broadcast when the cluster item is pressed. }
      {#X Value Next }
    Next : PCommandSItem;
      { Next is a pointer to the next item in the cluster. }
      {#X Value Command }
  end;  { of TCommandSItem }


  TCommandArray = array[0..15] of Word;
    { TCommandArray holds a list of commands which are associated with a
      cluster. }
    {#X TCommandCheckBoxes TCommandRadioButtons }


  {#Z+}
  PCommandCheckBoxes = ^TCommandCheckBoxes;
  {#Z-}
  TCommandCheckBoxes = Object(TCheckBoxes)
    { TCommandCheckBoxes function as normal TCheckBoxes, except that when a
      cluster item is pressed it broadcasts a command associated with the
      cluster item to the cluster's owner.

      TCommandCheckBoxes are useful when other parts of a dialog should be
      enabled or disabled in response to a check box's status. }
    CommandList : TCommandArray;
      { CommandList is the list of commands associated with each check box
        item. }
      {#X Init Load Store }
    constructor Init (var Bounds : TRect; ACommandStrings : PCommandSItem);
      { Init calls the inherited constructor, then sets up the #CommandList#
        with the specified commands.  If an error occurs Init fails. }
      {#X NewCommandSItem }
    constructor Load (var S : TStream);
      { Load calls the inherited constructor, then loads the #CommandList#
        from the stream S.  If an error occurs Load fails. }
      {#X Store Init }
    procedure Press (Item : Sw_Integer); virtual;
      { Press calls the inherited Press then broadcasts the command
        associated with the cluster item that was pressed to the check boxes'
        owner. }
      {#X CommandList }
    procedure Store (var S : TStream); virtual;
      { Store calls the inherited Store method then writes the #CommandList#
        to the stream. }
      {#X Load }
  end;  { of TCommandCheckBoxes }


  {#Z+}
  PCommandRadioButtons = ^TCommandRadioButtons;
  {#Z-}
  TCommandRadioButtons = Object(TRadioButtons)
    { TCommandRadioButtons function as normal TRadioButtons, except that when
      a cluster item is pressed it broadcasts a command associated with the
      cluster item to the cluster's owner.

      TCommandRadioButtons are useful when other parts of a dialog should be
      enabled or disabled in response to a radiobutton's status. }
    CommandList : TCommandArray;  { commands for each possible value }
      { The list of commands associated with each radio button item. }
      {#X Init Load Store }
    constructor Init (var Bounds : TRect; ACommandStrings : PCommandSItem);
      { Init calls the inherited constructor and sets up the #CommandList#
        with the specified commands.  If an error occurs Init disposes of the
        command strings then fails. }
      {#X NewCommandSItem }
    constructor Load (var S : TStream);
      { Load calls the inherited constructor then loads the #CommandList#
        from the stream S.  If an error occurs Load fails. }
      {#X Store }
    procedure MovedTo (Item : Sw_Integer); virtual;
      { MovedTo calls the inherited MoveTo, then broadcasts the command of
        the newly selected cluster item to the cluster's owner. }
      {#X Press CommandList }
    procedure Press (Item : Sw_Integer); virtual;
      { Press calls the inherited Press then broadcasts the command
        associated with the cluster item that was pressed to the check boxes
        owner. }
      {#X CommandList MovedTo }
    procedure Store (var S : TStream); virtual;
      { Store calls the inherited Store method then writes the #CommandList#
        to the stream. }
      {#X Load }
  end;  { of TCommandRadioButtons }


function NewCommandSItem (Str : String; ACommand : Word;
                          ANext : PCommandSItem) : PCommandSItem;
  { NewCommandSItem allocates and returns a pointer to a new #TCommandSItem#
   record.  The Value and Next fields of the record are set to NewStr(Str)
   and ANext, respectively.  The NewSItem function and the TSItem record type
   allow easy construction of singly-linked lists of command strings. }

function NewSItem(const Str: String; ANext: PSItem): PSItem;

procedure RegisterDialogs;
  { Dialogs registration procedure }

var
  ClpBrd: PChar;
    { ClpBrd is used internally by the Dialogs and Editors units for cut and
      paste operations in inputlines.  It should never be accessed by an
      application.  It is declared globally so that the Editors unit can
      reassign ClpBrd to the buffer in Editors.ClipBoard.  This results in
      one clipboard used for both inputlines, editors, and memos. }


{#Z+}
  { Stream Registration Records }
const
  RDialog: TStreamRec = (
     ObjType: idDialog;
     VmtLink: Ofs(TypeOf(TDialog)^);
     Load:    @TDialog.Load;
     Store:   @TDialog.Store
  );

  RInputLine: TStreamRec = (
     ObjType: idInputLine;
     VmtLink: Ofs(TypeOf(TInputLine)^);
     Load:    @TInputLine.Load;
     Store:   @TInputLine.Store
  );

  RButton: TStreamRec = (
     ObjType: idButton;
     VmtLink: Ofs(TypeOf(TButton)^);
     Load:    @TButton.Load;
     Store:   @TButton.Store
  );

  RCluster: TStreamRec = (
     ObjType: idCluster;
     VmtLink: Ofs(TypeOf(TCluster)^);
     Load:    @TCluster.Load;
     Store:   @TCluster.Store
  );

  RRadioButtons: TStreamRec = (
     ObjType: idRadioButtons;
     VmtLink: Ofs(TypeOf(TRadioButtons)^);
     Load:    @TRadioButtons.Load;
     Store:   @TRadioButtons.Store
  );

  RCheckBoxes: TStreamRec = (
     ObjType: idCheckBoxes;
     VmtLink: Ofs(TypeOf(TCheckBoxes)^);
     Load:    @TCheckBoxes.Load;
     Store:   @TCheckBoxes.Store
  );

  RMultiCheckBoxes: TStreamRec = (
     ObjType: idMultiCheckBoxes;
     VmtLink: Ofs(TypeOf(TMultiCheckBoxes)^);
     Load:    @TMultiCheckBoxes.Load;
     Store:   @TMultiCheckBoxes.Store
  );

  RListBox: TStreamRec = (
     ObjType: idListBox;
     VmtLink: Ofs(TypeOf(TListBox)^);
     Load:    @TListBox.Load;
     Store:   @TListBox.Store
  );

  RStaticText: TStreamRec = (
     ObjType: idStaticText;
     VmtLink: Ofs(TypeOf(TStaticText)^);
     Load:    @TStaticText.Load;
     Store:   @TStaticText.Store
  );

  RLabel: TStreamRec = (
     ObjType: idLabel;
     VmtLink: Ofs(TypeOf(TLabel)^);
     Load:    @TLabel.Load;
     Store:   @TLabel.Store
  );

  RHistory: TStreamRec = (
     ObjType: idHistory;
     VmtLink: Ofs(TypeOf(THistory)^);
     Load:    @THistory.Load;
     Store:   @THistory.Store
  );

  RParamText: TStreamRec = (
     ObjType: idParamText;
     VmtLink: Ofs(TypeOf(TParamText)^);
     Load:    @TParamText.Load;
     Store:   @TParamText.Store
  );

  RCommandCheckBoxes : TStreamRec = (
    ObjType : idCommandCheckBoxes;
    VmtLink : Ofs(TypeOf(TCommandCheckBoxes)^);
    Load    : @TCommandCheckBoxes.Load;
    Store   : @TCommandCheckBoxes.Store);

  RCommandRadioButtons : TStreamRec = (
    ObjType : idCommandRadioButtons;
    VmtLink : Ofs(TypeOf(TCommandRadioButtons)^);
    Load    : @TCommandRadioButtons.Load;
    Store   : @TCommandRadioButtons.Store);

  RCommandIcon : TStreamRec = (
    ObjType  : idCommandIcon;
    VmtLink  : Ofs(Typeof(TCommandIcon)^);
    Load     : @TCommandIcon.Load;
    Store    : @TCommandIcon.Store);

  RBrowseButton: TStreamRec = (
    ObjType  : idBrowseButton;
    VmtLink  : Ofs(TypeOf(TBrowseButton)^);
    Load     : @TBrowseButton.Load;
    Store    : @TBrowseButton.Store);
{#Z-}


implementation

uses
  Commands, HelpCtx, HistList;



{ Utility functions }

function IsBlank(Ch: Char): Boolean;
begin
  IsBlank := (Ch = ' ') or (Ch = #13) or (Ch = #10);
end;

function NewSItem(const Str: String; ANext: PSItem): PSItem;
var
  Item: PSItem;
begin
  New(Item);
  Item^.Value := NewStr(Str);
  Item^.Next := ANext;
  NewSItem := Item;
end;

function Max(A, B: Sw_Integer): Sw_Integer;
begin
  if A>B then
    Max:=A
  else
    Max:=B;
end;

function HotKey(const S: String): Char;
var
  P: Sw_Word;
begin
 { Buglist 3.1 patch }
  HotKey := #0;
  if S = '' then
    Exit;
  P := Pos('~',S);
  if P <> 0 then
    HotKey := UpCase(S[P+1]);
  {P := Pos('~',S);
  if P <> 0 then HotKey := UpCase(S[P+1])
  else HotKey := #0; }
end;

{****************************************************************************}
{ TBrowseButton Object                                                       }
{****************************************************************************}
{****************************************************************************}
{ TBrowseButton.Init                                                         }
{****************************************************************************}
constructor TBrowseButton.Init(var Bounds: TRect; ATitle: TTitleStr;
  ACommand: Word; AFlags: Byte; ALink: PBrowseInputLine);
begin
  if not inherited Init(Bounds,ATitle,ACommand,AFlags) then
    Fail;
  Link := ALink;
end;

{****************************************************************************}
{ TBrowseButton.Load                                                         }
{****************************************************************************}
constructor TBrowseButton.Load(var S: TStream);
begin
  if not inherited Load(S) then
    Fail;
  GetPeerViewPtr(S,Link);
end;

{****************************************************************************}
{ TBrowseButton.Press                                                        }
{****************************************************************************}
procedure TBrowseButton.Press;
var
  E: TEvent;
begin
  Message(Owner, evBroadcast, cmRecordHistory, nil);
  if Flags and bfBroadcast <> 0 then
    Message(Owner, evBroadcast, Command, Link) else
  begin
    E.What := evCommand;
    E.Command := Command;
    E.InfoPtr := Link;
    PutEvent(E);
  end;
end;

{****************************************************************************}
{ TBrowseButton.Store                                                        }
{****************************************************************************}
procedure TBrowseButton.Store(var S: TStream);
begin
  inherited Store(S);
  PutPeerViewPtr(S,Link);
end;


{****************************************************************************}
{ TBrowseInputLine Object                                                    }
{****************************************************************************}
{****************************************************************************}
{ TBrowseInputLine.Init                                                      }
{****************************************************************************}
constructor TBrowseInputLine.Init(var Bounds: TRect; AMaxLen: Sw_Integer; AHistory: Sw_Word);
begin
  if not inherited Init(Bounds,AMaxLen) then
    Fail;
  History := AHistory;
end;

{****************************************************************************}
{ TBrowseInputLine.Load                                                      }
{****************************************************************************}
constructor TBrowseInputLine.Load(var S: TStream);
begin
  if not inherited Load(S) then
    Fail;
  S.Read(History,SizeOf(History));
  if (S.Status <> stOk) then
    Fail;
end;

{****************************************************************************}
{ TBrowseInputLine.DataSize                                                  }
{****************************************************************************}
function TBrowseInputLine.DataSize: Sw_Word;
begin
  DataSize := SizeOf(TBrowseInputLineRec);
end;

{****************************************************************************}
{ TBrowseInputLine.GetData                                                   }
{****************************************************************************}
procedure TBrowseInputLine.GetData(var Rec);
var
  LocalRec: TBrowseInputLineRec absolute Rec;
begin
  if (Validator = nil) or
    (Validator^.Transfer(Data^,@LocalRec.Text, vtGetData) = 0) then
  begin
    FillChar(LocalRec.Text, DataSize, #0);
    Move(Data^, LocalRec.Text, Length(Data^) + 1);
  end;
  LocalRec.History := History;
end;

{****************************************************************************}
{ TBrowseInputLine.SetData                                                   }
{****************************************************************************}
procedure TBrowseInputLine.SetData(var Rec);
var
  LocalRec: TBrowseInputLineRec absolute Rec;
begin
  if (Validator = nil) or
    (Validator^.Transfer(Data^, @LocalRec.Text, vtSetData) = 0) then
    Move(LocalRec.Text, Data^[0], MaxLen + 1);
  History := LocalRec.History;
  SelectAll(True);
end;

{****************************************************************************}
{ TBrowseInputLine.Store                                                     }
{****************************************************************************}
procedure TBrowseInputLine.Store(var S: TStream);
begin
  inherited Store(S);
  S.Write(History,SizeOf(History));
end;

{****************************************************************************}
{ TButton Object                                                             }
{****************************************************************************}
{****************************************************************************}
{ TButton.Init                                                               }
{****************************************************************************}
constructor TButton.Init(var Bounds: TRect; ATitle: TTitleStr;
  ACommand: Word; AFlags: Word);
begin
  TView.Init(Bounds);
  Options := Options or (ofSelectable + ofFirstClick +
    ofPreProcess + ofPostProcess);
  EventMask := EventMask or evBroadcast;
  if not CommandEnabled(ACommand) then State := State or sfDisabled;
  Flags := AFlags;
  if AFlags and bfDefault <> 0 then AmDefault := True
  else AmDefault := False;
  Title := NewStr(ATitle);
  Command := ACommand;
end;

constructor TButton.Load(var S: TStream);
begin
  TView.Load(S);
  Title := S.ReadStr;
  S.Read(Command, SizeOf(Word) + SizeOf(Byte) + SizeOf(Boolean));
  if not CommandEnabled(Command) then State := State or sfDisabled
  else State := State and not sfDisabled;
end;

destructor TButton.Done;
begin
  DisposeStr(Title);
  TView.Done;
end;

procedure TButton.Draw;
begin
  DrawState(False);
end;

procedure TButton.DrawState(Down: Boolean);
var
  CButton, CShadow: Word;
  Ch: Char;
  I, S, Y, T: Sw_Integer;
  B: TDrawBuffer;

procedure DrawTitle;
var
  L, SCOff: Sw_Integer;
begin
  if Flags and bfLeftJust <> 0 then L := 1 else
  begin
    L := (S - CStrLen(Title^) - 1) div 2;
    if L < 1 then L := 1;
  end;
  MoveCStr(B[I + L], Title^, CButton);
  if ShowMarkers and not Down then
  begin
    if State and sfSelected <> 0 then SCOff := 0 else
      if AmDefault then SCOff := 2 else SCOff := 4;
    WordRec(B[0]).Lo := Byte(SpecialChars[SCOff]);
    WordRec(B[S]).Lo := Byte(SpecialChars[SCOff + 1]);
  end;
end;

begin
  if State and sfDisabled <> 0 then CButton := GetColor($0404) else
  begin
    CButton := GetColor($0501);
    if State and sfActive <> 0 then
      if State and sfSelected <> 0 then CButton := GetColor($0703) else
        if AmDefault then CButton := GetColor($0602);
  end;
  CShadow := GetColor(8);
  S := Size.X - 1;
  T := Size.Y div 2 - 1;
  for Y := 0 to Size.Y - 2 do
  begin
    MoveChar(B, ' ', Byte(CButton), Size.X);
    WordRec(B[0]).Hi := CShadow;
    if Down then
    begin
      WordRec(B[1]).Hi := CShadow;
      Ch := ' ';
      I := 2;
    end else
    begin
      WordRec(B[S]).Hi := Byte(CShadow);
      if ShowMarkers then Ch := ' ' else
      begin
        if Y = 0 then
          WordRec(B[S]).Lo := Byte('') else
          WordRec(B[S]).Lo := Byte('');
        Ch := '';
      end;
      I := 1;
    end;
    if (Y = T) and (Title <> nil) then DrawTitle;
    if ShowMarkers and not Down then
    begin
      WordRec(B[1]).Lo := Byte('[');
      WordRec(B[S - 1]).Lo := Byte(']');
    end;
    WriteLine(0, Y, Size.X, 1, B);
  end;
  MoveChar(B[0], ' ', Byte(CShadow), 2);
  MoveChar(B[2], Ch, Byte(CShadow), S - 1);
  WriteLine(0, Size.Y - 1, Size.X, 1, B);
end;

function TButton.GetPalette: PPalette;
const
  P: String[Length(CButton)] = CButton;
begin
  GetPalette := PPalette(@P);
end;

procedure TButton.HandleEvent(var Event: TEvent);
var
  Down: Boolean;
  C: Char;
  Mouse: TPoint;
  ClickRect: TRect;
begin
  GetExtent(ClickRect);
  Inc(ClickRect.A.X);
  Dec(ClickRect.B.X);
  Dec(ClickRect.B.Y);
  if Event.What = evMouseDown then
  begin
    MakeLocal(Event.Where, Mouse);
    if not ClickRect.Contains(Mouse) then ClearEvent(Event);
  end;
  if Flags and bfGrabFocus <> 0 then
    TView.HandleEvent(Event);
  case Event.What of
    evMouseDown:
      begin
        if State and sfDisabled = 0 then
        begin
          Inc(ClickRect.B.X);
          Down := False;
          repeat
            MakeLocal(Event.Where, Mouse);
            if Down <> ClickRect.Contains(Mouse) then
            begin
              Down := not Down;
              DrawState(Down);
            end;
          until not MouseEvent(Event, evMouseMove);
          if Down then
          begin
            Press;
            DrawState(False);
          end;
        end;
        ClearEvent(Event);
      end;
    evKeyDown:
      begin
        if assigned(Title) then
         begin
           C := HotKey(Title^);
           if (Event.KeyCode = GetAltCode(C)) or
              (Owner^.Phase = phPostProcess) and (C <> #0) and
              (Upcase(Event.CharCode) = C) or
              (State and sfFocused <> 0) and (Event.CharCode = ' ') then
            begin
              Press;
              ClearEvent(Event);
            end;
         end;
      end;
    evBroadcast:
      case Event.Command of
        { tvbugs31 patch }
        { cmDefault:
          if AmDefault then
          begin
            Press;
            ClearEvent(Event);
          end; }
        cmDefault :
          if AmDefault and (State and sfDisabled = 0) then
          begin
            Press;
            ClearEvent(Event);
          end;
        { end patch }
        cmGrabDefault, cmReleaseDefault:
          if Flags and bfDefault <> 0 then
          begin
            AmDefault := Event.Command = cmReleaseDefault;
            DrawView;
          end;
        cmCommandSetChanged:
          begin
            SetState(sfDisabled, not CommandEnabled(Command));
            DrawView;
          end;
      end;
  end;
end;

procedure TButton.MakeDefault(Enable: Boolean);
var
  C: Word;
begin
  if Flags and bfDefault = 0 then
  begin
    if Enable then C := cmGrabDefault else C := cmReleaseDefault;
    Message(Owner, evBroadcast, C, @Self);
    AmDefault := Enable;
    DrawView;
  end;
end;

procedure TButton.Press;
var
  E: TEvent;
begin
  Message(Owner, evBroadcast, cmRecordHistory, nil);
  if Flags and bfBroadcast <> 0 then
    Message(Owner, evBroadcast, Command, @Self) else
  begin
    E.What := evCommand;
    E.Command := Command;
    E.InfoPtr := @Self;
    PutEvent(E);
  end;
end;

procedure TButton.SetState(AState: Word; Enable: Boolean);
begin
  TView.SetState(AState, Enable);
  if AState and (sfSelected + sfActive) <> 0 then DrawView;
  if AState and sfFocused <> 0 then MakeDefault(Enable);
end;

procedure TButton.Store(var S: TStream);
begin
  TView.Store(S);
  S.WriteStr(Title);
  S.Write(Command, SizeOf(Word) + SizeOf(Byte) + SizeOf(Boolean));
end;

{ TCheckBoxes }

procedure TCheckBoxes.Draw;
const
  Button = ' [ ] ';
begin
  DrawMultiBox(Button, ' X');
end;

function TCheckBoxes.Mark(Item: Sw_Integer): Boolean;
begin
  Mark := Value and (1 shl Item) <> 0;
end;

procedure TCheckBoxes.Press(Item: Sw_Integer);
begin
  Value := Value xor (1 shl Item);
end;

{ TCluster }

constructor TCluster.Init(var Bounds: TRect; AStrings: PSItem);
var
  I: Sw_Integer;
  P: PSItem;
begin
  TView.Init(Bounds);
  Options := Options or (ofSelectable + ofFirstClick + ofPreProcess +
    ofPostProcess + ofVersion20);
  I := 0;
  P := AStrings;
  while P <> nil do
  begin
    Inc(I);
    P := P^.Next;
  end;
  Strings.Init(I,0);
  while AStrings <> nil do
  begin
    P := AStrings;
    Strings.AtInsert(Strings.Count, AStrings^.Value);
    AStrings := AStrings^.Next;
    Dispose(P);
  end;
  Value := 0;
  Sel := 0;
  SetCursor(2,0);
  ShowCursor;
  EnableMask := $FFFFFFFF;
end;

constructor TCluster.Load(var S: TStream);
begin
  TView.Load(S);
  if (Options and ofVersion) >= ofVersion20 then
  begin
    S.Read(Value, SizeOf(Longint) * 2 + SizeOf(Sw_Integer));
  end
  else
  begin
    S.Read(Value, SizeOf(Word));
    S.Read(Sel, SizeOf(Sw_Integer));
    EnableMask := $FFFFFFFF;
    Options := Options or ofVersion20;
  end;
  Strings.Load(S);
  SetButtonState(0, True);
end;

destructor TCluster.Done;
begin
  Strings.Done;
  TView.Done;
end;

function TCluster.ButtonState(Item: Sw_Integer): Boolean;
begin
  ButtonState := ((EnableMask and (1 shl Item)) <> 0);
end;

function TCluster.DataSize: Sw_Word;
begin
  DataSize := SizeOf(Sw_Word);
end;

procedure TCluster.DrawBox(const Icon: String; Marker: Char);
begin
  DrawMultiBox(Icon, ' '+Marker);
end;

procedure TCluster.DrawMultiBox(const Icon, Marker: String);
var
  I,J,Cur,Col: Integer;
  CNorm, CSel, CDis, Color: Word;
  B: TDrawBuffer;
begin
  CNorm := GetColor($0301);
  CSel := GetColor($0402);
  CDis := GetColor($0505);
  for I := 0 to Size.Y do
  begin
    MoveChar(B, ' ', Byte(CNorm), Size.X);
    for J := 0 to (Strings.Count - 1) div Size.Y + 1 do
    begin
      Cur := J*Size.Y + I;
      if Cur < Strings.Count then
      begin
        Col := Column(Cur);
        if (Col + CStrLen(PString(Strings.At(Cur))^) + 5 <
          Sizeof(TDrawBuffer) div SizeOf(Word)) and (Col < Size.X) then
        begin
          if not ButtonState(Cur) then
            Color := CDis
          else if (Cur = Sel) and (State and sfFocused <> 0) then
            Color := CSel
          else
            Color := CNorm;
          MoveChar(B[Col], ' ', Byte(Color), Size.X - Col);
          MoveStr(B[Col], Icon, Byte(Color));
          WordRec(B[Col+2]).Lo := Byte(Marker[MultiMark(Cur) + 1]);
          MoveCStr(B[Col+5], PString(Strings.At(Cur))^, Color);
          if ShowMarkers and (State and sfFocused <> 0) and (Cur = Sel) then
          begin
            WordRec(B[Col]).Lo := Byte(SpecialChars[0]);
            WordRec(B[Column(Cur+Size.Y)-1]).Lo := Byte(SpecialChars[1]);
          end;
        end;
      end;
    end;
    WriteBuf(0, I, Size.X, 1, B);
  end;
  SetCursor(Column(Sel)+2,Row(Sel));
end;

procedure TCluster.GetData(var Rec);
begin
  Word(Rec) := Value;
end;

function TCluster.GetHelpCtx: Word;
begin
  if HelpCtx = hcNoContext then GetHelpCtx := hcNoContext
  else GetHelpCtx := HelpCtx + Sel;
end;

function TCluster.GetPalette: PPalette;
const
  P: String[Length(CCluster)] = CCluster;
begin
  GetPalette := PPalette(@P);
end;

procedure TCluster.HandleEvent(var Event: TEvent);
var
  Mouse: TPoint;
  I, S: Integer;
  C: Char;

procedure MoveSel;
begin
  if I <= Strings.Count then
  begin
    Sel := S;
    MovedTo(Sel);
    DrawView;
  end;
end;

begin
  TView.HandleEvent(Event);
  if (Options and ofSelectable) = 0 then Exit;
  if Event.What = evMouseDown then
  begin
    MakeLocal(Event.Where, Mouse);
    I := FindSel(Mouse);
    if I <> -1 then if ButtonState(I) then Sel := I;
    DrawView;
    repeat
      MakeLocal(Event.Where, Mouse);
      if FindSel(Mouse) = Sel then
        ShowCursor else
        HideCursor;
    until not MouseEvent(Event,evMouseMove); {Wait for mouse up}
    ShowCursor;
    MakeLocal(Event.Where, Mouse);
    if (FindSel(Mouse) = Sel) and ButtonState(Sel) then
    begin
      Press(Sel);
      DrawView;
    end;
    ClearEvent(Event);
  end else if Event.What = evKeyDown then
  begin
    S := Sel;
    case CtrlToArrow(Event.KeyCode) of
      kbUp:
        if State and sfFocused <> 0 then
        begin
          I := 0;
          repeat
            Inc(I);
            Dec(S);
            if S < 0 then S := Strings.Count - 1;
          until ButtonState(S) or (I > Strings.Count);
          MoveSel;
          ClearEvent(Event);
        end;
      kbDown:
        if State and sfFocused <> 0 then
        begin
          I := 0;
          repeat
            Inc(I);
            Inc(S);
            if S >= Strings.Count then S := 0;
          until ButtonState(S) or (I > Strings.Count);
          MoveSel;
          ClearEvent(Event);
        end;
      kbRight:
        if State and sfFocused <> 0 then
        begin
          I := 0;
          repeat
            Inc(I);
            Inc(S,Size.Y);
            if S >= Strings.Count then
            begin
              S := (S+1) mod Size.Y;
              if S >= Strings.Count then S := 0;
            end;
          until ButtonState(S) or (I > Strings.Count);
          MoveSel;
          ClearEvent(Event);
        end;
      kbLeft:
        if State and sfFocused <> 0 then
        begin
          I := 0;
          repeat
            Inc(I);
            if S > 0 then
            begin
              Dec(S, Size.Y);
              if S < 0 then
              begin
                S := ((Strings.Count + Size.Y - 1) div Size.Y)*Size.Y + S - 1;
                if S >= Strings.Count then S := Strings.Count-1;
              end;
            end else S := Strings.Count-1;
          until ButtonState(S) or (I > Strings.Count);
          MoveSel;
          ClearEvent(Event);
        end;
    else
      begin
        for I := 0 to Strings.Count-1 do
        begin
          C := HotKey(PString(Strings.At(I))^);
          if (GetAltCode(C) = Event.KeyCode) or
             (((Owner^.Phase = phPostProcess) or (State and sfFocused <> 0))
               and (C <> #0) and (UpCase(Event.CharCode) = C)) then
          begin
            if ButtonState(I) then
            begin
              if Focus then
              begin
                Sel := I;
                MovedTo(Sel);
                Press(Sel);
                DrawView;
              end;
              ClearEvent(Event);
            end;
            Exit;
          end;
        end;
        if (Event.CharCode = ' ') and (State and sfFocused <> 0)
          and ButtonState(Sel)then
        begin
          Press(Sel);
          DrawView;
          ClearEvent(Event);
        end;
      end
    end
  end;
end;

procedure TCluster.SetButtonState(AMask: Longint; Enable: Boolean);
begin
  if Enable then
    EnableMask := EnableMask or AMask
  else
    EnableMask := EnableMask and (not AMask);
  if EnableMask = 0 then
    Options := Options and (not ofSelectable);
end;

procedure TCluster.SetData(var Rec);
begin
  Value := Word(Rec);
  DrawView;
end;

procedure TCluster.SetState(AState: Word; Enable: Boolean);
begin
  TView.SetState(AState, Enable);
  if AState = sfFocused then DrawView;
end;

function TCluster.Mark(Item: Sw_Integer): Boolean;
begin
  Mark := False;
end;

function TCluster.MultiMark(Item: Sw_Integer): Byte;
begin
  MultiMark := Byte(Mark(Item) = True);
end;

procedure TCluster.MovedTo(Item: Sw_Integer);
begin
end;

procedure TCluster.Press(Item: Sw_Integer);
begin
end;

procedure TCluster.Store(var S: TStream);
begin
  TView.Store(S);
  S.Write(Value, SizeOf(Longint) * 2 + SizeOf(Sw_Integer));
  Strings.Store(S);
end;

function TCluster.Column(Item: Sw_Integer): Sw_Integer;
var
  I, Col, Width, L: Sw_Integer;
begin
  if Item < Size.Y then Column := 0
  else
  begin
    Width := 0;
    Col := -6;
    for I := 0 to Item do
    begin
      if I mod Size.Y = 0 then
      begin
        Inc(Col, Width + 6);
        Width := 0;
      end;
      if I < Strings.Count then
        L := CStrLen(PString(Strings.At(I))^);
      if L > Width then Width := L;
    end;
    Column := Col;
  end;
end;

function TCluster.FindSel(P: TPoint): Sw_Integer;
var
  I, S: Sw_Integer;
  R: TRect;
begin
  GetExtent(R);
  if not R.Contains(P) then FindSel := -1
  else
  begin
    I := 0;
    while P.X >= Column(I+Size.Y) do
      Inc(I, Size.Y);
    S := I + P.Y;
    if S >= Strings.Count then
      FindSel := -1 else
      FindSel := S;
  end;
end;

function TCluster.Row(Item: Sw_Integer): Sw_Integer;
begin
  Row := Item mod Size.Y;
end;

{****************************************************************************}
{ TCommandCheckBoxes Object                                                  }
{****************************************************************************}
{****************************************************************************}
{ TCommandCheckBoxes.Init                                                    }
{****************************************************************************}
constructor TCommandCheckBoxes.Init (var Bounds : TRect;
                                     ACommandStrings : PCommandSItem);
var StartSItem, S : PSItem;
    CItems : PCommandSItem;
    i : Sw_Integer;
begin
  if ACommandStrings = nil then
     Fail;
    { set up string list }
  StartSItem := NewSItem(ACommandStrings^.Value,nil);
  S := StartSItem;
  CItems := ACommandStrings^.Next;
  while (CItems <> nil) do begin
    S^.Next := NewSItem(CItems^.Value,nil);
    S := S^.Next;
    CItems := CItems^.Next;
    end;
    { construct check boxes }
  if not TCheckBoxes.Init(Bounds,StartSItem) then begin
    while (StartSItem <> nil) do begin
      S := StartSItem;
      StartSItem := StartSItem^.Next;
      if (S^.Value <> nil) then
         DisposeStr(S^.Value);
      Dispose(S);
      end;
    Fail;
    end;
    { set up CommandList and dispose of memory used by ACommandList }
  i := 0;
  while (ACommandStrings <> nil) do begin
    CommandList[i] := ACommandStrings^.Command;
    CItems := ACommandStrings;
    ACommandStrings := ACommandStrings^.Next;
    Dispose(CItems);
    Inc(i);
    end;
end;

{****************************************************************************}
{ TCommandCheckBoxes.Load                                                    }
{****************************************************************************}
constructor TCommandCheckBoxes.Load (var S : TStream);
begin
  if not TCheckBoxes.Load(S) then
     Fail;
  S.Read(CommandList,SizeOf(CommandList));
  if (S.Status <> stOk) then begin
     TCheckBoxes.Done;
     Fail;
     end;
end;

{****************************************************************************}
{ TCommandCheckBoxes.Press                                                   }
{****************************************************************************}
procedure TCommandCheckBoxes.Press (Item : Sw_Integer);
var Temp : Sw_Integer;
begin
  Temp := Value;
  TCheckBoxes.Press(Item);
  if (Value <> Temp) then  { value changed - notify peers }
     Message(Owner,evCommand,CommandList[Item],@Value);
end;

{****************************************************************************}
{ TCommandCheckBoxes.Store                                                   }
{****************************************************************************}
procedure TCommandCheckBoxes.Store (var S : TStream);
begin
  TCheckBoxes.Store(S);
  S.Write(CommandList,SizeOf(CommandList));
end;

{****************************************************************************}
{ TCommandIcon Object                                                        }
{****************************************************************************}
{****************************************************************************}
{ TCommandIcon.Init                                                          }
{****************************************************************************}
constructor TCommandIcon.Init (var Bounds : TRect; AText : String;
                               ACommand : Word);
begin
  if not TStaticText.Init(Bounds,AText) then
     Fail;
  Options := Options or ofPostProcess;
  Command := ACommand;
end;

{****************************************************************************}
{ TCommandIcon.HandleEvent                                                   }
{****************************************************************************}
procedure TCommandIcon.HandleEvent (var Event : TEvent);
begin
  if ((Event.What = evMouseDown) and MouseInView(MouseWhere)) then begin
     ClearEvent(Event);
     Message(Owner,evCommand,Command,nil);
     end;
  TStaticText.HandleEvent(Event);
end;

{****************************************************************************}
{ TCommandInputLine Object                                                   }
{****************************************************************************}
{****************************************************************************}
{ TCommandInputLine.Changed                                                  }
{****************************************************************************}
{procedure TCommandInputLine.Changed;
begin
  Message(Owner,evBroadcast,cmInputLineChanged,@Self);
end;  }

{****************************************************************************}
{ TCommandInputLine.HandleEvent                                              }
{****************************************************************************}
{procedure TCommandInputLine.HandleEvent (var Event : TEvent);
var E : TEvent;
begin
  E := Event;
  TBSDInputLine.HandleEvent(Event);
  if ((E.What and evKeyBoard = evKeyBoard) and (Event.KeyCode = kbEnter))
     then Changed;
end; }

{****************************************************************************}
{ TCommandRadioButtons Object                                                }
{****************************************************************************}

{****************************************************************************}
{ TCommandRadioButtons.Init                                                  }
{****************************************************************************}
constructor TCommandRadioButtons.Init (var Bounds : TRect;
                                       ACommandStrings : PCommandSItem);
var
  StartSItem, S : PSItem;
  CItems : PCommandSItem;
  i : Sw_Integer;
begin
  if ACommandStrings = nil
     then Fail;
    { set up string list }
  StartSItem := NewSItem(ACommandStrings^.Value,nil);
  S := StartSItem;
  CItems := ACommandStrings^.Next;
  while (CItems <> nil) do begin
    S^.Next := NewSItem(CItems^.Value,nil);
    S := S^.Next;
    CItems := CItems^.Next;
    end;
    { construct check boxes }
  if not TRadioButtons.Init(Bounds,StartSItem) then begin
     while (StartSItem <> nil) do begin
       S := StartSItem;
       StartSItem := StartSItem^.Next;
       if (S^.Value <> nil) then
          DisposeStr(S^.Value);
       Dispose(S);
       end;
     Fail;
     end;
    { set up command list }
  i := 0;
  while (ACommandStrings <> nil) do begin
    CommandList[i] := ACommandStrings^.Command;
    CItems := ACommandStrings;
    ACommandStrings := ACommandStrings^.Next;
    Dispose(CItems);
    Inc(i);
    end;
end;

{****************************************************************************}
{ TCommandRadioButtons.Load                                                  }
{****************************************************************************}
constructor TCommandRadioButtons.Load (var S : TStream);
begin
  if not TRadioButtons.Load(S) then
     Fail;
  S.Read(CommandList,SizeOf(CommandList));
  if (S.Status <> stOk) then begin
     TRadioButtons.Done;
     Fail;
     end;
end;

{****************************************************************************}
{ TCommandRadioButtons.MoveTo                                                }
{****************************************************************************}
procedure TCommandRadioButtons.MovedTo (Item : Sw_Integer);
var Temp : Sw_Integer;
begin
  Temp := Value;
  TRadioButtons.MovedTo(Item);
  if (Value <> Temp) then  { value changed - notify peers }
     Message(Owner,evCommand,CommandList[Item],@Value);
end;

{****************************************************************************}
{ TCommandRadioButtons.Press                                                 }
{****************************************************************************}
procedure TCommandRadioButtons.Press (Item : Sw_Integer);
var Temp : Sw_Integer;
begin
  Temp := Value;
  TRadioButtons.Press(Item);
  if (Value <> Temp) then  { value changed - notify peers }
     Message(Owner,evCommand,CommandList[Item],@Value);
end;

{****************************************************************************}
{ TCommandRadioButtons.Store                                                 }
{****************************************************************************}
procedure TCommandRadioButtons.Store (var S : TStream);
begin
  TRadioButtons.Store(S);
  S.Write(CommandList,SizeOf(CommandList));
end;

{ TDialog }

constructor TDialog.Init(var Bounds: TRect; ATitle: TTitleStr);
begin
  inherited Init(Bounds, ATitle, wnNoNumber);
  Options := Options or ofVersion20;
  GrowMode := 0;
  Flags := wfMove + wfClose;
  Palette := dpGrayDialog;
end;

constructor TDialog.Load(var S: TStream);
begin
  if not inherited Load(S) then
    Fail;
  if Options and ofVersion = ofVersion10 then
  begin
    Palette := dpGrayDialog;
    Inc(Options, ofVersion20);
  end;
end;

{****************************************************************************}
{ TDialog.Cancel                                                             }
{****************************************************************************}
procedure TDialog.Cancel (ACommand : Word);
begin
  if State and sfModal = sfModal then
    EndModal(ACommand)
  else Close;
end;

{****************************************************************************}
{ TDialog.ChangeTitle                                                        }
{****************************************************************************}
procedure TDialog.ChangeTitle (ANewTitle : TTitleStr);
begin
  if (Title <> nil) then
    DisposeStr(Title);
  Title := NewStr(ANewTitle);
  Frame^.DrawView;
end;

{****************************************************************************}
{ TDialog.FreeSubView                                                        }
{****************************************************************************}
procedure TDialog.FreeSubView (ASubView : PView);
begin
  if IsSubView(ASubView) then begin
     Delete(ASubView);
     Dispose(ASubView,Done);
     DrawView;
     end;
end;

{****************************************************************************}
{ TDialog.FreeAllSubViews                                                    }
{****************************************************************************}
procedure TDialog.FreeAllSubViews;
var
  P : PView;
begin
  P := First;
  repeat
    P := First;
    if (P <> nil) then begin
       Delete(P);
       Dispose(P,Done);
       end;
  until (P = nil);
  DrawView;
end;

{****************************************************************************}
{ TDialog.GetPalette                                                         }
{****************************************************************************}
function TDialog.GetPalette: PPalette;
const
  P: array[dpBlueDialog..dpGrayDialog] of string[Length(CBlueDialog)] =
    (CBlueDialog, CCyanDialog, CGrayDialog);
begin
  GetPalette := PPalette(@P[Palette]);
end;

{****************************************************************************}
{ TDialog.HandleEvent                                                        }
{****************************************************************************}
procedure TDialog.HandleEvent(var Event: TEvent);
begin
  TWindow.HandleEvent(Event);
  case Event.What of
    evKeyDown:
      case Event.KeyCode of
        kbEsc, kbCtrlF4:
          begin
            Event.What := evCommand;
            Event.Command := cmCancel;
            Event.InfoPtr := nil;
            PutEvent(Event);
            ClearEvent(Event);
          end;
        kbEnter:
          begin
            Event.What := evBroadcast;
            Event.Command := cmDefault;
            Event.InfoPtr := nil;
            PutEvent(Event);
            ClearEvent(Event);
          end;
      end;
    evCommand:
      case Event.Command of
        cmOk, cmCancel, cmYes, cmNo:
          if State and sfModal <> 0 then
          begin
            EndModal(Event.Command);
            ClearEvent(Event);
          end;
      end;
  end;
end;

{****************************************************************************}
{ TDialog.IsSubView                                                          }
{****************************************************************************}
function TDialog.IsSubView (AView : PView) : Boolean;
var P : PView;
begin
  P := First;
  while (P <> nil) and (P <> AView) do
    P := P^.NextView;
  IsSubView := ((P <> nil) and (P = AView));
end;

{****************************************************************************}
{ TDialog.NewButton                                                          }
{****************************************************************************}
function TDialog.NewButton (X, Y, W, H : Sw_Integer; ATitle : TTitleStr;
                               ACommand, AHelpCtx : Word;
                               AFlags : Byte) : PButton;
var
  B : PButton;
  R : TRect;
begin
  R.Assign(X,Y,X+W,Y+H);
  B := New(PButton,Init(R,ATitle,ACommand,AFlags));
  if (B <> nil) then begin
     B^.HelpCtx := AHelpCtx;
     Insert(B);
     end;
  NewButton := B;
end;

{****************************************************************************}
{ TDialog.NewInputLine                                                       }
{****************************************************************************}
function TDialog.NewInputLine (X, Y, W, AMaxLen : Sw_Integer; AHelpCtx : Word
                                  ; AValidator : PValidator) : PInputLine;
var
  P : PInputLine;
  R : TRect;
begin
  R.Assign(X,Y,X+W,Y+1);
  P := New(PInputLine,Init(R,AMaxLen));
  if (P <> nil) then begin
     P^.SetValidator(AValidator);
     P^.HelpCtx := AHelpCtx;
     Insert(P);
     end;
  NewInputLine := P;
end;

{****************************************************************************}
{ TDialog.NewLabel                                                           }
{****************************************************************************}
function TDialog.NewLabel (X, Y : Sw_Integer; AText : String;
                              ALink : PView) : PLabel;
var
  P : PLabel;
  R : TRect;
begin
  R.Assign(X,Y,X+CStrLen(AText)+1,Y+1);
  P := New(PLabel,Init(R,AText,ALink));
  if (P <> nil) then
     Insert(P);
  NewLabel := P;
end;

{****************************************************************************}
{ TDialog.Valid                                                              }
{****************************************************************************}
function TDialog.Valid(Command: Word): Boolean;
begin
  if Command = cmCancel then
    Valid := True
  else Valid := TGroup.Valid(Command);
end;

{****************************************************************************}
{ THistory object                                                            }
{****************************************************************************}
{****************************************************************************}
{ THistory.Init                                                              }
{****************************************************************************}
constructor THistory.Init(var Bounds: TRect; ALink: PInputLine;
  AHistoryId: Sw_Word);
begin
  TView.Init(Bounds);
  Options := Options or ofPostProcess;
  EventMask := EventMask or evBroadcast;
  Link := ALink;
  HistoryId := AHistoryId;
end;

{****************************************************************************}
{ THistory.Load                                                              }
{****************************************************************************}
constructor THistory.Load(var S: TStream);
begin
  TView.Load(S);
  GetPeerViewPtr(S, Link);
  S.Read(HistoryId, SizeOf(Sw_Word));
end;

{****************************************************************************}
{ THistory.Draw                                                              }
{****************************************************************************}
procedure THistory.Draw;
var
  B: TDrawBuffer;
begin
  MoveCStr(B, #222'~'#25'~'#221, GetColor($0102));
  WriteLine(0, 0, Size.X, Size.Y, B);
end;

{****************************************************************************}
{ THistory.GetPalette                                                        }
{****************************************************************************}
function THistory.GetPalette: PPalette;
const
  P: String[Length(CHistory)] = CHistory;
begin
  GetPalette := PPalette(@P);
end;

{****************************************************************************}
{ THistory.HandleEvent                                                       }
{****************************************************************************}
procedure THistory.HandleEvent(var Event: TEvent);
var
  HistoryWindow: PHistoryWindow;
  R,P: TRect;
  C: Word;
  Rslt: String;
begin
  TView.HandleEvent(Event);
  if (Event.What = evMouseDown) or
     ((Event.What = evKeyDown) and (CtrlToArrow(Event.KeyCode) = kbDown) and
      (Link^.State and sfFocused <> 0)) then
  begin
    if not Link^.Focus then
    begin
      ClearEvent(Event);
      Exit;
    end;
    RecordHistory(Link^.Data^);
    Link^.GetBounds(R);
    Dec(R.A.X); Inc(R.B.X); Inc(R.B.Y,7); Dec(R.A.Y,1);
    Owner^.GetExtent(P);
    R.Intersect(P);
    Dec(R.B.Y,1);
    HistoryWindow := InitHistoryWindow(R);
    if HistoryWindow <> nil then
    begin
      C := Owner^.ExecView(HistoryWindow);
      if C = cmOk then
      begin
        Rslt := HistoryWindow^.GetSelection;
        if Length(Rslt) > Link^.MaxLen then Rslt[0] := Char(Link^.MaxLen);
        Link^.Data^ := Rslt;
        Link^.SelectAll(True);
        Link^.DrawView;
      end;
      Dispose(HistoryWindow, Done);
    end;
    ClearEvent(Event);
  end
  else if (Event.What = evBroadcast) then
    if ((Event.Command = cmReleasedFocus) and (Event.InfoPtr = Link))
      or (Event.Command = cmRecordHistory) then
    RecordHistory(Link^.Data^);
end;

{****************************************************************************}
{ THistory.InitHistoryWindow                                                 }
{****************************************************************************}
function THistory.InitHistoryWindow(var Bounds: TRect): PHistoryWindow;
var
  P: PHistoryWindow;
begin
  P := New(PHistoryWindow, Init(Bounds, HistoryId));
  P^.HelpCtx := Link^.HelpCtx;
  InitHistoryWindow := P;
end;

{****************************************************************************}
{ THistory.RecordHistory                                                     }
{****************************************************************************}
procedure THistory.RecordHistory(const S: String);
begin
  HistoryAdd(HistoryId, S);
end;

{****************************************************************************}
{ THistory.Store                                                             }
{****************************************************************************}
procedure THistory.Store(var S: TStream);
begin
  TView.Store(S);
  PutPeerViewPtr(S, Link);
  S.Write(HistoryId, SizeOf(Sw_Word));
end;

{****************************************************************************}
{ THistoryViewer object                                                      }
{****************************************************************************}
{****************************************************************************}
{ THistoryViewer.Init                                                        }
{****************************************************************************}
constructor THistoryViewer.Init(var Bounds: TRect; AHScrollBar,
  AVScrollBar: PScrollBar; AHistoryId: Sw_Word);
begin
  TListViewer.Init(Bounds, 1, AHScrollBar, AVScrollBar);
  HistoryId := AHistoryId;
  SetRange(HistoryCount(AHistoryId));
  if Range > 1 then FocusItem(1);
  HScrollBar^.SetRange(1, HistoryWidth-Size.X + 3);
end;

{****************************************************************************}
{ THistoryViewer.GetPalette                                                  }
{****************************************************************************}
function THistoryViewer.GetPalette: PPalette;
const
  P: String[Length(CHistoryViewer)] = CHistoryViewer;
begin
  GetPalette := PPalette(@P);
end;

{****************************************************************************}
{ THistoryViewer.GetText                                                     }
{****************************************************************************}
function THistoryViewer.GetText(Item,Maxlen: Sw_Integer): String;
begin
  GetText := HistoryStr(HistoryId, Item);
end;

{****************************************************************************}
{ THistoryViewer.HandleEvent                                                 }
{****************************************************************************}
procedure THistoryViewer.HandleEvent(var Event: TEvent);
begin
  if ((Event.What = evMouseDown) and (Event.Double)) or
     ((Event.What = evKeyDown) and (Event.KeyCode = kbEnter)) then
  begin
    EndModal(cmOk);
    ClearEvent(Event);
  end else if ((Event.What = evKeyDown) and (Event.KeyCode = kbEsc)) or
    ((Event.What = evCommand) and (Event.Command = cmCancel)) then
  begin
    EndModal(cmCancel);
    ClearEvent(Event);
  end else TListViewer.HandleEvent(Event);
end;

{****************************************************************************}
{ THistoryViewer.HistoryWidth                                                }
{****************************************************************************}
function THistoryViewer.HistoryWidth: Sw_Integer;
var
  Width, T, Count, I: Sw_Integer;
begin
  Width := 0;
  Count := HistoryCount(HistoryId);
  for I := 0 to Count-1 do
  begin
    T := Length(HistoryStr(HistoryId, I));
    if T > Width then Width := T;
  end;
  HistoryWidth := Width;
end;

{****************************************************************************}
{ THistoryWindow object                                                      }
{****************************************************************************}
{****************************************************************************}
{ THistoryWindow.Init                                                        }
{****************************************************************************}
constructor THistoryWindow.Init(var Bounds: TRect; HistoryId: Sw_Word);
begin
  TWindow.Init(Bounds, '', wnNoNumber);
  Flags := wfClose;
  InitViewer(HistoryId);
end;

{****************************************************************************}
{ THistoryWindow.GetPalette                                                  }
{****************************************************************************}
function THistoryWindow.GetPalette: PPalette;
const
  P: String[Length(CHistoryWindow)] = CHistoryWindow;
begin
  GetPalette := PPalette(@P);
end;

{****************************************************************************}
{ THistoryWindow.GetSelection                                                }
{****************************************************************************}
function THistoryWindow.GetSelection: String;
begin
  GetSelection := Viewer^.GetText(Viewer^.Focused,255);
end;

{****************************************************************************}
{ THistoryWindow.InitViewer                                                  }
{****************************************************************************}
procedure THistoryWindow.InitViewer(HistoryId: Sw_Word);
var
  R: TRect;
begin
  GetExtent(R);
  R.Grow(-1,-1);
  Viewer := New(PHistoryViewer, Init(R,
    StandardScrollBar(sbHorizontal + sbHandleKeyboard),
    StandardScrollBar(sbVertical + sbHandleKeyboard),
    HistoryId));
  Insert(Viewer);
end;

{****************************************************************************}
{ TInputLine object                                                          }
{****************************************************************************}
{****************************************************************************}
{ TInputLine.Init                                                            }
{****************************************************************************}
constructor TInputLine.Init(var Bounds: TRect; AMaxLen: Sw_Integer);
begin
  TView.Init(Bounds);
  State := State or sfCursorVis;
  Options := Options or (ofSelectable + ofFirstClick + ofVersion20);
  GetMem(Data, AMaxLen + 1);
  Data^ := '';
  MaxLen := AMaxLen;
end;

{****************************************************************************}
{ TInputLine.Load                                                            }
{****************************************************************************}
constructor TInputLine.Load(var S: TStream);
begin
  TView.Load(S);
  S.Read(MaxLen, SizeOf(Sw_Integer) * 5);
  GetMem(Data, MaxLen + 1);
  S.Read(Data^[0], 1);
  S.Read(Data^[1], Length(Data^));
  if Options and ofVersion >= ofVersion20 then
    Validator := PValidator(S.Get);
  Options := Options or ofVersion20;
end;

{****************************************************************************}
{ TInputLine.Done                                                            }
{****************************************************************************}
destructor TInputLine.Done;
begin
  FreeMem(Data, MaxLen + 1);
  SetValidator(nil);
  TView.Done;
end;

{****************************************************************************}
{ TInputLine.CanScroll                                                       }
{****************************************************************************}
function TInputLine.CanScroll(Delta: Sw_Integer): Boolean;
begin
  if Delta < 0 then
    CanScroll := FirstPos > 0
  else if Delta > 0 then
    CanScroll := Length(Data^) - FirstPos + 2 > Size.X
  else CanScroll := False;
end;

{****************************************************************************}
{ TInputLine.DataSize                                                        }
{****************************************************************************}
function TInputLine.DataSize: Sw_Word;
var
  DSize: Sw_Word;
begin
  DSize := 0;
  if Validator <> nil then
    DSize := Validator^.Transfer(Data^, nil, vtDataSize);
  if DSize <> 0 then
    DataSize := DSize
  else DataSize := MaxLen + 1;
end;

{****************************************************************************}
{ TInputLine.Draw                                                            }
{****************************************************************************}
procedure TInputLine.Draw;
var
  Color: Byte;
  L, R: Sw_Integer;
  B: TDrawBuffer;
begin
  if Options and ofSelectable <> ofSelectable then
  begin
    Color := GetColor(5);
    MoveChar(B, ' ', Color, Size.X);
    MoveStr(B[1], Copy(Data^, FirstPos + 1, Size.X - 2), Color);
    WriteLine(0, 0, Size.X, Size.Y, B);
    Exit;
  end;
  if State and sfFocused = 0 then
    Color := GetColor(1)
  else Color := GetColor(2);
  MoveChar(B, ' ', Color, Size.X);
  MoveStr(B[1], Copy(Data^, FirstPos + 1, Size.X - 2), Color);
  if CanScroll(1) then
    MoveChar(B[Size.X - 1], #16, GetColor(4), 1);
  if State and sfFocused <> 0 then
  begin
    if CanScroll(-1) then
      MoveChar(B[0], #17, GetColor(4), 1);
    L := SelStart - FirstPos;
    R := SelEnd - FirstPos;
    if L < 0 then
      L := 0;
    if R > Size.X - 2 then
      R := Size.X - 2;
    if L < R then
      MoveChar(B[L + 1], #0, GetColor(3), R - L);
  end;
  WriteLine(0, 0, Size.X, Size.Y, B);
  SetCursor(CurPos - FirstPos + 1, 0);
end;

{****************************************************************************}
{ TInputLine.GetData                                                         }
{****************************************************************************}
procedure TInputLine.GetData(var Rec);
begin
  if (Validator = nil) or
    (Validator^.Transfer(Data^, @Rec, vtGetData) = 0) then
  begin
    FillChar(Rec, DataSize, #0);
    Move(Data^, Rec, Length(Data^) + 1);
  end;
end;

{****************************************************************************}
{ TInputLine.GetPalette                                                      }
{****************************************************************************}
function TInputLine.GetPalette: PPalette;
const
  P: String[Length(CInputLine)] = CInputLine;
begin
  GetPalette := PPalette(@P);
end;

{****************************************************************************}
{ TInputLine.HandleEvent                                                     }
{****************************************************************************}
procedure TInputLine.HandleEvent(var Event: TEvent);
const
  PadKeys = [$47, $4B, $4D, $4F, $73, $74];
var
  Delta, Anchor, I: Sw_Integer;
  ExtendBlock: Boolean;
  OldData: string;
  OldCurPos, OldFirstPos,
  OldSelStart, OldSelEnd: Sw_Integer;
  WasAppending: Boolean;

  function MouseDelta: Sw_Integer;
  var
    Mouse: TPoint;
  begin
    MakeLocal(Event.Where, Mouse);
    if Mouse.X <= 0 then MouseDelta := -1 else
    if Mouse.X >= Size.X - 1 then MouseDelta := 1 else
    MouseDelta := 0;
  end;

  function MousePos: Sw_Integer;
  var
    Pos: Sw_Integer;
    Mouse: TPoint;
  begin
    MakeLocal(Event.Where, Mouse);
    if Mouse.X < 1 then Mouse.X := 1;
    Pos := Mouse.X + FirstPos - 1;
    if Pos < 0 then Pos := 0;
    if Pos > Length(Data^) then Pos := Length(Data^);
    MousePos := Pos;
  end;

  procedure DeleteSelect;
  begin
    if SelStart <> SelEnd then
    begin
      Delete(Data^, SelStart + 1, SelEnd - SelStart);
      CurPos := SelStart;
    end;
  end;

  procedure AdjustSelectBlock;
  begin
    if CurPos < Anchor then
    begin
      SelStart := CurPos;
      SelEnd := Anchor;
    end else
    begin
      SelStart := Anchor;
      SelEnd := CurPos;
    end;
  end;

  procedure SaveState;
  begin
    if Validator <> nil then
    begin
      OldData := Data^;
      OldCurPos := CurPos;
      OldFirstPos := FirstPos;
      OldSelStart := SelStart;
      OldSelEnd := SelEnd;
      WasAppending := Length(Data^) = CurPos;
    end;
  end;

  procedure RestoreState;
  begin
    if Validator <> nil then
    begin
      Data^ := OldData;
      CurPos := OldCurPos;
      FirstPos := OldFirstPos;
      SelStart := OldSelStart;
      SelEnd := OldSelEnd;
    end;
  end;

  function CheckValid(NoAutoFill: Boolean): Boolean;
  var
    OldLen: Sw_Integer;
    NewData: String;
  begin
    if Validator <> nil then
    begin
      CheckValid := False;
      OldLen := Length(Data^);
      if (Validator^.Options and voOnAppend = 0) or
        (WasAppending and (CurPos = OldLen)) then
      begin
        NewData := Data^;
        if not Validator^.IsValidInput(NewData, NoAutoFill) then
          RestoreState
        else
        begin
          if Length(NewData) > MaxLen then NewData[0] := Char(MaxLen);
          Data^ := NewData;
          if (CurPos >= OldLen) and (Length(Data^) > OldLen) then
            CurPos := Length(Data^);
          CheckValid := True;
        end;
      end
      else
      begin
        CheckValid := True;
        if CurPos = OldLen then
          if not Validator^.IsValidInput(Data^, False) then
          begin
            Validator^.Error;
            CheckValid := False;
          end;
      end;
    end
    else
      CheckValid := True;
  end;

begin
  TView.HandleEvent(Event);
  if State and sfSelected <> 0 then
  begin
    case Event.What of
      evMouseDown:
        begin
          Delta := MouseDelta;
          if CanScroll(Delta) then
          begin
            repeat
              if CanScroll(Delta) then
              begin
                Inc(FirstPos, Delta);
                DrawView;
              end;
            until not MouseEvent(Event, evMouseAuto);
          end else
          if Event.Double then SelectAll(True) else
          begin
            Anchor := MousePos;
            repeat
              if Event.What = evMouseAuto then
              begin
                Delta := MouseDelta;
                if CanScroll(Delta) then Inc(FirstPos, Delta);
              end;
              CurPos := MousePos;
              AdjustSelectBlock;
              DrawView;
            until not MouseEvent(Event, evMouseMove + evMouseAuto);
          end;
          ClearEvent(Event);
        end;
      evKeyDown:
        begin
          SaveState;
          Event.KeyCode := CtrlToArrow(Event.KeyCode);
          if (Event.ScanCode in PadKeys) and
             (GetShiftState and $03 <> 0) then
          begin
            Event.CharCode := #0;
            if CurPos = SelEnd then Anchor := SelStart
            else Anchor := SelEnd;
            ExtendBlock := True;
          end
          else
            ExtendBlock := False;
          case Event.KeyCode of
            kbLeft:
              if CurPos > 0 then Dec(CurPos);
            kbRight:
              if CurPos < Length(Data^) then
              begin
                Inc(CurPos);
                CheckValid(True);
              end;
            kbHome:
              CurPos := 0;
            kbEnd:
              begin
                CurPos := Length(Data^);
                CheckValid(True);
              end;
            kbBack:
              if CurPos > 0 then
              begin
                Delete(Data^, CurPos, 1);
                Dec(CurPos);
                if FirstPos > 0 then Dec(FirstPos);
                CheckValid(True);
              end;
            kbDel:
              begin
                if SelStart = SelEnd then
                  if CurPos < Length(Data^) then
                  begin
                    SelStart := CurPos;
                    SelEnd := CurPos + 1;
                  end;
                DeleteSelect;
                CheckValid(True);
              end;
            kbIns:
              SetState(sfCursorIns, State and sfCursorIns = 0);
          else
            case Event.CharCode of
              ' '..#255:
                begin
                  if State and sfCursorIns <> 0 then
                    Delete(Data^, CurPos + 1, 1) else DeleteSelect;
                  if CheckValid(True) then
                  begin
                    if Length(Data^) < MaxLen then
                    begin
                      if FirstPos > CurPos then FirstPos := CurPos;
                      Inc(CurPos);
                      Insert(Event.CharCode, Data^, CurPos);
                    end;
                    CheckValid(False);
                  end;
                end;
              ^Y:
                begin
                  Data^ := '';
                  CurPos := 0;
                end;
            else
              Exit;
            end
          end;
          if ExtendBlock then
            AdjustSelectBlock
          else
          begin
            SelStart := CurPos;
            SelEnd := CurPos;
          end;
          if FirstPos > CurPos then FirstPos := CurPos;
          I := CurPos - Size.X + 2;
          if FirstPos < I then FirstPos := I;
          DrawView;
          ClearEvent(Event);
        end;
    end;
  end;
end;

{****************************************************************************}
{ TInputLine.SelectAll                                                       }
{****************************************************************************}
procedure TInputLine.SelectAll(Enable: Boolean);
begin
  CurPos := 0;
  FirstPos := 0;
  SelStart := 0;
  if Enable then SelEnd := Length(Data^) else SelEnd := 0;
  DrawView;
end;

{****************************************************************************}
{ TInputLine.SetData                                                         }
{****************************************************************************}
procedure TInputLine.SetData(var Rec);
begin
  if (Validator = nil) or
    (Validator^.Transfer(Data^, @Rec, vtSetData) = 0) then
    Move(Rec, Data^[0], DataSize);
  SelectAll(True);
end;

{****************************************************************************}
{ TInputLine.SetState                                                        }
{****************************************************************************}
procedure TInputLine.SetState(AState: Word; Enable: Boolean);
begin
  TView.SetState(AState, Enable);
  if (AState = sfSelected) or ((AState = sfActive) and
     (State and sfSelected <> 0)) then
    SelectAll(Enable)
  else if AState = sfFocused then
    DrawView;
end;

{****************************************************************************}
{ TInputLine.SetValidator                                                    }
{****************************************************************************}
procedure TInputLine.SetValidator(AValid: PValidator);
begin
  if Validator <> nil then Validator^.Free;
  Validator := AValid;
end;

{****************************************************************************}
{ TInputLine.Store                                                           }
{****************************************************************************}
procedure TInputLine.Store(var S: TStream);
begin
  TView.Store(S);
  S.Write(MaxLen, SizeOf(Sw_Integer) * 5);
  S.WriteStr(Data);
  S.Put(Validator);
end;

{****************************************************************************}
{ TInputLine.Valid                                                           }
{****************************************************************************}
function TInputLine.Valid(Command: Word): Boolean;
begin
  Valid := inherited Valid(Command);
  if (Validator <> nil) and (State and sfDisabled = 0) then
    if Command = cmValid then
      Valid := Validator^.Status = vsOk
    else if Command <> cmCancel then
      if not Validator^.Valid(Data^) then
      begin
        Select;
        Valid := False;
      end;
end;

{ TLabel }

constructor TLabel.Init(var Bounds: TRect; const AText: String; ALink: PView);
begin
  TStaticText.Init(Bounds, AText);
  Link := ALink;
  Options := Options or (ofPreProcess + ofPostProcess);
  EventMask := EventMask or evBroadcast;
end;

constructor TLabel.Load(var S: TStream);
begin
  TStaticText.Load(S);
  GetPeerViewPtr(S, Link);
end;

procedure TLabel.Draw;
var
  Color: Word;
  B: TDrawBuffer;
  SCOff: Byte;
begin
  if Light then
  begin
    Color := GetColor($0402);
    SCOff := 0;
  end
  else
  begin
    Color := GetColor($0301);
    SCOff := 4;
  end;
  MoveChar(B[0], ' ', Byte(Color), Size.X);
  if Text <> nil then MoveCStr(B[1], Text^, Color);
  if ShowMarkers then WordRec(B[0]).Lo := Byte(SpecialChars[SCOff]);
  WriteLine(0, 0, Size.X, 1, B);
end;

function TLabel.GetPalette: PPalette;
const
  P: String[Length(CLabel)] = CLabel;
begin
  GetPalette := PPalette(@P);
end;

procedure TLabel.HandleEvent(var Event: TEvent);
var
  C: Char;

  procedure FocusLink;
  begin
    if (Link <> nil) and (Link^.Options and ofSelectable <> 0) then
      Link^.Focus;
    ClearEvent(Event);
  end;

begin
  TStaticText.HandleEvent(Event);
  if Event.What = evMouseDown then FocusLink
  else if Event.What = evKeyDown then
  begin
    C := HotKey(Text^);
    if (GetAltCode(C) = Event.KeyCode) or
       ((C <> #0) and (Owner^.Phase = phPostProcess) and
        (UpCase(Event.CharCode) = C)) then FocusLink
  end
  else if Event.What = evBroadcast then
    if ((Event.Command = cmReceivedFocus) or
       (Event.Command = cmReleasedFocus)) and
       (Link <> nil) then
    begin
      Light := Link^.State and sfFocused <> 0;
      DrawView;
    end;
end;

procedure TLabel.Store(var S: TStream);
begin
  TStaticText.Store(S);
  PutPeerViewPtr(S, Link);
end;

{ TListBox }

constructor TListBox.Init(var Bounds: TRect; ANumCols: Sw_Word;
  AScrollBar: PScrollBar);
begin
  TListViewer.Init(Bounds, ANumCols, nil, AScrollBar);
  List := nil;
  SetRange(0);
end;

constructor TListBox.Load(var S: TStream);
begin
  TListViewer.Load(S);
  List := PCollection(S.Get);
end;

function TListBox.DataSize: Sw_Word;
begin
  DataSize := SizeOf(TListBoxRec);
end;

{****************************************************************************}
{ TListBox.DeleteFocusedItem                                                 }
{****************************************************************************}
procedure TListBox.DeleteFocusedItem;
begin
  DeleteItem(Focused);
end;

{****************************************************************************}
{ TListBox.DeleteItem                                                        }
{****************************************************************************}
procedure TListBox.DeleteItem (Item : Sw_Integer);
begin
  if (List <> nil) and (List^.Count > 0) and
     ((Item < List^.Count) and (Item > -1)) then begin
     if IsSelected(Item) and (Item > 0) then
        FocusItem(Item - 1);
     List^.AtDelete(Item);
     SetRange(List^.Count);
     end;
end;

{****************************************************************************}
{ TListBox.FreeAll                                                           }
{****************************************************************************}
procedure TListBox.FreeAll;
begin
  if (List <> nil) then
  begin
    List^.FreeAll;
    SetRange(List^.Count);
  end;
end;

{****************************************************************************}
{ TListBox.FreeFocusedItem                                                   }
{****************************************************************************}
procedure TListBox.FreeFocusedItem;
begin
  FreeItem(Focused);
end;

{****************************************************************************}
{ TListBox.FreeItem                                                          }
{****************************************************************************}
procedure TListBox.FreeItem (Item : Sw_Integer);
begin
  if (Item > -1) and (Item < Range) then
  begin
    List^.AtFree(Item);
    if (Range > 1) and (Focused >= List^.Count) then
      Dec(Focused);
    SetRange(List^.Count);
  end;
end;

{****************************************************************************}
{ TListBox.GetData                                                           }
{****************************************************************************}
procedure TListBox.GetData(var Rec);
begin
  TListBoxRec(Rec).List := List;
  TListBoxRec(Rec).Selection := Focused;
end;

{****************************************************************************}
{ TListBox.GetFocusedItem                                                    }
{****************************************************************************}
function TListBox.GetFocusedItem : Pointer;
begin
  if (List = nil) or (List^.Count = 0) then
     GetFocusedItem := nil
  else GetFocusedItem := List^.At(Focused);
end;

{****************************************************************************}
{ TListBox.GetText                                                           }
{****************************************************************************}
function TListBox.GetText(Item,MaxLen: Sw_Integer): String;
var
  S : PString;
begin
  GetText := '';
  if (List <> nil) then
  begin
    S := PString(List^.At(Item));
    if (S <> nil) then
      GetText := S^;
  end;
end;

{****************************************************************************}
{ TListBox.Insert                                                            }
{****************************************************************************}
procedure TListBox.Insert (Item : Pointer);
begin
  if (List <> nil) then
  begin
    List^.Insert(Item);
    SetRange(List^.Count);
  end;
end;

procedure TListBox.NewList(AList: PCollection);
begin
  if List <> nil then Dispose(List, Done);
  List := AList;
  if AList <> nil then SetRange(AList^.Count)
  else SetRange(0);
  if Range > 0 then FocusItem(0);
  DrawView;
end;

procedure TListBox.SetData(var Rec);
begin
  NewList(TListBoxRec(Rec).List);
  FocusItem(TListBoxRec(Rec).Selection);
  DrawView;
end;

{****************************************************************************}
{ TListBox.SetFocusedItem                                                    }
{****************************************************************************}
procedure TListBox.SetFocusedItem (Item : Pointer);
begin
  FocusItem(List^.IndexOf(Item));
end;

procedure TListBox.Store(var S: TStream);
begin
  TListViewer.Store(S);
  S.Put(List);
end;

{ TMultiCheckBoxes }

constructor TMultiCheckBoxes.Init(var Bounds: TRect; AStrings: PSItem;
  ASelRange: Byte; AFlags: Word; const AStates: String);
begin
  Inherited Init(Bounds, AStrings);
  SelRange := ASelRange;
  Flags := AFlags;
  States := NewStr(AStates);
end;

constructor TMultiCheckBoxes.Load(var S: TStream);
begin
  TCluster.Load(S);
  S.Read(SelRange, SizeOf(Byte));
  S.Read(Flags, SizeOf(Word));
  States := S.ReadStr;
end;

destructor TMultiCheckBoxes.Done;
begin
  DisposeStr(States);
  TCluster.Done;
end;

procedure TMultiCheckBoxes.Draw;
const
  Button = ' [ ] ';
begin
  DrawMultiBox(Button, States^);
end;

function TMultiCheckBoxes.DataSize: Sw_Word;
begin
  DataSize := SizeOf(Longint);
end;

function TMultiCheckBoxes.MultiMark(Item: Sw_Integer): Byte;
begin
  MultiMark := (Value shr (Sw_Word(Item) * WordRec(Flags).Hi))
    and WordRec(Flags).Lo;
end;

procedure TMultiCheckBoxes.GetData(var Rec);
begin
  Longint(Rec) := Value;
end;

procedure TMultiCheckBoxes.Press(Item: Sw_Integer);
var
  CurState: ShortInt;
begin
  CurState := (Value shr (Sw_Word(Item) * WordRec(Flags).Hi))
    and WordRec(Flags).Lo;

  Dec(CurState);
  if (CurState >= SelRange) or (CurState < 0) then
    CurState := SelRange - 1;
  Value := (Value and not (LongInt(WordRec(Flags).Lo)
    shl (Sw_Word(Item) * WordRec(Flags).Hi))) or
    (LongInt(CurState) shl (Sw_Word(Item) * WordRec(Flags).Hi));
end;

procedure TMultiCheckBoxes.SetData(var Rec);
begin
  Value := Longint(Rec);
  DrawView;
end;

procedure TMultiCheckBoxes.Store(var S: TStream);
begin
  TCluster.Store(S);
  S.Write(SelRange, SizeOf(Byte));
  S.Write(Flags, SizeOf(Word));
  S.WriteStr(States);
end;

{ TParamText }

constructor TParamText.Init(var Bounds: TRect; const AText: String;
  AParamCount: Sw_Integer);
begin
  TStaticText.Init(Bounds, AText);
  ParamCount := AParamCount;
end;

constructor TParamText.Load(var S: TStream);
begin
  TStaticText.Load(S);
  S.Read(ParamCount, SizeOf(Sw_Integer));
end;

function TParamText.DataSize: Sw_Word;
begin
  DataSize := ParamCount * SizeOf(Longint);
end;

procedure TParamText.GetText(var S: String);
begin
  if Text <> nil then FormatStr(S, Text^, ParamList^)
  else S := '';
end;

procedure TParamText.SetData(var Rec);
begin
  ParamList := @Rec;
  DrawView;
end;

procedure TParamText.Store(var S: TStream);
begin
  TStaticText.Store(S);
  S.Write(ParamCount, SizeOf(Sw_Integer));
end;

{ TRadioButtons }

procedure TRadioButtons.Draw;
const
  Button = ' ( ) ';
begin
  DrawMultiBox(Button, ' *');
end;

function TRadioButtons.Mark(Item: Sw_Integer): Boolean;
begin
  Mark := Item = Value;
end;

procedure TRadioButtons.Press(Item: Sw_Integer);
begin
  Value := Item;
end;

procedure TRadioButtons.MovedTo(Item: Sw_Integer);
begin
  Value := Item;
end;

procedure TRadioButtons.SetData(var Rec);
begin
  TCluster.SetData(Rec);
  Sel := Integer(Value);
end;

{ TStaticText }

constructor TStaticText.Init(var Bounds: TRect; const AText: String);
begin
  TView.Init(Bounds);
  Text := NewStr(AText);
end;

constructor TStaticText.Load(var S: TStream);
begin
  TView.Load(S);
  Text := S.ReadStr;
end;

destructor TStaticText.Done;
begin
  DisposeStr(Text);
  TView.Done;
end;

procedure TStaticText.Draw;
var
  Color: Byte;
  Center: Boolean;
  I, J, L, P, Y: Sw_Integer;
  B: TDrawBuffer;
  S: String;
begin
  Color := GetColor(1);
  GetText(S);
  L := Length(S);
  P := 1;
  Y := 0;
  Center := False;
  while Y < Size.Y do
  begin
    MoveChar(B, ' ', Color, Size.X);
    if P <= L then
    begin
      if S[P] = #3 then
      begin
        Center := True;
        Inc(P);
      end;
      I := P;
      repeat
        J := P;
        while (P <= L) and (S[P] = ' ') do Inc(P);
        while (P <= L) and (S[P] <> ' ') and (S[P] <> #13) do Inc(P);
      until (P > L) or (P >= I + Size.X) or (S[P] = #13);
      if P > I + Size.X then
        if J > I then P := J else P := I + Size.X;
      if Center then J := (Size.X - P + I) div 2 else J := 0;
      MoveBuf(B[J], S[I], Color, P - I);
      while (P <= L) and (S[P] = ' ') do Inc(P);
      if (P <= L) and (S[P] = #13) then
      begin
        Center := False;
        Inc(P);
        if (P <= L) and (S[P] = #10) then Inc(P);
      end;
    end;
    WriteLine(0, Y, Size.X, 1, B);
    Inc(Y);
  end;
end;

function TStaticText.GetPalette: PPalette;
const
  P: String[Length(CStaticText)] = CStaticText;
begin
  GetPalette := PPalette(@P);
end;

procedure TStaticText.GetText(var S: String);
begin
  if Text <> nil then S := Text^
  else S := '';
end;

procedure TStaticText.Store(var S: TStream);
begin
  TView.Store(S);
  S.WriteStr(Text);
end;

{****************************************************************************}
{                            Public Declarations                             }
{****************************************************************************}
{****************************************************************************}
{ NewCommandSItem                                                            }
{****************************************************************************}
function NewCommandSItem (Str : String; ACommand : Word;
                          ANext : PCommandSItem) : PCommandSItem;
var Temp : PCommandSItem;
begin
  New(Temp);
  if (Temp <> nil) then
  begin
    Temp^.Value := Str;
    Temp^.Command := ACommand;
    Temp^.Next := ANext;
  end;
  NewCommandSItem := Temp;
end;

{****************************************************************************}
{ RegisterDialogs                                                            }
{****************************************************************************}
procedure RegisterDialogs;
begin
  RegisterType(RDialog);
  RegisterType(RInputLine);
  RegisterType(RButton);
  RegisterType(RCluster);
  RegisterType(RRadioButtons);
  RegisterType(RCheckBoxes);
  RegisterType(RMultiCheckBoxes);
  RegisterType(RListBox);
  RegisterType(RStaticText);
  RegisterType(RLabel);
  RegisterType(RHistory);
  RegisterType(RParamText);
  RegisterType(RCommandCheckBoxes);
  RegisterType(RCommandIcon);
  RegisterType(RCommandRadioButtons);
end;

{****************************************************************************}
{                            Unit Initialization                             }
{****************************************************************************}

var
  OldExitProc : pointer;
procedure DoneClpBrd;{$ifdef PPC_BP}far;{$endif}
begin
  ExitProc:=OldExitProc;
  if assigned(ClpBrd) then
   FreeMem(ClpBrd,ClpBrdSize);
end;


begin
  GetMem(ClpBrd,ClpBrdSize);
  FillChar(Clpbrd[0],ClpBrdSize,#0);
  OldExitProc:=ExitProc;
  ExitProc:=@DoneClpBrd;
end.
