{************************************************}
{                                                }
{   Turbo Vision 2.0 Demo                        }
{   Copyright (c) 1992 by Borland International  }
{                                                }
{************************************************}

program DosCol1;
uses
  Objects;

type
  PClient = ^TClient;
  TClient = object(TObject)
    Account, Name, Phone: PString;
    constructor Init(NewAccount, NewName, NewPhone: String);
    Constructor Load(VAR s:TStream);
    destructor Done; virtual;
    Procedure Store(VAR s:TStream);
    procedure Print; virtual;
  end;

Const
  RClient: TStreamRec = (
    ObjType: 1000;
    VmtLink: Ofs(Typeof(TClient)^);
    Load: @TClient.Load;
    Store: @TClient.Store);

{ TClient }
constructor TClient.Init(NewAccount, NewName, NewPhone: String);
begin
  Account := NewStr(NewAccount);
  Name := NewStr(NewName);
  Phone := NewStr(NewPhone);
end;

constructor TClient.Load(var s:TStream);
begin
  Account:=s.ReadStr;
  Name:=s.ReadStr;
  Phone:=s.ReadStr;
end;


destructor TClient.Done;
begin
  DisposeStr(Account);
  DisposeStr(Name);
  DisposeStr(Phone);
end;

procedure TClient.store(var s:TStream);
begin
  s.WriteStr(Account);
  s.WriteStr(Name);
  s.WriteStr(Phone);
end;

procedure TClient.Print;
begin
  Writeln('  ',
    Account^, '':10-Length(Account^),
    Name^, '':20-Length(Name^),
    Phone^, '':16-Length(Phone^));
end;

{ Use ForEach iterator to display client information }

procedure PrintAll(C: PCollection);

  procedure CallPrint(P : PClient);{$ifndef FPC}far;{$endif}
  begin
    P^.Print;                   { Call Print method }
  end;

begin { Print }
  Writeln;
  Writeln;
  Writeln('Client list:');
  C^.ForEach(@CallPrint);     { Print each client }
end;

{ Use FirstThat iterator to search non-key field }

procedure SearchPhone(C: PCollection; PhoneToFind: String);

var
  FoundClient: PClient;

  function PhoneMatch(Client: PClient): Boolean;{$ifndef FPC}far;{$endif}
  begin
    PhoneMatch := Pos(PhoneToFind, Client^.Phone^) <> 0;
  end;

begin { SearchPhone }
  Writeln;
  FoundClient := C^.FirstThat(@PhoneMatch);
  if FoundClient = nil then
    Writeln('No client met the search requirement')
  else
  begin
    Writeln('Found client:');
    FoundClient^.Print;
  end;
end;


var
  ClientList : PCollection;
  S : TDosStream;
begin
  RegisterObjects;
  RegisterType(RClient);

  ClientList := New(PCollection, Init(10, 5));

  { Build collection }
  with ClientList^ do
  begin
    Insert(New(PClient, Init('91-100', 'Anders, Smitty', '(406) 111-2222')));
    Insert(New(PClient, Init('90-167', 'Smith, Zelda', '(800) 555-1212')));
    Insert(New(PClient, Init('90-167', 'Smith, Amber', '(800) 535-1942')));
    Insert(New(PClient, Init('90-177', 'Smitty, John', '(406) 987-4321')));
    Insert(New(PClient, Init('90-160', 'Johnson, Agatha', '(302) 139-8913')));
  end;

  { Use ForEach iterator to print all }
  PrintAll(ClientList);

  { Use FirstThat iterator to find match with search pattern }
  SearchPhone(ClientList, '(800)');

  { Save to disk }
  S.Init('doscol.dat', stCreate);

  S.Put(ClientList);
  S.Close;

  { Clean up }
  Dispose(ClientList, Done);
  ClientList:=NIL;

  { Reload }
  S.Open(stOpenRead);
  ClientList:=PCollection(S.Get);
  S.Close;
  S.Done;

  PrintAll(ClientList);
end.
