
{*******************************************************}
{                                                       }
{       Graphics Vision Unit                            }
{                                                       }
{       Copyright (c) 1996 Stefan Milius                }
{       Copyright (c) 1997, 1999 Matthias K"oppe        }
{                                                       }
{*******************************************************}

{ $Id$ }

Unit GVLight;

{$ifndef FPK}
{$A+,B-,F+,G+,I-,O+,P-,Q-,R-,S-,T-,V+,X+}
{$endif}

Interface

Uses Drivers, GVViews;

type

  PLightShow = ^TLightShow;
  TLightShow = object(TGView)
                 constructor Init;
                 destructor Done; virtual;
                 procedure Draw; virtual;
                 procedure HandleEvent(var Event: TEvent); virtual;
               private
                 Old, KeyState: Byte;
               end;

Implementation

{$ifdef FPK}
uses Objects, GvFPK;
{$else}
{$ifdef Windows}
uses WinTypes, WinProcs, WinGr, Objects;
{$else !Windows}
Uses Objects, MyMouse;
{$endif}
{$endif}

{$ifdef FPK}

procedure SetShiftState(AState: Byte; Enable: Boolean);
begin
end; { SetShiftState }

{$else !FPK}
var
  ShiftState: Byte absolute $40:$17;

{$ifdef Windows}
const
  vk_Scroll = $91;

procedure SetShiftState(AState: Byte; Enable: Boolean);
var
  State: TKeyboardState;

  procedure Change(VK: Byte);
  begin
    Char(State[VK]) := Char(Enable);
  end;

begin
  GetKeyboardState(State);
  if AState and kbScrollState <> 0 then Change(vk_Scroll);
  if AState and kbCapsState <> 0 then Change(vk_Capital);
  if AState and kbNumState <> 0 then Change(vk_NumLock);
  SetKeyboardState(State);
end;
{$else !Windows}
procedure SetShiftState(AState: Byte; Enable: Boolean); assembler;
asm
	MOV	ES,Seg0040
        MOV	AL, AState
	MOV	BL, Enable
        OR	BL, BL
        JZ	@@1
        OR	ES:ShiftState, AL
        JMP	@@2
@@1:    NOT	AL
        AND     ES:ShiftState, AL
@@2:	MOV	AH, 1
	INT	16H
end;
{$endif !Windows}
{$endif !FPK}

(****************************** TLightShow object *************************)

constructor TLightShow.Init;
var R: TRect;
Begin
  R.Assign(0,0,0,0);
  inherited Init(R);
  EventMask := EventMask or evTimer;
  Old := GetShiftState and $70;
  SetShiftState($70, false);
  KeyState := kbScrollState;
  SetShiftState(KeyState, true);
End;

destructor TLightShow.Done;
Begin
  SetShiftState($70, false);
  SetShiftState(Old, true);
  inherited Done;
End;

procedure TLightShow.Draw;
Begin End;

procedure TLightShow.HandleEvent(var Event: TEvent);
Begin
  If (Event.What = evTimer) and (Event.InfoWord mod 8 = 0) then Begin
    SetShiftState(KeyState, false);
    Case KeyState Of
      kbScrollState, kbNumState: KeyState := KeyState shl 1;
      kbCapsState: KeyState := kbScrollState;
    End;
    SetShiftState(KeyState, true)
  End
End;

End.
