unit GvMouse;

{ Graphics Vision: Mouse emulation

  This unit is intended for use with systems that don't supply
  a mouse cursor, i.e. it is only used in FPC.

  Copr. 1997,1999 Matthias K"oppe

  $Id: gvmouse.pas 1.3 1999/02/11 13:45:49 mkoeppe Exp $
}

interface

{$ifdef FPK}
uses Objects, Drivers, Views, GvViews, BGI;
{$else}
uses Objects, Drivers, Views, GvViews;
{$endif}

type
  PMouse = ^TMouse;
  TMouse = object(TGView)
    constructor Init(var Bounds: TRect);
    procedure Draw; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
{$ifndef Linux}
{    procedure HideDrawClipped(Vis: PVis; VisOwner: PGView); virtual;}
{$endif}
    procedure GetShape(Num: Integer; var Spot: TPoint;
		       var ShapeLS, ShapeRS, ShapeLP, ShapeRP: Integer); virtual;
    end;						      

implementation

{$ifdef FPK}
uses GvFPK, ExtGraph;
{$else}
uses MetaGr;
{$endif}

constructor TMouse.Init(var Bounds: TRect);
begin
  inherited Init(Bounds);
  {EventMask := EventMask or evMouse;}
  Options := (Options or ofHoldFirst or ofStoreBack) and not ofBuffer;
  DragMode := DragMode or dmClickThru;
  SetState(sfTransparent, true);
  Hide;
end;

procedure TMouse.Draw;
var
  Spot: TPoint;
  ShapeLS, ShapeRS, ShapeLP, ShapeRP: Integer;
begin 
  if not GetState(sfTransparent)
  then begin
    SetFillStyle(SolidFill, DarkGray);
    Bar(0, 0, Size.X - 1, Size.Y - 1)
  end;

  GetShape(CursorNum, Spot, ShapeLS, ShapeRS, ShapeLP, ShapeRP);
  if ShapeLS >= 0 then
    DrawColIcon(Size.X div 2 - Spot.X, Size.Y div 2 - Spot.Y, ShapeLS, 0);
  if ShapeRS >= 0 then
    DrawColIcon(Size.X div 2 - Spot.X + 16, Size.Y div 2 - Spot.Y, ShapeRS, 0);
 if ShapeLP >= 0 then
    DrawColIcon(Size.X div 2 - Spot.X, Size.Y div 2 - Spot.Y, ShapeLP, 15);
  if ShapeRP >= 0 then
    DrawColIcon(Size.X div 2 - Spot.X + 16, Size.Y div 2 - Spot.Y, ShapeRP, 15);

{  SetWriteMode(XORPut);
  SetColor(White);
  Line(Size.X div 2, 0, Size.X div 2, Size.Y - 1);
  Line(0, Size.Y div 2, Size.X - 1, Size.Y div 2);
  SetWriteMode(NormalPut)}
end;

procedure TMouse.HandleEvent(var Event: TEvent);
var
  Wh: TPoint;
  G: PGGroup;
begin
  if (Event.What and evMouse <> 0) 
  then begin
    GOwner^.MakeLocal(Event.Where, Wh);
    Dec(Wh.X, Size.x div 2);
    Dec(Wh.Y, Size.y div 2);
    MoveTo(Wh.X, Wh.Y);
    if GOwner^.First <> @Self then begin
      { Stay very on top, i.e. even on top of `stay-on-top' views }
      G := GOwner;
      G^.Delete(@Self);
      G^.Insert(@Self);
    end;
    Show
  end
end;

{$ifndef LINUX}
{procedure TMouse.HideDrawClipped(Vis: PVis; VisOwner: PGView);
begin
  DrawClipped(Unraw(Vis), VisOwner)
end;}
{$endif}

procedure TMouse.GetShape(Num: Integer; var Spot: TPoint;
			  var ShapeLS, ShapeRS, ShapeLP, ShapeRP: Integer);
begin
  case Num of
    mcStd:
	  begin
	    Spot.X := 0; Spot.Y := 0;
	    ShapeLS := 50; ShapeRS := -1;
	    ShapeLP := 51; ShapeRP := -1
	  end;
    mcLargeCross,
    mcCross:
	    begin 
	      Spot.X := 8; Spot.Y := 8;
	      ShapeLS := 52; ShapeRS := -1;
	      ShapeLP := 53; ShapeRP := -1
	    end;
    mcHourGlass:
		begin
		  Spot.X := 7; Spot.Y := 13;
		  ShapeLS := 54; ShapeRS := -1;
		  ShapeLP := 55; ShapeRP := -1
		end;
    mcMove:
	    begin
	      Spot.X := 15; Spot.Y := 11;
	      ShapeLS := 56; ShapeRS := 57;
	      ShapeLP := 58; ShapeRP := 59
	    end;
    mcResizeDnRi:
		 begin
		   Spot.X := 6; Spot.Y := 6;
		   ShapeLS := 60; ShapeRS := -1;
		   ShapeLP := 61; ShapeRP := -1
		 end;
    mcResizeDnLe:
		 begin
		   Spot.X := 6; Spot.Y := 6;
		   ShapeLS := 62; ShapeRS := -1;
		   ShapeLP := 63; ShapeRP := -1
		 end;
    mcResizeVert:
		 begin
		   Spot.X := 5; Spot.Y := 8;
		   ShapeLS := 64; ShapeRS := -1;
		   ShapeLP := 65; ShapeRP := -1
		 end;
    mcResizeHori:
		 begin
		   Spot.X := 9; Spot.Y := 5;
		   ShapeLS := 66; ShapeRS := 67;
		   ShapeLP := 68; ShapeRP := 69
		 end;
    mcInput:
	    begin
	      Spot.X := 4; Spot.Y := 8;
	      ShapeLS := 70; ShapeRS := -1;
	      ShapeLP := 71; ShapeRP := -1
	    end;
  else begin
    Spot.X := 0; Spot.Y := 0;
    ShapeLS := 50; ShapeRS := -1;
    ShapeLP := 51; ShapeRP := -1
  end;
  end;
end; { TMouse.GetShape }

end.




