//
// scatter_bowash.c: produces an pgm file of ellipse area_orientation counts. 
//

#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <math.h>
#include <string.h>

#define DBX(x) 

#define max(x,y) ((x) > (y) ? (x):(y))
#define min(x,y) ((x) < (y) ? (x):(y))

extern "C++"
{
void accum2(unsigned char* angle, unsigned char* strength, int num_rows, int num_cols, int mag_thres,
            float x_left, float x_right, float y_bottom, float y_top,
	    float area0, float area1, float orient0, float orient1,
	    int *score, int narea, int norient, int search_box_width, int search_box_height,
	    int use_ecc, float ecc_max, int use_centers, float centers_box, struct center_collection *myCenters);
  /*
  void ash2(int mx, int my, int kx, int ky, int npie,
	  float x0 , float x1, float y0, float y1, 
	  float* score, int nx, int ny, float* ash);
  */
}

#define PI 3.141592653589793
#define TINY (exp(-10.0))
#define BIG 1.0e+16
#define BIG_LAM (800.0)

#define MAX_AREA (0.2)
//#define MIN_AREA (0.005)
//#define MAX_ECC 4.0

#include"coord_fcn.cc"

int in_range(int i,int n,int j,int m)
{
if((i>0)&&(i<n)&&(j>0)&&(j<m))
   return 1;
else 
   return 0;
}

int in_rangeA(int i,int n,int j,int m)
{
if((i>0)&&(i<n)&&(j>0)&&(j<m))
   return 1;
else 
   return 0;
}

float n_fabs(float x)
{
if( x < 0.0)
   return -x;
else
   return x;
}

void convert_indx(int indx,int *i,int *j,int ny)
{
*j=indx%ny;
*i=(indx-*j)/ny;
}

inline float deg2rad(float x)
{
  return x*PI/180.0;
}

inline float rad2deg(float x)
{
  return x*180.0/PI;
}

/*
static int icomp(const void* x, const void* y)
{
  int a = (int)((int *)x);
  int b = (int)((int *)y);
  printf("x:%d  a:%d  y:%d  b:%d\n",x,a,y,b);
  if(a > b)
     return 1;
  else if(a<b)
     return -1;
  else
     return 0;
}
*/
#include "indexx_int.c"

inline indx2(int i, int I, int j, int J, int k, int K)
{
  i = min(max(i,0),I-1);
  j = min(max(j,0),J-1);
  k = min(max(k,0),K-1);
  return (i*J+j)*K+k;
}

inline indx(int i, int I, int j, int J)
{
  if (i < 0 || i >= I || j < 0 || j >= J)
    {
      cerr << "Indx out of range!" << endl;
      exit(-1);
    }
  return (i*J+j);
}

inline indxpm(int i, int I, int j, int J)
{
// Assume that index ranges from -I/2,...,-1,,0,1,...,I/2 etc.
// I, J, must be odd.
  int I2 = I/2, J2 = J/2;
  i = min(max(i,-I2),I2) + I2;
  j = min(max(j,-J2),J2) + J2;
  return (i*J+j);
}


// header for strength and orientation files
struct header {
  int rows;
  int cols;
};

int getline_aux (FILE *file, char *buffer, unsigned int n)
{
  int reading = 0;
  while (!reading) {
    if (!fgets (buffer, n, file))
      return 0;
    reading = (buffer [0] != '#');
  }
  return 1;
}

void error(char *msg)
{
  fprintf(stderr, "canny: error in %s\n",msg);
  exit(-1);
}

int fwrite_header(FILE * fp, struct header * hd)
{
  fprintf(fp,"%s\n","P5");
  fprintf(fp,"%d %d\n", hd->cols, hd->rows);
  fprintf(fp,"%d\n",255);
  return 1;
}

int fread_header(FILE * fp, struct header * hd)
{
  int maxgray;
  char buf2[3];
  char buf[256];
  
  if (!getline_aux (fp, buf, 256) || (sscanf(buf, "%s", buf2) != 1))
    error("fread_header: first line");
  
  if (strcmp(buf2,"P5") !=0)
    error("fread_header: Not a raw PGM file");

  if (!getline_aux (fp, buf, 256) || (sscanf(buf, "%d %d", &(hd->cols),&(hd->rows)) != 2))
    error("fread_header: couldn't read X Y");

  if (!getline_aux (fp, buf, 256) || (sscanf(buf, "%d", &maxgray) != 1))
    error("fread_header: couldn't read maxgray");

  if (maxgray > 255)
    error("fread_header: maxgray > 255");
  
  return 1;
}

// Objects used in the localmax section of the code
struct cell
{
  int icoord;
  int jcoord;
  int val;
};

int sgn(int x)
{
if(x < 0)
  return -1;
else if (x == 0)
  return 0;
else
  return 1;
}

static int cellcmpr(const void* x, const void* y)
{
  int vx = ((const cell *)x)->val;
  int vy = ((const cell *)y)->val;
  return sgn(vy-vx);
}


struct center
{
float x_center;
float y_center;
};

struct center_collection
{
struct center *centers;
int num_centers;
};


main(int argc, char** argv)
{
  int i;

//
// Read the flags.
//
  // default values.
  // setup is for ellipses in [0 1]^2 with area < 1/2
  int narea = 100, norient = 100;  // number of cells in acc array for each property
  float area0 = 0.0, area1 = 1.0;
  float orient0 = -PI/2.0, orient1 = PI/2.0;
  int search_box_width = 25;
  int search_box_height = 25;
  float ecc_max= 500.0;
  int nedges = -1;
  int thres = 1;
  int use_ecc = 0;
  int use_centers = 0;
  float centers_box = 500.0;
  struct center_collection myCenters;

  // start reading the flags.
  for(i = 1; i < argc; i++)
    {
      if(argv[i][0] == '-')
	{
	  switch(argv[i][1])
	    {
	    case '?':
	    case 'H':
	    case 'h':
	      cerr << "Usage: " << argv[0] << endl;
	      cerr << "[-a0 float: starting area (default = 0 )]" << endl;
	      cerr << "[-a1 float: ending area (default = 1.0)]" << endl;
	      cerr << "[-na int  : # of area quantization cells (default=100)]" << endl;
	      cerr << "[-o0 float: starting orientation angle (default = -PI/2 radians)]" << endl;
	      cerr << "[-o1 float: ending orientation angle (default = PI/2 radians)]" << endl;
	      cerr << "[-no int  : # of orientation quantization cells (default=100)]" << endl;
	      cerr << "[-e int   : # of edges for houghing (default=0.01*npixels)]" << endl;
	      cerr << "[-t int (0...255) : threshold value of edge strength for houghing, only works with -e 0 (default=1.0)]" << endl;
	      cerr << "[-Bw int: EDGE Pair Search Box Width (default = 25 pixels)]" << endl;
	      cerr << "[-Bh int: EDGE Pair Search Box Height (default = 25 pixels)]" << endl;
	      cerr << "[-m float: max eccentricity (default= infinity)]" << endl;
	      cerr << "[-c float: quality of distance information(default= infinity)]" << endl;
	      cerr << "input gradient angle filename" << endl;
	      cerr << "input gradient magnitude filename" << endl;
	      cerr << "input centers filename" << endl;
	      cerr << "output core filename" << endl;
	      exit(1);
	      break;
	    case 'a':
	      if (i++ < argc)
		{
		  if (argv[i-1][2] == '0')
		    area0 = atof(argv[i]);
		  else
		    area1 = atof(argv[i]);
		}
	      break;
	    case 'o':
	      if (++i < argc)
		{
		  if (argv[i-1][2] == '0')
		    orient0 = atof(argv[i]);
		  else
		    orient1 = atof(argv[i]);
		}
	      break;
	    case 'B':
	      if (++i < argc)
		{
		  if (argv[i-1][2] == 'h')
		    search_box_height = atoi(argv[i]);
		  else
		    search_box_width = atoi(argv[i]);
		}
	      break;
	    case 'n':
	      if (++i < argc)
		switch (argv[i-1][2])
		  {
		  case 'a':
		    narea = atoi(argv[i]);
		    break;
		  case 'o':
		    norient = atoi(argv[i]);
		    break;
		  default:
		    cerr << argv[i-1] << ": Unknown flags." << endl;
		    exit(-1);
		    break;
		  }
	      break;
	    case 'e':
	      if (++i < argc)
		nedges = atoi(argv[i]);
	      break;
	    case 't':
	      if (++i < argc)
		thres = atoi(argv[i]);
	      break;
	    case 'm':
	      if (++i < argc)
		{
		ecc_max = atof(argv[i]);
		use_ecc = 1;
		}
	      break;
	    case 'c':
	      if (++i < argc)
		{
		centers_box = atof(argv[i]);
		use_centers = 1;
		}
	      break;
	    default:
	      cerr << argv[i] << ": Unknown flags." << endl;
	      exit(-1);
	      break;
	    }
	}
      else
	break;
    }

//
// Read the filenames.
//
  char *angfile, *magfile, *centersfile, *outfile;
  if (i < argc)
    angfile = argv[i++];
  if (i < argc)
    magfile = argv[i++];
  if(use_centers == 1)
      {
	if (i < argc)
	    centersfile = argv[i++];
      }
  if (i < argc)
    outfile = argv[i++];

  if (i < argc)
    {
      cerr << "Too many arguments." << endl;
      exit(-1);
    }

// Load the orientation and magnitude files.
unsigned char *ang,*mag;
struct header ang_fh,mag_fh;
FILE *fp;

fp = fopen(angfile,"r");
fread_header(fp,&ang_fh);
printf("ang: rows:%d  cols:%d\n",ang_fh.rows,ang_fh.cols);
int picsize=ang_fh.cols*ang_fh.rows;
ang=(unsigned char *)calloc(picsize,1);
fread(ang,picsize,1,fp);
fclose(fp);

// test picture
fp = fopen("angle.pgm","w");
fwrite_header(fp,&ang_fh);
fwrite(ang,picsize,1,fp);
fclose(fp);


fp = fopen(magfile,"r");
fread_header(fp,&mag_fh);
printf("mag: rows:%d  cols:%d\n",mag_fh.rows,mag_fh.cols);
if((ang_fh.cols != mag_fh.cols)&&(ang_fh.rows != mag_fh.rows))
    error("angle and mag file sizes don't match");
mag=(unsigned char *)calloc(picsize,1);
fread(mag,picsize,1,fp);
fclose(fp);

// test picture
fp = fopen("mag.pgm","w");
fwrite_header(fp,&ang_fh);
fwrite(mag,picsize,1,fp);
fclose(fp);


//
// Open the centers file if it exists
//
if(use_centers)
     {
     fp = fopen(centersfile,"r");
     fscanf(fp,"%d",&(myCenters.num_centers));
     printf("num_centers:%d\n",myCenters.num_centers);
     myCenters.centers = (struct center *)calloc(myCenters.num_centers, sizeof(struct center));
     for(i = 0; i < myCenters.num_centers; ++i)
         {
	   fscanf(fp,"%f",&(myCenters.centers[i].x_center));
	   fscanf(fp,"%f",&(myCenters.centers[i].y_center));
	   printf("x:%f  y:%f\n",myCenters.centers[i].x_center,myCenters.centers[i].y_center);
	 }
     }


// determine number of edges to include in the Hough Accumulation Step
  if (nedges == -1)
    nedges = 0.01*picsize;
  if (nedges != 0)		// if nedges==0, then use default thres.
    {
      int *tmp = new int[picsize+20];
      int *indx = new int[picsize+20];
      for (i = 0; i < picsize; i++)
	{
	tmp[i] = mag[i];
	//        if(mag[i] != 0)
	//            printf("tmp:%d  mag:%d\n",tmp[i],mag[i]);
	}

      indexx_int(picsize,tmp,indx);
      //      qsort((char*)tmp, picsize, sizeof(int), icomp);

      thres = (int)(tmp[indx[picsize - nedges]]);
      cerr << "Max coherency: " << tmp[indx[0]] << endl;
      cerr << "Min coherency: " << tmp[indx[picsize-1]] << endl;


      /*
      for(i = 0; i < 10; ++i)
         tmp[i] = 10-i;
      */
      

      delete tmp;
    }

  cerr << "Edge threshold used: " << thres << " number of edges: " << nedges << endl;

//
// Allocate and initialize the cube.
//
  int ncells = narea*norient;
  int *score = new int[ncells+20];
  //  float *ash = new float[ncells+20];
  for (i = 0; i < ncells; i++)
    score[i]=0; 

//
// Present area/orient accumulator array parameters.
//
  cerr << "(area0,area1,narea,darea) = (" << area0 << "," << area1 << "," << narea << "," 
    << (area1-area0)/float(narea-1) <<    ")" << endl;
  cerr << "(orient0,orient1,norient,dorient) = (" << orient0 << "," << orient1 << "," << norient << ","
    << (orient1-orient0)/float(norient-1) << ")" << endl;

//
// Main call here.
//
  accum2(&ang[0], &mag[0], ang_fh.rows, ang_fh.cols, thres,
         0.0, 1.0, 0.0, 1.0,
	 area0, area1, orient0, orient1,
	 score, narea, norient,
	 search_box_width, search_box_height, use_ecc, ecc_max, use_centers, centers_box, &myCenters);

  int rmax = 0;
  int imax,jmax;
  for(i = 0; i < ncells; ++i)
     if(score[i] > rmax)
       {
	  convert_indx(i,&imax,&jmax,norient);
          rmax = score[i];
       }

  unsigned char *acc_array = new unsigned char[ncells];
  for(i = 0; i < ncells; ++i)
       acc_array[i] = (unsigned char)(255 * score[i] / rmax);

  cerr << "Max counts in score: " << rmax << endl;
  cerr << "max score: AREA: " << ((float(imax)-0.5)*(area1-area0)/float(narea-1)+area0) << endl;
  cerr << "max score: ORIENT: " << ((float(jmax)-0.5)*(orient1-orient0)/float(norient-1)+orient0) << endl;


  //
  // determine and rank the localmaxima
  //
  int *lmlist = new int[ncells];
  for (i = 0; i < ncells; i++)
       lmlist[i] = 0;
  int ind,j,l, jstep = norient, nn[26], istrong, iweak;
  for (i = 1; i < narea-1; i++)
    for (j = 1; j < norient-1; j++)
	{
	  //ind = (k*nazm+j)*ndip+i;
	  ind = (i*norient+j);
	  nn[0] = ind-1;
	  nn[1] = ind+1;
	  nn[2] = ind-jstep;
	  nn[3] = nn[2]-1;
	  nn[4] = nn[2]+1;
	  nn[5] = ind+jstep;
	  nn[6] = nn[5]-1;
	  nn[7] = nn[5]+1;

	  // check the local max in the strong & weak sense.
	  istrong = iweak = 0;
	  for (l = 0; l < 8; l++)
	    {
	      if (score[ind] > score[nn[l]])
		istrong++;
	      if (score[ind] >= score[nn[l]])
		iweak++;
	    }
	  if (iweak==8 && istrong >= 7) // allow two maxima in the neighbor.
	    lmlist[ind] = 1;
	}

//
// Index the local max score
//
  int count = 0;
  for (i = 0; i < ncells; i++)
    if (lmlist[i] == 1)
      count++;
  int nmax = count;
  cerr << "The number of local maxima: " << nmax << endl;
  cell *maxcells = new cell[nmax];

  count = 0;
  for (i = 1; i < narea-1; i++)
    for (j = 1; j < norient-1; j++)
	{
	  // ind = (k*nazm+j)*ndip+i;
	  ind = (i*norient+j);
	  if (lmlist[ind] == 1)
	    {
	      maxcells[count].val = score[ind];
	      maxcells[count].icoord = i;
	      maxcells[count].jcoord = j;
	      count++;
	    }
	}
	
//
// Sort them in a decreasing order and display them.
//
  qsort((char*)maxcells, nmax, sizeof(cell), cellcmpr);

  printf("top ten\n");
  for(i = 0; i < 10; ++i)
      {
	printf("%f(%d)  %f(%d)  %d\n",(float)(maxcells[i].icoord)/(float)(narea - 1) * (area1-area0)+area0,maxcells[i].icoord,(float)(maxcells[i].jcoord)/(float)(norient - 1) * (orient1-orient0) + orient0,maxcells[i].jcoord,maxcells[i].val);
      }

//
// Output accumulator array
//
  printf("outfile:%s\n",outfile);
  struct header res_fh;
  res_fh.rows = narea;
  res_fh.cols = norient;
  fp = fopen(outfile,"w");
  fwrite_header(fp,&res_fh);
  fwrite(acc_array,res_fh.rows*res_fh.cols,1,fp);
  fclose(fp);


}


void accum2(unsigned char* angle, unsigned char* strength, int num_rows, int num_cols, int thres,
            float x_left, float x_right, float y_bottom, float y_top,
	    float area0, float area1, float orient0, float orient1,
	    int *score, int narea, int norient, int search_box_width, int search_box_height,
	    int use_ecc, float ecc_max, int use_centers, float centers_box, struct center_collection *myCenters)
//
//	Input arguments:
//		float *mag: magnitudes of edges. mag[i,j] >=0.0.
//		float *arg: arguments of edges. -pi <= arg[i,j] <= pi.
//		int nr, nc: number of rows and cols of mag, arg.
//
//		float thres: magnitude threshold value for voting.
//
//		float x0, x1: parameter range of accum. array in x 
//		float y0, y1: parameter range of accum. array in y 
//
//		int nx, ny: size of the accumurator array.
//
//	Output argument:
//		int *score: accumurator array of size (nx,ny).
//		
{

  // Image space cell ranges and units.
  float dx = (x_right-x_left)/float(num_cols);
  float dy = (y_top-y_bottom)/float(num_rows);
  cerr << "dx " << dx << " dy " << dy << endl;

  // internal parameters
  int num_rows_in_box = search_box_height;
  int num_cols_in_box = search_box_width / 2;  // we work with the left and right side of box
  
  int i,k;

  // Parameter space cell ranges and units.
  // (x,y) represents position of center of ellipse. 
  float darea = (area1-area0)/float(narea);
  float dorient = (orient1-orient0)/float(norient);

  int val;  // value assigned to a pair of edges

  int row0, col0,row1, col1, count = 0, row0_ind, row1_ind;

  int ioldbox, joldbox;
  int inewbox, jnewbox;

  //  float x, y, z, d, p, s,d_1, p_1, s_1;
  float x0,y0,p0,q0,x1,y1,p1,q1;
  float slope0,slope1;
  float a_calc,b_calc,c_calc,f_calc,g_calc,h_calc;
  float area_calc, orient_calc;
  float xcenter_calc, ycenter_calc;
  float ecc_calc;

  float dlam,lam0,lam,lam_upper;
  int nlam=300,range_flag=0;
  int in_box = 0;
  int ecc_ok = 0;

  for (row0 = 0; row0 < num_rows; row0++)
    //  for (row0 = num_rows/2-25; row0 < num_rows/2 + 10; row0++)
      {
	row0_ind = row0*num_cols;
	for (row1 = row0 + 5 ; row1 < min(num_rows, row0 + num_rows_in_box); row1++)
	     {
	       row1_ind = row1*num_cols;

	       for (col0 = 0; col0 < num_cols; col0++)
		 //	       for (col0 = num_cols/2 - 10; col0 < num_cols/2 + 10; col0++)
		   {
		   for (col1 = max(0, col0 - num_cols_in_box); col1 < min(col0+num_cols_in_box, num_cols); col1++)
		       {

			 if((row0==row1)&&(col0>=col1))
			   continue;
                         if( ((int)(strength[row0_ind + col0]) < thres) || ((int)(strength[row1_ind + col1]) < thres) )
			   continue;

			 val = (int)strength[row0_ind + col0] + (int)strength[row1_ind + col1];
			 //			 val = 1;
 
			 // position and slope info from angle file.
			 count++;

			 x0 = x_left + dx * (float)(col0);
			 y0 = y_bottom + dy * (float)(row0);
			 x1 = x_left + dx * (float)(col1);
			 y1 = y_bottom + dy * (float)(row1);


DBX(		      printf("x0:%f  y0:%f  x1:%f  y1:%f\n",x0,y0,x1,y1);
		      printf("col0:%d  row0:%d  col1:%d  row1:%d\n",col0,row0,col1,row1);)


  		      // compute slopes of the orientation edges (recall tan(a + pi/2) = -1/tan(a))
		      slope0 = (dx/dy) * tan(1.0/40.0*((int)(angle[row0_ind+col0]) - 128) ); // slope
		      slope1 = (dx/dy) * tan(1.0/40.0*((int)(angle[row1_ind+col1]) - 128) ); // slope

  /*
		      slope0 = -1.0/( (dx/dy) * tan(1.0/40.0*((int)(angle[row0_ind+col0]) - 128) ) ); // slope
		      slope1 = -1.0/( (dx/dy) * tan(1.0/40.0*((int)(angle[row1_ind+col1]) - 128) ) ); // slope
  */


DBX(		      printf("angle0:%d  slope0:%f  angle1:%d  slope1:%f\n",angle[row0_ind+col0],slope0,angle[row1_ind+col1],slope1);)

		      // determine p0,q0,p1,q1 to satisfy quadrant condition
		      p0 = 1.0;
		      q0 = slope0;
		      if( ( p0 * (x1 - x0) + q0 * (y1 - y0) ) < 0.0 )
			   {
			     p0 = -p0;
			     q0 = -q0;
			   }			     
		      p1 = 1.0;
		      q1 = slope1;
		      if( ( p1 * (x0 - x1) + q1 * (y0 - y1) ) < 0.0 )
			   {
			     p1 = -p1;
			     q1 = -q1;
			   }	
DBX(x0=4.0; y0=1.0;p0=-0.25; q0=1.0; x1=1.0; y1=5.0;p1=1.0;q1=-0.3;)

DBX(printf("p0:%f  q0:%f  p1:%f  q1:%f\n",p0,q0,p1,q1);)

                      //determine lambda range  |lam1| < |lam0|
                      lam0= lambda_range( x0, y0, p0, q0, x1, y1, p1, q1)/1.01;
DBX(                      cerr << "lam0: " << lam0 << endl;)

		      /*                  
                      if((lam0>BIG_LAM)||(lam0<-BIG_LAM))
			{
//                          cerr << "lam0 out of range" << endl;  
                          continue;
			}
		      */
		      intermed_calc( x0, y0, p0, q0, x1, y1, p1, q1, lam0,
					 &a_calc,&b_calc,&c_calc,&f_calc,&g_calc,&h_calc);

                      if(area(a_calc,b_calc,c_calc,f_calc,g_calc,h_calc)>MAX_AREA)
                          {
                          lam_upper=lam0;
                          while(area(a_calc,b_calc,c_calc,f_calc,g_calc,h_calc)>MAX_AREA)
                              {
                              lam_upper/=1.001;
			      intermed_calc( x0, y0, p0, q0, x1, y1, p1, q1, lam_upper,
					 &a_calc,&b_calc,&c_calc,&f_calc,&g_calc,&h_calc);
			      }

			  }
                       else
                          {
                          lam_upper=lam0;
			  }

		      intermed_calc( x0, y0, p0, q0, x1, y1, p1, q1, lam_upper,
				     &a_calc,&b_calc,&c_calc,&f_calc,&g_calc,&h_calc);
DBX(                      cerr << "lam_upper: " << lam_upper << " area: " << area(a_calc,b_calc,c_calc,f_calc,g_calc,h_calc) << endl;)


                       dlam=(lam_upper)/(float)(nlam);

                      // determine starting box for lam=dlam
                      lam=dlam;
		      intermed_calc( x0, y0, p0, q0, x1, y1, p1, q1, lam,
				     &a_calc,&b_calc,&c_calc,&f_calc,&g_calc,&h_calc);

		      
		      // calculate and test whether this center agrees to a certain tolerance with one we
		      // have on file
		      if(use_centers)
			   {
			     center(&xcenter_calc,&ycenter_calc,a_calc,b_calc,c_calc,f_calc,g_calc,h_calc);
			     in_box = 0;
			     for(i = 0; i < myCenters->num_centers; ++i)
			          {
			          if((n_fabs(xcenter_calc - myCenters->centers[i].x_center) < centers_box) && 
				     (n_fabs(ycenter_calc - myCenters->centers[i].y_center) < centers_box))
				           in_box = 1;
				  }
			   }
		      
		      if(use_ecc)
			   {
			     ecc_calc = eccen(a_calc,b_calc,c_calc,f_calc,g_calc,h_calc);
			     if((ecc_calc < ecc_max) && (ecc_calc > 1.0))
			          ecc_ok = 1;
			     else
			          ecc_ok = 0;
			   }


		      area_calc = area(a_calc,b_calc,c_calc,f_calc,g_calc,h_calc);
		      orient_calc = orientation(a_calc,b_calc,c_calc,f_calc,g_calc,h_calc);

		      ioldbox = (int)((area_calc-area0)/darea);
		      joldbox = (int)((orient_calc-orient0)/dorient);

		      /*
                      if((in_range(ioldbox,ny,joldbox,nx))&&
                            (eccen(a_calc,b_calc,c_calc,f_calc,g_calc,h_calc)<1.4)&&
                            (eccen(a_calc,b_calc,c_calc,f_calc,g_calc,h_calc)>1.0))
			{
   		          score[ioldbox*nx+joldbox] += 
			      (val*wpie[abs(l)]*wpos[m]);
			}
		      */
		      
/*
		      printf("cond:%d\n",
			 ( ( (ecc_ok == 1) || (use_ecc == 0) ) &&
			   ( (in_box == 1) || (use_centers == 0) ) ) );
*/
 		      if((in_rangeA(ioldbox,narea,joldbox,norient)) &&
			 ( (ecc_ok == 1) || (use_ecc == 0) ) &&
			 ( (in_box == 1) || (use_centers == 0) ) )
			      score[ioldbox*norient+joldbox] += val;
/*
		      if(use_ecc == 1)
			  {
			    if((in_range(ioldbox,narea,joldbox,norient))&&(ecc_ok == 1))
			      score[ioldbox*norient+joldbox] += val;
			  }
		      else
			  {
			    if((in_range(ioldbox,narea,joldbox,norient))&&(in_box == 1))
			      score[ioldbox*norient+joldbox] += val;
			  }
*/

                      for(k=1;k<nlam;++k)
		  	   {
                           lam+=dlam;
			   intermed_calc( x0, y0, p0, q0, x1, y1, p1, q1, lam,
				     &a_calc,&b_calc,&c_calc,&f_calc,&g_calc,&h_calc);
			   area_calc = area(a_calc,b_calc,c_calc,f_calc,g_calc,h_calc);
			   orient_calc = orientation(a_calc,b_calc,c_calc,f_calc,g_calc,h_calc);

		      // calculate and test whether this center agrees to a certain tolerance with one we
		      // have on file
		      if(use_centers)
			   {
			     center(&xcenter_calc,&ycenter_calc,a_calc,b_calc,c_calc,f_calc,g_calc,h_calc);
			     in_box = 0;
			     for(i = 0; i < myCenters->num_centers; ++i)
			          {
			          if((n_fabs(xcenter_calc - myCenters->centers[i].x_center)<centers_box) && 
				     (n_fabs(ycenter_calc - myCenters->centers[i].y_center) < centers_box))
				           in_box = 1;
				  }
			   }
		      
		      if(use_ecc)
			   {
			     ecc_calc = eccen(a_calc,b_calc,c_calc,f_calc,g_calc,h_calc);
			     if((ecc_calc < ecc_max) && (ecc_calc > 1.0))
			          ecc_ok = 1;
			     else
			          ecc_ok = 0;
			   }

			   inewbox = (int)((area_calc-area0)/darea);
			   jnewbox = (int)((orient_calc-orient0)/dorient);
			   /*
                           center(&x,&y,a_calc,b_calc,c_calc,f_calc,g_calc,h_calc);
                           inewbox=(int)((y-y0)/dy);
                           jnewbox=(int)((x-x0)/dx);
			   */

             		  // test this new box.
                           if((abs(inewbox-ioldbox)+abs(jnewbox-joldbox))>0)
                                {
				  //printf("area:%f %d  orient:%f %d\n",area_calc,inewbox,orient_calc,jnewbox);

				  if((in_range(inewbox,narea,jnewbox,norient)) &&
				     ( (ecc_ok == 1) || (use_ecc == 0) ) &&
				     ( (in_box == 1) || (use_centers == 0) ) )
				      {
					ioldbox=inewbox;
					joldbox=jnewbox;
					score[ioldbox*norient+joldbox] += val;
				      }

				}
			   }
		       
		       fprintf(stderr, "%6d\b\b\b\b\b\b", count);
		       } //col1
		   } //col0

	     } //row1
	    
      } //row0
	
}


/*
void ash2(int mx, int my, int kx, int ky, int npie,
	  float x0 , float x1, float y0, float y1, 
	  float* score, int nx, int ny, float* ash)
//
//	Reference:
//		D.W.Scott: Multivariate Density Estimation, Chapter 5, John
//		Wiley, 1992.
//		D.W.Scott: "Averaged Shifted Histograms: Effective 
//		nonparametric density estimators in several dimensions,"
//		Annals of Statistics, vol.13, no.3, pp.1024-1040, 1985.
//
//	Input arguments:
//		int mx, my: weighting cube size.
//		int kx, ky: smoothing factor, normally set to 2.
//		int npie: number of division of the total pie region.
//
//		float x0, x1: parameter range of accum. array in x (dip).
//		float y0, y1: parameter range of accum. array in y (azimuth).
//
//		float *score: accumurator array of size (nx,ny,nz).
//		int nx, ny: size of the accumurator array.
//
//	Output argument:
//		float *ash: smoothed accumulator array of size (nx,ny,nz).
//
{
  // Count the score matrix and initialize ash.
  int i, j, ncells = nx*ny;
  float tscore = 0.0;
  for (i = 0; i < ncells; i++)
    {
      ash[i] = 0.0;
      tscore += score[i];
    }
  cerr << "Sum counts in score: " << tscore << endl;

  // Make weighting matrix.  Assume wx[(1-mx):(mx-1)] etc.
  float *w = new float[mx*my];
  float *wx = new float[mx], *wy = new float[my];
  float sum = 1.0;
  wx[0] = wy[0] = 1.0;
  for (i = 1; i < mx; i++)
    {
      wx[i] = pow(1.0-pow(float(i)/float(mx),kx),kx);
      sum += 2*wx[i];		// counts negative part. 
    }
  sum = float(mx)/sum;
  for (i = 0; i < mx; i++)
    wx[i] *= sum;

  sum = 1.0;
  for (i = 1; i < my; i++)
    {
      wy[i] = pow(1.0-pow(float(i)/float(my),ky),ky);
      sum += 2*wy[i];		// counts negative part. 
    }
  sum = float(my)/sum;
  for (i = 0; i < my; i++)
    wy[i] *= sum;
  

  for (i = 0; i < mx; i++)
    for (j = 0; j < my; j++)
       w[indx(i,mx,j,my)] = wx[i]*wy[j];

  float rmax = -BIG, rmin = BIG;
  sum = 0.0;
  for (i = 0; i < mx*my; i++)
    {
      sum += w[i];
      if (w[i] > rmax)
	rmax = w[i];
      if (w[i] < rmin)
	rmin = w[i];
    }
  cerr << "Max weight in ash : " << rmax << endl;
  cerr << "Min weight in ash : " << rmin << endl;
  cerr << "Weight matrix size: " << mx*my << endl;
  cerr << "Sum weight in ash : " << sum << endl;
  

  // Parameter space cell ranges and units.
  // (x,y) represents (dip, azimuth) respectively. 
  float dx = (x1-x0)/float(nx-1);
  float dy = (y1-y0)/float(ny-1); // note the difference from (y1-y0)/float(ny-1)

  float hx = mx*dx;
  float hy = my*dy;

  float h = sum;

  int p, q;
  float v;
  for (i = 0; i < nx; i++)
    for (j = 0; j < ny; j++)
        {
	  v = score[indx(i,nx,j,ny)];
	  if (v != 0.0)
	    {
	      v /= h;
	      for (p = max(0, i-mx+1); p <= min(nx-1,i+mx-1); p++)
		for (q = max(0, j-my+1); q <= min(ny-1,j+my-1); q++)
		    ash[indx(p,nx,q,ny)] += 
		      v*w[indx(abs(p-i),mx,abs(q-j),my)];
	    }
	}

// Postprocessing
  delete wy;
  delete wx;
  delete w;
}

*/
	 /*
	      // repeat the counting process for fat bowtie around the given
	      // slope and position.
	      for (m = 0; m < mpos; m++)
	      for (m_1 = m; m_1 < mpos; m_1++)
		{
		  d = r0+r*dr+dr/2.0+dpos[m]; // depth
		  p = c0+c*dc+ppos[m]; // phase
		  d_1 = r0+r_1*dr+dr/2.0+dpos[m_1]; // depth
		  p_1 = c0+c_1*dc+ppos[m_1]; // phase
	 */


	 /*
		  for (l = -npie2 ; l < npie2; l++)
		  for (l_1 = l ; l_1 < npie2; l_1++)
		    {
		      s = (dr/dc)*tan(arg[rind+c]+l*dpie); // slope
		      s_1 = (dr/dc)*tan(arg[rind_1+c_1]+l_1*dpie); // slope
	 */                      




/*
                           center(&xcenter_calc,&ycenter_calc,a_calc,b_calc,c_calc,f_calc,g_calc,h_calc);
			   if(((n_fabs(xcenter_calc - 0.25)<0.05)&&(n_fabs(ycenter_calc - 0.25) < 0.05)) || ((n_fabs(xcenter_calc - 0.75)<0.05)&&(n_fabs(ycenter_calc - 0.75) < 0.05)) )
			         in_box = 1;
			   else
			         in_box = 0;

			   ecc_calc = eccen(a_calc,b_calc,c_calc,f_calc,g_calc,h_calc);
			   if((ecc_calc < ecc_max) && (ecc_calc > 1.0))
			        ecc_ok = 1;
			   else
			        ecc_ok = 0;
*/



/*
  			         if(use_ecc)
				      {
					if((in_range(inewbox,narea,jnewbox,norient)) && (ecc_ok == 1))
					     {
					       ioldbox=inewbox;
					       joldbox=jnewbox;
					       score[ioldbox*norient+joldbox]+=val;
					     }
				      }
				 else
				      {
					if((in_range(inewbox,narea,jnewbox,norient)) && (in_box == 1))
					     {
					       ioldbox=inewbox;
					       joldbox=jnewbox;
					       score[ioldbox*norient+joldbox]+=val;
					     }
				      }
*/

