//
// scatter_bowash.c: produces an pgm file of ellipse center counts with an
// eccentricity bound built into the program.
//

#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <math.h>
#include <string.h>

#define DBX(x) 

#define max(x,y) ((x) > (y) ? (x):(y))
#define min(x,y) ((x) < (y) ? (x):(y))

void draw_x(int x_center, int y_center, char *image, int lx, char marker_color);

extern "C++"
{
void accum3(unsigned char* angle, unsigned char* strength, int num_rows, int num_cols, int mag_thres,
            float x_left, float x_right, float y_bottom, float y_top,
	    float y_center0, float y_center1, float x_center0, float x_center1, float area0, float area1,
	    int *score, int ny_center, int nx_center, int narea, int search_box_width, int search_box_height, float ecc_max);
}

#define PI 3.141592653589793
#define TINY (exp(-10.0))
#define BIG 1.0e+16
#define BIG_LAM (800.0)

#define MAX_AREA (1.0)

#include"coord_fcn.cc"

int in_range(int i,int n1,int j,int n2,int k,int n3)
{
if((i>=0)&&(i<n1)&&(j>=0)&&(j<n2)&&(k>=0)&&(k<n3))
    return 1;
else
    return 0;
}

void convert_indx(int indx,int *i,int *j,int ny, int *k,int nz)
{
*k=indx%nz;
*j=((indx-*k)/nz)%ny;
*i=(((indx-*k)/nz)-*j)/ny;
}


inline float deg2rad(float x)
{
  return x*PI/180.0;
}

inline float rad2deg(float x)
{
  return x*180.0/PI;
}

/*
static int icomp(const void* x, const void* y)
{
  int a = (int)((int *)x);
  int b = (int)((int *)y);
  printf("x:%d  a:%d  y:%d  b:%d\n",x,a,y,b);
  if(a > b)
     return 1;
  else if(a<b)
     return -1;
  else
     return 0;
}
*/
#include "indexx_int.c"

/*
inline indx2(int i, int I, int j, int J, int k, int K)
{
  i = min(max(i,0),I-1);
  j = min(max(j,0),J-1);
  k = min(max(k,0),K-1);
  return (i*J+j)*K+k;
}

inline indx(int i, int I, int j, int J)
{
  if (i < 0 || i >= I || j < 0 || j >= J)
    {
      cerr << "Indx out of range!" << endl;
      exit(-1);
    }
  return (i*J+j);
}
*/

// header for strength and orientation files
struct header {
  int rows;
  int cols;
};

int getline_aux (FILE *file, char *buffer, unsigned int n)
{
  int reading = 0;
  while (!reading) {
    if (!fgets (buffer, n, file))
      return 0;
    reading = (buffer [0] != '#');
  }
  return 1;
}

void error(char *msg)
{
  fprintf(stderr, "canny: error in %s\n",msg);
  exit(-1);
}

int fwrite_header(FILE * fp, struct header * hd)
{
  fprintf(fp,"%s\n","P5");
  fprintf(fp,"%d %d\n", hd->cols, hd->rows);
  fprintf(fp,"%d\n",255);
  return 1;
}

int fread_header(FILE * fp, struct header * hd)
{
  int maxgray;
  char buf2[3];
  char buf[256];
  
  if (!getline_aux (fp, buf, 256) || (sscanf(buf, "%s", buf2) != 1))
    error("fread_header: first line");
  
  if (strcmp(buf2,"P5") !=0)
    error("fread_header: Not a raw PGM file");

  if (!getline_aux (fp, buf, 256) || (sscanf(buf, "%d %d", &(hd->cols),&(hd->rows)) != 2))
    error("fread_header: couldn't read X Y");

  if (!getline_aux (fp, buf, 256) || (sscanf(buf, "%d", &maxgray) != 1))
    error("fread_header: couldn't read maxgray");

  if (maxgray > 255)
    error("fread_header: maxgray > 255");
  
  return 1;
}

// Objects used in the localmax section of the code
struct cell
{
  int icoord;
  int jcoord;
  int kcoord;
  int val;
};

int sgn(int x)
{
if(x < 0)
  return -1;
else if (x == 0)
  return 0;
else
  return 1;
}

static int cellcmpr(const void* x, const void* y)
{
  int vx = ((const cell *)x)->val;
  int vy = ((const cell *)y)->val;
  return sgn(vy-vx);
}

main(int argc, char** argv)
{
  int i;

//
// Read the flags.
//
  // default values.
  // setup is for ellipses in [0 1]^2 with area < 1/2
  int ny_center = 100, nx_center = 100, narea = 100;  // number of cells in acc array for each property
  float y_center0 = 0.0, y_center1 = 1.0;
  float x_center0 = 0.0, x_center1 = 1.0;
  float area0 = 0.0, area1 = 1.0;
  int search_box_width = 25;
  int search_box_height = 25;
  float ecc_max= 500.0;
  int num_display = 5;
  int nedges = -1;
  int thres = 1;

  // start reading the flags.
  for(i = 1; i < argc; i++)
    {
      if(argv[i][0] == '-')
	{
	  switch(argv[i][1])
	    {
	    case '?':
	    case 'H':
	    case 'h':
	      cerr << "Usage: " << argv[0] << endl;
	      cerr << "[-y0 float: starting y_center (default = 0 )]" << endl;
	      cerr << "[-y1 float: ending y_center (default = 1.0)]" << endl;
	      cerr << "[-ny int  : # of y_center quantization cells (default=100)]" << endl;
	      cerr << "[-x0 float: starting x_center (default = 0)]" << endl;
	      cerr << "[-x1 float: ending x_center (default = 1.0)]" << endl;
	      cerr << "[-nx int  : # of x_center quantization cells (default=100)]" << endl;
	      cerr << "[-a0 float: starting area (default = 0 )]" << endl;
	      cerr << "[-a1 float: ending area (default = 1.0)]" << endl;
	      cerr << "[-na int  : # of area quantization cells (default=100)]" << endl;
	      cerr << "[-e int   : # of edges for houghing (default=0.01*npixels)]" << endl;
	      cerr << "[-t int (0...255) : threshold value of edge strength for houghing, only works with -e 0 (default=1.0)]" << endl;
	      cerr << "[-Bw int: EDGE Pair Search Box Width (default = 25 pixels)]" << endl;
	      cerr << "[-Bh int: EDGE Pair Search Box Height (default = 25 pixels)]" << endl;
	      cerr << "[-m float: max eccentricity (default= infinity)]" << endl;
	      cerr << "[-d int: number of center_area results to display (default= 5)]" << endl;
	      cerr << "input image filename" << endl;
	      cerr << "input gradient angle filename" << endl;
	      cerr << "input gradient magnitude filename" << endl;
	      cerr << "output result filename" << endl;
	      exit(1);
	      break;
	    case 'y':
	      if (i++ < argc)
		{
		  if (argv[i-1][2] == '0')
		    y_center0 = atof(argv[i]);
		  else
		    y_center1 = atof(argv[i]);
		}
	      break;
	    case 'x':
	      if (++i < argc)
		{
		  if (argv[i-1][2] == '0')
		    x_center0 = atof(argv[i]);
		  else
		    x_center1 = atof(argv[i]);
		}
	      break;
	    case 'a':
	      if (++i < argc)
		{
		  if (argv[i-1][2] == '0')
		    area0 = atof(argv[i]);
		  else
		    area1 = atof(argv[i]);
		}
	      break;
	    case 'n':
	      if (++i < argc)
		switch (argv[i-1][2])
		  {
		  case 'y':
		    ny_center = atoi(argv[i]);
		    break;
		  case 'x':
		    nx_center = atoi(argv[i]);
		    break;
		  case 'a':
		    narea = atoi(argv[i]);
		    break;
		  default:
		    cerr << argv[i-1] << ": Unknown flags." << endl;
		    exit(-1);
		    break;
		  }
	      break;
	    case 'm':
	      if (++i < argc)
		{
		ecc_max = atof(argv[i]);
		}
	      break;
	    case 'd':
	      if (++i < argc)
		{
		num_display = atoi(argv[i]);
		}
	      break;
	    case 'B':
	      if (++i < argc)
		{
		  if (argv[i-1][2] == 'h')
		    search_box_height = atoi(argv[i]);
		  else
		    search_box_width = atoi(argv[i]);
		}
	      break;
	    case 'e':
	      if (++i < argc)
		nedges = atoi(argv[i]);
	      break;
	    case 't':
	      if (++i < argc)
		thres = atoi(argv[i]);
	      break;
	    default:
	      cerr << argv[i] << ": Unknown flags." << endl;
	      exit(-1);
	      break;
	    }
	}
      else
	break;
    }

//
// Read the filenames.
//
  char *imagefile, *angfile, *magfile, *outfile;
  if (i < argc)
    imagefile = argv[i++];
  if (i < argc)
    angfile = argv[i++];
  if (i < argc)
    magfile = argv[i++];
  if (i < argc)
    outfile = argv[i++];

  if (i < argc)
    {
      cerr << "Too many arguments." << endl;
      exit(-1);
    }

// Load the orientation and magnitude files.
unsigned char *ang,*mag;
struct header ang_fh,mag_fh;
FILE *fp;

fp = fopen(angfile,"r");
fread_header(fp,&ang_fh);
printf("ang: rows:%d  cols:%d\n",ang_fh.rows,ang_fh.cols);
int picsize=ang_fh.cols*ang_fh.rows;
ang=(unsigned char *)calloc(picsize,1);
fread(ang,picsize,1,fp);
fclose(fp);

// test picture
fp = fopen("angle.pgm","w");
fwrite_header(fp,&ang_fh);
fwrite(ang,picsize,1,fp);
fclose(fp);


fp = fopen(magfile,"r");
fread_header(fp,&mag_fh);
printf("mag: rows:%d  cols:%d\n",mag_fh.rows,mag_fh.cols);
if((ang_fh.cols != mag_fh.cols)&&(ang_fh.rows != mag_fh.rows))
    error("angle and mag file sizes don't match");
mag=(unsigned char *)calloc(picsize,1);
fread(mag,picsize,1,fp);
fclose(fp);
// test picture
fp = fopen("mag.pgm","w");
fwrite_header(fp,&ang_fh);
fwrite(mag,picsize,1,fp);
fclose(fp);



// determine number of edges to include in the Hough Accumulation Step
  if (nedges == -1)
    nedges = 0.01*picsize;
  if (nedges != 0)		// if nedges==0, then use default thres.
    {
      int *tmp = new int[picsize+20];
      int *indx = new int[picsize+20];
      for (i = 0; i < picsize; i++)
	{
	tmp[i] = mag[i];
	//        if(mag[i] != 0)
	//            printf("tmp:%d  mag:%d\n",tmp[i],mag[i]);
	}

      indexx_int(picsize,tmp,indx);
      //      qsort((char*)tmp, picsize, sizeof(int), icomp);

      thres = (int)(tmp[indx[picsize - nedges]]);
      cerr << "Max coherency: " << tmp[indx[0]] << endl;
      cerr << "Min coherency: " << tmp[indx[picsize-1]] << endl;


      /*
      for(i = 0; i < 10; ++i)
         tmp[i] = 10-i;
      */
      

      delete tmp;
    }

  cerr << "Edge threshold used: " << thres << " number of edges: " << nedges << endl;

//
// Allocate and initialize the cube.
//
  int ncells = ny_center*nx_center*narea;
  int *score = new int[ncells+20];
  //  float *ash = new float[ncells+20];
  for (i = 0; i < ncells; i++)
    score[i]=0; 

//
// Present y_center/x_center/area accumulator array parameters.
//
  cerr << "(y_center0,y_center1,ny_center,dy_center) = (" << y_center0 << "," << y_center1 << "," << ny_center << "," 
    << (y_center1-y_center0)/float(ny_center-1) <<    ")" << endl;
  cerr << "(x_center0,x_center1,nx_center,dx_center) = (" << x_center0 << "," << x_center1 << "," << nx_center << ","
    << (x_center1-x_center0)/float(nx_center-1) << ")" << endl;
  cerr << "(area0,area1,narea,darea) = (" << area0 << "," << area1 << "," << narea << ","
    << (area1-area0)/float(narea-1) << ")" << endl;

//
// Main call here.
//
  accum3(&ang[0], &mag[0], ang_fh.rows, ang_fh.cols, thres,
         0.0, 1.0, 0.0, 1.0,
	 y_center0, y_center1, x_center0, x_center1, area0, area1,
	 score, ny_center, nx_center, narea, search_box_width, search_box_height, ecc_max);
/*
	   y_center0, y_center1, x_center0, x_center1,
	   score, ny_center, nx_center, search_box_width, search_box_height, ecc_max);
*/
/*
	 area0, area1, orient0, orient1,
	 score, narea, norient, search_box_width,  search_box_height, ecc_max);
*/
  int rmax = 0;
  int imax,jmax,kmax;
  for(i = 0; i < ncells; ++i)
     if(score[i] > rmax)
       {
	  convert_indx(i,&imax,&jmax,nx_center,&kmax,narea);
          rmax = score[i];
       }
/*
  unsigned char *acc_array = new unsigned char[ncells];
  for(i = 0; i < ncells; ++i)
       acc_array[i] = (unsigned char)(255 * score[i] / rmax);
*/

  cerr << "Max counts in score: " << rmax << endl;
  cerr << "max score: X-COORD: " << ((float(imax)-0.5)*(y_center1-y_center0)/float(ny_center-1)+y_center0) << endl;
  cerr << "max score: Y_COORD: " << ((float(jmax)-0.5)*(x_center1-x_center0)/float(nx_center-1)+x_center0) << endl;
  cerr << "max score: AREA_COORD: " << ((float(kmax)-0.5)*(area1-area0)/float(narea-1)+area0) << endl;

  //
  // determine and rank the localmaxima
  //
  int *lmlist = new int[ncells];
  for (i = 0; i < ncells; i++)
       lmlist[i] = 0;
  int ind,j,k,l, jstep = nx_center*narea, nn[26], istrong, iweak;
  for (i = 1; i < ny_center-1; i++)
    for (j = 1; j < nx_center-1; j++)
      for (k = 1; k < narea-1; k++)
	  {
	  //ind = (k*nazm+j)*ndip+i;
	  ind = (i*nx_center+j)*narea+k;
	  nn[0] = ind-1;
	  nn[1] = ind+1;
	  nn[2] = ind-narea;
	  nn[3] = nn[2]-1;
	  nn[4] = nn[2]+1;
	  nn[5] = ind+narea;
	  nn[6] = nn[5]-1;
	  nn[7] = nn[5]+1;
	  nn[8] = ind-jstep;
	  nn[9] = nn[8]-1;
	  nn[10] = nn[8]+1;
	  nn[11] = nn[8]-narea;
	  nn[12] = nn[11]-1;
	  nn[13] = nn[11]+1;
	  nn[14] = nn[8]+narea;
	  nn[15] = nn[14]-1;
	  nn[16] = nn[14]+1;
	  nn[17] = ind+jstep;
	  nn[18] = nn[17]-1;
	  nn[19] = nn[17]+1;
	  nn[20] = nn[17]-narea;
	  nn[21] = nn[20]-1;
	  nn[22] = nn[20]+1;
	  nn[23] = nn[17]+narea;
	  nn[24] = nn[23]-1;
	  nn[25] = nn[23]+1;

	  // check the local max in the strong & weak sense.
	  istrong = iweak = 0;
	  for (l = 0; l < 26; l++)
	    {
	      if (score[ind] > score[nn[l]])
		istrong++;
	      if (score[ind] >= score[nn[l]])
		iweak++;
	    }
	  if (iweak==26 && istrong >= 25) // allow two maxima in the neighbor.
	    lmlist[ind] = 1;
	}

//
// Index the local max score
//
  int count = 0;
  for (i = 0; i < ncells; i++)
    if (lmlist[i] == 1)
      count++;
  int nmax = count;
  cerr << "The number of local maxima: " << nmax << endl;
  cell *maxcells = new cell[nmax];

  count = 0;
  for (i = 1; i < ny_center-1; i++)
    for (j = 1; j < nx_center-1; j++)
      for (k = 1; k < narea-1; k++)
	{
	  // ind = (k*nazm+j)*ndip+i;
	  ind = (i*nx_center+j)*narea+k;
	  if (lmlist[ind] == 1)
	    {
	      maxcells[count].val = score[ind];
	      maxcells[count].icoord = i;
	      maxcells[count].jcoord = j;
	      maxcells[count].kcoord = k;
	      count++;
	    }
	}
	
//
// Sort them in a decreasing order and display them.
//
  qsort((char*)maxcells, nmax, sizeof(cell), cellcmpr);

  printf("top twenty\n");
  for(i = 0; i < 20; ++i)
      {
	printf("%f(%d)  %f(%d)  %f(%d)  %d\n",
              (float)(maxcells[i].icoord)/(float)(ny_center - 1) * (y_center1-y_center0)+y_center0,maxcells[i].icoord,
              (float)(maxcells[i].jcoord)/(float)(nx_center - 1) * (x_center1-x_center0) + x_center0,maxcells[i].jcoord,
              (float)(maxcells[i].kcoord)/(float)(narea - 1) * (area1-area0) + area0,maxcells[i].kcoord,
              maxcells[i].val);
      }


//
//  Display the top results
//
  char *image;
  struct header image_fh; 
  fp = fopen(imagefile,"r");
  fread_header(fp,&image_fh);
  printf("image: rows:%d  cols:%d\n",image_fh.rows,image_fh.cols);
  picsize=image_fh.cols*image_fh.rows;
  image=(char *)calloc(picsize,1);
  fread(image,picsize,1,fp);
  fclose(fp);

  // draw the x's and circles of matching radii
  int m, x_center_coord, y_center_coord, radius, delta_x, delta_y;
  float theta;
  int M = 200;

  for(i = 0; i < num_display; ++i)
        {
        x_center_coord = (int)((float)(maxcells[i].jcoord)/(float)(nx_center - 1) * (float)(ang_fh.cols));
        y_center_coord = (int)((float)(maxcells[i].icoord)/(float)(ny_center - 1) * (float)(ang_fh.rows));

        // mark center with an X
        draw_x(x_center_coord, y_center_coord, image, ang_fh.cols, 128);

        // draw circle with the same radius (note the assumption that the picture has area 1!
        radius = sqrt((area1 - area0) * (float)(maxcells[i].kcoord)/(float)(narea - 1)/PI * (ang_fh.cols * ang_fh.rows)) + 1 ;
   	for(m=0;m<=M;++m)
     		{
     		theta=(2.0*m-1.0)/(2.0*M)*2.0*PI;
                delta_y = (int)( (float)(radius) * sin(theta));
                delta_x = (int)( (float)(radius) * cos(theta));

                image[(y_center_coord + delta_y) * ang_fh.cols + (x_center_coord + delta_x)] = 128;
                }
	}

 
  struct header res_fh;
  res_fh.rows = image_fh.rows;
  res_fh.cols = image_fh.cols;
  fp = fopen(outfile,"w");
  fwrite_header(fp,&res_fh);
  fwrite(image,image_fh.rows*image_fh.cols,1,fp);
  fclose(fp);
}


void draw_x(int x_center, int y_center, char *image, int lx, char marker_color)
{
int m;
for(m = -3; m <= 3; ++m)
     {
     image[(y_center + m) * lx + (x_center + m)] = marker_color;
     image[(y_center + m) * lx + (x_center - m)] = marker_color;
     }
}

 
void accum3(unsigned char* angle, unsigned char* strength, int num_rows, int num_cols, int thres,
            float x_left, float x_right, float y_bottom, float y_top,
	    float y_center0, float y_center1, float x_center0, float x_center1, float area0, float area1,
            int *score, int ny_center, int nx_center, int narea, int search_box_width, int search_box_height, float ecc_max)
/*
	    float y_center0, float y_center1, float x_center0, float x_center1,
	    int *score, int ny_center, int nx_center, int search_box_width, int search_box_height, float ecc_max)
*/
/*
	    float area0, float area1, float orient0, float orient1,
	    int *score, int narea, int norient, int search_box_width, int search_box_height, float ecc_max)
*/
//
//	Input arguments:
//		float *mag: magnitudes of edges. mag[i,j] >=0.0.
//		float *arg: arguments of edges. -pi <= arg[i,j] <= pi.
//		int nr, nc: number of rows and cols of mag, arg.
//
//		float thres: magnitude threshold value for voting.
//
//		float x0, x1: parameter range of accum. array in x 
//		float y0, y1: parameter range of accum. array in y 
//
//		int nx, ny: size of the accumurator array.
//
//	Output argument:
//		int *score: accumurator array of size (nx,ny).
//		
{

  // Image space cell ranges and units.
  float dx = (x_right-x_left)/float(num_cols);
  float dy = (y_top-y_bottom)/float(num_rows);
  cerr << "dx " << dx << " dy " << dy << endl;

  // internal parameters
  int num_rows_in_box = search_box_height;
  int num_cols_in_box = search_box_width / 2;  // we work with the left and right side of box
  
  int k;

  // Parameter space cell ranges and units.
  // (x,y) represents position of center of ellipse. 
  float dy_center = (y_center1-y_center0)/float(ny_center);
  float dx_center = (x_center1-x_center0)/float(nx_center);
  float darea = (area1-area0)/float(narea);

  int val;  // value assigned to a pair of edges

  int row0, col0,row1, col1, count = 0, row0_ind, row1_ind;

  int ioldbox, joldbox, koldbox;
  int inewbox, jnewbox, knewbox;

  //  float x, y, z, d, p, s,d_1, p_1, s_1;
  float x0,y0,p0,q0,x1,y1,p1,q1;
  float slope0,slope1;
  float a_calc,b_calc,c_calc,f_calc,g_calc,h_calc;

  // calculated quanitites
  float y_center_calc, x_center_calc;
  float area_calc;

  // constraint quantities and flags
  int ecc_ok;
  float ecc_calc;

  float dlam,lam0,lam,lam_upper;
  int nlam=100,range_flag=0;

  for (row0 = 0; row0 < num_rows; row0++)
      {
	row0_ind = row0*num_cols;
	for (row1 = row0 + 5 ; row1 < min(num_rows, row0 + num_rows_in_box); row1++)
	     {
	       row1_ind = row1*num_cols;

	       for (col0 = 0; col0 < num_cols; col0++)
		   {
		   for (col1 = max(0, col0 - num_cols_in_box); col1 < min(col0+num_cols_in_box, num_cols); col1++)
		       {

			 if((row0==row1)&&(col0>=col1))
			   continue;
                         if( ((int)(strength[row0_ind + col0]) < thres) || ((int)(strength[row1_ind + col1]) < thres) )
			   continue;

			 val = (int)strength[row0_ind + col0] + (int)strength[row1_ind + col1];
//			 val = 1;
 
			 // position and slope info from angle file.
			 count++;

			 x0 = x_left + dx * (float)(col0);
			 y0 = y_bottom + dy * (float)(row0);
			 x1 = x_left + dx * (float)(col1);
			 y1 = y_bottom + dy * (float)(row1);


DBX(		      printf("x0:%f  y0:%f  x1:%f  y1:%f\n",x0,y0,x1,y1);
		      printf("col0:%d  row0:%d  col1:%d  row1:%d\n",col0,row0,col1,row1);)


  		      // compute slopes of the orientation edges (recall tan(a + pi/2) = -1/tan(a))
		      slope0 = (dx/dy) * tan(1.0/40.0*((int)(angle[row0_ind+col0]) - 128) ); // slope
		      slope1 = (dx/dy) * tan(1.0/40.0*((int)(angle[row1_ind+col1]) - 128) ); // slope

DBX(		      printf("angle0:%d  slope0:%f  angle1:%d  slope1:%f\n",angle[row0_ind+col0],slope0,angle[row1_ind+col1],slope1);)
		      // determine p0,q0,p1,q1 to satisfy quadrant condition
		      p0 = 1.0;
		      q0 = slope0;
		      if( ( p0 * (x1 - x0) + q0 * (y1 - y0) ) < 0.0 )
			   {
			     p0 = -p0;
			     q0 = -q0;
			   }			     
		      p1 = 1.0;
		      q1 = slope1;
		      if( ( p1 * (x0 - x1) + q1 * (y0 - y1) ) < 0.0 )
			   {
			     p1 = -p1;
			     q1 = -q1;
			   }	
// DBX(x0=4.0; y0=1.0;p0=-0.25; q0=1.0; x1=1.0; y1=5.0;p1=1.0;q1=-0.3;)

DBX(printf("p0:%f  q0:%f  p1:%f  q1:%f\n",p0,q0,p1,q1);)

                      //determine lambda range  |lam1| < |lam0|
                      lam0= lambda_range( x0, y0, p0, q0, x1, y1, p1, q1)/1.01;
DBX(                      cerr << "lam0: " << lam0 << endl;)

		      /*                  
                      if((lam0>BIG_LAM)||(lam0<-BIG_LAM))
			{
//                          cerr << "lam0 out of range" << endl;  
                          continue;
			}
		      */
		      intermed_calc( x0, y0, p0, q0, x1, y1, p1, q1, lam0,
					 &a_calc,&b_calc,&c_calc,&f_calc,&g_calc,&h_calc);

                      if(area(a_calc,b_calc,c_calc,f_calc,g_calc,h_calc)>MAX_AREA)
                          {
                          lam_upper=lam0;
                          while(area(a_calc,b_calc,c_calc,f_calc,g_calc,h_calc)>MAX_AREA)
                              {
                              lam_upper/=1.001;
			      intermed_calc( x0, y0, p0, q0, x1, y1, p1, q1, lam_upper,
					 &a_calc,&b_calc,&c_calc,&f_calc,&g_calc,&h_calc);
			      }

			  }
                       else
                          {
                          lam_upper=lam0;
			  }

		      intermed_calc( x0, y0, p0, q0, x1, y1, p1, q1, lam_upper,
				     &a_calc,&b_calc,&c_calc,&f_calc,&g_calc,&h_calc);
DBX(                      cerr << "lam_upper: " << lam_upper << " area: " << area(a_calc,b_calc,c_calc,f_calc,g_calc,h_calc) << endl;)


                       dlam=(lam_upper)/(float)(nlam);

                      // determine starting box for lam=dlam
                      lam=dlam;
		      intermed_calc( x0, y0, p0, q0, x1, y1, p1, q1, lam,
				     &a_calc,&b_calc,&c_calc,&f_calc,&g_calc,&h_calc);

		      
		      ecc_calc = eccen(a_calc,b_calc,c_calc,f_calc,g_calc,h_calc);
		      if((ecc_calc < ecc_max) && (ecc_calc > 1.0))
			  ecc_ok = 1;
		      else
			  ecc_ok = 0;

                      center(&x_center_calc,&y_center_calc,a_calc,b_calc,c_calc,f_calc,g_calc,h_calc);
		      area_calc = area(a_calc,b_calc,c_calc,f_calc,g_calc,h_calc);
		      /*
		      orient_calc = orientation(a_calc,b_calc,c_calc,f_calc,g_calc,h_calc);
		      */

		      ioldbox = (int)((y_center_calc-y_center0)/dy_center);
		      joldbox = (int)((x_center_calc-x_center0)/dx_center);
		      koldbox = (int)((area_calc-area0)/darea);

                      if((in_range(ioldbox,ny_center,joldbox,nx_center,koldbox,narea)) && (ecc_ok == 1))
   		          score[(ioldbox * nx_center + joldbox) * narea + koldbox] += val;

                      for(k=1;k<nlam;++k)
		  	   {
                           lam+=dlam;
			   intermed_calc( x0, y0, p0, q0, x1, y1, p1, q1, lam,
				     &a_calc,&b_calc,&c_calc,&f_calc,&g_calc,&h_calc);
			   /*
			   orient_calc = orientation(a_calc,b_calc,c_calc,f_calc,g_calc,h_calc);
			   */

DBX(printf("y_center:%f  x_center:%f\n",y_center_calc,x_center_calc);)

                           ecc_calc = eccen(a_calc,b_calc,c_calc,f_calc,g_calc,h_calc);
			   if((ecc_calc < ecc_max) && (ecc_calc > 1.0))
			     ecc_ok = 1;
			   else
			     ecc_ok = 0;

                           center(&x_center_calc,&y_center_calc,a_calc,b_calc,c_calc,f_calc,g_calc,h_calc);
			   area_calc = area(a_calc,b_calc,c_calc,f_calc,g_calc,h_calc);

			   inewbox = (int)((y_center_calc-y_center0)/dy_center);
			   jnewbox = (int)((x_center_calc-x_center0)/dx_center);
			   knewbox = (int)((area_calc-area0)/darea);

             		  // test this new box.
                           if((abs(inewbox-ioldbox)+abs(jnewbox-joldbox)+abs(knewbox-koldbox))>0)
                                {
	                         if((in_range(inewbox,ny_center,jnewbox,nx_center,knewbox,narea))&& (ecc_ok == 1))
                                    {
                                    ioldbox=inewbox;
                                    joldbox=jnewbox;
                                    koldbox=knewbox;
                                    score[(ioldbox * nx_center + joldbox) * narea + koldbox]+=val;
				   }
				}
			   }

		       fprintf(stderr, "%6d\b\b\b\b\b\b", count);

		       } //col1
		   } //col0

	     } //row1
	    
      } //row0
	
}


